/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.StringUtils;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.MetadataStorageHelper;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectStoreRequest;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.WorkspaceClientServerException;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class StoreMetaDataObjectGroupActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StoreMetaDataObjectGroupActionPlugin.class);
    private static final String JSON = ".json";
    private static final String OG_METADATA_STORAGE = "OG_METADATA_STORAGE";
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final StorageClientFactory storageClientFactory;

    public StoreMetaDataObjectGroupActionPlugin() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public StoreMetaDataObjectGroupActionPlugin(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, StorageClientFactory storageClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters params, HandlerIO handlerIO) {
        List<String> objectGroupIds = params.getObjectNameList().stream().map(metadataFilename -> StringUtils.substringBeforeLast((String)metadataFilename, (String)".")).collect(Collectors.toList());
        try {
            this.storeDocumentsWithLfc(params, handlerIO, objectGroupIds);
            return this.getItemStatuses(objectGroupIds, StatusCode.OK);
        }
        catch (VitamException e) {
            LOGGER.error("An error occurred during object group storage", (Throwable)e);
            return this.getItemStatuses(objectGroupIds, StatusCode.FATAL);
        }
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        throw new IllegalStateException("Not implemented.");
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public void storeDocumentsWithLfc(WorkerParameters params, HandlerIO handlerIO, List<String> objectGroupIds) throws VitamException {
        MultiValuedMap<String, String> objectGroupIdsByStrategie = this.saveDocumentWithLfcInWorkspace(handlerIO, objectGroupIds);
        this.saveDocumentWithLfcInStorage(params.getContainerName(), objectGroupIdsByStrategie);
    }

    private MultiValuedMap<String, String> saveDocumentWithLfcInWorkspace(HandlerIO handlerIO, List<String> objectGroupIds) throws VitamException {
        Stopwatch loadGOT = Stopwatch.createStarted();
        HashSetValuedHashMap objectGroupIdsByStrategie = new HashSetValuedHashMap();
        Map<String, JsonNode> gots = this.getObjectGroupsByIdsRaw(objectGroupIds);
        for (JsonNode got : gots.values()) {
            MetadataDocumentHelper.removeComputedFieldsFromObjectGroup((JsonNode)got);
            String strategyId = MetadataDocumentHelper.getStrategyIdFromRawUnitOrGot((JsonNode)got);
            objectGroupIdsByStrategie.put((Object)strategyId, (Object)got.get("_id").asText());
        }
        PerformanceLogger.getInstance().log("STP_OG_STORING", OG_METADATA_STORAGE, "loadGOT", loadGOT.elapsed(TimeUnit.MILLISECONDS));
        Stopwatch loadLFC = Stopwatch.createStarted();
        Map<String, JsonNode> lfc = this.getRawLogbookLifeCycleByIds(objectGroupIds);
        PerformanceLogger.getInstance().log("STP_OG_STORING", OG_METADATA_STORAGE, "loadLFC", loadLFC.elapsed(TimeUnit.MILLISECONDS));
        for (String guid : objectGroupIds) {
            JsonNode docWithLfc = MetadataStorageHelper.getGotWithLFC((JsonNode)gots.get(guid), (JsonNode)lfc.get(guid));
            String fileName = guid + JSON;
            try {
                InputStream is = CanonicalJsonFormatter.serialize((JsonNode)docWithLfc);
                Stopwatch storeWorkspace = Stopwatch.createStarted();
                handlerIO.transferInputStreamToWorkspace("ObjectGroup/" + fileName, is, null, false);
                PerformanceLogger.getInstance().log("STP_OG_STORING", OG_METADATA_STORAGE, "storeWorkspace", storeWorkspace.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (ProcessingException e) {
                throw new WorkspaceClientServerException("Could not backup file for " + guid, (Throwable)e);
            }
        }
        return objectGroupIdsByStrategie;
    }

    private Map<String, JsonNode> getObjectGroupsByIdsRaw(List<String> documentIds) throws VitamException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            RequestResponse requestResponse = metaDataClient.getObjectGroupsByIdsRaw(documentIds);
            if (!requestResponse.isOk()) {
                throw new ProcessingException("Documents not found " + documentIds);
            }
            List results = ((RequestResponseOK)requestResponse).getResults();
            if (results.size() != documentIds.size()) {
                throw new ProcessingException("Documents not found " + documentIds);
            }
            Map<String, JsonNode> map = this.mapById(results);
            return map;
        }
    }

    private Map<String, JsonNode> getRawLogbookLifeCycleByIds(List<String> documentIds) throws VitamException {
        try (LogbookLifeCyclesClient logbookClient = this.logbookLifeCyclesClientFactory.getClient();){
            List results = logbookClient.getRawObjectGroupLifeCycleByIds(documentIds);
            Map<String, JsonNode> map = this.mapById(results);
            return map;
        }
    }

    private void saveDocumentWithLfcInStorage(String containerName, MultiValuedMap<String, String> objectGroupIdsByStrategies) throws VitamException {
        Stopwatch storeStorage = Stopwatch.createStarted();
        for (String strategy : objectGroupIdsByStrategies.keySet()) {
            ArrayList<CallSite> workspaceURIs = new ArrayList<CallSite>();
            ArrayList<CallSite> objectNames = new ArrayList<CallSite>();
            Collection objectGroupIds = objectGroupIdsByStrategies.get((Object)strategy);
            for (String objectGroupId : objectGroupIds) {
                String filename = objectGroupId + JSON;
                String workspaceURI = "ObjectGroup" + File.separator + filename;
                workspaceURIs.add((CallSite)((Object)workspaceURI));
                objectNames.add((CallSite)((Object)filename));
            }
            BulkObjectStoreRequest request = new BulkObjectStoreRequest(containerName, workspaceURIs, DataCategory.OBJECTGROUP, objectNames);
            try {
                StorageClient storageClient = this.storageClientFactory.getClient();
                try {
                    storageClient.bulkStoreFilesFromWorkspace(strategy, request);
                }
                finally {
                    if (storageClient == null) continue;
                    storageClient.close();
                }
            }
            catch (StorageAlreadyExistsClientException | StorageNotFoundClientException e) {
                LOGGER.debug("Bulk storage failed for strategy {}", (Object)strategy);
                throw new ProcessingException("Bulk storage failed", e);
            }
        }
        PerformanceLogger.getInstance().log("STP_OG_STORING", OG_METADATA_STORAGE, "storeStorage", storeStorage.elapsed(TimeUnit.MILLISECONDS));
    }

    private List<ItemStatus> getItemStatuses(List<String> objectGroupIds, StatusCode statusCode) {
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        for (int i = 0; i < objectGroupIds.size(); ++i) {
            itemStatuses.add(PluginHelper.buildItemStatus(OG_METADATA_STORAGE, statusCode, null));
        }
        return itemStatuses;
    }

    private Map<String, JsonNode> mapById(List<JsonNode> results) {
        return results.stream().collect(Collectors.toMap(entry -> entry.get("_id").textValue(), entry -> entry));
    }
}

