/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;

public class ScrollSpliteratorHelper {
    public static ScrollSpliterator<JsonNode> createUnitScrollSplitIterator(MetaDataClient client, SelectMultiQuery selectMultiQuery) {
        return ScrollSpliteratorHelper.createUnitScrollSplitIterator(client, selectMultiQuery, VitamConfiguration.getElasticSearchScrollLimit());
    }

    public static ScrollSpliterator<JsonNode> createUnitScrollSplitIterator(MetaDataClient client, SelectMultiQuery selectMultiQuery, int bachSize) {
        return new ScrollSpliterator(selectMultiQuery, query -> {
            try {
                JsonNode jsonNode = client.selectUnits((JsonNode)query.getFinalSelect());
                return RequestResponseOK.getFromJsonNode((JsonNode)jsonNode);
            }
            catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                throw new IllegalStateException(e);
            }
        }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), bachSize);
    }

    public static ScrollSpliterator<JsonNode> createObjectGroupScrollSplitIterator(MetaDataClient client, SelectMultiQuery selectMultiQuery, int bachSize) {
        return new ScrollSpliterator(selectMultiQuery, query -> {
            try {
                JsonNode jsonNode = client.selectObjectGroups((JsonNode)query.getFinalSelect());
                return RequestResponseOK.getFromJsonNode((JsonNode)jsonNode);
            }
            catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                throw new IllegalStateException(e);
            }
        }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), bachSize);
    }

    public static ScrollSpliterator<JsonNode> createObjectGroupScrollSplitIterator(MetaDataClient client, SelectMultiQuery selectMultiQuery) {
        return ScrollSpliteratorHelper.createObjectGroupScrollSplitIterator(client, selectMultiQuery, VitamConfiguration.getElasticSearchScrollLimit());
    }

    public static ScrollSpliterator<JsonNode> getUnitWithInheritedRulesScrollSpliterator(SelectMultiQuery request, MetaDataClient client) {
        return new ScrollSpliterator(request, query -> {
            try {
                JsonNode jsonNode = client.selectUnitsWithInheritedRules((JsonNode)query.getFinalSelect());
                return RequestResponseOK.getFromJsonNode((JsonNode)jsonNode);
            }
            catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                throw new IllegalStateException(e);
            }
        }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), VitamConfiguration.getElasticSearchScrollLimit().intValue());
    }

    public static boolean checkNumberOfResultQuery(ItemStatus itemStatus, long total) {
        if (total == 0L) {
            itemStatus.increment(StatusCode.KO);
            ObjectNode infoNode = JsonHandler.createObjectNode();
            infoNode.put("Reason", "the DSL query has no result");
            String evdev = JsonHandler.unprettyPrint((Object)infoNode);
            itemStatus.setEvDetailData(evdev);
            return true;
        }
        return false;
    }
}

