/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.functional.administration.common.utils.ArchiveUnitUpdateUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.DefaultWorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.common.parameter.WorkerParametersFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.ArchiveUnitLifecycleUpdateUtils;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.StoreMetaDataUnitActionPlugin;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class RunningIngestsUpdateActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RunningIngestsUpdateActionPlugin.class);
    private static final String RUNNING_INGESTS_UPDATE_TASK_ID = "UPDATE_RUNNING_INGESTS";
    private static final int RANK_RUNNING_INGESTS_FILE = 0;
    private final Map<String, List<JsonNode>> updatedRulesByType = new HashMap<String, List<JsonNode>>();
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final StoreMetaDataUnitActionPlugin storeMetaDataUnitActionPlugin;
    private final MetaDataClientFactory metaDataClientFactory;
    private final ArchiveUnitLifecycleUpdateUtils archiveUnitLifecycleUpdateUtils = new ArchiveUnitLifecycleUpdateUtils();
    private static final String RESULTS = "$results";
    private static final String ID = "#id";
    private static final String MANAGEMENT_KEY = "#management";
    private static final String FIELDS_KEY = "$fields";
    private static final String RULES_KEY = "Rules";
    private static final long SLEEP_TIME = 10000L;
    private static final long NB_TRY = 600L;
    private static final String PROCESS_ID_FIELD = "operationId";

    public RunningIngestsUpdateActionPlugin() {
        this.storeMetaDataUnitActionPlugin = new StoreMetaDataUnitActionPlugin();
        this.processingManagementClientFactory = ProcessingManagementClientFactory.getInstance();
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
    }

    @VisibleForTesting
    public RunningIngestsUpdateActionPlugin(ProcessingManagementClientFactory processingManagementClientFactory, MetaDataClientFactory metaDataClientFactory, StoreMetaDataUnitActionPlugin storeMetaDataUnitActionPlugin) {
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
        this.storeMetaDataUnitActionPlugin = storeMetaDataUnitActionPlugin;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(RUNNING_INGESTS_UPDATE_TASK_ID);
        try {
            try {
                this.getRunningIngests(params, handler);
            }
            catch (VitamDBException e) {
                LOGGER.error((Throwable)e);
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (ProcessingException e) {
            LOGGER.error("Processing exception", (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot parse json", (Throwable)e);
            itemStatus.increment(StatusCode.KO);
        }
        return new ItemStatus(RUNNING_INGESTS_UPDATE_TASK_ID).setItemsStatus(RUNNING_INGESTS_UPDATE_TASK_ID, itemStatus);
    }

    private void getRunningIngests(WorkerParameters params, HandlerIO handler) throws ProcessingException, InvalidParseOperationException, VitamDBException {
        block14: {
            InputStream inputStream = null;
            try {
                inputStream = handler.getInputStreamFromWorkspace("PROCESSING/updatedRules.json");
                JsonNode rulesUpdated = JsonHandler.getFromInputStream((InputStream)inputStream);
                for (JsonNode rule : rulesUpdated) {
                    List<Object> listRulesByType;
                    if (!this.updatedRulesByType.containsKey(rule.get("RuleType").asText())) {
                        listRulesByType = new ArrayList<JsonNode>();
                        listRulesByType.add(rule);
                        this.updatedRulesByType.put(rule.get("RuleType").asText(), listRulesByType);
                        continue;
                    }
                    listRulesByType = this.updatedRulesByType.get(rule.get("RuleType").asText());
                    listRulesByType.add(rule);
                    this.updatedRulesByType.put(rule.get("RuleType").asText(), listRulesByType);
                }
                if (rulesUpdated.isArray() && rulesUpdated.size() > 0) {
                    JsonNode runningIngests = JsonHandler.getFromFile((File)((File)handler.getInput(0)));
                    if (!runningIngests.isArray() || runningIngests.size() <= 0) break block14;
                    List listIngest = JsonHandler.toArrayList((ArrayNode)((ArrayNode)runningIngests));
                    long nbTry = 0L;
                    while (true) {
                        Iterator<JsonNode> it = listIngest.iterator();
                        while (it.hasNext()) {
                            JsonNode currentIngest = (JsonNode)it.next();
                            this.checkAndProcessIngest(currentIngest, it, params, handler);
                        }
                        if (listIngest.size() == 0) {
                            break block14;
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                        }
                        if (nbTry == 600L) {
                            break block14;
                        }
                        ++nbTry;
                    }
                }
                LOGGER.warn("No rules updated");
            }
            catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
                LOGGER.error("Workspace error: Cannot get file", e);
                throw new ProcessingException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    private void checkAndProcessIngest(JsonNode currentIngest, Iterator<JsonNode> iterator, WorkerParameters params, HandlerIO handlerIO) throws ProcessingException, VitamDBException {
        block24: {
            String operationId = currentIngest.get(PROCESS_ID_FIELD).asText();
            DefaultWorkerParameters paramsCopy = WorkerParametersFactory.newWorkerParameters();
            paramsCopy.setContainerName(params.getContainerName());
            paramsCopy.setCurrentStep(params.getCurrentStep());
            paramsCopy.setUrlWorkspace(params.getUrlWorkspace());
            paramsCopy.setUrlMetadata(params.getUrlMetadata());
            paramsCopy.setObjectNameList(new ArrayList());
            try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
                 ProcessingManagementClient processingManagementClient = this.processingManagementClientFactory.getClient();){
                ArrayNode resultUnitsArray;
                ItemStatus status = processingManagementClient.getOperationProcessStatus(operationId);
                if (!ProcessState.COMPLETED.equals((Object)status.getGlobalState())) break block24;
                if (status.getGlobalStatus().isGreaterOrEqualToKo()) {
                    iterator.remove();
                    return;
                }
                ObjectNode projectionNode = JsonHandler.createObjectNode();
                SelectMultiQuery selectMultiple = new SelectMultiQuery();
                ObjectNode objectNode = JsonHandler.createObjectNode();
                objectNode.put(ID, 1);
                objectNode.put(MANAGEMENT_KEY, 1);
                projectionNode.set(FIELDS_KEY, (JsonNode)objectNode);
                ArrayNode arrayNode = JsonHandler.createArrayNode();
                selectMultiple.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.in((String)VitamFieldsHelper.operations(), (String[])new String[]{operationId})}));
                selectMultiple.addRoots(arrayNode);
                selectMultiple.addProjection((JsonNode)projectionNode);
                JsonNode unitsResultNode = metaDataClient.selectUnits((JsonNode)selectMultiple.getFinalSelect());
                if (unitsResultNode != null && (resultUnitsArray = (ArrayNode)unitsResultNode.get(RESULTS)) != null && resultUnitsArray.size() > 0) {
                    for (JsonNode unitNode : resultUnitsArray) {
                        UpdateMultiQuery query = new UpdateMultiQuery();
                        String auGuid = unitNode.get(ID).asText();
                        JsonNode managementNode = unitNode.get(MANAGEMENT_KEY);
                        int nbUpdates = 0;
                        for (String key : this.updatedRulesByType.keySet()) {
                            JsonNode categoryNode = managementNode.get(key);
                            if (categoryNode == null || categoryNode.get(RULES_KEY) == null || !ArchiveUnitUpdateUtils.updateCategoryRules((JsonNode)categoryNode.get(RULES_KEY), this.updatedRulesByType.get(key), (UpdateMultiQuery)query, (String)key)) continue;
                            ++nbUpdates;
                        }
                        if (nbUpdates <= 0) continue;
                        try {
                            query.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{params.getContainerName()})});
                            JsonNode updateResultJson = metaDataClient.updateUnitById((JsonNode)query.getFinalUpdate(), auGuid);
                            this.archiveUnitLifecycleUpdateUtils.logLifecycle(params, auGuid, StatusCode.OK, ArchiveUnitUpdateUtils.getDiffMessageFor((JsonNode)updateResultJson, (String)auGuid), handlerIO.getLifecyclesClient());
                            this.archiveUnitLifecycleUpdateUtils.commitLifecycle(params.getContainerName(), auGuid, handlerIO.getLifecyclesClient());
                            paramsCopy.setObjectName(auGuid);
                            this.saveMetadataWithLfcInTheStorage((WorkerParameters)paramsCopy, handlerIO);
                        }
                        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                            try {
                                handlerIO.getLifecyclesClient().rollBackUnitsByOperation(params.getContainerName());
                            }
                            catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException ex) {
                                LOGGER.error("Couldn't rollback lifecycles", ex);
                            }
                            throw new ProcessingException(e);
                        }
                    }
                }
                iterator.remove();
            }
            catch (InvalidCreateOperationException | BadRequestException | InternalServerException | InvalidParseOperationException | VitamClientException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                throw new ProcessingException(e);
            }
        }
    }

    private void saveMetadataWithLfcInTheStorage(WorkerParameters workerParameters, HandlerIO handlerIO) throws ProcessingException {
        try {
            this.storeMetaDataUnitActionPlugin.storeDocumentsWithLfc(workerParameters, handlerIO, Collections.singletonList(workerParameters.getObjectName()));
        }
        catch (VitamException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

