/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;

public class PrepareStorageStrategiesPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PrepareStorageStrategiesPlugin.class);
    private static final String PLUGIN_NAME = "PREPARE_STORAGE_STRATEGIES";
    private static final int STRATEGIES_OUT_RANK = 0;
    private final StorageClientFactory storageClientFactory;

    public PrepareStorageStrategiesPlugin() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    PrepareStorageStrategiesPlugin(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) throws ProcessingException {
        try {
            this.storeStrategies(handlerIO);
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, JsonHandler.createObjectNode());
        }
        catch (ProcessingException e) {
            LOGGER.error(String.format("Prepare Storage Strategies failed with status [%s]", StatusCode.FATAL), (Throwable)e);
            ObjectNode error = JsonHandler.createObjectNode().put("error", e.getMessage());
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, error);
        }
    }

    private void storeStrategies(HandlerIO handlerIO) throws ProcessingException {
        block9: {
            try (StorageClient storageClient = this.storageClientFactory.getClient();){
                RequestResponse storageStrategies = storageClient.getStorageStrategies();
                if (storageStrategies.isOk()) {
                    File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(0).getPath());
                    JsonHandler.writeAsFile((Object)((RequestResponseOK)storageStrategies).getResultsAsJsonNodes(), (File)tempFile);
                    handlerIO.addOutputResult(0, (Object)tempFile, true, false);
                    break block9;
                }
                throw new StorageServerClientException("Exception while retrieving storage strategies");
            }
            catch (InvalidParseOperationException | StorageServerClientException e) {
                LOGGER.error("Storage server errors : ", e);
                throw new ProcessingException(String.format("Storage server errors : %s", e));
            }
        }
    }
}

