/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.google.common.base.Strings;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.i18n.PluginPropertiesLoader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.IllegalPathException;
import fr.gouv.vitam.common.security.SafeFileChecker;
import fr.gouv.vitam.processing.common.exception.InvocationPluginException;
import fr.gouv.vitam.processing.common.exception.PluginNotFoundException;
import fr.gouv.vitam.worker.common.PluginProperties;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.PluginConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class PluginLoader {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PluginLoader.class);
    private static final String PLUGIN_CONFIG_FILE = "plugins.json";
    private static final String WORKER_PLUGIN_WORKSPACE = "plugins-workspace";
    private Map<String, PluginConfiguration> plugins;
    private final String pluginsConfigFile;

    public PluginLoader() throws IllegalPathException {
        this(PLUGIN_CONFIG_FILE);
    }

    PluginLoader(String pluginsConfigFile) throws IllegalPathException {
        LOGGER.debug("Load plugin files : " + pluginsConfigFile);
        SafeFileChecker.checkSafeFilePath((String)VitamConfiguration.getVitamConfigFolder(), (String[])new String[]{pluginsConfigFile});
        this.pluginsConfigFile = pluginsConfigFile;
        this.plugins = new HashMap<String, PluginConfiguration>();
    }

    public void loadConfiguration() throws FileNotFoundException, InvalidParseOperationException, PluginNotFoundException {
        Map mapFromInputStream = JsonHandler.getMapFromInputStream((InputStream)PropertiesUtils.getConfigAsStream((String)this.pluginsConfigFile), PluginProperties.class);
        for (Map.Entry pluginPropertiesEntry : mapFromInputStream.entrySet()) {
            Optional<Class<ActionHandler>> actionHandlerClazz;
            PluginProperties pluginProperties = (PluginProperties)pluginPropertiesEntry.getValue();
            if (Strings.isNullOrEmpty((String)pluginProperties.getJarName())) {
                actionHandlerClazz = this.loadInternalPlugins((String)pluginPropertiesEntry.getKey(), pluginProperties);
            } else {
                actionHandlerClazz = this.loadExternalPlugins((String)pluginPropertiesEntry.getKey(), pluginProperties);
                LOGGER.debug("Load external plugin name : {}", (Object)(actionHandlerClazz.isPresent() ? actionHandlerClazz.get().getName() : "null"));
            }
            if (!actionHandlerClazz.isPresent()) continue;
            this.plugins.put((String)pluginPropertiesEntry.getKey(), new PluginConfiguration(pluginProperties.getPropertiesFile(), actionHandlerClazz.get()));
        }
    }

    private Optional<Class<ActionHandler>> loadInternalPlugins(String handlerID, PluginProperties pluginProperties) throws PluginNotFoundException {
        Class<?> actionHandlerClazz;
        try {
            if (StringUtils.isNotEmpty((CharSequence)pluginProperties.getPropertiesFile())) {
                SafeFileChecker.checkSafeRessourceFilePath((String)pluginProperties.getPropertiesFile());
                PluginPropertiesLoader.loadProperties((String)handlerID, (String)pluginProperties.getPropertiesFile());
            }
            actionHandlerClazz = Thread.currentThread().getContextClassLoader().loadClass(pluginProperties.getClassName());
        }
        catch (IllegalPathException | ClassNotFoundException e) {
            LOGGER.error("could not find class: {}", (Object)pluginProperties.getClassName());
            throw new PluginNotFoundException(String.format("could not find class: %s", pluginProperties.getClassName()), e);
        }
        return Optional.of(actionHandlerClazz);
    }

    private Optional<Class<ActionHandler>> loadExternalPlugins(String handlerID, PluginProperties pluginProperties) {
        try {
            File jarFile = SafeFileChecker.checkSafeFilePath((String)VitamConfiguration.getVitamConfigFolder(), (String[])new String[]{WORKER_PLUGIN_WORKSPACE, pluginProperties.getJarName()});
            if (!jarFile.exists()) {
                LOGGER.error("Jar file {} not found in {} folder. FullPath {}", new Object[]{pluginProperties.getJarName(), WORKER_PLUGIN_WORKSPACE, jarFile.getAbsolutePath()});
                return Optional.empty();
            }
            URL[] urls = new URL[]{jarFile.toURI().toURL()};
            URLClassLoader pluginLoader = new URLClassLoader(urls);
            String propertiesFile = pluginProperties.getPropertiesFile();
            if (StringUtils.isNotEmpty((CharSequence)propertiesFile)) {
                SafeFileChecker.checkSafeRessourceFilePath((String)propertiesFile);
                PluginPropertiesLoader.loadProperties((String)handlerID, (String)propertiesFile, (ClassLoader)pluginLoader);
            }
            SafeFileChecker.checkSafeRessourceFilePath((String)pluginProperties.getClassName());
            return Optional.of(pluginLoader.loadClass(pluginProperties.getClassName()));
        }
        catch (IllegalPathException | IOException | ClassNotFoundException e) {
            LOGGER.error("could not find class: " + pluginProperties.getClassName() + ". the jar file " + pluginProperties.getJarName() + " should be be in plugins-workspace folder", e);
            return Optional.empty();
        }
    }

    public boolean contains(String pluginId) {
        return this.plugins.containsKey(pluginId);
    }

    public ActionHandler newInstance(String pluginId) throws InvocationPluginException, PluginNotFoundException {
        PluginConfiguration pluginConfiguration = this.plugins.get(pluginId);
        if (!this.contains(pluginId)) {
            throw new PluginNotFoundException(String.format("Cannot find plugin for id: %s", pluginId));
        }
        try {
            return pluginConfiguration.newInstance();
        }
        catch (Exception e) {
            throw new InvocationPluginException("could not instance plugin with action Id: " + pluginId, (Throwable)e);
        }
    }

    public Map<String, ActionHandler> loadAllPlugins() throws InvocationPluginException {
        HashMap<String, ActionHandler> actionHandlers = new HashMap<String, ActionHandler>();
        for (Map.Entry<String, PluginConfiguration> configurationEntry : this.plugins.entrySet()) {
            try {
                ActionHandler actionHandler = configurationEntry.getValue().newInstance();
                try {
                    actionHandlers.put(configurationEntry.getKey(), actionHandler);
                }
                finally {
                    if (actionHandler == null) continue;
                    actionHandler.close();
                }
            }
            catch (Exception e) {
                throw new InvocationPluginException(String.format("could not instance plugin with action Id: %s", configurationEntry.getKey()), (Throwable)e);
            }
        }
        return actionHandlers;
    }
}

