/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.InsertMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.RequestMultiple;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.model.BulkUnitInsertEntry;
import fr.gouv.vitam.metadata.api.model.BulkUnitInsertRequest;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class IndexUnitActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IndexUnitActionPlugin.class);
    private static final String HANDLER_PROCESS = "INDEXATION";
    private static final String ARCHIVE_UNIT = "ArchiveUnit";
    private static final String TAG_WORK = "_work";
    private static final int SEDA_PARAMETERS_RANK = 0;
    private final MetaDataClientFactory metaDataClientFactory;

    public IndexUnitActionPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    IndexUnitActionPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public static String getId() {
        return HANDLER_PROCESS;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO param) {
        throw new RuntimeException();
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handlerIO) {
        try {
            ArrayList<ItemStatus> arrayList;
            block23: {
                MetaDataClient metadataClient = this.metaDataClientFactory.getClient();
                try {
                    StatusCode statusCode;
                    ItemStatus itemsStatus;
                    ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
                    ArrayList<Object> queryCaches = new ArrayList<Object>();
                    for (String objectId : workerParameters.getObjectNameList()) {
                        ItemStatus itemsStatus2;
                        workerParameters.setObjectName(objectId);
                        handlerIO.setCurrentObjectId(objectId);
                        this.checkMandatoryParameters(workerParameters);
                        ItemStatus itemStatus = new ItemStatus(HANDLER_PROCESS);
                        Object query2 = null;
                        try {
                            query2 = this.indexArchiveUnit(workerParameters, workerParameters.getContainerName(), workerParameters.getObjectName(), handlerIO);
                            if (!((QueryCache)query2).update) {
                                queryCaches.add(query2);
                                itemStatus.increment(StatusCode.OK);
                                itemsStatus = new ItemStatus(HANDLER_PROCESS).setItemsStatus(HANDLER_PROCESS, itemStatus);
                                itemStatuses.add(itemsStatus);
                                continue;
                            }
                            metadataClient.updateUnitById((JsonNode)((UpdateMultiQuery)((QueryCache)query2).requestMultiple).getFinalUpdate(), ((QueryCache)query2).unitId);
                            itemStatus.increment(StatusCode.OK);
                            itemsStatus = new ItemStatus(HANDLER_PROCESS).setItemsStatus(HANDLER_PROCESS, itemStatus);
                            itemStatuses.add(itemsStatus);
                        }
                        catch (InvalidCreateOperationException | IllegalArgumentException e) {
                            LOGGER.error(e);
                            itemStatus.increment(StatusCode.KO);
                            itemsStatus2 = new ItemStatus(HANDLER_PROCESS).setItemsStatus(HANDLER_PROCESS, itemStatus);
                            itemStatuses.add(itemsStatus2);
                        }
                        catch (ProcessingException e) {
                            LOGGER.error((Throwable)e);
                            itemStatus.increment(StatusCode.FATAL);
                            itemsStatus2 = new ItemStatus(HANDLER_PROCESS).setItemsStatus(HANDLER_PROCESS, itemStatus);
                            itemStatuses.add(itemsStatus2);
                        }
                        catch (InvalidParseOperationException e) {
                            itemStatus.increment(StatusCode.FATAL);
                            itemsStatus2 = new ItemStatus(HANDLER_PROCESS).setItemsStatus(HANDLER_PROCESS, itemStatus);
                            itemStatuses.add(itemsStatus2);
                            throw new IllegalArgumentException(e);
                        }
                        catch (MetaDataNotFoundException e) {
                            LOGGER.error("Unit references a non existing unit " + query2.toString());
                            throw new IllegalArgumentException(e);
                        }
                        catch (MetaDataException e) {
                            LOGGER.error((Throwable)e);
                            itemStatus.increment(StatusCode.FATAL);
                        }
                    }
                    List entries = queryCaches.stream().map(query -> query.requestMultiple).map(query -> (InsertMultiQuery)query).map(query -> new BulkUnitInsertEntry(query.getRoots(), (JsonNode)query.getData())).collect(Collectors.toList());
                    try {
                        metadataClient.insertUnitBulk(new BulkUnitInsertRequest(entries));
                        statusCode = StatusCode.OK;
                    }
                    catch (IllegalArgumentException e) {
                        throw e;
                    }
                    catch (InvalidParseOperationException | MetaDataNotFoundException e) {
                        throw new IllegalArgumentException(e);
                    }
                    catch (MetaDataException e) {
                        LOGGER.error((Throwable)e);
                        statusCode = StatusCode.FATAL;
                    }
                    if (statusCode == StatusCode.FATAL || statusCode == StatusCode.ALREADY_EXECUTED) {
                        for (int i = 0; i < workerParameters.getObjectNameList().size(); ++i) {
                            ItemStatus itemStatus = new ItemStatus(HANDLER_PROCESS);
                            itemStatus.increment(statusCode);
                            itemsStatus = new ItemStatus(HANDLER_PROCESS).setItemsStatus(HANDLER_PROCESS, itemStatus);
                            itemStatuses.set(i, itemsStatus);
                        }
                    }
                    arrayList = itemStatuses;
                    if (metadataClient == null) break block23;
                }
                catch (Throwable throwable) {
                    if (metadataClient != null) {
                        try {
                            metadataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                metadataClient.close();
            }
            return arrayList;
        }
        finally {
            handlerIO.setCurrentObjectId(null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QueryCache indexArchiveUnit(WorkerParameters params, String operationId, String unitId, HandlerIO handlerIO) throws ProcessingException, InvalidCreateOperationException {
        QueryCache queryCache;
        ObjectNode data;
        InputStream input;
        Object query;
        block11: {
            Object parents;
            ParametersChecker.checkNullOrEmptyParameters((VitamParameter)params);
            query = null;
            input = null;
            input = handlerIO.getInputStreamFromWorkspace("Units" + File.separator + unitId);
            JsonNode archiveUnit = this.prepareArchiveUnitJson(input, operationId, unitId, handlerIO);
            data = (ObjectNode)archiveUnit.get(ARCHIVE_UNIT);
            JsonNode work = archiveUnit.get(TAG_WORK);
            Boolean existing = false;
            if (work != null && work.get("_existing") != null) {
                existing = work.get("_existing").asBoolean();
            }
            query = existing != false ? new UpdateMultiQuery() : new InsertMultiQuery();
            if (work != null && work.get("_up") != null) {
                parents = (ArrayNode)work.get("_up");
                query.addRoots(parents);
            }
            if (Boolean.TRUE.equals(existing)) break block11;
            ((InsertMultiQuery)query).addData(new ObjectNode[]{data});
            parents = new QueryCache(false, (RequestMultiple)query, null);
            IOUtils.closeQuietly((InputStream)input);
            return parents;
        }
        try {
            query.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{params.getContainerName()})});
            String existingAuGUID = data.get("_id").asText();
            queryCache = new QueryCache(true, (RequestMultiple)query, existingAuGUID);
        }
        catch (InvalidParseOperationException e) {
            try {
                LOGGER.error("Internal Server Error", (Throwable)e);
                throw new ProcessingException((Throwable)e);
                catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e2) {
                    LOGGER.error("Workspace Server Error", e2);
                    throw new ProcessingException(e2);
                }
                catch (IllegalArgumentException e3) {
                    LOGGER.error("Illegal Argument Exception for " + (query != null ? query.toString() : ""));
                    throw e3;
                }
                catch (IOException e4) {
                    LOGGER.error("Archive unit not found");
                    throw new ProcessingException("Archive unit not found");
                }
                catch (InvalidCreateOperationException e5) {
                    LOGGER.error("InvalidCreateOperationException for " + (query != null ? query.toString() : ""));
                    throw e5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return queryCache;
    }

    private JsonNode prepareArchiveUnitJson(InputStream input, String containerId, String objectName, HandlerIO handlerIO) throws InvalidParseOperationException, ProcessingException {
        try {
            ParametersChecker.checkParameter((String)"Input stream is a mandatory parameter", (Object[])new Object[]{input});
            ParametersChecker.checkParameter((String)"Container id is a mandatory parameter", (String[])new String[]{containerId});
            ParametersChecker.checkParameter((String)"ObjectName id is a mandatory parameter", (String[])new String[]{objectName});
        }
        catch (IllegalArgumentException e) {
            throw new ProcessingException((Throwable)e);
        }
        JsonNode archiveUnit = JsonHandler.getFromInputStream((InputStream)input);
        ObjectNode archiveUnitNode = (ObjectNode)archiveUnit.get(ARCHIVE_UNIT);
        JsonNode sedaParameters = JsonHandler.getFromFile((File)((File)handlerIO.getInput(0)));
        if (sedaParameters.get("ArchiveTransfer").get("DataObjectPackage").get("OriginatingAgencyIdentifier") != null) {
            String prodService = sedaParameters.get("ArchiveTransfer").get("DataObjectPackage").get("OriginatingAgencyIdentifier").asText();
            ArrayNode originatingAgencies = JsonHandler.createArrayNode();
            originatingAgencies.add(prodService);
            archiveUnitNode.set("_sps", (JsonNode)originatingAgencies);
            archiveUnitNode.put("_sp", prodService);
        }
        return archiveUnit;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    static class QueryCache {
        boolean update;
        RequestMultiple requestMultiple;
        String unitId;

        public QueryCache(boolean update, RequestMultiple requestMultiple, String unitId) {
            this.update = update;
            this.requestMultiple = requestMultiple;
            this.unitId = unitId;
        }
    }
}

