/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.SetAction;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.InsertMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.exception.ProcessingInternalServerException;
import fr.gouv.vitam.processing.common.exception.StepAlreadyExecutedException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IndexObjectGroupActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IndexObjectGroupActionPlugin.class);
    private static final String OG_INDEXATION = "OG_INDEXATION";
    private static final int OG_INPUT_RANK = 0;
    public static final String INVALID_OR_MISSING_QUALIFIERS = "Invalid or missing _qualifiers";
    public static final String MISSING_VERSIONS = "Missing versions";
    public static final String MISSING_VERSION = "Missing version";
    private final MetaDataClientFactory metaDataClientFactory;

    public IndexObjectGroupActionPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    public IndexObjectGroupActionPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) throws ProcessingException {
        try {
            ArrayList<ItemStatus> arrayList;
            block20: {
                MetaDataClient metadataClient = this.metaDataClientFactory.getClient();
                try {
                    ArrayList<ItemStatus> aggregateItemStatus = new ArrayList<ItemStatus>();
                    ArrayList<ObjectNode> objectGroups = new ArrayList<ObjectNode>();
                    for (String objectId : workerParameters.getObjectNameList()) {
                        workerParameters.setObjectName(objectId);
                        handler.setCurrentObjectId(objectId);
                        this.checkMandatoryParameters(workerParameters);
                        ItemStatus itemStatus = new ItemStatus(OG_INDEXATION);
                        try {
                            this.checkMandatoryIOParameter(handler);
                            ObjectNode objectNode = this.indexObjectGroup(handler, workerParameters, itemStatus);
                            if (objectNode != null) {
                                objectGroups.add(objectNode);
                            }
                        }
                        catch (StepAlreadyExecutedException e) {
                            LOGGER.warn((Throwable)e);
                            itemStatus.increment(StatusCode.ALREADY_EXECUTED);
                        }
                        catch (ProcessingInternalServerException exc) {
                            LOGGER.error((Throwable)exc);
                            itemStatus.increment(StatusCode.FATAL);
                        }
                        catch (ProcessingException e) {
                            LOGGER.error((Throwable)e);
                            itemStatus.increment(StatusCode.KO);
                        }
                        if (StatusCode.UNKNOWN.equals((Object)itemStatus.getGlobalStatus())) {
                            itemStatus.increment(StatusCode.WARNING);
                        }
                        aggregateItemStatus.add(new ItemStatus(OG_INDEXATION).setItemsStatus(OG_INDEXATION, itemStatus));
                    }
                    if (!objectGroups.isEmpty()) {
                        try {
                            metadataClient.insertObjectGroups(objectGroups);
                        }
                        catch (InvalidParseOperationException | MetaDataException e) {
                            LOGGER.error(e);
                            ArrayList<ItemStatus> aggregateItemStatusBis = new ArrayList<ItemStatus>();
                            for (ItemStatus ignored : aggregateItemStatus) {
                                aggregateItemStatusBis.add(new ItemStatus(OG_INDEXATION).setItemsStatus(OG_INDEXATION, new ItemStatus(OG_INDEXATION).increment(StatusCode.FATAL)));
                            }
                            aggregateItemStatus = aggregateItemStatusBis;
                        }
                    }
                    arrayList = aggregateItemStatus;
                    if (metadataClient == null) break block20;
                }
                catch (Throwable throwable) {
                    if (metadataClient != null) {
                        try {
                            metadataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                metadataClient.close();
            }
            return arrayList;
        }
        finally {
            handler.setCurrentObjectId(null);
        }
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO param) {
        throw new RuntimeException();
    }

    private ObjectNode indexObjectGroup(HandlerIO handlerIO, WorkerParameters params, ItemStatus itemStatus) throws ProcessingException {
        ObjectNode objectNode;
        block9: {
            ParametersChecker.checkNullOrEmptyParameters((VitamParameter)params);
            MetaDataClient metadataClient = this.metaDataClientFactory.getClient();
            try {
                ObjectNode json = (ObjectNode)handlerIO.getInput(0);
                objectNode = this.handleExistingObjectGroup(json, metadataClient, params, itemStatus);
                if (metadataClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (metadataClient != null) {
                        try {
                            metadataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException | MetaDataException e) {
                    throw new ProcessingInternalServerException("Metadata Server Error", e);
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException e) {
                    throw new ProcessingException("Json wrong format", e);
                }
            }
            metadataClient.close();
        }
        return objectNode;
    }

    private ObjectNode handleExistingObjectGroup(ObjectNode json, MetaDataClient metadataClient, WorkerParameters params, ItemStatus itemStatus) throws MetaDataExecutionException, MetaDataClientServerException, InvalidParseOperationException, InvalidCreateOperationException, VitamClientException {
        this.removeTemporaryObjectVersionWorkFields(json);
        JsonNode work = json.remove("_work");
        if (work != null && work.get("DataObjectGroupExistingReferenceId") != null && !work.get("DataObjectGroupExistingReferenceId").asText().isEmpty()) {
            String existingOg = work.get("DataObjectGroupExistingReferenceId").asText();
            RequestResponse requestResponse = metadataClient.getObjectGroupByIdRaw(existingOg);
            JsonNode ogInDB = null;
            if (requestResponse.isOk()) {
                ogInDB = (JsonNode)((RequestResponseOK)requestResponse).getFirstResult();
            }
            if (ogInDB != null) {
                ObjectNode infoNode = JsonHandler.createObjectNode();
                ArrayNode originQualifiers = (ArrayNode)ogInDB.get("_qualifiers");
                ArrayNode newQualifiers = (ArrayNode)json.get("_qualifiers");
                UpdateMultiQuery query = new UpdateMultiQuery();
                query.addHintFilter(new String[]{BuilderToken.FILTERARGS.OBJECTGROUPS.exactToken()});
                ObjectNode newUpdateQuery = query.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{params.getContainerName()}), this.generateQualifiersUpdate(originQualifiers, newQualifiers, infoNode)}).getFinalUpdate();
                metadataClient.updateObjectGroupById((JsonNode)newUpdateQuery, ogInDB.get("_id").asText());
                String evDevDetailData = JsonHandler.unprettyPrint((Object)infoNode);
                itemStatus.setEvDetailData(evDevDetailData);
                itemStatus.increment(StatusCode.OK);
                return null;
            }
        }
        InsertMultiQuery insertRequest = new InsertMultiQuery().addData(new ObjectNode[]{json});
        ObjectNode finalInsert = insertRequest.getFinalInsert();
        itemStatus.increment(StatusCode.OK);
        return finalInsert;
    }

    private void removeTemporaryObjectVersionWorkFields(ObjectNode jsonOG) {
        JsonNode qualifiers = jsonOG.get("_qualifiers");
        if (qualifiers == null || !qualifiers.isArray()) {
            LOGGER.error("Invalid or missing _qualifiers : " + JsonHandler.unprettyPrint((Object)jsonOG));
            throw new IllegalStateException(INVALID_OR_MISSING_QUALIFIERS);
        }
        for (JsonNode qualifier : qualifiers) {
            JsonNode qualifierVersions = qualifier.get("versions");
            if (qualifierVersions == null || !qualifierVersions.isArray()) {
                LOGGER.error("Missing versions : " + JsonHandler.unprettyPrint((Object)jsonOG));
                throw new IllegalStateException(MISSING_VERSIONS);
            }
            for (JsonNode version : qualifierVersions) {
                if (version == null || !version.isObject()) {
                    LOGGER.error("Missing version : " + JsonHandler.unprettyPrint((Object)jsonOG));
                    throw new IllegalStateException(MISSING_VERSION);
                }
                ((ObjectNode)version).remove("_work");
            }
        }
    }

    private Action generateQualifiersUpdate(ArrayNode originQualifiers, ArrayNode newQualifiers, ObjectNode infoNode) throws InvalidCreateOperationException {
        JsonNode qualifierNode;
        int i;
        ArrayNode finalQualifiers = originQualifiers.deepCopy();
        HashMap<String, ArrayNode> action = new HashMap<String, ArrayNode>();
        HashMap<String, ArrayNode> listOrigin = new HashMap<String, ArrayNode>();
        ObjectNode updatedQualifiers = JsonHandler.createObjectNode();
        for (i = 0; i < originQualifiers.size(); ++i) {
            qualifierNode = originQualifiers.get(i);
            listOrigin.put(qualifierNode.get("qualifier").asText(), (ArrayNode)qualifierNode.get("versions"));
        }
        block1: for (i = 0; i < newQualifiers.size(); ++i) {
            qualifierNode = newQualifiers.get(i);
            String qualifType = qualifierNode.get("qualifier").asText();
            if (listOrigin.containsKey(qualifType)) {
                for (int j = 0; j < finalQualifiers.size(); ++j) {
                    ObjectNode current = (ObjectNode)finalQualifiers.get(j);
                    if (!current.get("qualifier").asText().equals(qualifierNode.get("qualifier").asText())) continue;
                    ArrayNode versionsNode = (ArrayNode)qualifierNode.get("versions");
                    for (JsonNode versionNode : versionsNode) {
                        int nbCopy = current.get("_nbc").asInt() + 1;
                        current.put("_nbc", current.get("_nbc").asInt() + 1);
                        ArrayNode currentArray = (ArrayNode)current.get("versions");
                        ((ObjectNode)versionNode).put("DataObjectVersion", current.get("qualifier").asText() + "_" + nbCopy);
                        currentArray.add(versionNode);
                        IntNode version = new IntNode(nbCopy);
                        updatedQualifiers.set(current.get("qualifier").asText(), (JsonNode)version);
                    }
                    continue block1;
                }
                continue;
            }
            finalQualifiers.add(qualifierNode);
            updatedQualifiers.set(qualifType, (JsonNode)new IntNode(1));
        }
        infoNode.set("updatedQualifiers", (JsonNode)updatedQualifiers);
        action.put(BuilderToken.PROJECTIONARGS.QUALIFIERS.exactToken(), finalQualifiers);
        return new SetAction(action);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

