/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.batch.report.model.OperationSummary;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.CommonReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class GenericReportGenerationHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(GenericReportGenerationHandler.class);
    private final CommonReportService<?> reportService;

    protected GenericReportGenerationHandler(CommonReportService<?> reportService) {
        this.reportService = reportService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.storeReportToWorkspace(param, handler);
            this.storeReportToOffers(param.getContainerName());
            this.cleanupReport(param.getContainerName());
            return PluginHelper.buildItemStatus(this.getPluginId(), StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Report generation failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(this.getPluginId(), e.getStatusCode(), e.getEventDetails());
        }
    }

    private ReportResults storeReportToWorkspace(WorkerParameters param, HandlerIO handler) throws ProcessingStatusException, ProcessingException {
        try {
            if (this.reportService.isReportWrittenInWorkspace(param.getContainerName())) {
                JsonNode report = handler.getJsonFromWorkspace("report.jsonl");
                return ((Report)JsonHandler.getFromJsonNode((JsonNode)report, Report.class)).getReportSummary().getVitamResults();
            }
            Report reportInfo = this.generateReport(param, this.getLogbookInformation(param));
            this.reportService.storeReportToWorkspace(reportInfo);
            return reportInfo.getReportSummary().getVitamResults();
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private void storeReportToOffers(String containerName) throws ProcessingStatusException {
        this.reportService.storeReportToOffers(containerName);
    }

    private void cleanupReport(String containerName) throws ProcessingStatusException {
        this.reportService.cleanupReport(containerName);
    }

    protected OperationSummary getOperationSummary(LogbookOperation logbook, String processId) throws InvalidParseOperationException {
        List events = logbook.getEvents();
        LogbookEventOperation lastEvent = (LogbookEventOperation)events.get(events.size() - 2);
        ObjectNode rSI = StringUtils.isNotBlank((CharSequence)logbook.getRightsStatementIdentifier()) ? JsonHandler.getFromString((String)logbook.getRightsStatementIdentifier()) : JsonHandler.createObjectNode();
        ObjectNode evDetData = Objects.isNull(lastEvent.getEvDetData()) ? JsonHandler.createObjectNode() : JsonHandler.getFromString((String)lastEvent.getEvDetData());
        return new OperationSummary(VitamThreadUtils.getVitamSession().getTenantId(), processId, lastEvent.getEvType(), lastEvent.getOutcome(), lastEvent.getOutDetail(), lastEvent.getOutMessg(), (JsonNode)rSI, (JsonNode)evDetData);
    }

    protected Report generateReport(WorkerParameters param, LogbookOperation logbook) throws InvalidParseOperationException {
        OperationSummary operationSummary = this.getOperationSummary(logbook, param.getContainerName());
        ReportSummary reportSummary = this.getReport(logbook);
        if (reportSummary.getVitamResults() != null && reportSummary.getVitamResults().getNbKo() > 0 && StatusCode.WARNING.name().equals(param.getWorkflowStatusKo())) {
            operationSummary.setOutcome(operationSummary.getOutcome().replace(StatusCode.KO.name(), param.getWorkflowStatusKo()));
            operationSummary.setOutDetail(operationSummary.getOutDetail().replace(StatusCode.KO.name(), param.getWorkflowStatusKo()));
        }
        ObjectNode context = JsonHandler.createObjectNode();
        return new Report(operationSummary, reportSummary, (JsonNode)context);
    }

    protected ReportSummary getReport(LogbookOperation logbook) {
        Optional<LogbookEventOperation> logbookEvent = logbook.getEvents().stream().filter(e -> e.getEvType().startsWith(this.getLogbookActionKey())).reduce((a, b) -> b);
        String startDate = logbook.getEvDateTime();
        String endDate = LocalDateUtil.nowFormatted();
        if (logbookEvent.isEmpty()) {
            return new ReportSummary(startDate, endDate, this.getReportType(), new ReportResults(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)), null);
        }
        Map<StatusCode, Integer> codesNumber = this.getStatusStatistic((LogbookEvent)logbookEvent.get());
        int nbOk = codesNumber.get(StatusCode.OK) == null ? 0 : codesNumber.get(StatusCode.OK);
        int nbKo = codesNumber.get(StatusCode.KO) == null ? 0 : codesNumber.get(StatusCode.KO);
        int nbWarning = codesNumber.get(StatusCode.WARNING) == null ? 0 : codesNumber.get(StatusCode.WARNING);
        ReportResults results = new ReportResults(Integer.valueOf(nbOk), Integer.valueOf(nbKo), Integer.valueOf(nbWarning));
        return new ReportSummary(startDate, endDate, this.getReportType(), results, null);
    }

    protected Map<StatusCode, Integer> getStatusStatistic(LogbookEvent logbookEvent) {
        String outMessg = logbookEvent.getOutMessg();
        if (StringUtils.isBlank((CharSequence)outMessg)) {
            return Collections.emptyMap();
        }
        String[] splitedMessage = outMessg.split(" Detail= ");
        if (splitedMessage.length != 2) {
            return Collections.emptyMap();
        }
        return Stream.of(splitedMessage).reduce((first, second) -> second).map(last -> Stream.of(last.split("\\s")).filter(StringUtils::isNotBlank).collect(Collectors.toMap(s -> StatusCode.valueOf((String)s.split(":")[0]), s -> Integer.valueOf(s.split(":")[1])))).orElse(Collections.emptyMap());
    }

    protected abstract String getPluginId();

    protected abstract ReportType getReportType();

    protected abstract String getLogbookActionKey();

    protected abstract LogbookOperation getLogbookInformation(WorkerParameters var1) throws ProcessingException;
}

