/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.format.identification.FormatIdentifier;
import fr.gouv.vitam.common.format.identification.FormatIdentifierFactory;
import fr.gouv.vitam.common.format.identification.exception.FileFormatNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierBadRequestException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierFactoryException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierNotFoundException;
import fr.gouv.vitam.common.format.identification.exception.FormatIdentifierTechnicalException;
import fr.gouv.vitam.common.format.identification.model.FormatIdentifierResponse;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.model.administration.ContractsDetailsModel;
import fr.gouv.vitam.common.model.administration.FileFormatModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormatIdentificationActionPlugin
extends ActionHandler
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FormatIdentificationActionPlugin.class);
    public static final String FILE_FORMAT = "FILE_FORMAT";
    public static final String PUID = "PUID";
    private static final String FILE_FORMAT_NOT_FOUND = "NOT_FOUND";
    private static final String FILE_FORMAT_UPDATED_FORMAT = "UPDATED_FORMAT";
    private static final String FILE_FORMAT_PUID_NOT_FOUND = "PUID_NOT_FOUND";
    private static final String FILE_FORMAT_NOT_FOUND_REFERENTIAL_ERROR = "NOT_FOUND_REFERENTIAL";
    private static final String FILE_FORMAT_REJECTED = "REJECTED_FORMAT";
    private static final String FORMAT_IDENTIFIER_ID = "siegfried-local";
    private static final int OG_INPUT_RANK = 0;
    private static final String SUBSTATUS_UNKNOWN = "UNKNOWN";
    private static final String SUBSTATUS_UNCHARTED = "UNCHARTED";
    private static final String SUBSTATUS_REJECTED = "REJECTED";
    private static final int REFERENTIAL_INGEST_CONTRACT_PARAMETERS_RANK = 1;
    private static final String UNKNOWN_FORMAT = "unknown";
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final FormatIdentifierFactory formatIdentifierFactory;

    public FormatIdentificationActionPlugin() {
        this(AdminManagementClientFactory.getInstance(), FormatIdentifierFactory.getInstance());
    }

    @VisibleForTesting
    public FormatIdentificationActionPlugin(AdminManagementClientFactory adminManagementClientFactory, FormatIdentifierFactory formatIdentifierFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.formatIdentifierFactory = formatIdentifierFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        IngestContractModel ingestContract;
        FormatIdentifier formatIdentifier;
        this.checkMandatoryParameters(params);
        LOGGER.debug("FormatIdentificationActionHandler running ...");
        ItemStatus itemStatus = new ItemStatus(FILE_FORMAT);
        try {
            formatIdentifier = this.formatIdentifierFactory.getFormatIdentifierFor(FORMAT_IDENTIFIER_ID);
        }
        catch (FormatIdentifierFactoryException | FormatIdentifierNotFoundException | FormatIdentifierTechnicalException e) {
            LOGGER.error("An error occurred during format identifier initialization", e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(FILE_FORMAT).setItemsStatus(FILE_FORMAT, itemStatus);
        }
        try {
            ingestContract = this.loadIngestContractFromWorkspace(handlerIO);
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error("An error occurred during ingest contract loading", e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(FILE_FORMAT).setItemsStatus(FILE_FORMAT, itemStatus);
        }
        try {
            List versions;
            JsonNode jsonOG = (JsonNode)handlerIO.getInput(0);
            boolean metadataUpdated = false;
            Map<String, String> objectIdToUri = this.getMapOfObjectsIdsAndUris(jsonOG);
            JsonNode qualifiers = jsonOG.get("_qualifiers");
            if (qualifiers != null && (versions = qualifiers.findValues("versions")) != null && !versions.isEmpty()) {
                for (JsonNode versionsArray : versions) {
                    for (JsonNode version : versionsArray) {
                        if (version.get("PhysicalId") != null) continue;
                        File file = null;
                        try {
                            String objectId = version.get("_id").asText();
                            file = this.loadFileFromWorkspace(handlerIO, objectIdToUri.get(objectId));
                            ObjectCheckFormatResult result = this.executeOneObjectFromOG(ingestContract, formatIdentifier, file, (ObjectNode)version);
                            if (result.getMetadataUpdated()) {
                                metadataUpdated = true;
                            }
                            ItemStatus subTaskItemStatus = new ItemStatus(FILE_FORMAT);
                            subTaskItemStatus.increment(result.getStatus());
                            itemStatus.increment(result.getStatus());
                            if (result.getStatus().equals((Object)StatusCode.KO)) {
                                switch (result.getSubStatus()) {
                                    case "NOT_FOUND": {
                                        subTaskItemStatus.setGlobalOutcomeDetailSubcode(SUBSTATUS_UNKNOWN);
                                        break;
                                    }
                                    case "NOT_FOUND_REFERENTIAL": 
                                    case "PUID_NOT_FOUND": {
                                        subTaskItemStatus.setGlobalOutcomeDetailSubcode(SUBSTATUS_UNCHARTED);
                                        break;
                                    }
                                    case "REJECTED_FORMAT": {
                                        subTaskItemStatus.setGlobalOutcomeDetailSubcode(SUBSTATUS_REJECTED);
                                        itemStatus.setGlobalOutcomeDetailSubcode(FILE_FORMAT_REJECTED);
                                    }
                                }
                                LOGGER.error(JsonHandler.unprettyPrint((Object)result));
                            }
                            itemStatus.setSubTaskStatus(objectId, subTaskItemStatus);
                            if (result.getEventDetailData() != null) {
                                ((ItemStatus)itemStatus.getSubTaskStatus().get(objectId)).setEvDetailData(result.getEventDetailData());
                            }
                            if (!StatusCode.FATAL.equals((Object)itemStatus.getGlobalStatus())) continue;
                            String string = new ItemStatus(FILE_FORMAT).setItemsStatus(FILE_FORMAT, itemStatus);
                            return string;
                        }
                        finally {
                            if (file == null) continue;
                            try {
                                Files.delete(file.toPath());
                            }
                            catch (IOException e) {
                                LOGGER.error((Throwable)e);
                            }
                        }
                    }
                }
            }
            if (metadataUpdated) {
                handlerIO.transferJsonToWorkspace("ObjectGroup", params.getObjectName(), jsonOG, false, false);
            }
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        if (itemStatus.getGlobalStatus().getStatusLevel() == StatusCode.UNKNOWN.getStatusLevel()) {
            itemStatus.increment(StatusCode.OK);
        }
        LOGGER.debug("FormatIdentificationActionHandler response: " + itemStatus.getGlobalStatus());
        return new ItemStatus(FILE_FORMAT).setItemsStatus(itemStatus.getItemId(), itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    private ObjectCheckFormatResult executeOneObjectFromOG(IngestContractModel ingestContract, FormatIdentifier formatIdentifier, File file, ObjectNode version) {
        FileFormatModel fileFormatModel;
        FormatIdentifierResponse format;
        try {
            format = this.getFirstPronomFormat(formatIdentifier, file);
        }
        catch (FormatIdentifierBadRequestException | FormatIdentifierNotFoundException | FormatIdentifierTechnicalException e) {
            LOGGER.error("An error occurred during file format identification", e);
            return new ObjectCheckFormatResult().setStatus(StatusCode.FATAL);
        }
        catch (FileFormatNotFoundException e) {
            LOGGER.error("File does not match any format signature", (Throwable)e);
            ObjectCheckFormatResult objectCheckFormatResult = new ObjectCheckFormatResult();
            if (ingestContract.isFormatUnidentifiedAuthorized() && ingestContract.isEveryFormatType()) {
                this.checkNotFoundFormatIdentification(version, objectCheckFormatResult);
                objectCheckFormatResult.setStatus(StatusCode.WARNING);
            } else {
                objectCheckFormatResult.setStatus(StatusCode.KO);
            }
            objectCheckFormatResult.setSubStatus(FILE_FORMAT_NOT_FOUND);
            return objectCheckFormatResult;
        }
        try {
            fileFormatModel = this.loadFileFormat(format);
            if (fileFormatModel == null) {
                ObjectCheckFormatResult objectCheckFormatResult = new ObjectCheckFormatResult();
                if (ingestContract.isFormatUnidentifiedAuthorized()) {
                    this.checkNotFoundFormatIdentification(version, objectCheckFormatResult);
                }
                objectCheckFormatResult.setStatus(StatusCode.KO);
                objectCheckFormatResult.setSubStatus(FILE_FORMAT_PUID_NOT_FOUND);
                return objectCheckFormatResult;
            }
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | ReferentialException | IOException e) {
            LOGGER.error("An error occurred during format loading from referential", e);
            return new ObjectCheckFormatResult().setStatus(StatusCode.FATAL);
        }
        if (this.identifiedFormatsRestricted(fileFormatModel.getPuid(), ingestContract)) {
            LOGGER.error("File format " + fileFormatModel.getPuid() + " is not authorized by ingest contract " + ingestContract.getIdentifier());
            return new ObjectCheckFormatResult().setStatus(StatusCode.KO).setSubStatus(FILE_FORMAT_REJECTED);
        }
        ObjectCheckFormatResult objectCheckFormatResult = new ObjectCheckFormatResult();
        objectCheckFormatResult.setStatus(StatusCode.OK);
        this.checkAndUpdateFormatIdentification(version, fileFormatModel.getPuid(), fileFormatModel.getName(), fileFormatModel.getMimeType(), objectCheckFormatResult);
        return objectCheckFormatResult;
    }

    private FileFormatModel loadFileFormat(FormatIdentifierResponse format) throws InvalidCreateOperationException, ReferentialException, InvalidParseOperationException, IOException {
        RequestResponse result;
        String formatId = format.getPuid();
        Select select = new Select();
        select.setQuery((Query)QueryHelper.eq((String)PUID, (String)formatId));
        try (AdminManagementClient adminClient = this.adminManagementClientFactory.getClient();){
            result = adminClient.getFormats((JsonNode)select.getFinalSelect());
        }
        if (!result.isOk() || ((RequestResponseOK)result).getResults().isEmpty()) {
            return null;
        }
        return (FileFormatModel)((RequestResponseOK)result).getResults().get(0);
    }

    private void checkAndUpdateFormatIdentification(ObjectNode version, String puid, String name, String mimeType, ObjectCheckFormatResult objectCheckFormatResult) {
        ObjectNode diffJsonNodeToPopulate = JsonHandler.createObjectNode();
        ObjectNode formatIdentification = (ObjectNode)version.get("FormatIdentification");
        if (formatIdentification == null) {
            formatIdentification = JsonHandler.createObjectNode();
            version.set("FormatIdentification", (JsonNode)formatIdentification);
        }
        boolean puidUpdated = this.checkAndUpdateManifestFormatFieldAgainstReferentialValue(formatIdentification, PUID, "FormatId", puid, diffJsonNodeToPopulate, objectCheckFormatResult);
        boolean formatLiteralUpdated = this.checkAndUpdateManifestFormatFieldAgainstReferentialValue(formatIdentification, "FormatLitteral", "FormatLitteral", name, diffJsonNodeToPopulate, objectCheckFormatResult);
        boolean mimeTypeUpdated = this.checkAndUpdateManifestFormatFieldAgainstReferentialValue(formatIdentification, "MimeType", "MimeType", mimeType, diffJsonNodeToPopulate, objectCheckFormatResult);
        if (puidUpdated || formatLiteralUpdated || mimeTypeUpdated) {
            objectCheckFormatResult.setMetadataUpdated(true);
        }
        if (StatusCode.WARNING.equals((Object)objectCheckFormatResult.getStatus())) {
            objectCheckFormatResult.setSubStatus(FILE_FORMAT_UPDATED_FORMAT);
        }
        if (!diffJsonNodeToPopulate.isEmpty()) {
            ObjectNode wrappingDiffJsonObject = (ObjectNode)JsonHandler.createObjectNode().set("diff", (JsonNode)diffJsonNodeToPopulate);
            objectCheckFormatResult.setEventDetailData(JsonHandler.unprettyPrint((Object)wrappingDiffJsonObject));
        }
    }

    private boolean checkAndUpdateManifestFormatFieldAgainstReferentialValue(ObjectNode newFormatIdentification, String fieldName, String manifestFieldName, String referentialFormatFieldValue, ObjectNode diffJsonNodeToPopulate, ObjectCheckFormatResult objectCheckFormatResult) {
        String manifestFieldValue;
        boolean isManifestFieldUpdated = false;
        String string = manifestFieldValue = newFormatIdentification.get(manifestFieldName) != null ? newFormatIdentification.get(manifestFieldName).asText() : null;
        if (referentialFormatFieldValue != null && !referentialFormatFieldValue.equals(manifestFieldValue)) {
            if (manifestFieldValue != null) {
                diffJsonNodeToPopulate.put("- " + fieldName, manifestFieldValue);
                if (fieldName.equals(PUID)) {
                    objectCheckFormatResult.setStatus(StatusCode.WARNING);
                }
            }
            newFormatIdentification.put(manifestFieldName, referentialFormatFieldValue);
            diffJsonNodeToPopulate.put("+ " + fieldName, referentialFormatFieldValue);
            isManifestFieldUpdated = true;
        }
        return isManifestFieldUpdated;
    }

    private FormatIdentifierResponse getFirstPronomFormat(FormatIdentifier formatIdentifier, File file) throws FileFormatNotFoundException, FormatIdentifierTechnicalException, FormatIdentifierBadRequestException, FormatIdentifierNotFoundException {
        List formats = formatIdentifier.analysePath(file.toPath());
        for (FormatIdentifierResponse format : formats) {
            if (!"pronom".equals(format.getMatchedNamespace())) continue;
            return format;
        }
        throw new FileFormatNotFoundException("File format not found in siegfried-local");
    }

    private File loadFileFromWorkspace(HandlerIO handlerIO, String filePath) throws ProcessingException {
        try {
            return handlerIO.getFileFromWorkspace("SIP/" + filePath);
        }
        catch (IOException e) {
            LOGGER.debug("Error while saving the file", (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            LOGGER.debug("Workspace Server Error", e);
            throw new ProcessingException(e);
        }
    }

    private Map<String, String> getMapOfObjectsIdsAndUris(JsonNode jsonOG) {
        HashMap<String, String> binaryObjectsToStore = new HashMap<String, String>();
        JsonNode work = jsonOG.get("_work");
        JsonNode qualifiers = work.get("_qualifiers");
        if (qualifiers == null) {
            return binaryObjectsToStore;
        }
        List versions = qualifiers.findValues("versions");
        if (versions == null || versions.isEmpty()) {
            return binaryObjectsToStore;
        }
        for (JsonNode version : versions) {
            for (JsonNode binaryObject : version) {
                if (binaryObject.get("PhysicalId") != null) continue;
                binaryObjectsToStore.put(binaryObject.get("_id").asText(), binaryObject.get("Uri").asText());
            }
        }
        return binaryObjectsToStore;
    }

    private IngestContractModel loadIngestContractFromWorkspace(HandlerIO handlerIO) throws InvalidParseOperationException {
        ContractsDetailsModel contractsDetailsModel = (ContractsDetailsModel)JsonHandler.getFromFile((File)((File)handlerIO.getInput(1)), ContractsDetailsModel.class);
        return contractsDetailsModel.getIngestContractModel();
    }

    private boolean identifiedFormatsRestricted(String puid, IngestContractModel ingestContract) {
        return !ingestContract.isEveryFormatType() && !ingestContract.getFormatType().contains(puid);
    }

    private void checkNotFoundFormatIdentification(ObjectNode version, ObjectCheckFormatResult objectCheckFormatResult) {
        String formatName = version.path("FormatIdentification").path("FormatLitteral").textValue();
        String mimeType = version.path("FormatIdentification").path("MimeType").textValue();
        this.checkAndUpdateFormatIdentification(version, UNKNOWN_FORMAT, formatName, mimeType, objectCheckFormatResult);
    }

    private static class ObjectCheckFormatResult {
        private StatusCode status;
        private String subStatus;
        private boolean metadataUpdated;
        private String eventDetailData;

        private ObjectCheckFormatResult() {
        }

        public ObjectCheckFormatResult setStatus(StatusCode status) {
            this.status = status;
            return this;
        }

        public ObjectCheckFormatResult setSubStatus(String subStatus) {
            this.subStatus = subStatus;
            return this;
        }

        public StatusCode getStatus() {
            return this.status;
        }

        public String getSubStatus() {
            return this.subStatus;
        }

        public void setMetadataUpdated(boolean metadataUpdated) {
            this.metadataUpdated = metadataUpdated;
        }

        public boolean getMetadataUpdated() {
            return this.metadataUpdated;
        }

        public String getEventDetailData() {
            return this.eventDetailData;
        }

        public void setEventDetailData(String eventDetailData) {
            this.eventDetailData = eventDetailData;
        }
    }
}

