/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportBody;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.util.List;

public abstract class CommonReportService<T> {
    public static final String JSONL_EXTENSION = ".jsonl";
    public static final String WORKSPACE_REPORT_URI = "report.jsonl";
    private final BatchReportClientFactory batchReportClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final ReportType reportType;

    protected CommonReportService(ReportType reportType) {
        this(reportType, BatchReportClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    protected CommonReportService(ReportType reportType, BatchReportClientFactory batchReportClientFactory, WorkspaceClientFactory workspaceClientFactory, StorageClientFactory storageClientFactory) {
        this.reportType = reportType;
        this.batchReportClientFactory = batchReportClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public void appendEntries(String processId, List<T> entries) throws ProcessingStatusException {
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            ReportBody reportBody = new ReportBody(processId, this.reportType, entries);
            batchReportClient.appendReportEntries(reportBody);
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not append entries into report", e);
        }
    }

    public boolean isReportWrittenInWorkspace(String processId) throws ProcessingStatusException {
        boolean bl;
        block8: {
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                bl = workspaceClient.isExistingObject(processId, WORKSPACE_REPORT_URI);
                if (workspaceClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, "Could not check report existence in workspace", e);
                }
            }
            workspaceClient.close();
        }
        return bl;
    }

    public void deleteReportFromWorkspaceIfExists(String processId) throws ProcessingStatusException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (workspaceClient.isExistingObject(processId, WORKSPACE_REPORT_URI)) {
                workspaceClient.deleteObject(processId, WORKSPACE_REPORT_URI);
            }
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not purge existing report from workspace", e);
        }
    }

    public void storeReportToWorkspace(Report reportInfo) throws ProcessingStatusException {
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            batchReportClient.storeReportToWorkspace(reportInfo);
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not store report", e);
        }
    }

    public void storeReportToOffers(String containerName) throws ProcessingStatusException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(containerName);
            description.setWorkspaceObjectURI(WORKSPACE_REPORT_URI);
            storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), DataCategory.REPORT, containerName + JSONL_EXTENSION, description);
        }
        catch (StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not store report to offers", e);
        }
    }

    public void cleanupReport(String processId) throws ProcessingStatusException {
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            batchReportClient.cleanupReport(processId, this.reportType);
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not cleanup report entries (" + processId + ")", e);
        }
    }
}

