/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.DataObjectInfo;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckObjectSizeActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckObjectSizeActionPlugin.class);
    public static final String CHECK_OBJECT_SIZE = "CHECK_SIZE";
    private static final int OG_OUT_RANK = 0;

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) throws ProcessingException {
        this.checkMandatoryParameters(params);
        LOGGER.debug("CheckSizeActionPlugin running ...");
        ItemStatus itemStatus = new ItemStatus(CHECK_OBJECT_SIZE);
        try {
            List versions;
            JsonNode jsonOG = handlerIO.getJsonFromWorkspace("ObjectGroup/" + params.getObjectName());
            handlerIO.addOutputResult(0, (Object)jsonOG, true, false);
            Map<String, DataObjectInfo> binaryObjects = this.getBinaryObjects(jsonOG);
            JsonNode qualifiers = jsonOG.get("_qualifiers");
            if (qualifiers != null && (versions = qualifiers.findValues("versions")) != null && !versions.isEmpty()) {
                for (JsonNode versionsArray : versions) {
                    for (JsonNode version : versionsArray) {
                        String objectId;
                        String checkSizeEvDetDetails;
                        if (version.get("PhysicalId") != null || (checkSizeEvDetDetails = this.checkIsSizeIncorrect(binaryObjects.get(objectId = version.get("_id").asText()), version, itemStatus)) == null) continue;
                        ((ItemStatus)itemStatus.getSubTaskStatus().get(objectId)).setEvDetailData(checkSizeEvDetDetails);
                    }
                }
            }
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        if (itemStatus.getGlobalStatus().getStatusLevel() == StatusCode.UNKNOWN.getStatusLevel()) {
            itemStatus.increment(StatusCode.OK);
        }
        LOGGER.debug("CheckSizeActionPlugin response: " + itemStatus.getGlobalStatus());
        return new ItemStatus(CHECK_OBJECT_SIZE).setItemsStatus(CHECK_OBJECT_SIZE, itemStatus);
    }

    private String checkIsSizeIncorrect(DataObjectInfo dataObjectInfo, JsonNode version, ItemStatus itemStatus) {
        ItemStatus subTaskItemStatus = new ItemStatus(CHECK_OBJECT_SIZE);
        String eventDetailData = null;
        if (version.get("_work") != null && !JsonHandler.isNullOrEmpty((JsonNode)version.get("_work").get("_diffSizeJson"))) {
            ObjectNode workNode = (ObjectNode)version.get("_work");
            if (workNode.get("_diffSizeJson").size() > 0) {
                JsonNode wrappingDiffJsonObject = JsonHandler.createObjectNode().set("diff", workNode.get("_diffSizeJson"));
                eventDetailData = JsonHandler.unprettyPrint((Object)wrappingDiffJsonObject);
            }
            if (workNode.get("_isSizeIncorrect").asBoolean()) {
                subTaskItemStatus.increment(StatusCode.WARNING);
                itemStatus.increment(StatusCode.WARNING);
            } else {
                subTaskItemStatus.increment(StatusCode.OK);
            }
        } else {
            subTaskItemStatus.increment(StatusCode.OK);
        }
        itemStatus.setSubTaskStatus(dataObjectInfo.getId(), subTaskItemStatus);
        return eventDetailData;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
        handler.checkHandlerIO(1, Collections.singletonList(String.class));
    }

    private Map<String, DataObjectInfo> getBinaryObjects(JsonNode jsonOG) throws ProcessingException {
        HashMap<String, DataObjectInfo> binaryObjects = new HashMap<String, DataObjectInfo>();
        JsonNode work = jsonOG.get("_work");
        JsonNode qualifiers = work.get("_qualifiers");
        if (qualifiers == null) {
            return binaryObjects;
        }
        List versions = qualifiers.findValues("versions");
        if (versions == null || versions.isEmpty()) {
            return binaryObjects;
        }
        for (JsonNode version : versions) {
            LOGGER.debug(version.toString());
            for (JsonNode jsonBinaryObject : version) {
                if (jsonBinaryObject.get("PhysicalId") != null) continue;
                binaryObjects.put(jsonBinaryObject.get("_id").asText(), new DataObjectInfo().setSize(Long.valueOf(jsonBinaryObject.get("Size").asLong())).setId(jsonBinaryObject.get("_id").asText()).setUri(jsonBinaryObject.get("Uri").asText()));
            }
        }
        return binaryObjects;
    }
}

