/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationErrorCode;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationException;
import fr.gouv.vitam.processing.common.exception.MetaDataContainSpecialCharactersException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.validation.MetadataValidationProvider;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public class CheckObjectGroupSchemaActionPlugin
extends ActionHandler {
    private static final String WORKSPACE_SERVER_ERROR = "Workspace Server Error";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckObjectGroupSchemaActionPlugin.class);
    private static final String CHECK_OG_SCHEMA_TASK_ID = "CHECK_OBJECT_GROUP_SCHEMA";
    private static final int OG_OUT_RANK = 0;
    private static final String OBJECT_GROUP_SANITIZE = "OBJECT_GROUP_SANITIZE";
    private static final String ONTOLOGY_VALIDATION = "ONTOLOGY_VALIDATION";
    static final String INVALID_OG = "INVALID_OBJECT_GROUP";
    private static final String DATE_FORMAT = "DATE_FORMAT";
    static final String CONSISTENCY = "CONSISTENCY";
    private final MetadataValidationProvider metadataValidationProvider;

    public CheckObjectGroupSchemaActionPlugin() {
        this(MetadataValidationProvider.getInstance());
    }

    @VisibleForTesting
    CheckObjectGroupSchemaActionPlugin(MetadataValidationProvider metadataValidationProvider) {
        this.metadataValidationProvider = metadataValidationProvider;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(CHECK_OG_SCHEMA_TASK_ID);
        try {
            this.checkObjectGroupJsonAgainstSchema(handler, params, itemStatus);
            itemStatus.increment(StatusCode.OK);
            return new ItemStatus(CHECK_OG_SCHEMA_TASK_ID).setItemsStatus(CHECK_OG_SCHEMA_TASK_ID, itemStatus);
        }
        catch (MetadataValidationException e) {
            LOGGER.warn("Object group schema validation failed " + params.getObjectName(), (Throwable)e);
            if (e.getErrorCode().equals((Object)MetadataValidationErrorCode.ONTOLOGY_VALIDATION_FAILURE)) {
                itemStatus.setItemId(ONTOLOGY_VALIDATION);
                itemStatus.increment(StatusCode.KO);
                ObjectNode object = JsonHandler.createObjectNode();
                object.put("evDetTechData", e.getMessage());
                itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)object));
                return new ItemStatus(CHECK_OG_SCHEMA_TASK_ID).setItemsStatus(CHECK_OG_SCHEMA_TASK_ID, itemStatus);
            }
            throw new IllegalStateException("Unexpected value: " + e.getErrorCode());
        }
        catch (MetaDataContainSpecialCharactersException e) {
            LOGGER.error((Throwable)e);
            itemStatus.setItemId(OBJECT_GROUP_SANITIZE);
            itemStatus.increment(StatusCode.KO);
            ObjectNode object = JsonHandler.createObjectNode();
            object.put("evDetTechData", e.getMessage());
            itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)object));
            return new ItemStatus(CHECK_OG_SCHEMA_TASK_ID).setItemsStatus(CHECK_OG_SCHEMA_TASK_ID, itemStatus);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(CHECK_OG_SCHEMA_TASK_ID).setItemsStatus(itemStatus.getItemId(), itemStatus);
        }
    }

    private void checkObjectGroupJsonAgainstSchema(HandlerIO handlerIO, WorkerParameters params, ItemStatus itemStatus) throws ProcessingException, MetadataValidationException {
        JsonNode objectGroupJson;
        String objectName = params.getObjectName();
        try (InputStream archiveOgToJson = handlerIO.getInputStreamFromWorkspace("ObjectGroup" + File.separator + objectName);){
            objectGroupJson = JsonHandler.getFromInputStream((InputStream)archiveOgToJson);
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingException(WORKSPACE_SERVER_ERROR, e);
        }
        try {
            SanityChecker.checkJsonAll((JsonNode)objectGroupJson);
        }
        catch (InvalidParseOperationException e) {
            itemStatus.setGlobalOutcomeDetailSubcode(INVALID_OG);
            String err = "Sanity Checker failed for Object Group: " + e.getMessage();
            throw new MetaDataContainSpecialCharactersException(err, (Throwable)e);
        }
        Stopwatch ontologyTime = Stopwatch.createStarted();
        ObjectNode updatedOgJson = this.metadataValidationProvider.getObjectGroupOntologyValidator().verifyAndReplaceFields(objectGroupJson);
        boolean isUpdateJsonMandatory = !objectGroupJson.equals((Object)updatedOgJson);
        PerformanceLogger.getInstance().log("STP_OBJECT_GROUP_CHECK_AND_PROCESS", CHECK_OG_SCHEMA_TASK_ID, "validationOntology", ontologyTime.elapsed(TimeUnit.MILLISECONDS));
        if (isUpdateJsonMandatory) {
            handlerIO.transferJsonToWorkspace("ObjectGroup", objectName, (JsonNode)updatedOgJson, false, false);
        }
    }
}

