/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.DataObjectInfo;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class CheckConformityActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckConformityActionPlugin.class);
    public static final String CALC_CHECK = "CALC_CHECK";
    private static final String EMPTY = "EMPTY";
    private static final String INVALID = "INVALID";
    private static final int ALGO_RANK = 0;
    private static final int OG_OUT_RANK = 0;

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) throws ProcessingException {
        this.checkMandatoryParameters(params);
        LOGGER.debug("CheckConformityActionHandler running ...");
        ItemStatus itemStatus = new ItemStatus(CALC_CHECK);
        try {
            List versions;
            JsonNode jsonOG = handlerIO.getJsonFromWorkspace("ObjectGroup/" + params.getObjectName());
            handlerIO.addOutputResult(0, (Object)jsonOG, true, false);
            Map<String, DataObjectInfo> binaryObjects = this.getBinaryObjects(jsonOG);
            boolean oneOrMoreMessagesDigestUpdated = false;
            JsonNode qualifiers = jsonOG.get("_qualifiers");
            if (qualifiers != null && (versions = qualifiers.findValues("versions")) != null && !versions.isEmpty()) {
                for (JsonNode versionsArray : versions) {
                    for (JsonNode version : versionsArray) {
                        String objectId;
                        boolean messagesDigestUpdated;
                        if (version.get("PhysicalId") != null || !(messagesDigestUpdated = this.checkMessageDigest(binaryObjects.get(objectId = version.get("_id").asText()), version, itemStatus, handlerIO))) continue;
                        oneOrMoreMessagesDigestUpdated = true;
                    }
                }
            }
            if (oneOrMoreMessagesDigestUpdated) {
                handlerIO.transferJsonToWorkspace("ObjectGroup", params.getObjectName(), jsonOG, false, false);
            }
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        if (itemStatus.getGlobalStatus().getStatusLevel() == StatusCode.UNKNOWN.getStatusLevel()) {
            itemStatus.increment(StatusCode.OK);
        }
        LOGGER.debug("CheckConformityActionHandler response: " + itemStatus.getGlobalStatus());
        return new ItemStatus(CALC_CHECK).setItemsStatus(CALC_CHECK, itemStatus);
    }

    private boolean checkMessageDigest(DataObjectInfo binaryObject, JsonNode version, ItemStatus itemStatus, HandlerIO handlerIO) throws ProcessingException {
        boolean bl;
        InputStream inputStream = null;
        try {
            ObjectNode jsonNode;
            Digest manifestDigest;
            DigestType digestTypeInput = DigestType.fromValue((String)((String)handlerIO.getInput(0)));
            inputStream = handlerIO.getInputStreamFromWorkspace("SIP" + File.separator + binaryObject.getUri());
            Digest vitamDigest = new Digest(digestTypeInput);
            boolean isVitamDigest = false;
            if (!binaryObject.getAlgo().equals((Object)digestTypeInput)) {
                manifestDigest = new Digest(binaryObject.getAlgo());
                inputStream = manifestDigest.getDigestInputStream(inputStream);
            } else {
                manifestDigest = vitamDigest;
                isVitamDigest = true;
            }
            vitamDigest.update(inputStream);
            String manifestDigestString = manifestDigest.digestHex();
            String vitamDigestString = vitamDigest.digestHex();
            String binaryObjectMessageDigest = binaryObject.getMessageDigest();
            boolean messagesDigestUpdated = false;
            LOGGER.debug("DEBUG: \n\t" + binaryObject.getAlgo().getName() + " " + binaryObjectMessageDigest + "\n\t" + manifestDigestString + "\n\t" + vitamDigestString);
            ItemStatus subTaskItemStatus = new ItemStatus(CALC_CHECK);
            if (binaryObjectMessageDigest.isEmpty() || binaryObjectMessageDigest.equals(null)) {
                subTaskItemStatus.increment(StatusCode.KO);
                subTaskItemStatus.setGlobalOutcomeDetailSubcode(EMPTY);
                itemStatus.increment(StatusCode.KO);
            } else if (manifestDigestString.equals(binaryObjectMessageDigest)) {
                subTaskItemStatus.increment(StatusCode.OK);
                itemStatus.increment(StatusCode.OK);
                if (!isVitamDigest) {
                    ((ObjectNode)version).put("MessageDigest", vitamDigestString);
                    ((ObjectNode)version).put("Algorithm", (String)handlerIO.getInput(0));
                    messagesDigestUpdated = true;
                }
                jsonNode = JsonHandler.createObjectNode();
                jsonNode.put("MessageDigest", binaryObjectMessageDigest);
                jsonNode.put("Algorithm", binaryObject.getAlgo().getName());
                jsonNode.put("SystemMessageDigest", vitamDigestString);
                jsonNode.put("SystemAlgorithm", (String)handlerIO.getInput(0));
                subTaskItemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)jsonNode));
            } else {
                subTaskItemStatus.increment(StatusCode.KO);
                subTaskItemStatus.setGlobalOutcomeDetailSubcode(INVALID);
                itemStatus.increment(StatusCode.KO);
                jsonNode = JsonHandler.createObjectNode();
                jsonNode.put("MessageDigest", binaryObject.getMessageDigest());
                jsonNode.put("Algorithm", binaryObject.getAlgo().getName());
                jsonNode.put("ComputedMessageDigest", manifestDigestString);
                subTaskItemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)jsonNode));
            }
            itemStatus.setSubTaskStatus(binaryObject.getId(), subTaskItemStatus);
            bl = messagesDigestUpdated;
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            try {
                LOGGER.error(e);
                throw new ProcessingException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return bl;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
        handler.checkHandlerIO(1, Arrays.asList(String.class));
    }

    private Map<String, DataObjectInfo> getBinaryObjects(JsonNode jsonOG) throws ProcessingException {
        HashMap<String, DataObjectInfo> binaryObjects = new HashMap<String, DataObjectInfo>();
        JsonNode work = jsonOG.get("_work");
        JsonNode qualifiers = work.get("_qualifiers");
        if (qualifiers == null) {
            return binaryObjects;
        }
        List versions = qualifiers.findValues("versions");
        if (versions == null || versions.isEmpty()) {
            return binaryObjects;
        }
        for (JsonNode version : versions) {
            LOGGER.debug(version.toString());
            for (JsonNode jsonBinaryObject : version) {
                if (jsonBinaryObject.get("PhysicalId") != null) continue;
                binaryObjects.put(jsonBinaryObject.get("_id").asText(), new DataObjectInfo().setSize(Long.valueOf(jsonBinaryObject.get("Size").asLong())).setId(jsonBinaryObject.get("_id").asText()).setUri(jsonBinaryObject.get("Uri").asText()).setMessageDigest(jsonBinaryObject.get("MessageDigest").asText()).setAlgo(DigestType.fromValue((String)jsonBinaryObject.get("Algorithm").asText())));
            }
        }
        return binaryObjects;
    }
}

