/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.common.utils.ClassificationLevelUtil;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.IOException;
import java.io.InputStream;

public class CheckClassificationLevelActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckClassificationLevelActionPlugin.class);
    private static final String CHECK_CLASSIFICATION_LEVEL_TASK_ID = "CHECK_CLASSIFICATION_LEVEL";
    private static final int UNIT_INPUT_RANK = 0;

    CheckClassificationLevelActionPlugin() {
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID);
        try {
            JsonNode archiveUnit = this.getArchiveUnit(param, handler);
            if (!ClassificationLevelUtil.checkClassificationLevel((JsonNode)archiveUnit)) {
                itemStatus.increment(StatusCode.KO);
                return new ItemStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID).setItemsStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID, itemStatus);
            }
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            LOGGER.error("Workspace Server Error");
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID).setItemsStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID, itemStatus);
        }
        catch (InvalidParseOperationException | IOException e) {
            LOGGER.error("File couldnt be converted into json", e);
            itemStatus.increment(StatusCode.KO);
            return new ItemStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID).setItemsStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID, itemStatus);
        }
        itemStatus.increment(StatusCode.OK);
        return new ItemStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID).setItemsStatus(CHECK_CLASSIFICATION_LEVEL_TASK_ID, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    private JsonNode getArchiveUnit(WorkerParameters params, HandlerIO handlerIO) throws IOException, InvalidParseOperationException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)params);
        String objectName = params.getObjectName();
        JsonNode archiveUnit = null;
        if (handlerIO.getInput().size() > 0) {
            archiveUnit = (JsonNode)handlerIO.getInput(0);
        } else {
            try (InputStream inputStream = handlerIO.getInputStreamFromWorkspace("Units/" + objectName);){
                archiveUnit = JsonHandler.getFromInputStream((InputStream)inputStream);
            }
        }
        return archiveUnit;
    }
}

