/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CheckAttachementActionHandler
extends ActionHandler {
    public static final String MAPS_EXISTING_GOTS_GUID_FOR_ATTACHMENT_FILE = "Maps/EXISTING_GOTS_GUID_FOR_ATTACHMENT_MAP.json";
    public static final String MAPS_EXISITING_UNITS_FOR_ATTACHMENT_FILE = "Maps/EXISTING_UNITS_GUID_FOR_ATTACHMENT_MAP.json";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckAttachementActionHandler.class);
    private static final String HANDLER_ID = "CHECK_ATTACHEMENT";
    private static final String OPI = "#opi";
    private static final String ARRAY_PROJECTION_FORMAT = "%s.%s";
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final ProcessingManagementClientFactory processingManagementClientFactory;

    CheckAttachementActionHandler() {
        this(MetaDataClientFactory.getInstance(), ProcessingManagementClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    CheckAttachementActionHandler(MetaDataClientFactory metaDataClientFactory, ProcessingManagementClientFactory processingManagementClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID).increment(StatusCode.OK);
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            JsonNode queryDsl;
            JsonNode unitsOpi;
            JsonNode UnitsOpiJsonNode;
            Set unitsIds;
            JsonNode existingGotsJsonNode = handlerIO.getJsonFromWorkspace(MAPS_EXISTING_GOTS_GUID_FOR_ATTACHMENT_FILE);
            Set existingGotsMap = (Set)JsonHandler.getFromJsonNode((JsonNode)existingGotsJsonNode, Set.class);
            if (!existingGotsMap.isEmpty()) {
                UnmodifiableIterator bulksExistingGotsIds = Iterators.partition(existingGotsMap.iterator(), (int)VitamConfiguration.getBatchSize());
                while (bulksExistingGotsIds.hasNext()) {
                    JsonNode queryDsl2 = this.getInitialOperationQuery((List)bulksExistingGotsIds.next());
                    JsonNode gotsOpi = metaDataClient.selectObjectGroups(queryDsl2);
                    if (!this.isFailedOrIncompletedOperation(gotsOpi)) continue;
                    ItemStatus itemStatus2 = new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, new ItemStatus(HANDLER_ID).increment(StatusCode.KO));
                    return itemStatus2;
                }
            }
            if ((unitsIds = (Set)JsonHandler.getFromJsonNode((JsonNode)(UnitsOpiJsonNode = handlerIO.getJsonFromWorkspace(MAPS_EXISITING_UNITS_FOR_ATTACHMENT_FILE)), Set.class)).isEmpty()) return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus).increment(StatusCode.OK);
            UnmodifiableIterator bulksExistingUnitsIds = Iterators.partition(unitsIds.iterator(), (int)VitamConfiguration.getBatchSize());
            do {
                if (!bulksExistingUnitsIds.hasNext()) return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus).increment(StatusCode.OK);
            } while (!this.isFailedOrIncompletedOperation(unitsOpi = metaDataClient.selectUnits(queryDsl = this.getInitialOperationQuery((List)bulksExistingUnitsIds.next()))));
            ItemStatus itemStatus3 = new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, new ItemStatus(HANDLER_ID).increment(StatusCode.KO));
            return itemStatus3;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Could not convert json to Object", (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus).increment(StatusCode.OK);
        }
        catch (MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            throw new ProcessingException("Could not retrive operation Id", e);
        }
    }

    private JsonNode getInitialOperationQuery(List<String> metadataIds) throws ProcessingException {
        String[] metadataIdsArray = (String[])metadataIds.toArray(String[]::new);
        Select select = new Select();
        try {
            select.setQuery(QueryHelper.in((String)BuilderToken.PROJECTIONARGS.ID.exactToken(), (String[])metadataIdsArray).setDepthLimit(0));
            select.setProjection(JsonHandler.createObjectNode().set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)JsonHandler.createObjectNode().put(BuilderToken.PROJECTIONARGS.INITIAL_OPERATION.exactToken(), 1)));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Cannot create opi query", e);
            throw new ProcessingException("Cannot create opi query", e);
        }
        return select.getFinalSelect();
    }

    private JsonNode getLastEventsQuery(Set<String> operationsIds) throws ProcessingException {
        String[] operationsIdsArray = (String[])operationsIds.toArray(String[]::new);
        Select select = new Select();
        try {
            select.setQuery((Query)QueryHelper.in((String)"evId", (String[])operationsIdsArray));
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error("Cannot create last event query", (Throwable)e);
            throw new ProcessingException("Cannot create last event query", (Throwable)e);
        }
        return select.getFinalSelect();
    }

    private boolean isFailedOrIncompletedOperation(JsonNode metadataJsonNode) throws ProcessingException {
        try {
            Set metadataResponse = (Set)JsonHandler.getFromJsonNode((JsonNode)metadataJsonNode.get("$results"), Set.class, Map.class);
            Set operationsIds = metadataResponse.stream().map(metadata -> (String)metadata.get(OPI)).collect(Collectors.toSet());
            Map operationsStatus = operationsIds.stream().collect(Collectors.toMap(Function.identity(), e -> true));
            HashSet<String> operationsIdToCheckWithLogbook = new HashSet<String>();
            for (String t : operationsStatus.keySet()) {
                Optional<ItemStatus> itemStatus = this.getProcessStatusIfExists(t);
                if (itemStatus.isEmpty()) {
                    operationsIdToCheckWithLogbook.add(t);
                    continue;
                }
                operationsStatus.put(t, itemStatus.get().getGlobalStatus().isGreaterOrEqualToKo() || !itemStatus.get().getGlobalState().equals((Object)ProcessState.COMPLETED));
            }
            if (!operationsIdToCheckWithLogbook.isEmpty()) {
                List<LogbookOperation> logbookOperations = this.checkLogbook(operationsIdToCheckWithLogbook);
                logbookOperations.stream().map(LogbookOperation::getEvents).map(Iterables::getLast).forEach(lastEvent -> operationsStatus.put(lastEvent.getEvIdProc(), this.isWorkflowUncompleted((LogbookEventOperation)lastEvent) || StatusCode.valueOf((String)lastEvent.getOutcome()).isGreaterOrEqualToKo()));
            }
            return operationsStatus.values().stream().anyMatch(e -> e.equals(true));
        }
        catch (InvalidParseOperationException e2) {
            LOGGER.error((Throwable)e2);
            throw new ProcessingException(e2.getMessage(), (Throwable)e2);
        }
    }

    private boolean isWorkflowUncompleted(LogbookEventOperation lastEvent) {
        return !lastEvent.getEvType().equals(Contexts.DEFAULT_WORKFLOW.getEventType()) && !lastEvent.getEvType().equals(Contexts.FILING_SCHEME.getEventType()) && !lastEvent.getEvType().equals(Contexts.HOLDING_SCHEME.getEventType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<LogbookOperation> checkLogbook(Set<String> operationsId) throws ProcessingException {
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            JsonNode logbookOperationsQuery = this.getLastEventsQuery(operationsId);
            JsonNode logbookOperationsResult = logbookOperationsClient.selectOperation(logbookOperationsQuery).get("$results");
            if (logbookOperationsResult.size() != operationsId.size()) throw new LogbookNotFoundException("Cannot find logbooks");
            List list = (List)JsonHandler.getFromJsonNode((JsonNode)logbookOperationsResult, List.class, LogbookOperation.class);
            return list;
        }
        catch (InvalidParseOperationException | LogbookClientException | LogbookNotFoundException e) {
            throw new ProcessingException("Cannot retrive operation status from logbook", e);
        }
    }

    private Optional<ItemStatus> getProcessStatusIfExists(String operationId) throws ProcessingException {
        Optional<ItemStatus> optional;
        block9: {
            ProcessingManagementClient processingManagementClient = this.processingManagementClientFactory.getClient();
            try {
                optional = Optional.of(processingManagementClient.getOperationProcessStatus(operationId));
                if (processingManagementClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (processingManagementClient != null) {
                        try {
                            processingManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (WorkflowNotFoundException e) {
                    return Optional.empty();
                }
                catch (BadRequestException | InternalServerException | VitamClientException e) {
                    throw new ProcessingException("Cannot retrive operation status from Process Management", e);
                }
            }
            processingManagementClient.close();
        }
        return optional;
    }
}

