/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ContractsDetailsModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationException;
import fr.gouv.vitam.processing.common.exception.MetaDataContainSpecialCharactersException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.signingInformation.IngestContractChecker;
import fr.gouv.vitam.worker.core.plugin.signingInformation.exception.SigningInformationException;
import fr.gouv.vitam.worker.core.validation.MetadataValidationProvider;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CheckArchiveUnitSchemaActionPlugin
extends ActionHandler {
    private static final String WORKSPACE_SERVER_ERROR = "Workspace Server Error";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckArchiveUnitSchemaActionPlugin.class);
    private static final String CHECK_UNIT_SCHEMA_TASK_ID = "CHECK_UNIT_SCHEMA";
    private static final int UNIT_OUT_RANK = 0;
    private static final int REFERENTIAL_INGEST_CONTRACT_IN_RANK = 1;
    private static final String UNIT_SANITIZE = "UNIT_SANITIZE";
    private static final String ONTOLOGY_VALIDATION = "ONTOLOGY_VALIDATION";
    private static final String UNKNOWN_TECHNICAL_EXCEPTION = "Unknown technical exception";
    static final String INVALID_UNIT = "INVALID_UNIT";
    private static final String DATE_FORMAT = "DATE_FORMAT";
    static final String CONSISTENCY = "CONSISTENCY";
    private static final TypeReference<List<OntologyModel>> LIST_TYPE_REFERENCE = new TypeReference<List<OntologyModel>>(){};
    private final MetadataValidationProvider metadataValidationProvider;

    public CheckArchiveUnitSchemaActionPlugin() {
        this(MetadataValidationProvider.getInstance());
    }

    @VisibleForTesting
    CheckArchiveUnitSchemaActionPlugin(MetadataValidationProvider metadataValidationProvider) {
        this.metadataValidationProvider = metadataValidationProvider;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(CHECK_UNIT_SCHEMA_TASK_ID);
        try {
            ObjectNode archiveUnit = this.loadArchiveUnit(handler, params, itemStatus);
            this.checkAUJsonAgainstSchema(handler, params, archiveUnit);
            Stopwatch checkUnitTime = Stopwatch.createStarted();
            IngestContractModel contractModel = this.loadIngestContractFromWorkspace(handler);
            IngestContractChecker checkUnitActionHandler = new IngestContractChecker((JsonNode)archiveUnit, contractModel);
            checkUnitActionHandler.check();
            PerformanceLogger.getInstance().log("STP_UNIT_CHECK_AND_PROCESS", CHECK_UNIT_SCHEMA_TASK_ID, "checkUnit", checkUnitTime.elapsed(TimeUnit.MILLISECONDS));
            itemStatus.increment(StatusCode.OK);
            return new ItemStatus(CHECK_UNIT_SCHEMA_TASK_ID).setItemsStatus(CHECK_UNIT_SCHEMA_TASK_ID, itemStatus);
        }
        catch (MetadataValidationException e) {
            LOGGER.warn("Unit schema validation failed " + params.getObjectName(), (Throwable)e);
            switch (e.getErrorCode()) {
                case SCHEMA_VALIDATION_FAILURE: {
                    itemStatus.setGlobalOutcomeDetailSubcode(INVALID_UNIT);
                    ObjectNode object = JsonHandler.createObjectNode();
                    object.put("evDetTechData", e.getMessage());
                    itemStatus.increment(StatusCode.KO);
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)object));
                    return new ItemStatus(itemStatus.getItemId()).setItemsStatus(itemStatus.getItemId(), itemStatus);
                }
                case ONTOLOGY_VALIDATION_FAILURE: {
                    itemStatus.setItemId(ONTOLOGY_VALIDATION);
                    itemStatus.increment(StatusCode.KO);
                    ObjectNode object = JsonHandler.createObjectNode();
                    object.put("evDetTechData", e.getMessage());
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)object));
                    return new ItemStatus(CHECK_UNIT_SCHEMA_TASK_ID).setItemsStatus(CHECK_UNIT_SCHEMA_TASK_ID, itemStatus);
                }
                case INVALID_UNIT_DATE_FORMAT: {
                    itemStatus.setGlobalOutcomeDetailSubcode(DATE_FORMAT);
                    itemStatus.increment(StatusCode.KO);
                    itemStatus.setEvDetailData(e.getMessage());
                    return new ItemStatus(itemStatus.getItemId()).setItemsStatus(itemStatus.getItemId(), itemStatus);
                }
                case INVALID_START_END_DATE: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CONSISTENCY);
                    itemStatus.increment(StatusCode.KO);
                    ObjectNode object = JsonHandler.createObjectNode();
                    object.put("evDetTechData", e.getMessage());
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)object));
                    return new ItemStatus(itemStatus.getItemId()).setItemsStatus(itemStatus.getItemId(), itemStatus);
                }
            }
            throw new IllegalStateException("Unexpected value: " + e.getErrorCode());
        }
        catch (MetaDataContainSpecialCharactersException e) {
            LOGGER.error((Throwable)e);
            itemStatus.setItemId(UNIT_SANITIZE);
            itemStatus.increment(StatusCode.KO);
            ObjectNode object = JsonHandler.createObjectNode();
            object.put("evDetTechData", e.getMessage());
            itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)object));
            return new ItemStatus(CHECK_UNIT_SCHEMA_TASK_ID).setItemsStatus(CHECK_UNIT_SCHEMA_TASK_ID, itemStatus);
        }
        catch (SigningInformationException e) {
            LOGGER.error(e.getMessage());
            itemStatus.setGlobalOutcomeDetailSubcode(e.getErrorCode());
            itemStatus.increment(StatusCode.KO);
            ObjectNode object = JsonHandler.createObjectNode();
            object.put("evDetTechData", e.getMessage());
            itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)object));
            return new ItemStatus(itemStatus.getItemId()).setItemsStatus(itemStatus.getItemId(), itemStatus);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(CHECK_UNIT_SCHEMA_TASK_ID).setItemsStatus(itemStatus.getItemId(), itemStatus);
        }
    }

    private void checkAUJsonAgainstSchema(HandlerIO handlerIO, WorkerParameters params, ObjectNode archiveUnit) throws ProcessingException, MetadataValidationException {
        String objectName = params.getObjectName();
        Stopwatch ontologyTime = Stopwatch.createStarted();
        JsonNode archiveUnitJson = archiveUnit.get("ArchiveUnit");
        ObjectNode updatedArchiveUnitJson = this.metadataValidationProvider.getUnitOntologyValidator().verifyAndReplaceFields(archiveUnitJson);
        archiveUnit.set("ArchiveUnit", (JsonNode)updatedArchiveUnitJson);
        boolean isUpdateJsonMandatory = !archiveUnitJson.equals((Object)updatedArchiveUnitJson);
        PerformanceLogger.getInstance().log("STP_UNIT_CHECK_AND_PROCESS", CHECK_UNIT_SCHEMA_TASK_ID, "validationOntology", ontologyTime.elapsed(TimeUnit.MILLISECONDS));
        handlerIO.addOutputResult(0, (Object)archiveUnit, true, false);
        if (isUpdateJsonMandatory) {
            handlerIO.transferJsonToWorkspace("Units", objectName, (JsonNode)archiveUnit, false, false);
        }
        Stopwatch validationJson = Stopwatch.createStarted();
        this.metadataValidationProvider.getUnitValidator().validateStartAndEndDates((JsonNode)updatedArchiveUnitJson);
        this.metadataValidationProvider.getUnitValidator().validateInternalSchema(updatedArchiveUnitJson);
        PerformanceLogger.getInstance().log("STP_UNIT_CHECK_AND_PROCESS", CHECK_UNIT_SCHEMA_TASK_ID, "validationJson", validationJson.elapsed(TimeUnit.MILLISECONDS));
    }

    private ObjectNode loadArchiveUnit(HandlerIO handlerIO, WorkerParameters params, ItemStatus itemStatus) throws ProcessingException {
        ObjectNode archiveUnit;
        String objectName = params.getObjectName();
        try (InputStream archiveUnitToJson = handlerIO.getInputStreamFromWorkspace("Units" + File.separator + objectName);){
            archiveUnit = (ObjectNode)JsonHandler.getFromInputStream((InputStream)archiveUnitToJson);
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingException(WORKSPACE_SERVER_ERROR, e);
        }
        try {
            SanityChecker.checkJsonAll((JsonNode)archiveUnit);
        }
        catch (InvalidParseOperationException e) {
            itemStatus.setGlobalOutcomeDetailSubcode(INVALID_UNIT);
            String err = "Sanity Checker failed for Archive Unit: " + e.getMessage();
            throw new MetaDataContainSpecialCharactersException(err, (Throwable)e);
        }
        return archiveUnit;
    }

    private IngestContractModel loadIngestContractFromWorkspace(HandlerIO handlerIO) throws InvalidParseOperationException {
        ContractsDetailsModel contractsDetailsModel = (ContractsDetailsModel)JsonHandler.getFromFile((File)((File)handlerIO.getInput(1)), ContractsDetailsModel.class);
        return contractsDetailsModel.getIngestContractModel();
    }
}

