/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationException;
import fr.gouv.vitam.metadata.core.validation.UnitValidator;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.validation.MetadataValidationProvider;
import java.io.File;
import java.io.InputStream;
import java.time.Instant;

public class CheckArchiveUnitProfileActionPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckArchiveUnitProfileActionPlugin.class);
    private static final String CHECK_UNIT_PROFILE_TASK_ID = "CHECK_ARCHIVE_UNIT_PROFILE";
    static final String OUTCOME_DETAILS_NOT_AU_JSON_VALID = "NOT_AU_JSON_VALID";
    static final String OUTCOME_DETAILS_EMPTY_CONTROL_SCHEMA = "EMPTY_CONTROL_SCHEMA";
    static final String OUTCOME_DETAILS_NOT_FOUND = "NOT_FOUND";
    static final String OUTCOME_DETAILS_INACTIVE_STATUS = "INACTIVE_STATUS";
    private static final int GUID_MAP_RANK = 0;
    private final UnitValidator unitValidator;

    public CheckArchiveUnitProfileActionPlugin() {
        this(MetadataValidationProvider.getInstance().getUnitValidator());
    }

    @VisibleForTesting
    public CheckArchiveUnitProfileActionPlugin(UnitValidator unitValidator) {
        this.unitValidator = unitValidator;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) throws ProcessingException {
        this.checkMandatoryParameters(params);
        String objectName = params.getObjectName();
        ItemStatus itemStatus = new ItemStatus(CHECK_UNIT_PROFILE_TASK_ID);
        ObjectNode infoNode = JsonHandler.createObjectNode();
        String unitId = "";
        String url = "Units" + File.separator + objectName;
        try (InputStream archiveUnitInputStream = handlerIO.getInputStreamFromWorkspace(url);){
            ObjectNode archiveUnit = (ObjectNode)JsonHandler.getFromInputStream((InputStream)archiveUnitInputStream);
            JsonNode archiveUnitTag = archiveUnit.get("ArchiveUnit");
            boolean hasArchiveUnitProfile = archiveUnitTag.has("ArchiveUnitProfile");
            if (!hasArchiveUnitProfile) {
                String evdev = JsonHandler.unprettyPrint((Object)infoNode);
                itemStatus.setEvDetailData(evdev).setMasterData(LogbookParameterName.eventDetailData.name(), (Object)evdev).increment(StatusCode.OK);
                ItemStatus itemStatus2 = new ItemStatus(CHECK_UNIT_PROFILE_TASK_ID).setItemsStatus(CHECK_UNIT_PROFILE_TASK_ID, itemStatus);
                return itemStatus2;
            }
            File file = (File)handlerIO.getInput(0);
            String archiveUnitTagId = archiveUnitTag.get("_id").asText();
            if (file != null) {
                JsonNode fromFile = JsonHandler.getFromFile((File)file);
                unitId = fromFile.path(archiveUnitTagId).asText();
            }
            String archiveUnitProfileIdentifier = archiveUnitTag.get("ArchiveUnitProfile").asText();
            try {
                PerformanceLogger.getInstance().log(CHECK_UNIT_PROFILE_TASK_ID, "Validation of archive against AUP.", Instant.now().toEpochMilli());
                LOGGER.info("START - Validation of archive unit {} on {} - Time: {}", new Object[]{archiveUnitTagId, archiveUnitProfileIdentifier, Instant.now().toEpochMilli()});
                this.checkAUAgainstAUProfileSchema(archiveUnit);
                PerformanceLogger.getInstance().log(CHECK_UNIT_PROFILE_TASK_ID, "Validation of archive against AUP.", Instant.now().toEpochMilli());
                String evdev = JsonHandler.unprettyPrint((Object)infoNode);
                itemStatus.setEvDetailData(evdev).setMasterData(LogbookParameterName.eventDetailData.name(), (Object)evdev).increment(StatusCode.OK);
                ItemStatus itemStatus3 = new ItemStatus(CHECK_UNIT_PROFILE_TASK_ID).setItemsStatus(CHECK_UNIT_PROFILE_TASK_ID, itemStatus);
                return itemStatus3;
            }
            catch (MetadataValidationException e) {
                ItemStatus itemStatus4;
                block20: {
                    String outcomeDetails;
                    LOGGER.warn("Unit archive unit profile validation failed " + params.getObjectName(), (Throwable)e);
                    switch (e.getErrorCode()) {
                        case ARCHIVE_UNIT_PROFILE_SCHEMA_VALIDATION_FAILURE: {
                            outcomeDetails = OUTCOME_DETAILS_NOT_AU_JSON_VALID;
                            break;
                        }
                        case EMPTY_ARCHIVE_UNIT_PROFILE_SCHEMA: {
                            outcomeDetails = OUTCOME_DETAILS_EMPTY_CONTROL_SCHEMA;
                            break;
                        }
                        case UNKNOWN_ARCHIVE_UNIT_PROFILE: {
                            outcomeDetails = OUTCOME_DETAILS_NOT_FOUND;
                            break;
                        }
                        case ARCHIVE_UNIT_PROFILE_SCHEMA_INACTIVE: {
                            outcomeDetails = OUTCOME_DETAILS_INACTIVE_STATUS;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected value: " + e.getErrorCode());
                        }
                    }
                    infoNode.put("ArchiveUnit", unitId).put("ArchiveUnitProfile", archiveUnitProfileIdentifier).put("evDetTechData", e.getMessage());
                    itemStatus4 = this.createItemStatusKo(itemStatus, outcomeDetails, (JsonNode)infoNode);
                    if (archiveUnitInputStream == null) break block20;
                    archiveUnitInputStream.close();
                }
                return itemStatus4;
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(CHECK_UNIT_PROFILE_TASK_ID).setItemsStatus(CHECK_UNIT_PROFILE_TASK_ID, itemStatus);
        }
    }

    private ItemStatus createItemStatusKo(ItemStatus subItemStatus, String outcomeDetail, JsonNode evDetailData) {
        subItemStatus.increment(StatusCode.KO).setEvDetailData(JsonHandler.unprettyPrint((Object)evDetailData)).setGlobalOutcomeDetailSubcode(outcomeDetail);
        return new ItemStatus(CHECK_UNIT_PROFILE_TASK_ID).setItemsStatus(CHECK_UNIT_PROFILE_TASK_ID, subItemStatus);
    }

    private void checkAUAgainstAUProfileSchema(ObjectNode archiveUnit) throws MetadataValidationException {
        ObjectNode archiveUnitCopy = (ObjectNode)archiveUnit.get("ArchiveUnit").deepCopy();
        if (!archiveUnit.path("_work").path("_up").isMissingNode()) {
            archiveUnitCopy.set("_up", archiveUnit.path("_work").path("_up"));
        }
        this.unitValidator.validateArchiveUnitProfile(archiveUnitCopy);
    }
}

