/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;

public class BinaryEventData {
    public static final String MESSAGE_DIGEST = "MessageDigest";
    private static final String FILE_NAME = "FileName";
    private static final String OFFERS = "Offers";
    private static final String ALGORITHM = "Algorithm";
    private final String messageDigest;
    private final String fileName;
    private final String offers;
    private final String algorithm;

    @JsonCreator
    public BinaryEventData(@JsonProperty(value="MessageDigest") String messageDigest, @JsonProperty(value="FileName") String fileName, @JsonProperty(value="Offers") String offers, @JsonProperty(value="Algorithm") String algorithm) {
        this.messageDigest = messageDigest;
        this.fileName = fileName;
        this.offers = offers;
        this.algorithm = algorithm;
    }

    public static BinaryEventData from(String messageDigest) {
        return new BinaryEventData(messageDigest, null, null, null);
    }

    public static BinaryEventData from(StoredInfoResult storedInfoResult) {
        return new BinaryEventData(storedInfoResult.getDigest(), null, String.join((CharSequence)", ", storedInfoResult.getOfferIds()), storedInfoResult.getDigestType());
    }

    @JsonProperty(value="MessageDigest")
    public String getMessageDigest() {
        return this.messageDigest;
    }

    @JsonProperty(value="FileName")
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="Offers")
    public String getOffers() {
        return this.offers;
    }

    @JsonProperty(value="Algorithm")
    public String getAlgorithm() {
        return this.algorithm;
    }
}

