/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.functional.administration.common.utils.ArchiveUnitUpdateUtils;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.ArchiveUnitLifecycleUpdateUtils;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArchiveUnitRulesUpdateActionPlugin
extends ActionHandler
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ArchiveUnitRulesUpdateActionPlugin.class);
    private static final String UPDATE_UNIT_RULES_TASK_ID = "UPDATE_UNIT_RULES";
    private static final String RULE_TYPE = "RuleType";
    private static final String RESULTS = "$results";
    private static final String ARCHIVE_UNIT_NOT_FOUND = "Archive unit not found";
    private static final String MANAGEMENT_KEY = "#management";
    private static final String FIELDS_KEY = "$fields";
    private static final String RULES_KEY = "Rules";
    private final ArchiveUnitLifecycleUpdateUtils archiveUnitLifecycleUpdateUtils = new ArchiveUnitLifecycleUpdateUtils();
    private final MetaDataClientFactory metaDataClientFactory;

    public ArchiveUnitRulesUpdateActionPlugin() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    public ArchiveUnitRulesUpdateActionPlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        this.checkMandatoryParameters(params);
        LOGGER.debug("ArchiveUnitRulesUpdateActionPlugin running ...");
        ItemStatus itemStatus = new ItemStatus(UPDATE_UNIT_RULES_TASK_ID);
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            String archiveUnitId = params.getObjectName().split("\\.")[0];
            SelectParserMultiple selectRequest = new SelectParserMultiple();
            ObjectNode projectionNode = JsonHandler.createObjectNode();
            ObjectNode objectNode = JsonHandler.createObjectNode();
            objectNode.put(MANAGEMENT_KEY, 1);
            projectionNode.set(FIELDS_KEY, (JsonNode)objectNode);
            SelectMultiQuery request = selectRequest.getRequest().reset().addProjection((JsonNode)projectionNode);
            JsonNode jsonResponse = metaDataClient.selectUnitbyId((JsonNode)request.getFinalSelect(), archiveUnitId);
            JsonNode archiveUnitNode = jsonResponse.get(RESULTS);
            if (archiveUnitNode.size() == 0) {
                throw new MetaDataNotFoundException(ARCHIVE_UNIT_NOT_FOUND);
            }
            archiveUnitNode = archiveUnitNode.get(0);
            JsonNode managementNode = archiveUnitNode.get(MANAGEMENT_KEY);
            UpdateMultiQuery query = new UpdateMultiQuery();
            HashMap<String, List> updatedRulesByType = new HashMap<String, List>();
            JsonNode rulesForAU = handler.getJsonFromWorkspace("UnitsWithoutLevel/" + params.getObjectName());
            for (Object rule : rulesForAU) {
                if (!updatedRulesByType.containsKey(rule.get(RULE_TYPE).asText())) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(rule);
                    updatedRulesByType.put(rule.get(RULE_TYPE).asText(), arrayList);
                    continue;
                }
                List list = (List)updatedRulesByType.get(rule.get(RULE_TYPE).asText());
                list.add(rule);
                updatedRulesByType.put(rule.get(RULE_TYPE).asText(), list);
            }
            int nbUpdates = 0;
            for (Map.Entry entry : updatedRulesByType.entrySet()) {
                JsonNode categoryNode = managementNode.get((String)entry.getKey());
                if (categoryNode == null || categoryNode.get(RULES_KEY) == null || !ArchiveUnitUpdateUtils.updateCategoryRules((JsonNode)categoryNode.get(RULES_KEY), (List)((List)entry.getValue()), (UpdateMultiQuery)query, (String)((String)entry.getKey()))) continue;
                ++nbUpdates;
            }
            if (nbUpdates > 0) {
                query.addActions(new Action[]{UpdateActionHelper.push((String)VitamFieldsHelper.operations(), (String[])new String[]{params.getContainerName()})});
                JsonNode updateResultJson = metaDataClient.updateUnitById((JsonNode)query.getFinalUpdate(), archiveUnitId);
                String string = ArchiveUnitUpdateUtils.getDiffMessageFor((JsonNode)updateResultJson, (String)archiveUnitId);
                this.archiveUnitLifecycleUpdateUtils.logLifecycle(params, archiveUnitId, StatusCode.OK, string, handler.getLifecyclesClient());
                this.archiveUnitLifecycleUpdateUtils.commitLifecycle(params.getContainerName(), archiveUnitId, handler.getLifecyclesClient());
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (ProcessingException e) {
            LOGGER.error("Exception while getting AU information : ", (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Exception while parsing json : ", (Throwable)e);
            itemStatus.increment(StatusCode.KO);
        }
        catch (InvalidCreateOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            LOGGER.error("Exception with metadata: ", e);
            itemStatus.increment(StatusCode.FATAL);
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error("Archive unit not found : ", (Throwable)e);
            itemStatus.increment(StatusCode.KO);
        }
        LOGGER.debug("ArchiveUnitRulesUpdateActionPlugin response: " + itemStatus.getGlobalStatus());
        return new ItemStatus(UPDATE_UNIT_RULES_TASK_ID).setItemsStatus(UPDATE_UNIT_RULES_TASK_ID, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

