/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.mapping;

import fr.gouv.culture.archivesdefrance.seda.v2.HoldRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.RuleIdType;
import fr.gouv.vitam.common.model.unit.CommonRule;
import fr.gouv.vitam.common.model.unit.RuleCategoryModel;
import fr.gouv.vitam.common.model.unit.RuleModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;

public class RuleMapper {
    public RuleCategoryModel fillCommonRule(CommonRule rule) {
        if (rule == null) {
            return null;
        }
        boolean ruleUsed = false;
        RuleCategoryModel ruleCategoryModel = new RuleCategoryModel();
        RuleModel ruleModel = null;
        ArrayList<RuleModel> rules = new ArrayList<RuleModel>();
        for (Object ruleOrStartDate : rule.getRuleAndStartDate()) {
            if (ruleOrStartDate instanceof RuleIdType) {
                ruleModel = new RuleModel();
                rules.add(ruleModel);
                String ruleId = ((RuleIdType)ruleOrStartDate).getValue();
                ruleModel.setRule(ruleId);
            }
            if (!(ruleOrStartDate instanceof XMLGregorianCalendar) || ruleModel == null) continue;
            XMLGregorianCalendar startDate = (XMLGregorianCalendar)ruleOrStartDate;
            ruleModel.setStartDate(startDate.toString());
        }
        if (!rules.isEmpty()) {
            ruleUsed = true;
            ruleCategoryModel.getRules().addAll(rules);
        }
        if (rule.isPreventInheritance() != null) {
            ruleUsed = true;
            ruleCategoryModel.setPreventInheritance(rule.isPreventInheritance());
        }
        if (rule.getRefNonRuleId().size() > 0) {
            ruleUsed = true;
            List refNonRuleId = rule.getRefNonRuleId().stream().map(RuleIdType::getValue).collect(Collectors.toList());
            ruleCategoryModel.addAllPreventRulesId(refNonRuleId);
        }
        if (!ruleUsed) {
            return null;
        }
        return ruleCategoryModel;
    }

    public RuleCategoryModel fillHoldRule(HoldRuleType rule) {
        if (rule == null) {
            return null;
        }
        boolean ruleUsed = false;
        RuleCategoryModel ruleCategoryModel = new RuleCategoryModel();
        RuleModel ruleModel = null;
        ArrayList<RuleModel> rules = new ArrayList<RuleModel>();
        for (JAXBElement ruleEntry : rule.getHoldRuleDefGroup()) {
            String fieldLocalName;
            switch (fieldLocalName = ruleEntry.getName().getLocalPart()) {
                case "Rule": {
                    ruleModel = new RuleModel();
                    rules.add(ruleModel);
                    String ruleId = ((RuleIdType)ruleEntry.getValue()).getValue();
                    ruleModel.setRule(ruleId);
                    break;
                }
                case "StartDate": {
                    assert (ruleModel != null);
                    XMLGregorianCalendar startDate = (XMLGregorianCalendar)ruleEntry.getValue();
                    ruleModel.setStartDate(startDate.toString());
                    break;
                }
                case "HoldEndDate": {
                    assert (ruleModel != null);
                    XMLGregorianCalendar holdEndDate = (XMLGregorianCalendar)ruleEntry.getValue();
                    ruleModel.setHoldEndDate(holdEndDate.toString());
                    break;
                }
                case "HoldOwner": {
                    assert (ruleModel != null);
                    String holdOwner = (String)ruleEntry.getValue();
                    ruleModel.setHoldOwner(holdOwner);
                    break;
                }
                case "HoldReassessingDate": {
                    assert (ruleModel != null);
                    XMLGregorianCalendar holdReassessingDate = (XMLGregorianCalendar)ruleEntry.getValue();
                    ruleModel.setHoldReassessingDate(holdReassessingDate.toString());
                    break;
                }
                case "HoldReason": {
                    assert (ruleModel != null);
                    String holdReason = (String)ruleEntry.getValue();
                    ruleModel.setHoldReason(holdReason);
                    break;
                }
                case "PreventRearrangement": {
                    assert (ruleModel != null);
                    Boolean preventRearrangement = (Boolean)ruleEntry.getValue();
                    ruleModel.setPreventRearrangement(preventRearrangement);
                }
            }
        }
        if (!rules.isEmpty()) {
            ruleUsed = true;
            ruleCategoryModel.getRules().addAll(rules);
        }
        if (rule.isPreventInheritance() != null) {
            ruleUsed = true;
            ruleCategoryModel.setPreventInheritance(rule.isPreventInheritance());
        }
        if (!rule.getRefNonRuleId().isEmpty()) {
            ruleUsed = true;
            List refNonRuleId = rule.getRefNonRuleId().stream().map(RuleIdType::getValue).collect(Collectors.toList());
            ruleCategoryModel.addAllPreventRulesId(refNonRuleId);
        }
        if (!ruleUsed) {
            return null;
        }
        return ruleCategoryModel;
    }
}

