/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.mapping;

import fr.gouv.culture.archivesdefrance.seda.v2.BinaryDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.CoreMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2.DescriptiveTechnicalMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2.FileInfoType;
import fr.gouv.culture.archivesdefrance.seda.v2.FormatIdentificationType;
import fr.gouv.culture.archivesdefrance.seda.v2.MeasurementType;
import fr.gouv.culture.archivesdefrance.seda.v2.MeasurementWeightType;
import fr.gouv.culture.archivesdefrance.seda.v2.MinimalDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.PhysicalDataObjectType;
import fr.gouv.vitam.common.mapping.mapper.ElementMapper;
import fr.gouv.vitam.common.model.objectgroup.DbFileInfoModel;
import fr.gouv.vitam.common.model.objectgroup.DbFormatIdentificationModel;
import fr.gouv.vitam.common.model.objectgroup.DbVersionsModel;
import fr.gouv.vitam.common.model.objectgroup.MeasurementModel;
import fr.gouv.vitam.common.model.objectgroup.MetadataModel;
import fr.gouv.vitam.common.model.objectgroup.PhysicalDimensionsModel;
import fr.gouv.vitam.common.model.preservation.OtherMetadata;
import fr.gouv.vitam.processing.common.exception.ProcessingMalformedDataException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectReferenceException;
import java.util.List;

public class ObjectGroupMapper {
    public static DbVersionsModel map(MinimalDataObjectType dataObject, String groupId) throws ProcessingMalformedDataException, ProcessingObjectReferenceException {
        DbVersionsModel dbVersionsModel = new DbVersionsModel();
        dbVersionsModel.setId(dataObject.getId());
        dbVersionsModel.setDataObjectVersion(dataObject.getDataObjectVersion());
        dbVersionsModel.setDataObjectGroupId(groupId);
        if (dataObject.getDataObjectProfile() != null) {
            dbVersionsModel.setDataObjectProfile(dataObject.getDataObjectProfile().getValue());
        }
        if (dataObject.getPersistentIdentifier() != null) {
            dbVersionsModel.setPersistentIdentifier(dataObject.getPersistentIdentifier());
        }
        dbVersionsModel.setDataObjectUse(dataObject.getDataObjectUse());
        dbVersionsModel.setDataObjectNumber(dataObject.getDataObjectNumber());
        if (dataObject instanceof BinaryDataObjectType) {
            DescriptiveTechnicalMetadataType otherMetadata;
            CoreMetadataType metadata;
            FileInfoType fileInfo;
            FormatIdentificationType formatIdentification;
            BinaryDataObjectType dataBinaryObject = (BinaryDataObjectType)dataObject;
            dbVersionsModel.setUri(dataBinaryObject.getUri());
            if (dataBinaryObject.getSize() != null) {
                dbVersionsModel.setSize(dataBinaryObject.getSize().longValue());
            }
            if (dataBinaryObject.getMessageDigest() != null) {
                dbVersionsModel.setMessageDigest(dataBinaryObject.getMessageDigest().getValue());
                dbVersionsModel.setAlgorithm(dataBinaryObject.getMessageDigest().getAlgorithm());
            }
            if ((formatIdentification = dataBinaryObject.getFormatIdentification()) != null) {
                ObjectGroupMapper.mapFormatIdentification(dbVersionsModel, formatIdentification);
            }
            if ((fileInfo = dataBinaryObject.getFileInfo()) != null) {
                ObjectGroupMapper.mapFileInfo(dbVersionsModel, fileInfo);
            }
            if ((metadata = dataBinaryObject.getMetadata()) != null) {
                ObjectGroupMapper.mapMetadata(dbVersionsModel, metadata);
            }
            if ((otherMetadata = dataBinaryObject.getOtherMetadata()) != null) {
                ObjectGroupMapper.mapOtherMetadata(dbVersionsModel, otherMetadata);
            }
        } else if (dataObject instanceof PhysicalDataObjectType) {
            PhysicalDataObjectType dataPhysicalObject = (PhysicalDataObjectType)dataObject;
            if (dataPhysicalObject.getPhysicalDimensions() != null) {
                PhysicalDimensionsModel physicalDimensionsModel = new PhysicalDimensionsModel();
                if (dataPhysicalObject.getPhysicalDimensions().getDepth() != null) {
                    physicalDimensionsModel.setDepth(ObjectGroupMapper.mapMeasurement(dataPhysicalObject.getPhysicalDimensions().getDepth()));
                }
                if (dataPhysicalObject.getPhysicalDimensions().getDiameter() != null) {
                    physicalDimensionsModel.setDiameter(ObjectGroupMapper.mapMeasurement(dataPhysicalObject.getPhysicalDimensions().getDiameter()));
                }
                if (dataPhysicalObject.getPhysicalDimensions().getHeight() != null) {
                    physicalDimensionsModel.setHeight(ObjectGroupMapper.mapMeasurement(dataPhysicalObject.getPhysicalDimensions().getHeight()));
                }
                if (dataPhysicalObject.getPhysicalDimensions().getLength() != null) {
                    physicalDimensionsModel.setLength(ObjectGroupMapper.mapMeasurement(dataPhysicalObject.getPhysicalDimensions().getLength()));
                }
                if (dataPhysicalObject.getPhysicalDimensions().getWidth() != null) {
                    physicalDimensionsModel.setWidth(ObjectGroupMapper.mapMeasurement(dataPhysicalObject.getPhysicalDimensions().getWidth()));
                }
                if (dataPhysicalObject.getPhysicalDimensions().getThickness() != null) {
                    physicalDimensionsModel.setThickness(ObjectGroupMapper.mapMeasurement(dataPhysicalObject.getPhysicalDimensions().getThickness()));
                }
                if (dataPhysicalObject.getPhysicalDimensions().getWeight() != null) {
                    physicalDimensionsModel.setWeight(ObjectGroupMapper.mapWeightMeasurement(dataPhysicalObject.getPhysicalDimensions().getWeight()));
                }
                physicalDimensionsModel.setShape(dataPhysicalObject.getPhysicalDimensions().getShape());
                physicalDimensionsModel.setNumberOfPage(dataPhysicalObject.getPhysicalDimensions().getNumberOfPage());
                physicalDimensionsModel.setAny(ElementMapper.toMap((List)dataPhysicalObject.getAny()));
                dbVersionsModel.setPhysicalDimensionsModel(physicalDimensionsModel);
            }
            dbVersionsModel.setPhysicalId(dataPhysicalObject.getPhysicalId().getValue());
        }
        return dbVersionsModel;
    }

    private static void mapOtherMetadata(DbVersionsModel dbVersionsModel, DescriptiveTechnicalMetadataType otherMetadata) {
        OtherMetadata otherMetadataModel = new OtherMetadata(ElementMapper.toMap((List)otherMetadata.getAny()));
        dbVersionsModel.setOtherMetadata(otherMetadataModel);
    }

    private static void mapMetadata(DbVersionsModel dbVersionsModel, CoreMetadataType metadata) {
        MetadataModel metadataModel = new MetadataModel();
        if (metadata.getAudio() != null) {
            metadataModel.setAudio(ElementMapper.toMap((List)metadata.getAudio().getAny()));
        }
        if (metadata.getDocument() != null) {
            metadataModel.setDocument(ElementMapper.toMap((List)metadata.getDocument().getAny()));
        }
        if (metadata.getImage() != null) {
            metadataModel.setImage(ElementMapper.toMap((List)metadata.getImage().getAny()));
        }
        if (metadata.getText() != null) {
            metadataModel.setText(ElementMapper.toMap((List)metadata.getText().getAny()));
        }
        if (metadata.getVideo() != null) {
            metadataModel.setVideo(ElementMapper.toMap((List)metadata.getVideo().getAny()));
        }
        dbVersionsModel.setMetadata(metadataModel);
    }

    private static void mapFileInfo(DbVersionsModel dbVersionsModel, FileInfoType fileInfo) {
        DbFileInfoModel dbFileInfoModel = new DbFileInfoModel();
        dbFileInfoModel.setFilename(fileInfo.getFilename());
        if (fileInfo.getLastModified() != null) {
            dbFileInfoModel.setLastModified(fileInfo.getLastModified().toString());
        }
        dbFileInfoModel.setCreatingApplicationName(fileInfo.getCreatingApplicationName());
        dbFileInfoModel.setCreatingOs(fileInfo.getCreatingOs());
        if (fileInfo.getDateCreatedByApplication() != null) {
            dbFileInfoModel.setDateCreatedByApplication(fileInfo.getDateCreatedByApplication().toString());
        }
        dbFileInfoModel.setCreatingApplicationName(fileInfo.getCreatingApplicationName());
        dbFileInfoModel.setCreatingApplicationVersion(fileInfo.getCreatingApplicationVersion());
        dbVersionsModel.setFileInfoModel(dbFileInfoModel);
    }

    private static void mapFormatIdentification(DbVersionsModel dbVersionsModel, FormatIdentificationType formatIdentification) {
        DbFormatIdentificationModel dbFormatIdentificationModel = new DbFormatIdentificationModel();
        dbFormatIdentificationModel.setFormatId(formatIdentification.getFormatId());
        dbFormatIdentificationModel.setFormatLitteral(formatIdentification.getFormatLitteral());
        dbFormatIdentificationModel.setMimeType(formatIdentification.getMimeType());
        dbFormatIdentificationModel.setEncoding(formatIdentification.getEncoding());
        dbVersionsModel.setFormatIdentificationModel(dbFormatIdentificationModel);
    }

    private static MeasurementModel mapMeasurement(MeasurementType measurementType) {
        MeasurementModel measurementModel = new MeasurementModel();
        measurementModel.setUnit(measurementType.getUnit());
        measurementModel.setDValue(measurementType.getValue());
        return measurementModel;
    }

    private static MeasurementModel mapWeightMeasurement(MeasurementWeightType measurementWeightType) {
        MeasurementModel measurementModel = new MeasurementModel();
        measurementModel.setUnit(measurementWeightType.getUnit().value());
        measurementModel.setDValue(measurementWeightType.getValue());
        return measurementModel;
    }
}

