/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.mapping;

import fr.gouv.culture.archivesdefrance.seda.v2.CodeType;
import fr.gouv.culture.archivesdefrance.seda.v2.CoverageType;
import fr.gouv.culture.archivesdefrance.seda.v2.DescriptiveMetadataContentType;
import fr.gouv.culture.archivesdefrance.seda.v2.DetachedSigningRoleType;
import fr.gouv.culture.archivesdefrance.seda.v2.EventType;
import fr.gouv.culture.archivesdefrance.seda.v2.ExtendedType;
import fr.gouv.culture.archivesdefrance.seda.v2.LevelType;
import fr.gouv.culture.archivesdefrance.seda.v2.LinkingAgentIdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.MessageDigestBinaryObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.ReferencedObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.RelatedObjectReferenceType;
import fr.gouv.culture.archivesdefrance.seda.v2.SignatureDescriptionType;
import fr.gouv.culture.archivesdefrance.seda.v2.SignatureType;
import fr.gouv.culture.archivesdefrance.seda.v2.SigningInformationType;
import fr.gouv.culture.archivesdefrance.seda.v2.TextType;
import fr.gouv.culture.archivesdefrance.seda.v2.TimestampingInformationType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.mapping.mapper.ElementMapper;
import fr.gouv.vitam.common.model.unit.AdditionalProofType;
import fr.gouv.vitam.common.model.unit.CodeKeywordType;
import fr.gouv.vitam.common.model.unit.CustodialHistoryModel;
import fr.gouv.vitam.common.model.unit.DescriptiveMetadataModel;
import fr.gouv.vitam.common.model.unit.EventTypeModel;
import fr.gouv.vitam.common.model.unit.GpsType;
import fr.gouv.vitam.common.model.unit.KeywordsType;
import fr.gouv.vitam.common.model.unit.LinkingAgentIdentifierTypeModel;
import fr.gouv.vitam.common.model.unit.OrganizationType;
import fr.gouv.vitam.common.model.unit.ReferencedObjectTypeModel;
import fr.gouv.vitam.common.model.unit.SignatureDescriptionTypeModel;
import fr.gouv.vitam.common.model.unit.SignatureInformationExtendedModel;
import fr.gouv.vitam.common.model.unit.SignatureTypeModel;
import fr.gouv.vitam.common.model.unit.SignedObjectDigestModel;
import fr.gouv.vitam.common.model.unit.SigningInformationTypeModel;
import fr.gouv.vitam.common.model.unit.SigningRoleType;
import fr.gouv.vitam.common.model.unit.TextByLang;
import fr.gouv.vitam.common.model.unit.TimestampingInformationTypeModel;
import fr.gouv.vitam.worker.core.mapping.CustodialHistoryMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class DescriptiveMetadataMapper {
    private final CustodialHistoryMapper custodialHistoryMapper = new CustodialHistoryMapper();

    public DescriptiveMetadataModel map(DescriptiveMetadataContentType metadataContentType) {
        DescriptiveMetadataModel descriptiveMetadataModel = new DescriptiveMetadataModel();
        descriptiveMetadataModel.setAcquiredDate(LocalDateUtil.transformIsoOffsetDateToIsoOffsetDateTime((String)metadataContentType.getAcquiredDate()));
        descriptiveMetadataModel.setAddressee(metadataContentType.getAddressee());
        if (metadataContentType.getPersistentIdentifier() != null) {
            descriptiveMetadataModel.setPersistentIdentifier(metadataContentType.getPersistentIdentifier());
        }
        descriptiveMetadataModel.setAny(ElementMapper.toMap((List)metadataContentType.getAny()));
        descriptiveMetadataModel.setArchivalAgencyArchiveUnitIdentifier(metadataContentType.getArchivalAgencyArchiveUnitIdentifier());
        descriptiveMetadataModel.setAuthorizedAgent(metadataContentType.getAuthorizedAgent());
        descriptiveMetadataModel.setAgent(metadataContentType.getAgent());
        descriptiveMetadataModel.setTextContent(metadataContentType.getTextContent());
        descriptiveMetadataModel.setOriginatingSystemIdReplyTo(metadataContentType.getOriginatingSystemIdReplyTo());
        descriptiveMetadataModel.setDateLitteral(metadataContentType.getDateLitteral());
        descriptiveMetadataModel.setCoverage(this.mapCoverage(metadataContentType.getCoverage()));
        descriptiveMetadataModel.setCreatedDate(LocalDateUtil.transformIsoOffsetDateToIsoOffsetDateTime((String)metadataContentType.getCreatedDate()));
        CustodialHistoryModel custodialHistoryModel = this.custodialHistoryMapper.map(metadataContentType.getCustodialHistory());
        descriptiveMetadataModel.setCustodialHistory(custodialHistoryModel);
        descriptiveMetadataModel.setDescription(this.findDefaultTextType(metadataContentType.getDescription()));
        descriptiveMetadataModel.setDescription_(this.mapTextByLang(metadataContentType.getDescription()));
        descriptiveMetadataModel.setDescriptionLanguage(metadataContentType.getDescriptionLanguage());
        descriptiveMetadataModel.setDescriptionLevel(this.mapLevelType(metadataContentType.getDescriptionLevel()));
        descriptiveMetadataModel.setDocumentType(this.mapTextType(metadataContentType.getDocumentType()));
        descriptiveMetadataModel.setEndDate(metadataContentType.getEndDate());
        descriptiveMetadataModel.setEvent(this.mapEvents(metadataContentType.getEvent()));
        descriptiveMetadataModel.setFilePlanPosition(metadataContentType.getFilePlanPosition());
        descriptiveMetadataModel.setGps(DescriptiveMetadataMapper.mapGps(metadataContentType.getGps()));
        descriptiveMetadataModel.setKeyword(DescriptiveMetadataMapper.mapKeywords(metadataContentType.getKeyword()));
        descriptiveMetadataModel.setLanguage(metadataContentType.getLanguage());
        descriptiveMetadataModel.setOriginatingAgency(this.mapOrganizationType(metadataContentType.getOriginatingAgency()));
        descriptiveMetadataModel.setOriginatingAgencyArchiveUnitIdentifier(metadataContentType.getOriginatingAgencyArchiveUnitIdentifier());
        descriptiveMetadataModel.setOriginatingSystemId(metadataContentType.getOriginatingSystemId());
        descriptiveMetadataModel.setRecipient(metadataContentType.getRecipient());
        descriptiveMetadataModel.setRegisteredDate(LocalDateUtil.transformIsoOffsetDateToIsoOffsetDateTime((String)metadataContentType.getRegisteredDate()));
        descriptiveMetadataModel.setRelatedObjectReference(metadataContentType.getRelatedObjectReference());
        descriptiveMetadataModel.setReceivedDate(LocalDateUtil.transformIsoOffsetDateToIsoOffsetDateTime((String)metadataContentType.getReceivedDate()));
        descriptiveMetadataModel.setSentDate(LocalDateUtil.transformIsoOffsetDateToIsoOffsetDateTime((String)metadataContentType.getSentDate()));
        descriptiveMetadataModel.setSignature(this.mapSignatures(metadataContentType.getSignature()));
        descriptiveMetadataModel.setSigningInformation(this.mapSigningInformation(metadataContentType.getSigningInformation()));
        descriptiveMetadataModel.setSource(metadataContentType.getSource());
        descriptiveMetadataModel.setStartDate(LocalDateUtil.transformIsoOffsetDateToIsoOffsetDateTime((String)metadataContentType.getStartDate()));
        descriptiveMetadataModel.setStatus(metadataContentType.getStatus());
        descriptiveMetadataModel.setSubmissionAgency(this.mapOrganizationType(metadataContentType.getSubmissionAgency()));
        descriptiveMetadataModel.setSystemId(metadataContentType.getSystemId());
        descriptiveMetadataModel.setTag(metadataContentType.getTag());
        descriptiveMetadataModel.setTitle(this.findDefaultTextType(metadataContentType.getTitle()));
        descriptiveMetadataModel.setTitle_(this.mapTextByLang(metadataContentType.getTitle()));
        descriptiveMetadataModel.setTransactedDate(LocalDateUtil.transformIsoOffsetDateToIsoOffsetDateTime((String)metadataContentType.getTransactedDate()));
        descriptiveMetadataModel.setTransferringAgencyArchiveUnitIdentifier(metadataContentType.getTransferringAgencyArchiveUnitIdentifier());
        descriptiveMetadataModel.setType(this.mapTextType(metadataContentType.getType()));
        descriptiveMetadataModel.setVersion(metadataContentType.getVersion());
        descriptiveMetadataModel.setWriter(metadataContentType.getWriter());
        descriptiveMetadataModel.setTransmitter(metadataContentType.getTransmitter());
        descriptiveMetadataModel.setSender(metadataContentType.getSender());
        if (metadataContentType.getRelatedObjectReference() != null) {
            RelatedObjectReferenceType relatedObjectRef = metadataContentType.getRelatedObjectReference();
            RelatedObjectReferenceType relatedObjectRefNew = new RelatedObjectReferenceType();
            descriptiveMetadataModel.setRelatedObjectReference(relatedObjectRefNew);
            relatedObjectRefNew.getIsPartOf().addAll(relatedObjectRef.getIsPartOf());
            relatedObjectRefNew.getIsVersionOf().addAll(relatedObjectRef.getIsVersionOf());
            relatedObjectRefNew.getReplaces().addAll(relatedObjectRef.getReplaces());
            relatedObjectRefNew.getRequires().addAll(relatedObjectRef.getRequires());
            relatedObjectRefNew.getReferences().addAll(relatedObjectRef.getReferences());
        }
        return descriptiveMetadataModel;
    }

    private TextByLang mapTextByLang(List<TextType> textTypeList) {
        if (CollectionUtils.isEmpty(textTypeList)) {
            return null;
        }
        Map<String, String> collect = textTypeList.stream().filter(entry -> entry.getLang() != null).collect(Collectors.toMap(TextType::getLang, TextType::getValue));
        if (collect.isEmpty()) {
            return null;
        }
        TextByLang textByLang = new TextByLang();
        for (Map.Entry<String, String> stringStringEntry : collect.entrySet()) {
            textByLang.setTextByLang(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        return textByLang;
    }

    private OrganizationType mapOrganizationType(fr.gouv.culture.archivesdefrance.seda.v2.OrganizationType organizationType) {
        if (organizationType == null) {
            return null;
        }
        OrganizationType organization = new OrganizationType();
        if (organizationType.getIdentifier() != null) {
            organization.setIdentifier(organizationType.getIdentifier().getValue());
        }
        if (organizationType.getOrganizationDescriptiveMetadata() != null) {
            Map organizationDescriptiveMetadata = ElementMapper.toMap((List)organizationType.getOrganizationDescriptiveMetadata().getAny());
            organization.setOrganizationDescriptiveMetadata(organizationDescriptiveMetadata);
        }
        return organization;
    }

    private fr.gouv.vitam.common.model.unit.CoverageType mapCoverage(CoverageType coverage) {
        if (coverage == null) {
            return null;
        }
        fr.gouv.vitam.common.model.unit.CoverageType coverageType = new fr.gouv.vitam.common.model.unit.CoverageType();
        if (CollectionUtils.isNotEmpty((Collection)coverage.getSpatial())) {
            coverageType.setSpatial(coverage.getSpatial().stream().map(this::mapTextType).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)coverage.getTemporal())) {
            coverageType.setTemporal(coverage.getTemporal().stream().map(this::mapTextType).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)coverage.getJuridictional())) {
            coverageType.setJuridictional(coverage.getJuridictional().stream().map(this::mapTextType).collect(Collectors.toList()));
        }
        return coverageType;
    }

    private String mapTextType(TextType textType) {
        if (textType == null) {
            return null;
        }
        return textType.getValue();
    }

    private static List<KeywordsType> mapKeywords(List<fr.gouv.culture.archivesdefrance.seda.v2.KeywordsType> keywords) {
        ArrayList<KeywordsType> result = new ArrayList<KeywordsType>();
        for (fr.gouv.culture.archivesdefrance.seda.v2.KeywordsType sedaKeyword : keywords) {
            KeywordsType keyword = new KeywordsType();
            if (sedaKeyword.getKeywordContent() != null) {
                keyword.setKeywordContent(sedaKeyword.getKeywordContent().getValue());
            }
            if (sedaKeyword.getKeywordReference() != null) {
                keyword.setKeywordReference(sedaKeyword.getKeywordReference().getValue());
            }
            if (sedaKeyword.getKeywordType() != null) {
                keyword.setKeywordType(CodeKeywordType.fromValue((String)sedaKeyword.getKeywordType().getValue().value()));
            }
            result.add(keyword);
        }
        return result;
    }

    private static GpsType mapGps(fr.gouv.culture.archivesdefrance.seda.v2.GpsType gps) {
        if (gps == null) {
            return null;
        }
        return new GpsType().setGpsVersionID(gps.getGpsVersionID()).setGpsAltitude(gps.getGpsAltitude()).setGpsAltitudeRef(gps.getGpsAltitudeRef()).setGpsLatitude(gps.getGpsLatitude()).setGpsLatitudeRef(gps.getGpsLatitudeRef()).setGpsLongitude(gps.getGpsLongitude()).setGpsLongitudeRef(gps.getGpsLongitudeRef()).setGpsDateStamp(gps.getGpsDateStamp());
    }

    private fr.gouv.vitam.common.model.unit.LevelType mapLevelType(LevelType descriptionLevel) {
        if (descriptionLevel == null) {
            return null;
        }
        return fr.gouv.vitam.common.model.unit.LevelType.fromValue((String)descriptionLevel.value());
    }

    private List<SignatureTypeModel> mapSignatures(List<SignatureType> signatures) {
        if (signatures == null) {
            return null;
        }
        return signatures.stream().map(this::mapSignature).collect(Collectors.toList());
    }

    private SignatureTypeModel mapSignature(SignatureType signatureType) {
        return new SignatureTypeModel().setSigner(signatureType.getSigner()).setValidator(signatureType.getValidator()).setReferencedObject(this.mapReferencedObject(signatureType.getReferencedObject())).setMasterdata(DescriptiveMetadataMapper.getCodeType(signatureType.getMasterdata()));
    }

    private static String getCodeType(CodeType codeType) {
        if (codeType == null) {
            return null;
        }
        return codeType.getValue();
    }

    private ReferencedObjectTypeModel mapReferencedObject(ReferencedObjectType referencedObject) {
        if (referencedObject == null) {
            return null;
        }
        return new ReferencedObjectTypeModel().setSignedObjectId(referencedObject.getSignedObjectId()).setSignedObjectDigest(this.mapSignedObjectDigest(referencedObject.getSignedObjectDigest()));
    }

    private SignedObjectDigestModel mapSignedObjectDigest(MessageDigestBinaryObjectType signedMessageDigest) {
        if (signedMessageDigest == null) {
            return null;
        }
        return new SignedObjectDigestModel().setAlgorithm(signedMessageDigest.getAlgorithm()).setValue(signedMessageDigest.getValue());
    }

    private SigningInformationTypeModel mapSigningInformation(SigningInformationType signingInformation) {
        if (signingInformation == null) {
            return null;
        }
        return new SigningInformationTypeModel().setSigningRole(this.mapSigningRole(signingInformation.getSigningRole())).setDetachedSigningRole(this.mapDetachedSigningRole(signingInformation.getDetachedSigningRole())).setSignatureDescription(this.mapSignatureDescription(signingInformation.getSignatureDescription())).setTimestampingInformation(this.mapTimestampingInformation(signingInformation.getTimestampingInformation())).setAdditionalProof(this.mapAdditionalProof(signingInformation.getAdditionalProof())).setExtended(this.mapExtendedParams(signingInformation.getExtended()));
    }

    private List<SigningRoleType> mapSigningRole(List<fr.gouv.culture.archivesdefrance.seda.v2.SigningRoleType> signingRole) {
        if (signingRole == null) {
            return null;
        }
        return signingRole.stream().map((? super T role) -> {
            switch (role) {
                case SIGNED_DOCUMENT: {
                    return SigningRoleType.SIGNED_DOCUMENT;
                }
                case TIMESTAMP: {
                    return SigningRoleType.TIMESTAMP;
                }
                case SIGNATURE: {
                    return SigningRoleType.SIGNATURE;
                }
                case ADDITIONAL_PROOF: {
                    return SigningRoleType.ADDITIONAL_PROOF;
                }
            }
            throw new IllegalStateException("Unexpected value: " + role);
        }).collect(Collectors.toList());
    }

    private List<fr.gouv.vitam.common.model.unit.DetachedSigningRoleType> mapDetachedSigningRole(List<DetachedSigningRoleType> detachedSigningRole) {
        if (detachedSigningRole == null) {
            return null;
        }
        return detachedSigningRole.stream().map((? super T role) -> {
            switch (role) {
                case TIMESTAMP: {
                    return fr.gouv.vitam.common.model.unit.DetachedSigningRoleType.TIMESTAMP;
                }
                case SIGNATURE: {
                    return fr.gouv.vitam.common.model.unit.DetachedSigningRoleType.SIGNATURE;
                }
                case ADDITIONAL_PROOF: {
                    return fr.gouv.vitam.common.model.unit.DetachedSigningRoleType.ADDITIONAL_PROOF;
                }
            }
            throw new IllegalStateException("Unexpected value: " + role);
        }).collect(Collectors.toList());
    }

    private List<SignatureDescriptionTypeModel> mapSignatureDescription(List<SignatureDescriptionType> signature) {
        if (signature == null) {
            return null;
        }
        return signature.stream().map(this::mapSignatureDescription).collect(Collectors.toList());
    }

    private SignatureDescriptionTypeModel mapSignatureDescription(SignatureDescriptionType signatureDescriptionType) {
        return new SignatureDescriptionTypeModel().setSigner(signatureDescriptionType.getSigner()).setValidator(signatureDescriptionType.getValidator()).setSigningType(signatureDescriptionType.getSigningType());
    }

    private List<TimestampingInformationTypeModel> mapTimestampingInformation(List<TimestampingInformationType> timestampingInformation) {
        if (timestampingInformation == null) {
            return null;
        }
        return timestampingInformation.stream().map((? super T timestampingInfo) -> new TimestampingInformationTypeModel().setTimeStamp(timestampingInfo.getTimeStamp() == null ? null : timestampingInfo.getTimeStamp().toString()).setAdditionalTimestampingInformation(timestampingInfo.getAdditionalTimestampingInformation())).collect(Collectors.toList());
    }

    private List<AdditionalProofType> mapAdditionalProof(List<fr.gouv.culture.archivesdefrance.seda.v2.AdditionalProofType> additionalProofs) {
        if (additionalProofs == null) {
            return null;
        }
        return additionalProofs.stream().map((? super T additionalProof) -> new AdditionalProofType().setAdditionalProofInformation(additionalProof.getAdditionalProofInformation())).collect(Collectors.toList());
    }

    private SignatureInformationExtendedModel mapExtendedParams(ExtendedType extended) {
        if (extended == null || extended.getAny().isEmpty()) {
            return null;
        }
        SignatureInformationExtendedModel extendedModel = new SignatureInformationExtendedModel();
        ElementMapper.toMap((List)extended.getAny()).forEach((arg_0, arg_1) -> ((SignatureInformationExtendedModel)extendedModel).setAny(arg_0, arg_1));
        return extendedModel;
    }

    private List<EventTypeModel> mapEvents(List<EventType> eventTypes) {
        return eventTypes.stream().map(this::mapEvent).collect(Collectors.toList());
    }

    private EventTypeModel mapEvent(EventType event) {
        return new EventTypeModel().setEventDateTime(event.getEventDateTime()).setEventDetail(this.mapTextType(event.getEventDetail())).setEventDetailData(event.getEventDetailData()).setEventIdentifier(event.getEventIdentifier()).setEventType(event.getEventType()).setEventTypeCode(event.getEventTypeCode()).setOutcome(event.getOutcome()).setOutcomeDetail(event.getOutcomeDetail()).setOutcomeDetailMessage(event.getOutcomeDetailMessage()).setLinkingAgentIdentifier(event.getLinkingAgentIdentifier().stream().map(this::mapLinkingAgentIdentifier).collect(Collectors.toList()));
    }

    private LinkingAgentIdentifierTypeModel mapLinkingAgentIdentifier(LinkingAgentIdentifierType linkingAgentIdentifierType) {
        if (linkingAgentIdentifierType == null) {
            return null;
        }
        LinkingAgentIdentifierTypeModel linkingAgentIdentifierTypeModel = new LinkingAgentIdentifierTypeModel();
        linkingAgentIdentifierTypeModel.setLinkingAgentIdentifierType(linkingAgentIdentifierType.getLinkingAgentIdentifierType());
        linkingAgentIdentifierTypeModel.setLinkingAgentIdentifierValue(linkingAgentIdentifierType.getLinkingAgentIdentifierValue());
        linkingAgentIdentifierTypeModel.setLinkingAgentRole(linkingAgentIdentifierType.getLinkingAgentRole());
        return linkingAgentIdentifierTypeModel;
    }

    public String findDefaultTextType(List<TextType> textTypes) {
        return textTypes.stream().filter(t -> t.getLang() == null).findFirst().map(TextType::getValue).orElse(null);
    }
}

