/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.mapping;

import com.google.common.collect.Iterables;
import fr.gouv.culture.archivesdefrance.seda.v2.AccessRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.AppraisalRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveUnitType;
import fr.gouv.culture.archivesdefrance.seda.v2.ClassificationRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectRefType;
import fr.gouv.culture.archivesdefrance.seda.v2.DescriptiveMetadataContentType;
import fr.gouv.culture.archivesdefrance.seda.v2.DisseminationRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.EventType;
import fr.gouv.culture.archivesdefrance.seda.v2.FinalActionAppraisalCodeType;
import fr.gouv.culture.archivesdefrance.seda.v2.FinalActionStorageCodeType;
import fr.gouv.culture.archivesdefrance.seda.v2.HoldRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementHistoryType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementType;
import fr.gouv.culture.archivesdefrance.seda.v2.ReuseRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2.StorageRuleType;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.unit.ArchiveUnitHistoryModel;
import fr.gouv.vitam.common.model.unit.ArchiveUnitInternalModel;
import fr.gouv.vitam.common.model.unit.ArchiveUnitRoot;
import fr.gouv.vitam.common.model.unit.CommonRule;
import fr.gouv.vitam.common.model.unit.DataObjectReference;
import fr.gouv.vitam.common.model.unit.DescriptiveMetadataModel;
import fr.gouv.vitam.common.model.unit.ManagementModel;
import fr.gouv.vitam.common.model.unit.RuleCategoryModel;
import fr.gouv.vitam.processing.common.exception.ProcessingMalformedDataException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectReferenceException;
import fr.gouv.vitam.worker.core.mapping.DescriptiveMetadataMapper;
import fr.gouv.vitam.worker.core.mapping.RuleMapper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArchiveUnitMapper {
    private DescriptiveMetadataMapper descriptiveMetadataMapper;
    private RuleMapper ruleMapper;

    public ArchiveUnitMapper(DescriptiveMetadataMapper descriptiveMetadataMapper, RuleMapper ruleMapper) {
        this.descriptiveMetadataMapper = descriptiveMetadataMapper;
        this.ruleMapper = ruleMapper;
    }

    public ArchiveUnitRoot map(ArchiveUnitType archiveUnitType, String id, String groupId, String operationId, String unitType, String sedaVersion) throws ProcessingMalformedDataException, ProcessingObjectReferenceException {
        DescriptiveMetadataContentType metadataContentType;
        ArchiveUnitRoot archiveUnitRoot = new ArchiveUnitRoot();
        ArchiveUnitInternalModel archiveUnit = archiveUnitRoot.getArchiveUnit();
        archiveUnit.setId(id);
        archiveUnit.setOg(groupId);
        archiveUnit.setOpi(operationId);
        archiveUnit.setOps(Collections.singletonList(operationId));
        archiveUnit.setUnitType(UnitType.valueOf((String)unitType));
        IdentifierType archiveUnitProfile = archiveUnitType.getArchiveUnitProfile();
        if (archiveUnitProfile != null) {
            archiveUnit.setArchiveUnitProfile(archiveUnitProfile.getValue());
        }
        if ((metadataContentType = archiveUnitType.getContent()) != null) {
            DescriptiveMetadataModel metadataModel = this.descriptiveMetadataMapper.map(metadataContentType);
            archiveUnit.setDescriptiveMetadataModel(metadataModel);
        } else {
            archiveUnit.setDescriptiveMetadataModel(new DescriptiveMetadataModel());
        }
        this.mapAndValidateDataObjectReference(archiveUnitType);
        ManagementType management = archiveUnitType.getManagement();
        this.fillManagement(management, archiveUnit.getManagement());
        if (archiveUnitType.getContent() != null && archiveUnitType.getContent().getHistory() != null) {
            this.fillHistory(archiveUnitType.getContent().getHistory(), archiveUnit.getHistory());
        }
        if (management != null && management.getLogBook() != null) {
            List logbookExternal = management.getLogBook().getEvent().stream().map(this::toLogbookEvent).collect(Collectors.toList());
            archiveUnitRoot.setLogbookLifeCycleExternal(logbookExternal);
        }
        archiveUnit.setSedaVersion(sedaVersion);
        String vitamImplVersion = this.getClass().getPackage().getImplementationVersion();
        if (vitamImplVersion != null) {
            archiveUnit.setImplementationVersion(vitamImplVersion);
        } else {
            archiveUnit.setImplementationVersion("");
        }
        return archiveUnitRoot;
    }

    private LogbookEvent toLogbookEvent(EventType eventType) {
        LogbookEvent logbookEvent = new LogbookEvent();
        logbookEvent.setEvId(eventType.getEventIdentifier());
        logbookEvent.setEvTypeProc(eventType.getEventTypeCode());
        logbookEvent.setEvType(eventType.getEventType());
        logbookEvent.setEvDateTime(eventType.getEventDateTime());
        logbookEvent.setOutcome(eventType.getOutcome());
        logbookEvent.setOutDetail(eventType.getOutcomeDetail());
        logbookEvent.setOutMessg(eventType.getOutcomeDetailMessage());
        logbookEvent.setEvDetData(eventType.getEventDetailData());
        logbookEvent.setAgId(this.getElementAsText(eventType, "AgentIdentifier"));
        logbookEvent.setObId(this.getElementAsText(eventType, "ObjectIdentifier"));
        return logbookEvent;
    }

    private String getElementAsText(EventType eventType, String name) {
        return eventType.getAny().stream().map(object -> (Element)object).filter(element -> element.getLocalName().equals(name)).findFirst().map(Node::getFirstChild).map(Node::getTextContent).orElse(null);
    }

    public DataObjectReference mapAndValidateDataObjectReference(ArchiveUnitType archiveUnitType) throws ProcessingObjectReferenceException {
        List objectReferences = archiveUnitType.getArchiveUnitOrDataObjectReferenceOrDataObjectGroup().stream().filter(item -> item instanceof JAXBElement).filter(item -> ((JAXBElement)item).getDeclaredType().equals(DataObjectRefType.class)).map(item -> (JAXBElement)item).map(JAXBElement::getValue).map(item -> (DataObjectRefType)item).map(item -> {
            DataObjectReference dataObjectReference = new DataObjectReference();
            dataObjectReference.setDataObjectGroupReferenceId(item.getDataObjectGroupReferenceId());
            return dataObjectReference;
        }).collect(Collectors.toList());
        if (objectReferences.size() > 1) {
            throw new ProcessingObjectReferenceException("archive unit '" + archiveUnitType.getId() + "' references more than one technical object group");
        }
        return (DataObjectReference)Iterables.getOnlyElement(objectReferences, null);
    }

    private void fillManagement(ManagementType managementType, ManagementModel managementModel) throws ProcessingMalformedDataException {
        if (managementType != null) {
            managementModel.setUpdateOperationType(managementType.getUpdateOperation());
            managementModel.setNeedAuthorization(managementType.isNeedAuthorization());
            this.fillAccessRule(managementType, managementModel);
            this.fillStorageRule(managementType, managementModel);
            this.fillClassificationRule(managementType, managementModel);
            this.fillAppraisalRule(managementType, managementModel);
            this.fillDisseminationRule(managementType, managementModel);
            this.fillReuseRule(managementType, managementModel);
            this.fillHoldRule(managementType, managementModel);
        }
    }

    private void fillAccessRule(ManagementType managementType, ManagementModel managementModel) {
        AccessRuleType accessRule = managementType.getAccessRule();
        RuleCategoryModel accessRuleCategory = this.ruleMapper.fillCommonRule((CommonRule)accessRule);
        if (managementModel.getAccess() != null) {
            managementModel.getAccess().merge(accessRuleCategory);
        } else {
            managementModel.setAccess(accessRuleCategory);
        }
    }

    private void fillStorageRule(ManagementType managementType, ManagementModel managementModel) throws ProcessingMalformedDataException {
        StorageRuleType storageRule = managementType.getStorageRule();
        RuleCategoryModel storageRuleCategory = this.ruleMapper.fillCommonRule((CommonRule)storageRule);
        if (storageRule != null && storageRule.getFinalAction() != null && storageRuleCategory == null) {
            storageRuleCategory = new RuleCategoryModel();
        }
        if (managementModel.getStorage() != null) {
            managementModel.getStorage().merge(storageRuleCategory);
        } else {
            managementModel.setStorage(storageRuleCategory);
        }
        if (storageRuleCategory != null && storageRule != null) {
            FinalActionStorageCodeType sfa = storageRule.getFinalAction();
            if (sfa != null) {
                storageRuleCategory.setFinalAction(sfa.value());
            } else {
                throw new ProcessingMalformedDataException("FinalAction is required for StorageRule");
            }
        }
    }

    private void fillClassificationRule(ManagementType managementType, ManagementModel managementModel) {
        ClassificationRuleType classificationRule = managementType.getClassificationRule();
        RuleCategoryModel classificationRuleCategory = this.ruleMapper.fillCommonRule((CommonRule)classificationRule);
        if (classificationRule != null) {
            if (classificationRuleCategory == null) {
                classificationRuleCategory = new RuleCategoryModel();
            }
            if (classificationRule.getClassificationLevel() != null) {
                classificationRuleCategory.setClassificationLevel(classificationRule.getClassificationLevel());
            }
            if (classificationRule.getClassificationOwner() != null) {
                classificationRuleCategory.setClassificationOwner(classificationRule.getClassificationOwner());
            }
            if (classificationRule.getClassificationAudience() != null) {
                classificationRuleCategory.setClassificationAudience(classificationRule.getClassificationAudience());
            }
            if (classificationRule.getClassificationReassessingDate() != null) {
                classificationRuleCategory.setClassificationReassessingDate(classificationRule.getClassificationReassessingDate().toString());
            }
            if (classificationRule.isNeedReassessingAuthorization() != null) {
                classificationRuleCategory.setNeedReassessingAuthorization(classificationRule.isNeedReassessingAuthorization());
            }
        }
        if (managementModel.getClassification() != null) {
            managementModel.getClassification().merge(classificationRuleCategory);
        } else {
            managementModel.setClassification(classificationRuleCategory);
        }
    }

    private void fillReuseRule(ManagementType managementType, ManagementModel managementModel) {
        ReuseRuleType reuseRule = managementType.getReuseRule();
        RuleCategoryModel reuseRuleCategory = this.ruleMapper.fillCommonRule((CommonRule)reuseRule);
        if (managementModel.getReuse() != null) {
            managementModel.getReuse().merge(reuseRuleCategory);
        } else {
            managementModel.setReuse(reuseRuleCategory);
        }
    }

    private void fillDisseminationRule(ManagementType managementType, ManagementModel managementModel) {
        DisseminationRuleType disseminationRule = managementType.getDisseminationRule();
        RuleCategoryModel disseminationRuleCategory = this.ruleMapper.fillCommonRule((CommonRule)disseminationRule);
        if (managementModel.getDissemination() != null) {
            managementModel.getDissemination().merge(disseminationRuleCategory);
        } else {
            managementModel.setDissemination(disseminationRuleCategory);
        }
    }

    private void fillAppraisalRule(ManagementType managementType, ManagementModel managementModel) throws ProcessingMalformedDataException {
        AppraisalRuleType appraisalRule = managementType.getAppraisalRule();
        RuleCategoryModel appraisalRuleCategory = this.ruleMapper.fillCommonRule((CommonRule)appraisalRule);
        if (appraisalRule != null && appraisalRule.getFinalAction() != null && appraisalRuleCategory == null) {
            appraisalRuleCategory = new RuleCategoryModel();
        }
        if (managementModel.getAppraisal() != null) {
            managementModel.getAppraisal().merge(appraisalRuleCategory);
        } else {
            managementModel.setAppraisal(appraisalRuleCategory);
        }
        if (appraisalRuleCategory != null && appraisalRule != null) {
            FinalActionAppraisalCodeType afa = appraisalRule.getFinalAction();
            if (afa != null) {
                appraisalRuleCategory.setFinalAction(afa.value());
            } else {
                throw new ProcessingMalformedDataException("FinalAction is required for AppraisalRule");
            }
        }
    }

    private void fillHoldRule(ManagementType managementType, ManagementModel managementModel) {
        HoldRuleType holdRule = managementType.getHoldRule();
        RuleCategoryModel holdRuleCategory = this.ruleMapper.fillHoldRule(holdRule);
        if (managementModel.getHold() != null) {
            managementModel.getHold().merge(holdRuleCategory);
        } else {
            managementModel.setHold(holdRuleCategory);
        }
    }

    private void fillHistory(List<ManagementHistoryType> managementHistoryType, List<ArchiveUnitHistoryModel> archiveUnitHistoryModel) throws ProcessingMalformedDataException {
        if (managementHistoryType == null) {
            return;
        }
        for (ManagementHistoryType historyType : managementHistoryType) {
            ArchiveUnitHistoryModel historyModel = new ArchiveUnitHistoryModel();
            historyModel.setUpdateDate(historyType.getUpdateDate().toString());
            historyModel.getData().setVersion(historyType.getData().getVersion());
            this.fillManagement(historyType.getData().getManagement(), historyModel.getData().getManagement());
            archiveUnitHistoryModel.add(historyModel);
        }
    }
}

