/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.impl;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.processing.common.model.WorkspaceQueue;
import fr.gouv.vitam.worker.common.HandlerIO;
import java.util.function.Supplier;

public class WorkspaceTransferTask
implements Supplier<Boolean> {
    private HandlerIO handlerIO;
    private WorkspaceQueue task;

    public WorkspaceTransferTask(HandlerIO handlerAsyncIO, WorkspaceQueue task) {
        ParametersChecker.checkParameter((String)"Parameter handlerIO and task mustn't be null", (Object[])new Object[]{handlerAsyncIO, task});
        this.handlerIO = handlerAsyncIO;
        this.task = task;
    }

    @Override
    public Boolean get() {
        try {
            switch (this.task.getAction()) {
                case TRANSFER: {
                    this.handlerIO.transferInputStreamToWorkspace(this.task.getWorkspacePath(), this.task.getSourceFile(), this.task.getFilePath(), false);
                    break;
                }
                case UNZIP: {
                    this.handlerIO.unzipInputStreamOnWorkspace(this.handlerIO.getContainerName(), this.task.getFolderName(), this.task.getMediaType(), this.task.getSourceFile(), false);
                    break;
                }
                default: {
                    return Boolean.FALSE;
                }
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

