/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.impl;

import com.google.common.collect.Lists;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.processing.common.model.WorkspaceQueue;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.WorkerspaceQueueException;
import fr.gouv.vitam.worker.core.impl.WorkspaceTransferTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;

public class WorkspaceBatchRunner
implements Runnable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkspaceBatchRunner.class);
    private static final int BATCH_SIZE = 10;
    private BlockingQueue<WorkspaceQueue> queue;
    private HandlerIO handlerIO;
    private Executor executor;
    private volatile boolean doDequeue = true;
    private volatile boolean started = false;
    private volatile boolean stopped = false;
    private CompletableFuture<Boolean> waitMonitor;
    private Throwable exceptionOccurred = null;

    public WorkspaceBatchRunner(HandlerIO handlerAsyncIO, Executor executor, int queueSize) {
        ParametersChecker.checkParameter((String)"Parameters mustn't be null", (Object[])new Object[]{handlerAsyncIO, executor});
        this.waitMonitor = new CompletableFuture();
        this.queue = new LinkedBlockingQueue<WorkspaceQueue>(queueSize);
        this.handlerIO = handlerAsyncIO;
        this.executor = executor;
    }

    @Override
    public void run() {
        ArrayList completableFutures = new ArrayList();
        while (this.doDequeue || this.queue.size() > 0) {
            try {
                if (this.queue.size() <= 0) continue;
                int realBatchSize = 10;
                if (50 < this.queue.size()) {
                    realBatchSize = 50;
                } else if (100 < this.queue.size()) {
                    realBatchSize = 100;
                }
                while (realBatchSize > 0) {
                    WorkspaceQueue element = (WorkspaceQueue)this.queue.poll();
                    if (element != null) {
                        completableFutures.add((CompletableFuture)CompletableFuture.supplyAsync(new WorkspaceTransferTask(this.handlerIO, element), this.executor).exceptionally(e -> {
                            this.exceptionOccurred = e;
                            return Boolean.FALSE;
                        }));
                    }
                    --realBatchSize;
                }
                if (completableFutures.size() <= 0) continue;
                ((CompletableFuture)WorkspaceBatchRunner.sequence(completableFutures).exceptionally(e -> {
                    this.exceptionOccurred = e;
                    return Lists.newArrayList();
                })).join();
                completableFutures.clear();
            }
            catch (Exception e2) {
                LOGGER.error((Throwable)e2);
                this.queue.clear();
                this.waitMonitor.complete(Boolean.FALSE);
                this.doDequeue = false;
                break;
            }
        }
        this.waitMonitor.complete(Boolean.TRUE);
    }

    public void transfer(WorkspaceQueue workspaceQueue) throws WorkerspaceQueueException {
        ParametersChecker.checkParameter((String)"WorkspaceQueue is required", (Object[])new Object[]{workspaceQueue});
        if (!this.started) {
            throw new WorkerspaceQueueException("Workspace batch runner not started");
        }
        try {
            this.queue.put(workspaceQueue);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
            throw new WorkerspaceQueueException((Throwable)e);
        }
    }

    public void start() throws WorkerspaceQueueException {
        if (this.started) {
            throw new WorkerspaceQueueException("Workspace batch runner already started");
        }
        this.started = true;
        this.executor.execute(this);
    }

    public void join() throws WorkerspaceQueueException {
        if (!this.started) {
            throw new WorkerspaceQueueException("Workspace batch runner already started");
        }
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.doDequeue = false;
        try {
            this.waitMonitor.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error((Throwable)e);
            throw new WorkerspaceQueueException((Throwable)e);
        }
        if (null != this.exceptionOccurred) {
            throw new WorkerspaceQueueException(this.exceptionOccurred);
        }
    }

    private static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        return allDoneFuture.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }
}

