/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ingest.CheckSanityItem;
import fr.gouv.vitam.common.model.processing.Action;
import fr.gouv.vitam.common.model.processing.ActionDefinition;
import fr.gouv.vitam.common.model.processing.LifecycleState;
import fr.gouv.vitam.common.model.processing.ProcessBehavior;
import fr.gouv.vitam.common.model.processing.StatusAggregationBehavior;
import fr.gouv.vitam.common.model.processing.Step;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.processing.common.exception.HandlerNotFoundException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.api.Worker;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckConcurrentWorkflowLockHandler;
import fr.gouv.vitam.worker.core.handler.CheckDataObjectPackageActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckHeaderActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckIngestContractActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckNoObjectsActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckObjectUnitConsistencyActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckObjectsNumberActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckSedaActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckStorageAvailabilityActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckVersionActionHandler;
import fr.gouv.vitam.worker.core.handler.CommitLifeCycleObjectGroupActionHandler;
import fr.gouv.vitam.worker.core.handler.CommitLifeCycleUnitActionHandler;
import fr.gouv.vitam.worker.core.handler.DummyHandler;
import fr.gouv.vitam.worker.core.handler.ExtractSedaActionHandler;
import fr.gouv.vitam.worker.core.handler.IngestAccessionRegisterActionHandler;
import fr.gouv.vitam.worker.core.handler.IngestPrepareActionHandler;
import fr.gouv.vitam.worker.core.handler.ListArchiveUnitsActionHandler;
import fr.gouv.vitam.worker.core.handler.ListRunningIngestsActionHandler;
import fr.gouv.vitam.worker.core.handler.PrepareStorageInfoActionHandler;
import fr.gouv.vitam.worker.core.handler.RollBackActionHandler;
import fr.gouv.vitam.worker.core.handler.TransferNotificationActionHandler;
import fr.gouv.vitam.worker.core.handler.UploadSIPActionHandler;
import fr.gouv.vitam.worker.core.impl.HandlerIOImpl;
import fr.gouv.vitam.worker.core.impl.LifecycleFromWorker;
import fr.gouv.vitam.worker.core.plugin.PluginLoader;
import fr.gouv.vitam.worker.core.plugin.computeinheritedrules.ComputedInheritedRulesCheckDistributionThreshold;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationActionAccessionRegisterPreparationHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationActionCheckDistributionThresholdHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationActionFinalizationHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationActionObjectGroupPreparationHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationActionReportGenerationHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationActionUnitPreparationHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationAnalysisCheckDistributionThresholdHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationAnalysisFinalizationHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationAnalysisPreparationHandler;
import fr.gouv.vitam.worker.core.plugin.preservation.PreservationAccessionRegisterActionHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.ReclassificationFinalizationHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.ReclassificationPreparationCheckGraphHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.ReclassificationPreparationLoadRequestHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.ReclassificationPreparationUpdateDistributionHandler;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.TransferReplyAccessionRegisterPreparationHandler;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.TransferReplyObjectGroupPreparationHandler;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.TransferReplyReportGenerationHandler;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.TransferReplyUnitPreparationHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class WorkerImpl
implements Worker {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerImpl.class);
    private static final String EMPTY_EV_DET_DATA = "{}";
    private static PerformanceLogger PERFORMANCE_LOGGER = PerformanceLogger.getInstance();
    private static final String EMPTY_LIST = "null or Empty Action list";
    private static final String STEP_NULL = "step paramaters is null";
    private static final String HANDLER_NOT_FOUND = ": handler not found exception: ";
    private final Map<String, Supplier<ActionHandler>> actions = new HashMap<String, Supplier<ActionHandler>>();
    private String workerId;
    private final PluginLoader pluginLoader;

    public WorkerImpl(PluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
        this.workerId = GUIDFactory.newGUID().toString();
        this.init();
    }

    @Override
    @VisibleForTesting
    public WorkerImpl addActionHandler(String actionName, ActionHandler actionHandler) {
        ParametersChecker.checkParameter((String)"actionName is a mandatory parameter", (String[])new String[]{actionName});
        ParametersChecker.checkParameter((String)"actionHandler is a mandatory parameter", (Object[])new Object[]{actionHandler});
        this.actions.put(actionName, () -> actionHandler);
        return this;
    }

    private void init() {
        this.actions.put(UploadSIPActionHandler.getId(), UploadSIPActionHandler::new);
        this.actions.put(CheckSanityItem.CHECK_ANTIVIRUS.getItemValue(), IngestPrepareActionHandler::new);
        this.actions.put(CheckSanityItem.CHECK_FORMAT.getItemValue(), IngestPrepareActionHandler::new);
        this.actions.put(CheckSanityItem.CHECK_FILENAME_MANIFEST.getItemValue(), IngestPrepareActionHandler::new);
        this.actions.put(CheckSanityItem.CHECK_DIGEST_MANIFEST.getItemValue(), IngestPrepareActionHandler::new);
        this.actions.put(CheckSedaActionHandler.getId(), CheckSedaActionHandler::new);
        this.actions.put(CheckIngestContractActionHandler.getId(), CheckIngestContractActionHandler::new);
        this.actions.put(CheckObjectsNumberActionHandler.getId(), CheckObjectsNumberActionHandler::new);
        this.actions.put(CheckNoObjectsActionHandler.getId(), CheckNoObjectsActionHandler::new);
        this.actions.put(CheckVersionActionHandler.getId(), CheckVersionActionHandler::new);
        this.actions.put(CheckStorageAvailabilityActionHandler.getId(), CheckStorageAvailabilityActionHandler::new);
        this.actions.put(CheckObjectUnitConsistencyActionHandler.getId(), CheckObjectUnitConsistencyActionHandler::new);
        this.actions.put(PrepareStorageInfoActionHandler.getId(), PrepareStorageInfoActionHandler::new);
        this.actions.put(IngestAccessionRegisterActionHandler.getId(), IngestAccessionRegisterActionHandler::new);
        this.actions.put(PreservationAccessionRegisterActionHandler.getId(), PreservationAccessionRegisterActionHandler::new);
        this.actions.put(TransferNotificationActionHandler.getId(), TransferNotificationActionHandler::new);
        this.actions.put(DummyHandler.getId(), DummyHandler::new);
        this.actions.put(CommitLifeCycleUnitActionHandler.getId(), CommitLifeCycleUnitActionHandler::new);
        this.actions.put(CommitLifeCycleObjectGroupActionHandler.getId(), CommitLifeCycleObjectGroupActionHandler::new);
        this.actions.put(RollBackActionHandler.getId(), RollBackActionHandler::new);
        this.actions.put(CheckHeaderActionHandler.getId(), CheckHeaderActionHandler::new);
        CheckNoObjectsActionHandler checkNoObjectsActionHandler = new CheckNoObjectsActionHandler();
        CheckObjectsNumberActionHandler checkObjectsNumberActionHandler = new CheckObjectsNumberActionHandler();
        ExtractSedaActionHandler extractSedaActionHandler = new ExtractSedaActionHandler();
        CheckObjectUnitConsistencyActionHandler checkObjectUnitConsistencyActionHandler = new CheckObjectUnitConsistencyActionHandler();
        CheckDataObjectPackageActionHandler checkDataObjectPackageActionHandler = new CheckDataObjectPackageActionHandler(checkNoObjectsActionHandler, checkObjectsNumberActionHandler, extractSedaActionHandler, checkObjectUnitConsistencyActionHandler);
        this.actions.put(CheckDataObjectPackageActionHandler.getId(), () -> checkDataObjectPackageActionHandler);
        this.actions.put(ListRunningIngestsActionHandler.getId(), ListRunningIngestsActionHandler::new);
        this.actions.put(ListArchiveUnitsActionHandler.getId(), ListArchiveUnitsActionHandler::new);
        this.actions.put(CheckConcurrentWorkflowLockHandler.getId(), CheckConcurrentWorkflowLockHandler::new);
        this.actions.put(ReclassificationPreparationLoadRequestHandler.getId(), ReclassificationPreparationLoadRequestHandler::new);
        this.actions.put(ReclassificationPreparationCheckGraphHandler.getId(), ReclassificationPreparationCheckGraphHandler::new);
        this.actions.put(ReclassificationPreparationUpdateDistributionHandler.getId(), ReclassificationPreparationUpdateDistributionHandler::new);
        this.actions.put(ReclassificationFinalizationHandler.getId(), ReclassificationFinalizationHandler::new);
        this.actions.put(EliminationAnalysisCheckDistributionThresholdHandler.getId(), EliminationAnalysisCheckDistributionThresholdHandler::new);
        this.actions.put(EliminationAnalysisPreparationHandler.getId(), EliminationAnalysisPreparationHandler::new);
        this.actions.put(EliminationAnalysisFinalizationHandler.getId(), EliminationAnalysisFinalizationHandler::new);
        this.actions.put(EliminationActionCheckDistributionThresholdHandler.getId(), EliminationActionCheckDistributionThresholdHandler::new);
        this.actions.put(EliminationActionUnitPreparationHandler.getId(), EliminationActionUnitPreparationHandler::new);
        this.actions.put(EliminationActionObjectGroupPreparationHandler.getId(), EliminationActionObjectGroupPreparationHandler::new);
        this.actions.put(EliminationActionAccessionRegisterPreparationHandler.getId(), EliminationActionAccessionRegisterPreparationHandler::new);
        this.actions.put(EliminationActionReportGenerationHandler.getId(), EliminationActionReportGenerationHandler::new);
        this.actions.put(EliminationActionFinalizationHandler.getId(), EliminationActionFinalizationHandler::new);
        this.actions.put(TransferReplyUnitPreparationHandler.getId(), TransferReplyUnitPreparationHandler::new);
        this.actions.put(TransferReplyObjectGroupPreparationHandler.getId(), TransferReplyObjectGroupPreparationHandler::new);
        this.actions.put(TransferReplyAccessionRegisterPreparationHandler.getId(), TransferReplyAccessionRegisterPreparationHandler::new);
        this.actions.put(TransferReplyReportGenerationHandler.getId(), TransferReplyReportGenerationHandler::new);
        this.actions.put(ComputedInheritedRulesCheckDistributionThreshold.getId(), ComputedInheritedRulesCheckDistributionThreshold::new);
    }

    @Override
    public ItemStatus run(WorkerParameters workParams, Step step) throws IllegalArgumentException, ProcessingException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)workParams);
        if (step == null) {
            throw new IllegalArgumentException(STEP_NULL);
        }
        if (step.getActions() == null || step.getActions().isEmpty()) {
            throw new IllegalArgumentException(EMPTY_LIST);
        }
        ItemStatus responses = new ItemStatus(step.getStepName());
        this.workerId = GUIDFactory.newGUID().toString();
        try (HandlerIOImpl handlerIO = new HandlerIOImpl(workParams.getContainerName(), this.workerId, workParams.getObjectNameList());
             LogbookLifeCyclesClient logbookLfcClient = LogbookLifeCyclesClientFactory.getInstance().getClient();){
            LifecycleFromWorker lifecycleFromWorker = new LifecycleFromWorker(logbookLfcClient);
            for (Action action : step.getActions()) {
                List pluginResponse;
                Stopwatch stopwatch = Stopwatch.createStarted();
                handlerIO.reset();
                ActionDefinition actionDefinition = action.getActionDefinition();
                if (actionDefinition.getIn() != null) {
                    handlerIO.addInIOParameters(actionDefinition.getIn());
                }
                if (actionDefinition.getOut() != null) {
                    handlerIO.addOutIOParameters(actionDefinition.getOut());
                }
                String handlerName = actionDefinition.getActionKey();
                ItemStatus aggregateItemStatus = new ItemStatus();
                if (this.pluginLoader.contains(handlerName)) {
                    try (ActionHandler actionPlugin = this.pluginLoader.newInstance(handlerName);){
                        LOGGER.debug("START plugin ", (Object)actionDefinition.getActionKey(), (Object)step.getStepName());
                        pluginResponse = actionPlugin.executeList(workParams, (HandlerIO)handlerIO);
                        List<ItemStatus> itemStatuses = pluginResponse.stream().flatMap(itemStatus -> itemStatus.getItemsStatus().values().stream()).collect(Collectors.toList());
                        aggregateItemStatus = WorkerImpl.getActionResponse(handlerName, itemStatuses, action.getActionDefinition().getStatusAggregationBehavior());
                        aggregateItemStatus.setItemId(handlerName);
                        if (action.getActionDefinition().lifecycleEnabled()) {
                            lifecycleFromWorker.generateLifeCycle(pluginResponse, workParams, action, step.getDistribution().getType());
                        }
                        responses.setItemsStatus(aggregateItemStatus);
                    }
                } else {
                    ActionHandler actionHandler = this.getActionHandler(handlerName);
                    if (actionHandler == null) {
                        throw new HandlerNotFoundException(actionDefinition.getActionKey() + HANDLER_NOT_FOUND);
                    }
                    LOGGER.debug("START handler {} in step {}", (Object)actionDefinition.getActionKey(), (Object)step.getStepName());
                    pluginResponse = actionHandler.executeList(workParams, (HandlerIO)handlerIO);
                    for (ItemStatus itemStatus2 : pluginResponse) {
                        aggregateItemStatus.setItemId(itemStatus2.getItemId());
                        aggregateItemStatus.setItemsStatus(itemStatus2);
                    }
                    responses.setItemsStatus(aggregateItemStatus);
                }
                if (LifecycleState.FLUSH_LFC.equals((Object)action.getActionDefinition().getLifecycleState())) {
                    lifecycleFromWorker.saveLifeCycles(step.getDistribution().getType());
                }
                LOGGER.debug("STOP handler {} in step {}", (Object)actionDefinition.getActionKey(), (Object)step.getStepName());
                long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                PERFORMANCE_LOGGER.log(step.getStepName(), actionDefinition.getActionKey(), elapsed);
                if (!responses.shallStop(ProcessBehavior.BLOCKING.equals((Object)actionDefinition.getBehavior()))) continue;
                break;
            }
            lifecycleFromWorker.saveLifeCycles(step.getDistribution().getType());
            this.clearEvDetDataForDistributedSteps(step, responses);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
        LOGGER.debug("step name :" + step.getStepName());
        return responses;
    }

    private void clearEvDetDataForDistributedSteps(Step step, ItemStatus responses) {
        if (step.getDistribution().getKind().isDistributed()) {
            for (ItemStatus item : responses.getItemsStatus().values()) {
                item.setEvDetailData(EMPTY_EV_DET_DATA);
            }
            responses.setEvDetailData(EMPTY_EV_DET_DATA);
        }
    }

    private static ItemStatus getActionResponse(String handlerName, List<ItemStatus> pluginResponse, StatusAggregationBehavior statusBehavior) {
        ItemStatus status = new ItemStatus(handlerName);
        for (ItemStatus subItemStatus : pluginResponse) {
            subItemStatus.setItemId(handlerName);
            status.setItemsStatus(handlerName, subItemStatus, statusBehavior);
        }
        return status;
    }

    private ActionHandler getActionHandler(String actionId) {
        return this.actions.get(actionId).get();
    }

    @Override
    public String getWorkerId() {
        return this.workerId;
    }

    public void close() {
        this.actions.clear();
    }
}

