/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.impl;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.Action;
import fr.gouv.vitam.common.model.processing.DistributionType;
import fr.gouv.vitam.common.model.processing.LifecycleState;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParametersBulk;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCyclesClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.utils.LogbookLifecycleWorkerHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class LifecycleFromWorker {
    private List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersTemporaryBulks = new ArrayList<LogbookLifeCycleParametersBulk>();
    private List<LogbookLifeCycleParametersBulk> logbookLifeCycleParametersBulks = new ArrayList<LogbookLifeCycleParametersBulk>();
    private final LogbookLifeCyclesClient logbookLfcClient;

    LifecycleFromWorker(LogbookLifeCyclesClient logbookLfcClient) {
        this.logbookLfcClient = logbookLfcClient;
    }

    void generateLifeCycle(List<ItemStatus> pluginResponse, WorkerParameters workParams, Action action, DistributionType distributionType) throws InvalidGuidOperationException {
        int i = 0;
        String handlerName = action.getActionDefinition().getActionKey();
        for (ItemStatus itemStatus : pluginResponse) {
            String objectName = (String)workParams.getObjectNameList().get(i);
            ++i;
            if (StatusCode.ALREADY_EXECUTED.equals((Object)itemStatus.getGlobalStatus()) || !itemStatus.isLifecycleEnable()) continue;
            workParams.setObjectName(objectName);
            LogbookLifeCycleParameters lfcParam = this.createStartLogbookLfc(distributionType, handlerName, workParams);
            List<LogbookLifeCycleParameters> logbookParamList = this.createLogbookLifeCycleParameters(handlerName, itemStatus, lfcParam);
            String objectId = objectName.replace(".json", "");
            if (action.getActionDefinition().lifecycleState() == LifecycleState.TEMPORARY) {
                this.logbookLifeCycleParametersTemporaryBulks.add(new LogbookLifeCycleParametersBulk(objectId, logbookParamList));
                continue;
            }
            this.logbookLifeCycleParametersBulks.add(new LogbookLifeCycleParametersBulk(objectId, logbookParamList));
        }
    }

    void saveLifeCycles(DistributionType distributionType) throws VitamClientInternalException {
        if (!this.logbookLifeCycleParametersTemporaryBulks.isEmpty()) {
            this.logbookLfcClient.bulkLifeCycleTemporary(VitamThreadUtils.getVitamSession().getRequestId(), distributionType, this.logbookLifeCycleParametersTemporaryBulks);
            this.logbookLifeCycleParametersTemporaryBulks.clear();
        }
        if (!this.logbookLifeCycleParametersBulks.isEmpty()) {
            this.logbookLfcClient.bulkLifeCycle(VitamThreadUtils.getVitamSession().getRequestId(), distributionType, this.logbookLifeCycleParametersBulks);
            this.logbookLifeCycleParametersBulks.clear();
        }
    }

    private LogbookLifeCycleParameters createStartLogbookLfc(DistributionType distributionType, String handlerName, WorkerParameters workParams) throws InvalidGuidOperationException {
        LogbookLifeCycleUnitParameters lfcParam = null;
        switch (distributionType) {
            case Units: {
                lfcParam = LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()), (String)VitamLogbookMessages.getEventTypeLfc((String)handlerName), (GUID)GUIDReader.getGUID((String)workParams.getContainerName()), (LogbookTypeProcess)workParams.getLogbookTypeProcess(), (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)handlerName, (StatusCode)StatusCode.OK), (String)VitamLogbookMessages.getCodeLfc((String)handlerName, (StatusCode)StatusCode.OK), (GUID)GUIDReader.getGUID((String)LogbookLifecycleWorkerHelper.getObjectID((WorkerParameters)workParams)));
                lfcParam.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
                break;
            }
            case ObjectGroup: {
                lfcParam = LogbookParameterHelper.newLogbookLifeCycleObjectGroupParameters((GUID)GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()), (String)VitamLogbookMessages.getEventTypeLfc((String)handlerName), (GUID)GUIDReader.getGUID((String)workParams.getContainerName()), (LogbookTypeProcess)workParams.getLogbookTypeProcess(), (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)handlerName, (StatusCode)StatusCode.OK), (String)VitamLogbookMessages.getCodeLfc((String)handlerName, (StatusCode)StatusCode.OK), (GUID)GUIDReader.getGUID((String)LogbookLifecycleWorkerHelper.getObjectID((WorkerParameters)workParams)));
                lfcParam.putParameterValue(LogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
            }
        }
        lfcParam.putParameterValue(LogbookParameterName.agentIdentifier, ServerIdentity.getInstance().getJsonIdentity());
        return lfcParam;
    }

    private List<LogbookLifeCycleParameters> createLogbookLifeCycleParameters(String handlerName, ItemStatus actionResponse, LogbookLifeCycleParameters logbookParam) {
        logbookParam.putParameterValue(LogbookParameterName.eventDateTime, null);
        ArrayList<LogbookLifeCycleParameters> logbookParamList = new ArrayList<LogbookLifeCycleParameters>();
        LogbookLifeCycleParameters finalLogbookLfcParam = LogbookLifeCyclesClientHelper.copy((LogbookLifeCycleParameters)logbookParam);
        if (!actionResponse.getItemId().contains(".")) {
            finalLogbookLfcParam.setFinalStatus(handlerName, null, actionResponse.getGlobalStatus(), actionResponse.getMessage(), new String[0]);
        } else {
            finalLogbookLfcParam.setFinalStatus(actionResponse.getItemId(), null, actionResponse.getGlobalStatus(), actionResponse.getMessage(), new String[0]);
        }
        if (!actionResponse.getEvDetailData().isEmpty()) {
            finalLogbookLfcParam.putParameterValue(LogbookParameterName.eventDetailData, actionResponse.getEvDetailData());
        }
        if (actionResponse.getData("Detail") != null) {
            String outcomeDetailMessage = finalLogbookLfcParam.getParameterValue(LogbookParameterName.outcomeDetailMessage) + " " + actionResponse.getData("Detail");
            finalLogbookLfcParam.putParameterValue(LogbookParameterName.outcomeDetailMessage, outcomeDetailMessage);
        }
        for (Map.Entry entry : actionResponse.getItemsStatus().entrySet()) {
            for (Map.Entry subTaskEntry : ((ItemStatus)entry.getValue()).getSubTaskStatus().entrySet()) {
                LogbookLifeCycleParameters subLogbookLfcParam = LogbookLifeCyclesClientHelper.copy((LogbookLifeCycleParameters)logbookParam);
                subLogbookLfcParam.putParameterValue(LogbookParameterName.eventIdentifier, GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).getId());
                subLogbookLfcParam.putParameterValue(LogbookParameterName.parentEventIdentifier, logbookParam.getParameterValue(LogbookParameterName.eventIdentifier));
                subLogbookLfcParam.putParameterValue(LogbookParameterName.lifeCycleIdentifier, subLogbookLfcParam.getParameterValue(LogbookParameterName.objectIdentifier));
                subLogbookLfcParam.putParameterValue(LogbookParameterName.objectIdentifier, (String)subTaskEntry.getKey());
                ItemStatus subItemStatus = (ItemStatus)subTaskEntry.getValue();
                subLogbookLfcParam.setFinalStatus(handlerName, (String)entry.getKey(), subItemStatus.getGlobalStatus(), subItemStatus.getMessage(), new String[0]);
                if (!subItemStatus.getEvDetailData().isEmpty()) {
                    subLogbookLfcParam.putParameterValue(LogbookParameterName.eventDetailData, subItemStatus.getEvDetailData());
                }
                if (subItemStatus.getGlobalOutcomeDetailSubcode() != null) {
                    subLogbookLfcParam.putParameterValue(LogbookParameterName.outcomeDetail, VitamLogbookMessages.getOutcomeDetailLfc((String)handlerName, (String)((String)entry.getKey()), (String)subItemStatus.getGlobalOutcomeDetailSubcode(), (StatusCode)subItemStatus.getGlobalStatus()));
                    subLogbookLfcParam.putParameterValue(LogbookParameterName.outcomeDetailMessage, VitamLogbookMessages.getCodeLfc((String)handlerName, (String)((String)entry.getKey()), (String)subItemStatus.getGlobalOutcomeDetailSubcode(), (StatusCode)subItemStatus.getGlobalStatus(), (Object[])new Object[0]));
                }
                logbookParamList.add(subLogbookLfcParam);
            }
            ((ItemStatus)entry.getValue()).getSubTaskStatus().clear();
        }
        logbookParamList.add(finalLogbookLfcParam);
        return logbookParamList;
    }
}

