/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import fr.gouv.vitam.common.FileUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.model.processing.IOParameter;
import fr.gouv.vitam.common.model.processing.LazyFile;
import fr.gouv.vitam.common.model.processing.ProcessingUri;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCyclesClientHelper;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.model.WorkspaceAction;
import fr.gouv.vitam.processing.common.model.WorkspaceQueue;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.WorkerspaceQueueException;
import fr.gouv.vitam.worker.core.impl.AsyncWorkspaceTransfer;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.api.model.FileParams;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class HandlerIOImpl
implements HandlerIO,
VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(HandlerIOImpl.class);
    public static final String NOT_CONFORM_PARAM = "Input/Output io parameter is not correct";
    private static final String HANDLER_INPUT_NOT_FOUND = "Handler input not found exception: ";
    private final ListMultimap<String, Object> input = ArrayListMultimap.create();
    private final List<ProcessingUri> output = new ArrayList<ProcessingUri>();
    private final String containerName;
    private final String workerId;
    private final File localDirectory;
    private final Map<String, Object> memoryMap = new HashMap<String, Object>();
    private final WorkspaceClientFactory workspaceClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final LogbookLifeCyclesClientHelper helper;
    private AsyncWorkspaceTransfer asyncWorkspaceTransfer;
    private String currentObjectId;
    private List<String> objectIds;
    private boolean needRefresh = false;

    public HandlerIOImpl(String containerName, String workerId, List<String> objectIds) {
        this(WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), LogbookLifeCyclesClientFactory.getInstance(), containerName, workerId, objectIds);
    }

    @VisibleForTesting
    public HandlerIOImpl(WorkspaceClientFactory workspaceClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, String containerName, String workerId, List<String> objectIds) {
        this.containerName = containerName;
        this.workerId = workerId;
        this.localDirectory = PropertiesUtils.fileFromTmpFolder((String)(containerName + "_" + workerId));
        this.localDirectory.mkdirs();
        this.workspaceClientFactory = workspaceClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.helper = new LogbookLifeCyclesClientHelper();
        this.objectIds = objectIds;
        this.asyncWorkspaceTransfer = new AsyncWorkspaceTransfer(this);
    }

    public LogbookLifeCyclesClient getLifecyclesClient() {
        return this.logbookLifeCyclesClientFactory.getClient();
    }

    public LogbookLifeCyclesClientHelper getHelper() {
        return this.helper;
    }

    public void addInIOParameters(List<IOParameter> list) {
        block7: for (IOParameter in : list) {
            ProcessingUri uri = in.getUri();
            switch (uri.getPrefix()) {
                case WORKSPACE: {
                    for (String objectId : this.objectIds) {
                        this.input.put((Object)objectId, (Object)new LazyFile(uri.getPath(), in.getOptional()));
                    }
                    continue block7;
                }
                case WORKSPACE_OBJECT: {
                    for (String objectId : this.objectIds) {
                        this.input.put((Object)objectId, (Object)new LazyFile(objectId + File.separator + uri.getPath(), in.getOptional()));
                    }
                    continue block7;
                }
                case MEMORY: {
                    for (String objectId : this.objectIds) {
                        this.input.put((Object)objectId, this.memoryMap.get(String.format("%s.%s", uri.getPath(), objectId)));
                    }
                    continue block7;
                }
                case VALUE: {
                    for (String objectId : this.objectIds) {
                        this.input.put((Object)objectId, (Object)uri.getPath());
                    }
                    continue block7;
                }
                case MEMORY_SINGLE: {
                    this.input.put((Object)uri.getPath(), this.memoryMap.get(uri.getPath()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(HANDLER_INPUT_NOT_FOUND + uri.getPrefix() + ":" + uri.getPath());
                }
            }
        }
    }

    public void addOutIOParameters(List<IOParameter> list) {
        block3: for (IOParameter out : list) {
            switch (out.getUri().getPrefix()) {
                case WORKSPACE: 
                case WORKSPACE_OBJECT: 
                case MEMORY: 
                case MEMORY_SINGLE: {
                    this.output.add(out.getUri());
                    continue block3;
                }
            }
            throw new IllegalArgumentException("Handler Output not conform: " + out.getUri());
        }
    }

    public void reset() {
        this.input.clear();
        this.output.clear();
        this.helper.clear();
    }

    public void close() {
        try {
            this.enableAsync(false);
        }
        catch (WorkerspaceQueueException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.partialClose();
        }
    }

    public void partialClose() {
        this.reset();
        this.memoryMap.clear();
        if (!FileUtil.deleteRecursive((File)this.localDirectory)) {
            LOGGER.warn("Cannot clear the temporary directory: " + this.localDirectory);
        }
    }

    public List<Object> getInput() {
        return this.input.get((Object)this.currentObjectId);
    }

    public Object getInput(int rank) {
        if (this.input.get((Object)this.currentObjectId).get(rank) instanceof LazyFile) {
            return this.getFile(rank);
        }
        return this.input.get((Object)this.currentObjectId).get(rank);
    }

    public <T> T getInput(int rank, Class<T> type) {
        if (type == File.class) {
            return type.cast(this.getFile(rank));
        }
        return type.cast(this.input.get((Object)this.currentObjectId).get(rank));
    }

    public File getFile(int rank) {
        if (this.input.get((Object)this.currentObjectId).get(rank) instanceof LazyFile) {
            LazyFile lazyFile = (LazyFile)this.input.get((Object)this.currentObjectId).get(rank);
            try {
                this.input.get((Object)this.currentObjectId).set(rank, this.findFileFromWorkspace(lazyFile.getPath()));
            }
            catch (FileNotFoundException e) {
                if (lazyFile.isOptional()) {
                    LOGGER.debug("Optinal file not found", (Throwable)e);
                    return null;
                }
                throw new IllegalArgumentException(HANDLER_INPUT_NOT_FOUND + lazyFile.getPath(), e);
            }
        }
        return (File)this.input.get((Object)this.currentObjectId).get(rank);
    }

    public List<ProcessingUri> getOutput() {
        return this.output;
    }

    public ProcessingUri getOutput(int rank) {
        return this.output.get(rank);
    }

    public HandlerIO addOutputResult(int rank, Object object) throws ProcessingException {
        return this.addOutputResult(rank, object, false, false);
    }

    public HandlerIO addOutputResult(int rank, Object object, boolean asyncIO) throws ProcessingException {
        return this.addOutputResult(rank, object, false, asyncIO);
    }

    public HandlerIO addOutputResult(int rank, Object object, boolean deleteLocal, boolean asyncIO) throws ProcessingException {
        ProcessingUri uri = this.output.get(rank);
        if (uri == null) {
            throw new IllegalArgumentException(HANDLER_INPUT_NOT_FOUND + rank);
        }
        switch (uri.getPrefix()) {
            case MEMORY: {
                this.memoryMap.put(String.format("%s.%s", uri.getPath(), this.currentObjectId), object);
                break;
            }
            case MEMORY_SINGLE: {
                this.memoryMap.put(uri.getPath(), object);
                break;
            }
            case VALUE: {
                break;
            }
            case WORKSPACE_OBJECT: {
                if (!(object instanceof File)) {
                    throw new ProcessingException("Not a File but WORKSPACE out parameter: " + uri);
                }
                this.transferFileToWorkspace(this.currentObjectId + File.separator + uri.getPath(), (File)object, deleteLocal, asyncIO);
                break;
            }
            case WORKSPACE: {
                if (!(object instanceof File)) {
                    throw new ProcessingException("Not a File but WORKSPACE out parameter: " + uri);
                }
                this.transferFileToWorkspace(uri.getPath(), (File)object, deleteLocal, asyncIO);
                break;
            }
            default: {
                throw new IllegalArgumentException(HANDLER_INPUT_NOT_FOUND + uri);
            }
        }
        return this;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public File getNewLocalFile(String name) {
        File file = new File(this.localDirectory.getAbsolutePath() + "/" + name);
        file.getParentFile().mkdirs();
        return file;
    }

    public boolean checkHandlerIO(int outputNumber, List<Class<?>> clasz) {
        if (this.getInput().size() != clasz.size() || this.getOutput().size() != outputNumber) {
            LOGGER.error("InputSize shoul be {} but is {} OR OutputSize should be {} but is {}", new Object[]{clasz.size(), this.getInput().size(), outputNumber, this.getOutput().size()});
            return false;
        }
        for (int i = 0; i < this.getInput().size(); ++i) {
            Object object = this.getInput(i);
            if (object != null && clasz.get(i).isInstance(object)) continue;
            LOGGER.error("Input class should be {} but is {}", (Object)clasz.get(i).getName(), (Object)(object != null ? object.getClass().getName() : "Null object"));
            return false;
        }
        return true;
    }

    public boolean isExistingFileInWorkspace(String workspacePath) throws ProcessingException {
        boolean bl;
        block8: {
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                bl = workspaceClient.isExistingObject(this.containerName, workspacePath);
                if (workspaceClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException e) {
                    throw new ProcessingException("Cannot check file existence in workspace: " + this.containerName + "/" + workspacePath, (Throwable)e);
                }
            }
            workspaceClient.close();
        }
        return bl;
    }

    public void transferFileToWorkspace(String workspacePath, File sourceFile, boolean toDelete, boolean asyncIO) throws ProcessingException {
        try {
            ParametersChecker.checkParameter((String)"Workspace path is a mandatory parameter", (String[])new String[]{workspacePath});
            ParametersChecker.checkParameter((String)"Source file is a mandatory parameter", (Object[])new Object[]{sourceFile});
        }
        catch (IllegalArgumentException e) {
            throw new ProcessingException((Throwable)e);
        }
        if (!sourceFile.canRead()) {
            throw new ProcessingException("Cannot found source file: " + sourceFile);
        }
        try {
            this.transferInputStreamToWorkspace(workspacePath, Files.newInputStream(sourceFile.toPath(), new OpenOption[0]), toDelete, Paths.get(sourceFile.toURI()), asyncIO);
        }
        catch (IOException e) {
            throw new ProcessingException("Cannot found or read source file: " + sourceFile, (Throwable)e);
        }
    }

    public void transferAtomicFileToWorkspace(String workspacePath, File sourceFile) throws ProcessingException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
             FileInputStream inputStream = new FileInputStream(sourceFile);){
            workspaceClient.putAtomicObject(this.containerName, workspacePath, (InputStream)inputStream, sourceFile.length());
        }
        catch (ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingException("Cannot write to workspace: " + this.containerName + "/" + workspacePath, e);
        }
    }

    private void transferInputStreamToWorkspace(String workspacePath, InputStream inputStream, boolean toDelete, Path filePath, boolean asyncIO) throws ProcessingException {
        block24: {
            if (!asyncIO) {
                try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                    workspaceClient.putObject(this.containerName, workspacePath, inputStream);
                    break block24;
                }
                catch (ContentAddressableStorageServerException e) {
                    throw new ProcessingException("Cannot write to workspace: " + this.containerName + "/" + workspacePath, (Throwable)e);
                }
                finally {
                    try {
                        if (filePath != null && toDelete) {
                            Files.delete(filePath);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("File could not be deleted: " + filePath.toAbsolutePath());
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            LOGGER.warn("InputStream close failed :", (Throwable)e);
                        }
                    }
                }
            }
            try {
                this.asyncWorkspaceTransfer.transfer(new WorkspaceQueue(workspacePath, inputStream).setFilePath(filePath));
            }
            catch (WorkerspaceQueueException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
    }

    public void transferInputStreamToWorkspace(String workspacePath, InputStream inputStream, Path filePath, boolean asyncIO) throws ProcessingException {
        this.transferInputStreamToWorkspace(workspacePath, inputStream, true, filePath, asyncIO);
    }

    private File findFileFromWorkspace(String objectName) throws FileNotFoundException {
        File file;
        try {
            file = this.getFileFromWorkspace(objectName);
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new FileNotFoundException("File not found: " + objectName + ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + objectName);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileFromWorkspace(String objectName) throws IOException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        File file = this.getNewLocalFile(objectName);
        if (!file.exists()) {
            Response response = null;
            try {
                block14: {
                    try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                        response = workspaceClient.getObject(this.containerName, objectName);
                        if (response == null) break block14;
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                            StreamUtils.copy((InputStream)((InputStream)response.getEntity()), (OutputStream)fileOutputStream);
                        }
                    }
                }
                this.consumeAnyEntityAndClose(response);
            }
            catch (Throwable throwable) {
                this.consumeAnyEntityAndClose(response);
                throw throwable;
            }
        }
        return file;
    }

    public InputStream getInputStreamFromWorkspace(String objectName) throws IOException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        return new FileInputStream(this.getFileFromWorkspace(objectName));
    }

    public void consumeAnyEntityAndClose(Response response) {
        DefaultClient.staticConsumeAnyEntityAndClose((Response)response);
    }

    public JsonNode getJsonFromWorkspace(String jsonFilePath) throws ProcessingException {
        JsonNode jsonNode;
        Response response;
        block20: {
            response = null;
            InputStream is = null;
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                File file = this.getNewLocalFile(jsonFilePath);
                if (!file.exists()) {
                    response = workspaceClient.getObject(this.containerName, jsonFilePath);
                    is = (InputStream)response.getEntity();
                    if (is != null) {
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                            StreamUtils.copy((InputStream)is, (OutputStream)fileOutputStream);
                        }
                    } else {
                        LOGGER.error("Json not found");
                        throw new ProcessingException("Json not found");
                    }
                }
                jsonNode = JsonHandler.getFromFile((File)file);
                if (workspaceClient == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (workspaceClient != null) {
                            try {
                                workspaceClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidParseOperationException e) {
                        LOGGER.debug("Json wrong format", (Throwable)e);
                        throw new ProcessingException((Throwable)e);
                    }
                    catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
                        LOGGER.debug("Workspace Server Error", e);
                        throw new ProcessingException(e);
                    }
                    catch (IOException e) {
                        LOGGER.debug("Local Worker Storage Error", (Throwable)e);
                        throw new ProcessingException((Throwable)e);
                    }
                }
                catch (Throwable throwable3) {
                    this.consumeAnyEntityAndClose(response);
                    throw throwable3;
                }
            }
            workspaceClient.close();
        }
        this.consumeAnyEntityAndClose(response);
        return jsonNode;
    }

    public List<URI> getUriList(String containerName, String folderName) throws ProcessingException {
        List list;
        block8: {
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                list = (List)JsonHandler.getFromStringAsTypeReference((String)workspaceClient.getListUriDigitalObjectFromFolder(containerName, folderName).toJsonNode().get("$results").get(0).toString(), (TypeReference)new TypeReference<List<URI>>(){});
                if (workspaceClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | ContentAddressableStorageServerException e) {
                    LOGGER.debug("Workspace Server Error", e);
                    throw new ProcessingException(e);
                }
            }
            workspaceClient.close();
        }
        return list;
    }

    public void transferJsonToWorkspace(String collectionName, String objectName, JsonNode jsonNode, boolean toDelete, boolean asyncIO) throws ProcessingException {
        String path = collectionName + File.separator + objectName;
        try {
            if (toDelete) {
                InputStream inputStream = JsonHandler.writeToInpustream((Object)jsonNode);
                this.transferInputStreamToWorkspace(path, inputStream, null, asyncIO);
            } else {
                File file = this.getNewLocalFile(path);
                JsonHandler.writeAsFile((Object)jsonNode, (File)file);
                this.transferFileToWorkspace(path, file, toDelete, asyncIO);
            }
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingException("Invalid parse Exception: " + path, (Throwable)e);
        }
    }

    public void unzipInputStreamOnWorkspace(String container, String folderName, String archiveMimeType, InputStream uploadedInputStream, boolean asyncIO) throws ContentAddressableStorageException {
        if (container == null) {
            container = this.containerName;
        }
        LOGGER.debug("Try to push stream to workspace...");
        if (!asyncIO) {
            block12: {
                try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                    if (!workspaceClient.isExistingContainer(container)) {
                        workspaceClient.createContainer(container);
                        workspaceClient.uncompressObject(container, folderName, archiveMimeType, uploadedInputStream);
                        break block12;
                    }
                    LOGGER.error(container + "already exist");
                    throw new ContentAddressableStorageAlreadyExistException(container + "already exist");
                }
            }
            LOGGER.debug(" -> push compressed file to workspace finished");
        } else {
            try {
                this.asyncWorkspaceTransfer.transfer(new WorkspaceQueue(container, uploadedInputStream, WorkspaceAction.UNZIP).setMediaType(archiveMimeType).setFolderName(folderName));
            }
            catch (WorkerspaceQueueException e) {
                new ContentAddressableStorageException((Throwable)e);
            }
        }
    }

    public void enableAsync(boolean async) throws WorkerspaceQueueException {
        if (async) {
            this.asyncWorkspaceTransfer.startTransfer(VitamConfiguration.getAsyncWorkspaceQueueSize());
        } else {
            this.asyncWorkspaceTransfer.waitEndOfTransfer();
        }
    }

    public boolean removeFolder(String folderName) throws ContentAddressableStorageException {
        boolean bl;
        block9: {
            if (!this.isFolderExist(folderName)) {
                return false;
            }
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                workspaceClient.deleteFolder(this.containerName, folderName);
                bl = true;
                if (workspaceClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException exc) {
                    throw new ContentAddressableStorageException(exc);
                }
            }
            workspaceClient.close();
        }
        return bl;
    }

    public void setCurrentObjectId(String currentObjectId) {
        this.currentObjectId = currentObjectId;
    }

    private boolean isFolderExist(String folderName) throws ContentAddressableStorageException {
        boolean bl;
        block8: {
            WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
            try {
                bl = workspaceClient.isExistingFolder(this.containerName, folderName);
                if (workspaceClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ContentAddressableStorageServerException exc) {
                    throw new ContentAddressableStorageException((Throwable)exc);
                }
            }
            workspaceClient.close();
        }
        return bl;
    }

    public WorkspaceClientFactory getWorkspaceClientFactory() {
        return this.workspaceClientFactory;
    }

    public Map<String, Long> getFilesWithParamsFromWorkspace(String containerName, String folderName) throws ProcessingException {
        Map<String, Long> mapResults = new HashMap<String, Long>();
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            RequestResponse filesWithParamsFromFolderRequest = workspaceClient.getFilesWithParamsFromFolder(containerName, folderName);
            if (filesWithParamsFromFolderRequest != null && filesWithParamsFromFolderRequest.isOk()) {
                Map resultMap = (Map)JsonHandler.getFromStringAsTypeReference((String)filesWithParamsFromFolderRequest.toJsonNode().get("$results").get(0).toString(), (TypeReference)new TypeReference<Map<String, FileParams>>(){});
                mapResults = resultMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((FileParams)e.getValue()).getSize()));
            }
        }
        catch (InvalidFormatException | InvalidParseOperationException | ContentAddressableStorageServerException e2) {
            LOGGER.debug("Workspace Server Error", e2);
            throw new ProcessingException(e2);
        }
        return mapResults;
    }
}

