/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.impl;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.processing.common.model.WorkspaceQueue;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.WorkerspaceQueueException;
import fr.gouv.vitam.worker.core.impl.WorkspaceBatchRunner;
import java.util.concurrent.Executor;

public class AsyncWorkspaceTransfer {
    private HandlerIO handlerIO;
    private WorkspaceBatchRunner runner = null;

    public AsyncWorkspaceTransfer(HandlerIO handlerAsyncIO) {
        ParametersChecker.checkParameter((String)"The parameter handlerIO musn't be null", (Object[])new Object[]{handlerAsyncIO});
        this.handlerIO = handlerAsyncIO;
    }

    public void transfer(WorkspaceQueue workspaceQueue) throws WorkerspaceQueueException {
        if (null == this.runner) {
            throw new WorkerspaceQueueException("Workspace batch runner is not started, call startTransfer to start it");
        }
        this.runner.transfer(workspaceQueue);
    }

    public void startTransfer(int queueSize) throws WorkerspaceQueueException {
        if (null == this.runner) {
            if (queueSize < 1) {
                throw new WorkerspaceQueueException("The batch size must be greater than 1");
            }
            VitamThreadPoolExecutor executor = VitamThreadPoolExecutor.getDefaultExecutor();
            this.runner = new WorkspaceBatchRunner(this.handlerIO, (Executor)executor, queueSize);
            this.runner.start();
        }
    }

    public void waitEndOfTransfer() throws WorkerspaceQueueException {
        if (null != this.runner) {
            this.runner.join();
            this.runner = null;
        }
    }
}

