/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveTransferReplyType;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveUnitType;
import fr.gouv.culture.archivesdefrance.seda.v2.CodeListVersionsType;
import fr.gouv.culture.archivesdefrance.seda.v2.CodeType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectGroupType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectPackageType;
import fr.gouv.culture.archivesdefrance.seda.v2.DescriptiveMetadataContentType;
import fr.gouv.culture.archivesdefrance.seda.v2.DescriptiveMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2.EventLogBookOgType;
import fr.gouv.culture.archivesdefrance.seda.v2.EventType;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.LogBookOgType;
import fr.gouv.culture.archivesdefrance.seda.v2.LogBookType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2.ManagementType;
import fr.gouv.culture.archivesdefrance.seda.v2.MinimalDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.ObjectFactory;
import fr.gouv.culture.archivesdefrance.seda.v2.OperationType;
import fr.gouv.culture.archivesdefrance.seda.v2.OrganizationWithIdType;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.collection.CloseableIteratorUtils;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.VitamParameter;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.common.xml.XmlNamespaceUtils;
import fr.gouv.vitam.common.xml.XsdValidator;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleObjectGroupInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookLifeCycleUnitInProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.DataObjectDetail;
import fr.gouv.vitam.worker.common.utils.SedaIngestParams;
import fr.gouv.vitam.worker.common.utils.SedaXsdValidatorProvider;
import fr.gouv.vitam.worker.core.MarshallerObjectCache;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.TransformerException;
import org.bson.Document;
import org.xml.sax.SAXException;

public class TransferNotificationActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransferNotificationActionHandler.class);
    private static final int ATR_RESULT_OUT_RANK = 0;
    private static final int ARCHIVE_UNIT_MAP_RANK = 0;
    private static final int DATAOBJECT_MAP_RANK = 1;
    private static final int BDO_OG_STORED_MAP_RANK = 2;
    private static final int DATAOBJECT_ID_TO_DATAOBJECT_DETAIL_MAP_RANK = 3;
    private static final int SEDA_PARAMETERS_RANK = 4;
    private static final int OBJECT_GROUP_ID_TO_GUID_MAP_RANK = 5;
    private static final int EXISTING_GOT_TO_NEW_GOT_GUID_FOR_ATTACHMENT_RANK = 6;
    private static final int SEDA_INGEST_PARAMS = 7;
    public static final String SEDA_INGEST_PARAMS_FILE = "Maps/sedaParams.json";
    static final int HANDLER_IO_PARAMETER_NUMBER = 8;
    private static final String XML = ".xml";
    private static final String HANDLER_ID = "ATR_NOTIFICATION";
    private static final ObjectFactory objectFactory = new ObjectFactory();
    private static final String EVENT_ID_PROCESS = "evIdProc";
    private static final String TEST_STATUS_PREFIX = "Test ";
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final SedaXsdValidatorProvider sedaXsdValidatorProvider;

    public TransferNotificationActionHandler() {
        this(LogbookOperationsClientFactory.getInstance(), StorageClientFactory.getInstance(), SedaXsdValidatorProvider.getInstance());
    }

    @VisibleForTesting
    TransferNotificationActionHandler(LogbookOperationsClientFactory logbookOperationsClientFactory, StorageClientFactory storageClientFactory, SedaXsdValidatorProvider sedaXsdValidatorProvider) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.sedaXsdValidatorProvider = sedaXsdValidatorProvider;
    }

    public static String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            String vitamDigestString;
            File atrFile;
            String atrObjectName;
            StatusCode workflowStatus;
            block29: {
                workflowStatus = StatusCode.valueOf((String)((String)params.getMapParameters().get(WorkerParameterName.workflowStatusKo)));
                LogbookOperation logbookOperation = this.getLogbookOperation(params);
                atrObjectName = handlerIO.getOutput(0).getPath();
                try (WorkspaceClient workspaceClient = handlerIO.getWorkspaceClientFactory().getClient();){
                    SedaIngestParams sedaIngestParams;
                    boolean atrAlreadyGenerated = workspaceClient.isExistingObject(params.getContainerName(), atrObjectName);
                    if (handlerIO.isExistingFileInWorkspace(SEDA_INGEST_PARAMS_FILE)) {
                        sedaIngestParams = (SedaIngestParams)JsonHandler.getFromFile((File)((File)handlerIO.getInput(7, File.class)), SedaIngestParams.class);
                        if (sedaIngestParams == null) {
                            throw new ProcessingException("Seda ingest params is empty!");
                        }
                    } else {
                        LOGGER.warn("Seda Ingest has not been created!");
                        sedaIngestParams = new SedaIngestParams(SupportedSedaVersions.SEDA_2_2.getVersion(), SupportedSedaVersions.SEDA_2_2.getNamespaceURI());
                    }
                    if (atrAlreadyGenerated) {
                        atrFile = handlerIO.getFileFromWorkspace(atrObjectName);
                        this.checkAtrFile(atrFile, sedaIngestParams);
                        break block29;
                    }
                    atrFile = this.createATR(params, handlerIO, logbookOperation, workflowStatus, sedaIngestParams);
                    try (FileInputStream is = new FileInputStream(atrFile);){
                        workspaceClient.putAtomicObject(handlerIO.getContainerName(), atrObjectName, (InputStream)is, atrFile.length());
                    }
                }
            }
            try (FileInputStream inputStream = new FileInputStream(atrFile);){
                Digest vitamDigest = new Digest(VitamConfiguration.getDefaultDigestType());
                vitamDigestString = vitamDigest.update((InputStream)inputStream).digestHex();
            }
            LOGGER.debug("DEBUG: \n\t" + vitamDigestString);
            String eventDetailData = "{\"FileName\":\"ATR_" + params.getContainerName() + "\", \"MessageDigest\": \"" + vitamDigestString + "\", \"Algorithm\": \"" + VitamConfiguration.getDefaultDigestType() + "\"}";
            itemStatus.setEvDetailData(eventDetailData);
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(params.getContainerName());
            description.setWorkspaceObjectURI(atrObjectName);
            try (StorageClient storageClient = this.storageClientFactory.getClient();){
                storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), DataCategory.REPORT, params.getContainerName() + XML, description);
                if (!workflowStatus.isGreaterOrEqualToKo()) {
                    description.setWorkspaceObjectURI("SIP/manifest.xml");
                    storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), DataCategory.MANIFEST, params.getContainerName() + XML, description);
                }
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (InvalidParseOperationException | ProcessingException | StorageClientException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private void checkAtrFile(File atrFile, SedaIngestParams sedaIngestParams) throws IOException {
        try {
            XsdValidator xsdValidator = this.sedaXsdValidatorProvider.getValidator((SupportedSedaVersions)SupportedSedaVersions.getSupportedSedaVersionByXmlNamespace((String)sedaIngestParams.getNamespaceURI()).orElseThrow());
            xsdValidator.validate(atrFile);
        }
        catch (SAXException e) {
            if (e.getCause() == null) {
                LOGGER.error("ATR File is not valid with the XSD", (Throwable)e);
            }
            LOGGER.error("ATR File is not a correct xml file", (Throwable)e);
        }
    }

    private LogbookOperation getLogbookOperation(WorkerParameters params) throws InvalidParseOperationException, ProcessingException {
        LogbookOperation logbookOperation;
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            Select select = new Select();
            select.setQuery((Query)QueryHelper.eq((String)EVENT_ID_PROCESS, (String)params.getContainerName()));
            JsonNode node = client.selectOperationById(params.getContainerName());
            JsonNode elmt = node.get("$results").get(0);
            if (elmt == null) {
                LOGGER.error("Error while loading logbook operation: no result");
                throw new ProcessingException("Error while loading logbook operation: no result");
            }
            logbookOperation = new LogbookOperation(elmt);
        }
        catch (LogbookClientException e) {
            LOGGER.error("Error while loading logbook operation", (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error("Error while creating DSL query", (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        return logbookOperation;
    }

    private File createATR(WorkerParameters params, HandlerIO handlerIO, LogbookOperation logbookOperation, StatusCode workflowStatus, SedaIngestParams sedaIngestParams) throws ProcessingException, InvalidParseOperationException {
        ParametersChecker.checkNullOrEmptyParameters((VitamParameter)params);
        File atrFile = handlerIO.getNewLocalFile(handlerIO.getOutput(0).getPath());
        try {
            ArchiveTransferReplyType archiveTransferReply = objectFactory.createArchiveTransferReplyType();
            this.addFirstLevelBaseInformations(archiveTransferReply, params, logbookOperation, handlerIO, workflowStatus);
            ArrayList<String> statusToBeChecked = new ArrayList<String>();
            if (workflowStatus.isGreaterOrEqualToKo()) {
                statusToBeChecked.add(StatusCode.FATAL.toString());
                statusToBeChecked.add(StatusCode.KO.toString());
            } else {
                this.checkMandatoryIOParameter(handlerIO);
                statusToBeChecked.add(StatusCode.WARNING.toString());
            }
            if (workflowStatus.isGreaterOrEqualToKo() || StatusCode.WARNING.name().equals(workflowStatus.name())) {
                this.addOperation(archiveTransferReply, logbookOperation, statusToBeChecked);
            }
            this.addDataObjectPackage(handlerIO, archiveTransferReply, params.getContainerName(), statusToBeChecked, workflowStatus);
            MarshallerObjectCache marshallerObjectCache = new MarshallerObjectCache();
            Marshaller archiveTransferReplyMarshaller = marshallerObjectCache.getMarshaller(ArchiveTransferReplyType.class);
            archiveTransferReplyMarshaller.setProperty("jaxb.schemaLocation", (Object)(sedaIngestParams.getNamespaceURI() + " " + sedaIngestParams.getSedaValidatorXSD()));
            File atrWithUnifiedSedaVersion = handlerIO.getNewLocalFile("_atr_unified_seda.xml");
            archiveTransferReplyMarshaller.marshal((Object)archiveTransferReply, atrWithUnifiedSedaVersion);
            SupportedSedaVersions sedaVersion = (SupportedSedaVersions)SupportedSedaVersions.getSupportedSedaVersionByVersion((String)sedaIngestParams.getVersion()).orElseThrow();
            this.transformAtrFile(sedaVersion, atrWithUnifiedSedaVersion, atrFile);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (JAXBException e) {
            String msgErr = "Error on marshalling object archiveTransferReply";
            throw new ProcessingException(msgErr, (Throwable)e);
        }
        catch (TransformerException e) {
            String msgErr = "Error on transforming ATR file!";
            throw new ProcessingException(msgErr, (Throwable)e);
        }
        return atrFile;
    }

    private void transformAtrFile(SupportedSedaVersions sedaVersion, File atrWithUnifiedSedaVersion, File atrFile) throws IOException, TransformerException {
        try (FileInputStream inputStream = new FileInputStream(atrWithUnifiedSedaVersion);
             FileOutputStream outputStream = new FileOutputStream(atrFile);){
            XmlNamespaceUtils.transformXMLNamespace((InputStream)inputStream, (OutputStream)outputStream, (String)"fr:gouv:culture:archivesdefrance:seda:v2", (String)sedaVersion.getNamespaceURI());
        }
    }

    private void addFirstLevelBaseInformations(ArchiveTransferReplyType archiveTransferReply, WorkerParameters params, LogbookOperation logbookOperation, HandlerIO handlerIO, StatusCode workflowStatus) throws InvalidParseOperationException {
        JsonNode evDetDataNode;
        JsonNode sedaParameters;
        JsonNode infoATR = null;
        String messageIdentifier = "";
        if (handlerIO.getInput(4) != null && (infoATR = (sedaParameters = JsonHandler.getFromFile((File)((File)handlerIO.getInput(4)))).get("ArchiveTransfer")) != null && infoATR.get("MessageIdentifier") != null) {
            messageIdentifier = infoATR.get("MessageIdentifier").asText();
        }
        archiveTransferReply.setDate(this.buildXMLGregorianCalendar());
        archiveTransferReply.setMessageIdentifier(params.getContainerName());
        ManagementMetadataType mgmtMetadata = objectFactory.createManagementMetadataType();
        DescriptiveMetadataType descMetaData = objectFactory.createDescriptiveMetadataType();
        DataObjectPackageType dataObjectPackage = objectFactory.createDataObjectPackageType();
        dataObjectPackage.setDescriptiveMetadata(descMetaData);
        dataObjectPackage.setManagementMetadata(mgmtMetadata);
        archiveTransferReply.setDataObjectPackage(dataObjectPackage);
        if (logbookOperation.get((Object)LogbookMongoDbName.eventDetailData.getDbname()) != null && (evDetDataNode = JsonHandler.getFromString((String)logbookOperation.get((Object)LogbookMongoDbName.eventDetailData.getDbname()).toString())).get("ArchivalProfile") != null) {
            String profilId = evDetDataNode.get("ArchivalProfile").asText();
            mgmtMetadata.setArchivalProfile(this.buildIdentifierType(profilId));
        }
        if (infoATR != null) {
            archiveTransferReply.setArchivalAgreement(this.buildIdentifierType(infoATR.get("ArchivalAgreement") != null ? infoATR.get("ArchivalAgreement").textValue() : ""));
        }
        CodeListVersionsType codeListVersions = objectFactory.createCodeListVersionsType();
        archiveTransferReply.setCodeListVersions(codeListVersions);
        if (infoATR != null && infoATR.get("CodeListVersions") != null && infoATR.get("CodeListVersions").get("ReplyCodeListVersion") != null) {
            codeListVersions.setReplyCodeListVersion(this.buildCodeType(infoATR.get("CodeListVersions").get("ReplyCodeListVersion").textValue()));
        } else {
            codeListVersions.setReplyCodeListVersion(this.buildCodeType(""));
        }
        if (infoATR != null && infoATR.get("CodeListVersions") != null && infoATR.get("CodeListVersions").get("MessageDigestAlgorithmCodeListVersion") != null) {
            codeListVersions.setMessageDigestAlgorithmCodeListVersion(this.buildCodeType(infoATR.get("CodeListVersions").get("MessageDigestAlgorithmCodeListVersion").textValue()));
        } else {
            codeListVersions.setMessageDigestAlgorithmCodeListVersion(this.buildCodeType(""));
        }
        if (infoATR != null && infoATR.get("CodeListVersions") != null && infoATR.get("CodeListVersions").get("FileFormatCodeListVersion") != null) {
            codeListVersions.setFileFormatCodeListVersion(this.buildCodeType(infoATR.get("CodeListVersions").get("FileFormatCodeListVersion").textValue()));
        } else {
            codeListVersions.setFileFormatCodeListVersion(this.buildCodeType(""));
        }
        LogbookTypeProcess logbookTypeProcess = params.getLogbookTypeProcess();
        if (LogbookTypeProcess.INGEST_TEST.equals((Object)logbookTypeProcess)) {
            archiveTransferReply.setReplyCode(TEST_STATUS_PREFIX + workflowStatus.name());
        } else {
            archiveTransferReply.setReplyCode(workflowStatus.name());
            archiveTransferReply.setGrantDate(this.buildXMLGregorianCalendar());
        }
        archiveTransferReply.setMessageRequestIdentifier(this.buildIdentifierType(messageIdentifier));
        if (infoATR != null && infoATR.get("ArchivalAgency") != null) {
            archiveTransferReply.setArchivalAgency(this.buildOrganizationWithIdType(infoATR.get("ArchivalAgency").get("Identifier") != null ? infoATR.get("ArchivalAgency").get("Identifier").textValue() : ""));
        }
        if (infoATR != null && infoATR.get("TransferringAgency") != null) {
            archiveTransferReply.setTransferringAgency(this.buildOrganizationWithIdType(infoATR.get("TransferringAgency").get("Identifier") != null ? infoATR.get("TransferringAgency").get("Identifier").textValue() : ""));
        }
    }

    private XMLGregorianCalendar buildXMLGregorianCalendar() {
        try {
            SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(sdfDate.format(new Date()));
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("The implementation of DatatypeFactory is not available or cannot be instantiated", (Throwable)e);
            return null;
        }
    }

    private IdentifierType buildIdentifierType(String value) {
        IdentifierType identifierType = objectFactory.createIdentifierType();
        identifierType.setValue(value);
        return identifierType;
    }

    private CodeType buildCodeType(String value) {
        CodeType codeType = objectFactory.createCodeType();
        codeType.setValue(value);
        return codeType;
    }

    private OrganizationWithIdType buildOrganizationWithIdType(String value) {
        OrganizationWithIdType organizationWithIdType = objectFactory.createOrganizationWithIdType();
        organizationWithIdType.setIdentifier(this.buildIdentifierType(value));
        return organizationWithIdType;
    }

    private CloseableIterator<JsonNode> handlerLogbookLifeCycleUnit(String operationId, LogbookLifeCyclesClient client, LifeCycleStatusCode lifeCycleStatusCode) {
        try {
            Select select = new Select();
            return client.unitLifeCyclesByOperationIterator(operationId, lifeCycleStatusCode, (JsonNode)select.getFinalSelect());
        }
        catch (LogbookClientException e) {
            throw new IllegalStateException(e);
        }
    }

    private void addDataObjectPackage(HandlerIO handlerIO, ArchiveTransferReplyType archiveTransferReply, String containerName, List<String> statusToBeChecked, StatusCode workflowStatus) throws ProcessingException, FileNotFoundException, InvalidParseOperationException {
        block35: {
            try (LogbookLifeCyclesClient client = handlerIO.getLifecyclesClient();){
                block34: {
                    try {
                        Map archiveUnitSystemGuid;
                        FileInputStream archiveUnitMapTmpFile = null;
                        File file = (File)handlerIO.getInput(0);
                        if (file != null) {
                            archiveUnitMapTmpFile = new FileInputStream(file);
                        }
                        HashMap<String, String> systemGuidArchiveUnitId = new HashMap<String, String>();
                        if (archiveUnitMapTmpFile == null || (archiveUnitSystemGuid = JsonHandler.getMapFromInputStream((InputStream)archiveUnitMapTmpFile)) == null) break block34;
                        for (Map.Entry entry : archiveUnitSystemGuid.entrySet()) {
                            systemGuidArchiveUnitId.put(entry.getValue().toString(), (String)entry.getKey());
                        }
                        List auList = archiveTransferReply.getDataObjectPackage().getDescriptiveMetadata().getArchiveUnit();
                        if (workflowStatus.isGreaterOrEqualToKo() || StatusCode.WARNING.name().equals(workflowStatus.name())) {
                            try (CloseableIterator<JsonNode> lifecyclesSpliterator = this.handlerLogbookLifeCycleUnit(containerName, client, LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS);){
                                CloseableIteratorUtils.map(lifecyclesSpliterator, LogbookLifeCycleUnitInProcess::new).forEachRemaining(logbookLifeCycleUnit -> auList.add(this.buildArchiveUnit(statusToBeChecked, (Map<String, String>)systemGuidArchiveUnitId, (LogbookLifeCycleUnitInProcess)logbookLifeCycleUnit)));
                                break block34;
                            }
                        }
                        auList.addAll(this.buildListOfSimpleArchiveUnitWithoutEvents(archiveUnitSystemGuid));
                    }
                    catch (IllegalStateException e) {
                        throw new ProcessingException("Exception when building ArchiveUnitList for ArchiveTransferReply KO", (Throwable)e);
                    }
                }
                HashMap<String, String> objectGroupGuid = new HashMap<String, String>();
                HashMap<String, List<String>> dataObjectsForOG = new HashMap<String, List<String>>();
                File dataObjectMapTmpFile = (File)handlerIO.getInput(1);
                File bdoObjectGroupStoredMapTmpFile = (File)handlerIO.getInput(2);
                File objectGroupSystemGuidTmpFile = (File)handlerIO.getInput(5);
                File dataObjectToDetailDataObjectMapTmpFile = (File)handlerIO.getInput(3);
                File existingGOTGUIDToNewGotGUIDInAttachmentMapTmpFile = (File)handlerIO.getInput(6);
                Map<String, Object> dataObjectSystemGuid = this.getDataObjectSystemGuid(dataObjectMapTmpFile);
                Map<String, Object> bdoObjectGroupSystemGuid = this.getBdoObjectGroupSystemGuid(bdoObjectGroupStoredMapTmpFile);
                try {
                    HashMap<String, String> existingGOTGUIDToNewGotGUIDInAttachment;
                    HashMap<String, DataObjectDetail> dataObjectToDetailDataObject;
                    FileInputStream objectGroupGuidMapFIS;
                    for (Map.Entry<String, Object> entry : bdoObjectGroupSystemGuid.entrySet()) {
                        String idOG = entry.getValue().toString();
                        String string = entry.getKey();
                        if (!dataObjectsForOG.containsKey(idOG)) {
                            ArrayList<String> listObj = new ArrayList<String>();
                            listObj.add(string);
                            dataObjectsForOG.put(idOG, listObj);
                            continue;
                        }
                        ((List)dataObjectsForOG.get(idOG)).add(string);
                    }
                    Map objectGroupSystemGuid = null;
                    if (objectGroupSystemGuidTmpFile != null && (objectGroupSystemGuid = JsonHandler.getMapFromInputStream((InputStream)(objectGroupGuidMapFIS = new FileInputStream(objectGroupSystemGuidTmpFile)))) != null) {
                        for (Map.Entry entry : objectGroupSystemGuid.entrySet()) {
                            String guid = entry.getValue().toString();
                            objectGroupGuid.put(guid, (String)entry.getKey());
                        }
                    }
                    if (dataObjectToDetailDataObjectMapTmpFile != null) {
                        FileInputStream dataObjectToDetailDataObjectMapFIS = new FileInputStream(dataObjectToDetailDataObjectMapTmpFile);
                        dataObjectToDetailDataObject = JsonHandler.getMapFromInputStream((InputStream)dataObjectToDetailDataObjectMapFIS, DataObjectDetail.class);
                    } else {
                        dataObjectToDetailDataObject = new HashMap();
                    }
                    if (existingGOTGUIDToNewGotGUIDInAttachmentMapTmpFile != null) {
                        FileInputStream fileInputStream = new FileInputStream(existingGOTGUIDToNewGotGUIDInAttachmentMapTmpFile);
                        existingGOTGUIDToNewGotGUIDInAttachment = JsonHandler.getMapFromInputStream((InputStream)fileInputStream, String.class);
                    } else {
                        existingGOTGUIDToNewGotGUIDInAttachment = new HashMap();
                    }
                    List list = archiveTransferReply.getDataObjectPackage().getDataObjectGroupOrBinaryDataObjectOrPhysicalDataObject();
                    if (dataObjectSystemGuid == null) break block35;
                    if (workflowStatus.isGreaterOrEqualToKo() || StatusCode.WARNING.name().equals(workflowStatus.name())) {
                        try (CloseableIterator<JsonNode> lifecyclesSpliterator = this.handleLogbookLifeCyclesObjectGroup(containerName, client);){
                            CloseableIteratorUtils.map(lifecyclesSpliterator, LogbookLifeCycleObjectGroupInProcess::new).forEachRemaining(logbookLifeCycleObjectGroup -> dataObjectGroupList.add(this.buildDataObjectGroup(statusToBeChecked, (Map<String, String>)objectGroupGuid, (Map<String, List<String>>)dataObjectsForOG, dataObjectSystemGuid, (Map<String, DataObjectDetail>)dataObjectToDetailDataObject, (Map<String, String>)existingGOTGUIDToNewGotGUIDInAttachment, (LogbookLifeCycleObjectGroupInProcess)logbookLifeCycleObjectGroup)));
                            break block35;
                        }
                    }
                    list.addAll(this.buildListOfSimpleDataObjectGroup(dataObjectsForOG, dataObjectSystemGuid, dataObjectToDetailDataObject, objectGroupSystemGuid, existingGOTGUIDToNewGotGUIDInAttachment));
                }
                catch (InvalidParseOperationException | IllegalArgumentException | IllegalStateException e) {
                    throw new ProcessingException("Exception when building DataObjectGroup for ArchiveTransferReply KO", e);
                }
            }
        }
    }

    private Map<String, Object> getBdoObjectGroupSystemGuid(File bdoObjectGroupStoredMapTmpFile) throws InvalidParseOperationException, ProcessingException {
        Map map;
        if (bdoObjectGroupStoredMapTmpFile == null) {
            return new HashMap<String, Object>();
        }
        FileInputStream bdoObjectGroupStoredMapTmpFIStream = new FileInputStream(bdoObjectGroupStoredMapTmpFile);
        try {
            map = JsonHandler.getMapFromInputStream((InputStream)bdoObjectGroupStoredMapTmpFIStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)bdoObjectGroupStoredMapTmpFIStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        ((InputStream)bdoObjectGroupStoredMapTmpFIStream).close();
        return map;
    }

    private Map<String, Object> getDataObjectSystemGuid(File dataObjectMapTmpFile) throws ProcessingException, InvalidParseOperationException {
        Map map;
        if (dataObjectMapTmpFile == null) {
            return new HashMap<String, Object>();
        }
        FileInputStream binaryDataObjectMapTmpFIS = new FileInputStream(dataObjectMapTmpFile);
        try {
            map = JsonHandler.getMapFromInputStream((InputStream)binaryDataObjectMapTmpFIS);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)binaryDataObjectMapTmpFIS).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        ((InputStream)binaryDataObjectMapTmpFIS).close();
        return map;
    }

    private List<ArchiveUnitType> buildListOfSimpleArchiveUnitWithoutEvents(Map<String, Object> archiveUnitSystemGuid) {
        ArrayList<ArchiveUnitType> archiveUnitTypeList = new ArrayList<ArchiveUnitType>();
        for (Map.Entry<String, Object> entry : archiveUnitSystemGuid.entrySet()) {
            ArchiveUnitType archiveUnit = objectFactory.createArchiveUnitType();
            DescriptiveMetadataContentType descContent = new DescriptiveMetadataContentType();
            archiveUnit.setId(entry.getKey());
            descContent.getSystemId().add(entry.getValue().toString());
            archiveUnit.setContent(descContent);
            archiveUnitTypeList.add(archiveUnit);
        }
        return archiveUnitTypeList;
    }

    private ArchiveUnitType buildArchiveUnit(List<String> statusToBeChecked, Map<String, String> systemGuidArchiveUnitId, LogbookLifeCycleUnitInProcess logbookLifeCycleUnit) {
        List logbookLifeCycleUnitEvents = (List)logbookLifeCycleUnit.get((Object)"events");
        ArchiveUnitType archiveUnit = objectFactory.createArchiveUnitType();
        DescriptiveMetadataContentType descMetadataContent = objectFactory.createDescriptiveMetadataContentType();
        if (!systemGuidArchiveUnitId.isEmpty() && logbookLifeCycleUnit.get((Object)"_id") != null && systemGuidArchiveUnitId.get(logbookLifeCycleUnit.get((Object)"_id").toString()) != null) {
            archiveUnit.setId(systemGuidArchiveUnitId.get(logbookLifeCycleUnit.get((Object)"_id").toString()));
            descMetadataContent.getSystemId().add(logbookLifeCycleUnit.get((Object)"_id").toString());
        }
        archiveUnit.setContent(descMetadataContent);
        ManagementType archiveUnitMgmt = objectFactory.createManagementType();
        if (logbookLifeCycleUnitEvents != null && !logbookLifeCycleUnitEvents.isEmpty()) {
            LogBookType logbook = new LogBookType();
            for (Document document : logbookLifeCycleUnitEvents) {
                EventType eventObject = this.buildEventByContainerType(document, "ArchiveUnit", statusToBeChecked, null);
                if (eventObject == null) continue;
                logbook.getEvent().add(eventObject);
            }
            if (!logbook.getEvent().isEmpty()) {
                archiveUnitMgmt.setLogBook(logbook);
            }
        }
        archiveUnit.setManagement(archiveUnitMgmt);
        return archiveUnit;
    }

    private List<DataObjectGroupType> buildListOfSimpleDataObjectGroup(Map<String, List<String>> dataObjectsForOG, Map<String, Object> dataObjectSystemGuid, Map<String, DataObjectDetail> dataObjectToDetailDataObject, Map<String, Object> objectGroupSystemGuid, Map<String, String> existingGOTGUIDToNewGotGUIDInAttachment) {
        ArrayList<DataObjectGroupType> dataObjectGroupList = new ArrayList<DataObjectGroupType>();
        for (Map.Entry<String, List<String>> dataObjectGroupEntry : dataObjectsForOG.entrySet()) {
            String dataObjectGroupSystemId;
            DataObjectGroupType dataObjectGroup = objectFactory.createDataObjectGroupType();
            String dataObjectGroupId = dataObjectGroupEntry.getKey();
            Object dataObjectGroupSystemIdObject = objectGroupSystemGuid.get(dataObjectGroupId);
            String finalDataObjectGroupSystemId = dataObjectGroupSystemId = dataObjectGroupSystemIdObject.toString();
            dataObjectGroupSystemId = existingGOTGUIDToNewGotGUIDInAttachment.entrySet().stream().filter(key -> ((String)key.getValue()).equals(finalDataObjectGroupSystemId)).map(Map.Entry::getKey).findFirst().orElse(finalDataObjectGroupSystemId);
            dataObjectGroup.setId(dataObjectGroupId);
            for (String dataObjectId : dataObjectGroupEntry.getValue()) {
                DataObjectDetail dataObjectDetail = dataObjectToDetailDataObject.get(dataObjectId);
                Object binaryOrPhysicalDataObject = dataObjectDetail.isPhysical() ? objectFactory.createPhysicalDataObjectType() : objectFactory.createBinaryDataObjectType();
                binaryOrPhysicalDataObject.setId(dataObjectId);
                binaryOrPhysicalDataObject.setDataObjectGroupSystemId(dataObjectGroupSystemId);
                String dataObjectSystemGUID = dataObjectSystemGuid.get(dataObjectId).toString();
                if (dataObjectSystemGUID != null) {
                    binaryOrPhysicalDataObject.setDataObjectSystemId(dataObjectSystemGUID);
                }
                binaryOrPhysicalDataObject.setDataObjectVersion(dataObjectDetail.getVersion());
                dataObjectGroup.getBinaryDataObjectOrPhysicalDataObject().add(binaryOrPhysicalDataObject);
            }
            dataObjectGroupList.add(dataObjectGroup);
        }
        return dataObjectGroupList;
    }

    private DataObjectGroupType buildDataObjectGroup(List<String> statusToBeChecked, Map<String, String> objectGroupGuid, Map<String, List<String>> dataObjectsForOG, Map<String, Object> dataObjectSystemGuid, Map<String, DataObjectDetail> dataObjectToDetailDataObject, Map<String, String> existingGOTGUIDToNewGotGUIDInAttachment, LogbookLifeCycleObjectGroupInProcess logbookLifeCycleObjectGroup) {
        List logbookLifeCycleObjectGroupEvents;
        String ogGUID;
        TreeMap<String, String> dataObjectSystemGUIDToID = new TreeMap<String, String>();
        DataObjectGroupType dataObjectGroup = objectFactory.createDataObjectGroupType();
        String existingObjectGroupSystemGUID = ogGUID = logbookLifeCycleObjectGroup.get((Object)LogbookMongoDbName.objectIdentifier.getDbname()) != null ? logbookLifeCycleObjectGroup.get((Object)LogbookMongoDbName.objectIdentifier.getDbname()).toString() : "";
        if (existingGOTGUIDToNewGotGUIDInAttachment.containsKey(ogGUID)) {
            ogGUID = existingGOTGUIDToNewGotGUIDInAttachment.get(ogGUID);
        }
        String igId = "";
        if (objectGroupGuid.containsKey(ogGUID)) {
            igId = objectGroupGuid.get(ogGUID);
            dataObjectGroup.setId(igId);
        }
        if (dataObjectsForOG.get(igId) != null) {
            for (String idObj : dataObjectsForOG.get(igId)) {
                Object binaryOrPhysicalDataObject = dataObjectToDetailDataObject.get(idObj) != null && dataObjectToDetailDataObject.get(idObj).isPhysical() ? objectFactory.createPhysicalDataObjectType() : objectFactory.createBinaryDataObjectType();
                binaryOrPhysicalDataObject.setId(idObj);
                String dataObjectSystemGUID = dataObjectSystemGuid.get(idObj).toString();
                if (dataObjectSystemGUID != null) {
                    binaryOrPhysicalDataObject.setDataObjectSystemId(dataObjectSystemGUID);
                    dataObjectSystemGUIDToID.put(dataObjectSystemGUID, idObj);
                }
                if (existingObjectGroupSystemGUID != null && !existingObjectGroupSystemGUID.isEmpty()) {
                    binaryOrPhysicalDataObject.setDataObjectGroupSystemId(existingObjectGroupSystemGUID);
                }
                binaryOrPhysicalDataObject.setDataObjectVersion(dataObjectToDetailDataObject.get(idObj) != null ? dataObjectToDetailDataObject.get(idObj).getVersion() : "");
                dataObjectGroup.getBinaryDataObjectOrPhysicalDataObject().add(binaryOrPhysicalDataObject);
            }
        }
        if ((logbookLifeCycleObjectGroupEvents = (List)logbookLifeCycleObjectGroup.get((Object)"events")) != null) {
            dataObjectGroup.setLogBook(new LogBookOgType());
            for (Document eventDoc : logbookLifeCycleObjectGroupEvents) {
                String objectSystemId = eventDoc.get((Object)LogbookMongoDbName.objectIdentifier.getDbname()).toString();
                String objectId = (String)dataObjectSystemGUIDToID.get(objectSystemId);
                Object objectObject = this.findDataObjectById(dataObjectGroup, objectId);
                dataObjectGroup.getLogBook().getEvent().add((EventLogBookOgType)this.buildEventByContainerType(eventDoc, "DataObjectGroup", statusToBeChecked, objectObject));
            }
        }
        return dataObjectGroup;
    }

    private Object findDataObjectById(DataObjectGroupType dataObjectGroup, String objectId) {
        MinimalDataObjectType dataObject = null;
        if (objectId != null) {
            for (MinimalDataObjectType object : dataObjectGroup.getBinaryDataObjectOrPhysicalDataObject()) {
                if (!objectId.equals(object.getId())) continue;
                dataObject = object;
                break;
            }
        }
        return dataObject;
    }

    private void addOperation(ArchiveTransferReplyType archiveTransferReply, LogbookOperation logbookOperation, List<String> statusToBeChecked) {
        List logbookOperationEvents = (List)logbookOperation.get((Object)"events");
        OperationType operation = objectFactory.createOperationType();
        ArrayList<EventType> eventList = new ArrayList<EventType>();
        for (Document event : logbookOperationEvents) {
            eventList.add(this.buildEventByContainerType(event, "Operation", statusToBeChecked, null));
        }
        operation.getEvent().addAll(eventList);
        archiveTransferReply.setOperation(operation);
    }

    private CloseableIterator<JsonNode> handleLogbookLifeCyclesObjectGroup(String containerName, LogbookLifeCyclesClient client) {
        try {
            Select select = new Select();
            return client.objectGroupLifeCyclesByOperationIterator(containerName, LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS, (JsonNode)select.getFinalSelect());
        }
        catch (LogbookClientException e) {
            throw new IllegalStateException(e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
        ArrayList<Class<File>> handlerInitialIOList = new ArrayList<Class<File>>();
        for (int i = 0; i < 8; ++i) {
            handlerInitialIOList.add(File.class);
        }
        if (!handler.checkHandlerIO(1, handlerInitialIOList)) {
            throw new ProcessingException("Input/Output io parameter is not correct");
        }
    }

    private EventType buildEventByContainerType(Document document, String eventType, List<String> statusToBeChecked, Object dataObjectToReference) {
        EventType eventObject = null;
        if (document.get((Object)LogbookMongoDbName.outcome.getDbname()) != null && statusToBeChecked.contains(document.get((Object)LogbookMongoDbName.outcome.getDbname()).toString())) {
            String detailData;
            if ("DataObjectGroup".equals(eventType)) {
                eventObject = new EventLogBookOgType();
                if (dataObjectToReference != null) {
                    ((EventLogBookOgType)eventObject).setDataObjectReferenceId(dataObjectToReference);
                }
            } else {
                eventObject = objectFactory.createEventType();
            }
            if (document.get((Object)LogbookMongoDbName.eventType.getDbname()) != null) {
                eventObject.setEventTypeCode(document.get((Object)LogbookMongoDbName.eventType.getDbname()).toString());
                if ("Operation".equals(eventType)) {
                    eventObject.setEventType(VitamLogbookMessages.getLabelOp((String)document.get((Object)LogbookMongoDbName.eventType.getDbname()).toString()));
                } else if ("ArchiveUnit".equals(eventType) || "DataObjectGroup".equals(eventType)) {
                    eventObject.setEventType(VitamLogbookMessages.getFromFullCodeKey((String)document.get((Object)LogbookMongoDbName.eventType.getDbname()).toString()));
                }
            }
            if (document.get((Object)LogbookMongoDbName.eventDateTime.getDbname()) != null) {
                eventObject.setEventDateTime(document.get((Object)LogbookMongoDbName.eventDateTime.getDbname()).toString());
            }
            if (document.get((Object)LogbookMongoDbName.outcome.getDbname()) != null) {
                eventObject.setOutcome(document.get((Object)LogbookMongoDbName.outcome.getDbname()).toString());
            }
            if (document.get((Object)LogbookMongoDbName.outcomeDetail.getDbname()) != null) {
                eventObject.setOutcomeDetail(document.get((Object)LogbookMongoDbName.outcomeDetail.getDbname()).toString());
            }
            if (document.get((Object)LogbookMongoDbName.outcomeDetailMessage.getDbname()) != null) {
                eventObject.setOutcomeDetailMessage(document.get((Object)LogbookMongoDbName.outcomeDetailMessage.getDbname()).toString());
            }
            if (document.get((Object)LogbookMongoDbName.eventDetailData.getDbname()) != null && (detailData = document.get((Object)LogbookMongoDbName.eventDetailData.getDbname()).toString()).contains("evDetTechData")) {
                eventObject.setEventDetailData(document.get((Object)LogbookMongoDbName.eventDetailData.getDbname()).toString());
            }
        }
        return eventObject;
    }
}

