/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;

public class RollBackActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RollBackActionHandler.class);
    private static final String HANDLER_ID = "ROLL_BACK";

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            this.checkMandatoryIOParameter(handlerIO);
            try {
                try {
                    handlerIO.getLifecyclesClient().rollBackUnitsByOperation(params.getContainerName());
                }
                catch (LogbookClientNotFoundException e) {
                    LOGGER.error((Throwable)e);
                }
                try {
                    handlerIO.getLifecyclesClient().rollBackObjectGroupsByOperation(params.getContainerName());
                }
                catch (LogbookClientNotFoundException e) {
                    LOGGER.error((Throwable)e);
                }
            }
            catch (LogbookClientBadRequestException e) {
                LOGGER.error((Throwable)e);
                throw new ProcessingException((Throwable)e);
            }
            catch (LogbookClientServerException e) {
                LOGGER.error((Throwable)e);
                throw new ProcessingException((Throwable)e);
            }
            itemStatus.increment(StatusCode.OK);
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

