/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ContractsDetailsModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.model.StorageInformation;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class PrepareStorageInfoActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PrepareStorageInfoActionHandler.class);
    private static final String HANDLER_ID = "PREPARE_STORAGE_INFO";
    private static final int STORAGE_INFO_OUT_RANK = 0;
    private static final int REFERENTIAL_INGEST_CONTRACT_IN_RANK = 0;
    private final StorageClientFactory storageClientFactory;

    public PrepareStorageInfoActionHandler() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public PrepareStorageInfoActionHandler(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            this.checkMandatoryIOParameter(handlerIO);
            ManagementContractModel managementContract = this.loadManagementContractFromWorkspace(handlerIO);
            HashMap<String, JsonNode> storageCapacityNodeByStrategyId = new HashMap<String, JsonNode>();
            try (StorageClient storageClient = this.storageClientFactory.getClient();){
                storageCapacityNodeByStrategyId.put(VitamConfiguration.getDefaultStrategy(), storageClient.getStorageInformation(VitamConfiguration.getDefaultStrategy()));
                if (managementContract != null && managementContract.getStorage() != null) {
                    if (managementContract.getStorage().getUnitStrategy() != null && !storageCapacityNodeByStrategyId.containsKey(managementContract.getStorage().getUnitStrategy())) {
                        storageCapacityNodeByStrategyId.put(managementContract.getStorage().getUnitStrategy(), storageClient.getStorageInformation(managementContract.getStorage().getUnitStrategy()));
                    }
                    if (managementContract.getStorage().getObjectGroupStrategy() != null && !storageCapacityNodeByStrategyId.containsKey(managementContract.getStorage().getObjectGroupStrategy())) {
                        storageCapacityNodeByStrategyId.put(managementContract.getStorage().getObjectGroupStrategy(), storageClient.getStorageInformation(managementContract.getStorage().getObjectGroupStrategy()));
                    }
                    if (managementContract.getStorage().getObjectStrategy() != null && !storageCapacityNodeByStrategyId.containsKey(managementContract.getStorage().getObjectStrategy())) {
                        storageCapacityNodeByStrategyId.put(managementContract.getStorage().getObjectStrategy(), storageClient.getStorageInformation(managementContract.getStorage().getObjectStrategy()));
                    }
                }
            }
            ObjectNode strategiesInformation = JsonHandler.createObjectNode();
            for (Map.Entry stategyStorageCapacities : storageCapacityNodeByStrategyId.entrySet()) {
                StorageInformation[] storageInformation = (StorageInformation[])JsonHandler.getFromJsonNode((JsonNode)((JsonNode)stategyStorageCapacities.getValue()).get("capacities"), StorageInformation[].class);
                strategiesInformation.set((String)stategyStorageCapacities.getKey(), this.generateStorageInfoNode((String)stategyStorageCapacities.getKey(), storageInformation));
            }
            this.storeStrategiesStorageInfo(handlerIO, (JsonNode)strategiesInformation);
            itemStatus.increment(StatusCode.OK);
        }
        catch (InvalidParseOperationException | ProcessingException | StorageNotFoundClientException | StorageServerClientException e) {
            LOGGER.error(e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private JsonNode generateStorageInfoNode(String strategyId, StorageInformation[] storageInformation) throws InvalidParseOperationException, ProcessingException {
        ObjectNode storageInfo = JsonHandler.createObjectNode();
        int nbCopies = storageInformation.length > 0 ? storageInformation[0].getNbCopies() : 0;
        storageInfo.put("_nbc", nbCopies);
        ArrayNode offerIds = JsonHandler.createArrayNode();
        for (StorageInformation information : storageInformation) {
            offerIds.add(information.getOfferId());
        }
        storageInfo.set("offerIds", (JsonNode)offerIds);
        storageInfo.put("strategyId", strategyId);
        return storageInfo;
    }

    private void storeStrategiesStorageInfo(HandlerIO handlerIO, JsonNode strategiesInformation) throws InvalidParseOperationException, ProcessingException {
        File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(0).getPath());
        JsonHandler.writeAsFile((Object)strategiesInformation, (File)tempFile);
        handlerIO.addOutputResult(0, (Object)tempFile, true, false);
    }

    private ManagementContractModel loadManagementContractFromWorkspace(HandlerIO handlerIO) throws InvalidParseOperationException {
        ContractsDetailsModel contractsDetailsModel = (ContractsDetailsModel)JsonHandler.getFromFile((File)((File)handlerIO.getInput(0)), ContractsDetailsModel.class);
        return contractsDetailsModel.getManagementContractModel();
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

