/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierPolicy;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierPolicyTypeEnum;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierUsage;
import fr.gouv.vitam.common.model.administration.VersionUsageModel;
import fr.gouv.vitam.common.model.unit.ArchiveUnitRoot;
import fr.gouv.vitam.common.model.unit.PersistentIdentifierModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PersistentIdentifierGenerationService {
    public static final String PERSISTENT_IDENTIFIER_FIELD = "PersistentIdentifier";
    private static final PersistentIdentifierGenerationService PERSISTENT_IDENTIFIER_GENERATION_SERVICE = new PersistentIdentifierGenerationService();

    public static PersistentIdentifierGenerationService getInstance() {
        return PERSISTENT_IDENTIFIER_GENERATION_SERVICE;
    }

    public void handlePersistentIdentifierForGot(Map<String, List<JsonNode>> objectsByQualifierMap, ManagementContractModel managementContractModel, PersistentIdentifierPolicyTypeEnum persistentIdentifierType) throws InvalidParseOperationException {
        if (Objects.isNull(managementContractModel) || ActivationStatus.INACTIVE.equals((Object)managementContractModel.getStatus()) || Objects.isNull(managementContractModel.getPersistentIdentifierPolicyList())) {
            return;
        }
        Optional<PersistentIdentifierPolicy> persistentIdentifierPolicyOpt = this.retrievePolicyByPersistentType(managementContractModel, persistentIdentifierType);
        if (persistentIdentifierPolicyOpt.isEmpty()) {
            return;
        }
        PersistentIdentifierPolicy persistentIdPolicy = persistentIdentifierPolicyOpt.get();
        if (PersistentIdentifierPolicyTypeEnum.ARK.equals((Object)persistentIdPolicy.getPersistentIdentifierPolicyType())) {
            this.manageArkIdentifiersGeneration(objectsByQualifierMap, persistentIdPolicy);
        }
    }

    private void manageArkIdentifiersGeneration(Map<String, List<JsonNode>> objectsByQualifierMap, PersistentIdentifierPolicy persistentIdPolicy) throws InvalidParseOperationException {
        for (PersistentIdentifierUsage usageNode : persistentIdPolicy.getPersistentIdentifierUsages()) {
            List<String> qualifierList = PersistentIdentifierGenerationService.getSortedQualifierList(objectsByQualifierMap, usageNode);
            if (qualifierList.isEmpty()) continue;
            for (String qualifier : qualifierList) {
                boolean hasSingleQualifier;
                List<JsonNode> qualifiersToUpdate = objectsByQualifierMap.get(qualifier);
                int version = Integer.parseInt(StringUtils.substringAfterLast((String)qualifier, (String)"_"));
                boolean isFirstVersion = version == 1;
                boolean concernLastVersionPolicy = VersionUsageModel.IntermediaryVersionEnum.LAST.equals((Object)usageNode.getIntermediaryVersion());
                boolean concernAllVersionsPolicy = VersionUsageModel.IntermediaryVersionEnum.ALL.equals((Object)usageNode.getIntermediaryVersion());
                boolean bl = hasSingleQualifier = qualifierList.size() == 1;
                if ((!isFirstVersion || !usageNode.isInitialVersion() && !concernAllVersionsPolicy && (!concernLastVersionPolicy || !hasSingleQualifier)) && (isFirstVersion || !concernAllVersionsPolicy && (!concernLastVersionPolicy || !this.isLatestVersion(qualifierList, version)))) continue;
                this.fillArkPersistentIdentifier(persistentIdPolicy, qualifiersToUpdate);
            }
        }
    }

    private static List<String> getSortedQualifierList(Map<String, List<JsonNode>> objectsByQualifierMap, PersistentIdentifierUsage usageNode) {
        return objectsByQualifierMap.keySet().stream().filter(key -> key.startsWith(usageNode.getUsageName().getName())).sorted(Comparator.comparingInt(key -> Integer.parseInt(StringUtils.substringAfterLast((String)key, (String)"_")))).collect(Collectors.toList());
    }

    private void fillArkPersistentIdentifier(PersistentIdentifierPolicy persistentIdPolicy, List<JsonNode> qualifiersToUpdate) throws InvalidParseOperationException {
        for (JsonNode qualifierToUpdate : qualifiersToUpdate) {
            this.fillArkPersistentIdentifier(persistentIdPolicy, qualifierToUpdate);
        }
    }

    private boolean isLatestVersion(List<String> qualifierList, Integer version) {
        Integer lastVersion = qualifierList.stream().map(qualifier -> Integer.parseInt(StringUtils.substringAfterLast((String)qualifier, (String)"_"))).max(Integer::compare).orElseThrow();
        return version.equals(lastVersion);
    }

    public void fillArkPersistentIdentifier(PersistentIdentifierPolicy policy, JsonNode qualifierToUpdate) throws InvalidParseOperationException {
        ObjectNode updatingQualifier = (ObjectNode)qualifierToUpdate;
        PersistentIdentifierModel vitamPersistentIdentifierModel = new PersistentIdentifierModel();
        vitamPersistentIdentifierModel.setPersistentIdentifierType(policy.getPersistentIdentifierPolicyType().name().toLowerCase());
        String guid = updatingQualifier.get("_id").asText();
        if (!qualifierToUpdate.has(PERSISTENT_IDENTIFIER_FIELD)) {
            updatingQualifier.set(PERSISTENT_IDENTIFIER_FIELD, (JsonNode)JsonHandler.createArrayNode());
        }
        vitamPersistentIdentifierModel.setPersistentIdentifierReference(policy.getPersistentIdentifierAuthority());
        vitamPersistentIdentifierModel.setPersistentIdentifierContent(PersistentIdentifierPolicyTypeEnum.ARK.name().toLowerCase() + ":/" + policy.getPersistentIdentifierAuthority() + "/" + guid);
        ArrayNode persistentIdentifierNode = (ArrayNode)updatingQualifier.get(PERSISTENT_IDENTIFIER_FIELD);
        persistentIdentifierNode.add(JsonHandler.toJsonNode((Object)vitamPersistentIdentifierModel));
    }

    public void handlePersistentIdentifierForUnit(ArchiveUnitRoot archiveUnitRoot, String unitGUID, ManagementContractModel managementContractModel, PersistentIdentifierPolicyTypeEnum persistentIdentifierType) {
        if (Objects.isNull(managementContractModel) || ActivationStatus.INACTIVE.equals((Object)managementContractModel.getStatus()) || Objects.isNull(managementContractModel.getPersistentIdentifierPolicyList())) {
            return;
        }
        Optional<PersistentIdentifierPolicy> persistentIdentifierPolicy = this.retrievePolicyByPersistentTypeForUnit(managementContractModel, persistentIdentifierType);
        persistentIdentifierPolicy.ifPresent(persistentIdPolicy -> {
            String persistentIdAuthority = persistentIdPolicy.getPersistentIdentifierAuthority();
            PersistentIdentifierPolicyTypeEnum persistentIdPolicyType = persistentIdPolicy.getPersistentIdentifierPolicyType();
            PersistentIdentifierModel vitamPersistentIdentifierModel = new PersistentIdentifierModel();
            vitamPersistentIdentifierModel.setPersistentIdentifierReference(persistentIdAuthority);
            vitamPersistentIdentifierModel.setPersistentIdentifierType(persistentIdPolicyType.name().toLowerCase());
            vitamPersistentIdentifierModel.setPersistentIdentifierContent(persistentIdPolicyType.name().toLowerCase() + ":/" + persistentIdAuthority + "/" + unitGUID);
            if (Objects.isNull(archiveUnitRoot.getArchiveUnit().getDescriptiveMetadataModel().getPersistentIdentifier())) {
                archiveUnitRoot.getArchiveUnit().getDescriptiveMetadataModel().setPersistentIdentifier(new ArrayList());
            }
            archiveUnitRoot.getArchiveUnit().getDescriptiveMetadataModel().getPersistentIdentifier().add(vitamPersistentIdentifierModel);
        });
    }

    private Optional<PersistentIdentifierPolicy> retrievePolicyByPersistentTypeForUnit(ManagementContractModel managementContractModel, PersistentIdentifierPolicyTypeEnum persistentIdentifierPolicyType) {
        return managementContractModel.getPersistentIdentifierPolicyList().stream().filter(policy -> policy.isPersistentIdentifierUnit() && persistentIdentifierPolicyType.equals((Object)policy.getPersistentIdentifierPolicyType())).findFirst();
    }

    private Optional<PersistentIdentifierPolicy> retrievePolicyByPersistentType(ManagementContractModel managementContractModel, PersistentIdentifierPolicyTypeEnum persistentIdentifierPolicyType) {
        return managementContractModel.getPersistentIdentifierPolicyList().stream().filter(policy -> persistentIdentifierPolicyType.equals((Object)policy.getPersistentIdentifierPolicyType())).findFirst();
    }
}

