/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.google.common.collect.Iterables;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyNotFoundException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyReferentOfferException;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyUtils;
import fr.gouv.vitam.worker.core.handler.CheckIngestContractActionHandler;
import java.util.List;

public class ManagmentContractChecker {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ManagmentContractChecker.class);
    private String managementContractId;
    private AdminManagementClientFactory adminManagementClientFactory;
    private StorageClientFactory storageClientFactory;

    public ManagmentContractChecker(String managementContractId, AdminManagementClientFactory adminManagementClientFactory, StorageClientFactory storageClientFactory) {
        this.managementContractId = managementContractId;
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckIngestContractActionHandler.CheckIngestContractStatus check() {
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();
             StorageClient storageClient = this.storageClientFactory.getClient();){
            RequestResponse ManagementContractResponse = adminManagementClient.findManagementContractsByID(this.managementContractId);
            if (!ManagementContractResponse.isOk()) return CheckIngestContractActionHandler.CheckIngestContractStatus.KO;
            List results = ((RequestResponseOK)ManagementContractResponse).getResults();
            if (results.isEmpty()) {
                LOGGER.error("CheckContract : The Management Contract " + this.managementContractId + "  not found in database");
                CheckIngestContractActionHandler.CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractActionHandler.CheckIngestContractStatus.MANAGEMENT_CONTRACT_UNKNOWN;
                return checkIngestContractStatus;
            }
            ManagementContractModel managementContract = (ManagementContractModel)Iterables.getFirst((Iterable)results, null);
            if (!ActivationStatus.ACTIVE.equals((Object)managementContract.getStatus())) {
                LOGGER.error("CheckContract : The Management Contract " + managementContract + "  is not activated");
                CheckIngestContractActionHandler.CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractActionHandler.CheckIngestContractStatus.MANAGEMENT_CONTRACT_INACTIVE;
                return checkIngestContractStatus;
            }
            if (managementContract.getStorage() != null) {
                RequestResponse strategiesResponse = storageClient.getStorageStrategies();
                if (!strategiesResponse.isOk()) {
                    LOGGER.error(strategiesResponse.toString());
                    throw new StorageServerClientException("Exception while retrieving storage strategies");
                }
                List strategies = ((RequestResponseOK)strategiesResponse).getResults();
                try {
                    if (managementContract.getStorage().getObjectGroupStrategy() != null) {
                        StorageStrategyUtils.checkStrategy((String)managementContract.getStorage().getObjectGroupStrategy(), (List)strategies, (String)"Storage.ObjectGroupStrategy", (boolean)true);
                    }
                    if (managementContract.getStorage().getUnitStrategy() != null) {
                        StorageStrategyUtils.checkStrategy((String)managementContract.getStorage().getUnitStrategy(), (List)strategies, (String)"Storage.UnitStrategy", (boolean)true);
                    }
                    if (managementContract.getStorage().getObjectStrategy() != null) {
                        StorageStrategyUtils.checkStrategy((String)managementContract.getStorage().getObjectStrategy(), (List)strategies, (String)"Storage.ObjectStrategy", (boolean)false);
                    }
                }
                catch (StorageStrategyNotFoundException | StorageStrategyReferentOfferException exc) {
                    LOGGER.error(exc);
                    CheckIngestContractActionHandler.CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractActionHandler.CheckIngestContractStatus.MANAGEMENT_CONTRACT_INVALID;
                    if (storageClient != null) {
                        storageClient.close();
                    }
                    if (adminManagementClient == null) return checkIngestContractStatus;
                    adminManagementClient.close();
                    return checkIngestContractStatus;
                }
            }
            CheckIngestContractActionHandler.CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractActionHandler.CheckIngestContractStatus.OK;
            return checkIngestContractStatus;
        }
        catch (ReferentialNotFoundException e) {
            LOGGER.error("Management Contract not found :", (Throwable)e);
            return CheckIngestContractActionHandler.CheckIngestContractStatus.MANAGEMENT_CONTRACT_UNKNOWN;
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException | StorageServerClientException e) {
            LOGGER.error("Fatal check error :", e);
            return CheckIngestContractActionHandler.CheckIngestContractStatus.FATAL;
        }
    }
}

