/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ListRunningIngestsActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ListRunningIngestsActionHandler.class);
    private static final String HANDLER_ID = "LIST_RUNNING_INGESTS";
    private static final int RANK_FILE = 0;
    private final ProcessingManagementClientFactory processingManagementClientFactory;

    public ListRunningIngestsActionHandler() {
        this(ProcessingManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    public ListRunningIngestsActionHandler(ProcessingManagementClientFactory processingManagementClientFactory) {
        this.processingManagementClientFactory = processingManagementClientFactory;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            this.listRunningIngests(handler);
            itemStatus.increment(StatusCode.OK);
        }
        catch (ProcessingException e) {
            LOGGER.error("Processing exception", (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot parse json", (Throwable)e);
            itemStatus.increment(StatusCode.KO);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private void listRunningIngests(HandlerIO handlerIO) throws ProcessingException, InvalidParseOperationException {
        ProcessQuery pq = new ProcessQuery();
        ArrayList<String> listStates = new ArrayList<String>();
        listStates.add(ProcessState.RUNNING.name());
        listStates.add(ProcessState.PAUSE.name());
        pq.setStates(listStates);
        ArrayList<String> listProcessTypes = new ArrayList<String>();
        listProcessTypes.add(LogbookTypeProcess.INGEST.toString());
        listProcessTypes.add(LogbookTypeProcess.HOLDINGSCHEME.toString());
        listProcessTypes.add(LogbookTypeProcess.FILINGSCHEME.toString());
        pq.setListProcessTypes(listProcessTypes);
        try (ProcessingManagementClient processManagementClient = this.processingManagementClientFactory.getClient();){
            RequestResponseOK response = (RequestResponseOK)processManagementClient.listOperationsDetails(pq);
            List ingestsInProcess = response.getResults();
            File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(0).getPath());
            JsonHandler.writeAsFile((Object)ingestsInProcess, (File)tempFile);
            handlerIO.addOutputResult(0, (Object)tempFile, true, false);
        }
        catch (VitamClientException e) {
            LOGGER.error("Process Management cannot be called", (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static final String getId() {
        return HANDLER_ID;
    }
}

