/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.ExistsQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.FileRulesModel;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;

public class ListArchiveUnitsActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ListArchiveUnitsActionHandler.class);
    private static final String HANDLER_ID = "LIST_ARCHIVE_UNITS";
    private static final String JSON = ".json";
    private static final int AU_TO_BE_UPDATED_RANK = 0;
    private final MetaDataClientFactory metaDataClientFactory;

    public ListArchiveUnitsActionHandler() {
        this(MetaDataClientFactory.getInstance());
    }

    public ListArchiveUnitsActionHandler(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            HashMap<String, List<FileRulesModel>> archiveUnitGuidAndRulesToBeUpdated = new HashMap<String, List<FileRulesModel>>();
            ArrayList<String> archiveUnitsToBeUpdated = new ArrayList<String>();
            this.selectListOfArchiveUnitsForUpdate(handler, archiveUnitGuidAndRulesToBeUpdated, archiveUnitsToBeUpdated);
            this.exportToWorkspace(handler, archiveUnitGuidAndRulesToBeUpdated, archiveUnitsToBeUpdated);
            itemStatus.increment(StatusCode.OK);
        }
        catch (ProcessingException e) {
            LOGGER.error("Fatal : ", (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private void selectListOfArchiveUnitsForUpdate(HandlerIO handlerIO, Map<String, List<FileRulesModel>> archiveUnitGuidAndRulesToBeUpdated, List<String> archiveUnitsToBeUpdated) throws ProcessingException {
        InputStream input = null;
        try {
            input = handlerIO.getInputStreamFromWorkspace("PROCESSING/updatedRules.json");
            JsonNode rulesUpdated = JsonHandler.getFromInputStream((InputStream)input);
            if (rulesUpdated.isArray() && rulesUpdated.size() > 0) {
                for (JsonNode objNode : rulesUpdated) {
                    this.searchForInvolvedArchiveUnit((FileRulesModel)JsonHandler.getFromJsonNode((JsonNode)objNode, FileRulesModel.class), archiveUnitGuidAndRulesToBeUpdated, archiveUnitsToBeUpdated);
                }
            }
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error("Workspace error: Cannot get file", e);
            throw new ProcessingException(e);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Cannot parse json", (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error("Metadata error: Cannot request Metadata", (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        finally {
            StreamUtils.closeSilently((InputStream)input);
        }
    }

    private void searchForInvolvedArchiveUnit(FileRulesModel fileRule, Map<String, List<FileRulesModel>> archiveUnitGuidAndRulesToBeUpdated, List<String> archiveUnitsToBeUpdated) throws InvalidCreateOperationException {
        SelectMultiQuery selectMultiple = new SelectMultiQuery();
        StringBuffer sb = new StringBuffer();
        sb.append("#management.").append(fileRule.getRuleType()).append(".Rules").append(".Rule");
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            ObjectNode projectionNode = JsonHandler.createObjectNode();
            ObjectNode objectNode = JsonHandler.createObjectNode();
            objectNode.put("#id", 1);
            projectionNode.set("$fields", (JsonNode)objectNode);
            ArrayNode arrayNode = JsonHandler.createArrayNode();
            CompareQuery ruleQuery = QueryHelper.eq((String)sb.toString(), (String)fileRule.getRuleId());
            StringBuffer sbexists = new StringBuffer();
            sbexists.append("#management.").append(fileRule.getRuleType()).append(".Rules").append(".StartDate");
            ExistsQuery existsQuery = QueryHelper.exists((String)sbexists.toString());
            selectMultiple.setQuery(QueryHelper.and().add(new Query[]{ruleQuery, existsQuery}).setDepthLimit(0));
            selectMultiple.addRoots(arrayNode);
            selectMultiple.addProjection((JsonNode)projectionNode);
            LOGGER.debug("Selected Query For linked unit: " + selectMultiple.getFinalSelect().toString());
            ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(metaDataClient, selectMultiple);
            StreamSupport.stream(scrollRequest, false).forEach(item -> {
                String auGuid = item.get("#id").asText();
                if (!archiveUnitsToBeUpdated.contains(auGuid)) {
                    archiveUnitsToBeUpdated.add(auGuid);
                }
                if (archiveUnitGuidAndRulesToBeUpdated.get(auGuid) == null) {
                    ArrayList<FileRulesModel> rulesList = new ArrayList<FileRulesModel>();
                    rulesList.add(fileRule);
                    archiveUnitGuidAndRulesToBeUpdated.put(auGuid, rulesList);
                } else {
                    List rulesList = (List)archiveUnitGuidAndRulesToBeUpdated.get(auGuid);
                    rulesList.add(fileRule);
                    archiveUnitGuidAndRulesToBeUpdated.put(auGuid, rulesList);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToWorkspace(HandlerIO handlerIO, Map<String, List<FileRulesModel>> archiveUnitGuidAndRulesToBeUpdated, List<String> archiveUnitsToBeUpdated) throws ProcessingException {
        String distribFileName = handlerIO.getOutput(0).getPath();
        File distribFile = handlerIO.getNewLocalFile(distribFileName);
        try (JsonLineWriter jsonLineWriter = new JsonLineWriter((OutputStream)new FileOutputStream(distribFile));){
            ArrayNode guidArrayNode = JsonHandler.createArrayNode();
            for (String guid : archiveUnitsToBeUpdated) {
                guidArrayNode.add(guid);
                jsonLineWriter.addEntry(new JsonLineModel(guid));
            }
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        handlerIO.addOutputResult(0, (Object)distribFile, true, false);
        try {
            for (String key : archiveUnitGuidAndRulesToBeUpdated.keySet()) {
                File archiveUnitTempFile = handlerIO.getNewLocalFile("UnitsWithoutLevel/" + key + JSON);
                ArrayNode rulesArrayNode = JsonHandler.createArrayNode();
                List<FileRulesModel> rules = archiveUnitGuidAndRulesToBeUpdated.get(key);
                for (FileRulesModel rule : rules) {
                    rulesArrayNode.add(JsonHandler.toJsonNode((Object)rule));
                }
                JsonHandler.writeAsFile((Object)rulesArrayNode, (File)archiveUnitTempFile);
                try {
                    handlerIO.transferFileToWorkspace("UnitsWithoutLevel/" + key + JSON, archiveUnitTempFile, true, false);
                }
                finally {
                    if (archiveUnitTempFile.delete()) continue;
                    LOGGER.warn("File couldnt be deleted");
                }
            }
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error("Metadata error: Cannot request Metadata", (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static final String getId() {
        return HANDLER_ID;
    }
}

