/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.ingest.CheckSanityItem;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.Arrays;

public class IngestPrepareActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestPrepareActionHandler.class);
    private static final String IGNORED = "IGNORED";

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        LOGGER.debug("Start IngestPrepareActionHandler");
        try {
            String ingestParam = (String)handler.getInput(0, String.class);
            if (Arrays.stream(CheckSanityItem.values()).noneMatch(elmt -> elmt.getItemParam().equals(ingestParam))) {
                throw new IllegalStateException(String.format("The param %d is not recognized", ingestParam));
            }
            JsonNode externalJsonResults = handler.getJsonFromWorkspace("sanityCheckResult.json");
            ItemStatus result = (ItemStatus)JsonHandler.getFromJsonNode((JsonNode)externalJsonResults.get(ingestParam), ItemStatus.class);
            if (result.getItemId().equals(CheckSanityItem.CHECK_DIGEST_MANIFEST.getItemValue()) && !result.getGlobalStatus().isGreaterOrEqualToKo()) {
                return new ItemStatus(IGNORED).increment(StatusCode.UNKNOWN);
            }
            return new ItemStatus(result.getItemId()).setItemsStatus(result.getItemId(), result);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingException("An exception occured in IngestPrepareActionHandler :" + e.getMessage(), (Throwable)e);
        }
    }
}

