/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.AbstractAccessionRegisterAction;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class IngestAccessionRegisterActionHandler
extends AbstractAccessionRegisterAction {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestAccessionRegisterActionHandler.class);
    private static final String HANDLER_ID = "ACCESSION_REGISTRATION";
    private static final int SEDA_PARAMETERS_RANK = 0;

    public IngestAccessionRegisterActionHandler() {
        this(MetaDataClientFactory.getInstance(), AdminManagementClientFactory.getInstance());
    }

    IngestAccessionRegisterActionHandler(MetaDataClientFactory metaDataClientFactory, AdminManagementClientFactory adminManagementClientFactory) {
        super(metaDataClientFactory, adminManagementClientFactory);
    }

    @Override
    public ItemStatus execute(WorkerParameters params, HandlerIO handler) {
        LOGGER.debug("AbstractAccessionRegisterAction running ...");
        return super.execute(params, handler);
    }

    @Override
    protected void prepareAccessionRegisterInformation(WorkerParameters params, HandlerIO handler, AbstractAccessionRegisterAction.AccessionRegisterInfo accessionRegisterInfo) throws ProcessingException, InvalidParseOperationException {
        JsonNode comment;
        JsonNode messageIdentifier;
        JsonNode sedaParameters;
        this.checkMandatoryIOParameter(handler);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Params: " + params);
        }
        if ((sedaParameters = JsonHandler.getFromFile((File)((File)handler.getInput(0))).get("ArchiveTransfer")) == null) {
            throw new ProcessingException("No ArchiveTransfer found");
        }
        JsonNode dataObjectNode = sedaParameters.get("DataObjectPackage");
        if (dataObjectNode != null) {
            JsonNode nodeArchivalProfile;
            JsonNode nodeLegalStatus;
            JsonNode nodeOrigin;
            JsonNode nodeSubmission = dataObjectNode.get("SubmissionAgencyIdentifier");
            if (nodeSubmission != null && !Strings.isNullOrEmpty((String)nodeSubmission.asText())) {
                accessionRegisterInfo.setSubmissionAgency(nodeSubmission.asText());
            }
            if ((nodeOrigin = dataObjectNode.get("OriginatingAgencyIdentifier")) == null || Strings.isNullOrEmpty((String)nodeOrigin.asText())) {
                throw new ProcessingException("No OriginatingAgencyIdentifier found");
            }
            accessionRegisterInfo.setOriginatingAgency(nodeOrigin.asText());
            JsonNode nodeAcquisitionInformation = dataObjectNode.get("AcquisitionInformation");
            if (nodeAcquisitionInformation != null && !Strings.isNullOrEmpty((String)nodeAcquisitionInformation.asText())) {
                accessionRegisterInfo.setAcquisitionInformation(nodeAcquisitionInformation.asText());
            }
            if ((nodeLegalStatus = dataObjectNode.get("LegalStatus")) != null && !Strings.isNullOrEmpty((String)nodeLegalStatus.asText())) {
                accessionRegisterInfo.setLegalStatus(nodeLegalStatus.asText());
            }
            if ((nodeArchivalProfile = dataObjectNode.get("ArchivalProfile")) != null && !Strings.isNullOrEmpty((String)nodeArchivalProfile.asText())) {
                accessionRegisterInfo.setArchivalProfile(nodeArchivalProfile.asText());
            }
        } else {
            throw new ProcessingException("No DataObjectPackage found");
        }
        JsonNode archivalArchivalAgreement = sedaParameters.get("ArchivalAgreement");
        if (archivalArchivalAgreement != null && !Strings.isNullOrEmpty((String)archivalArchivalAgreement.asText())) {
            accessionRegisterInfo.setArchivalAgreement(archivalArchivalAgreement.asText());
        }
        if ((messageIdentifier = sedaParameters.get("MessageIdentifier")) != null && !Strings.isNullOrEmpty((String)messageIdentifier.asText())) {
            accessionRegisterInfo.setMessageIdentifier(messageIdentifier.asText());
        }
        if (!((comment = sedaParameters.get("Comment")) instanceof NullNode) && comment != null) {
            ArrayList<String> resultedComments = new ArrayList<String>();
            if (comment instanceof ArrayNode) {
                resultedComments.addAll((Collection)JsonHandler.getFromJsonNode((JsonNode)comment, (TypeReference)new TypeReference<Collection<? extends String>>(){}));
            } else if (!Strings.isNullOrEmpty((String)comment.asText())) {
                resultedComments.add(comment.asText());
            }
            accessionRegisterInfo.setComment(resultedComments);
        }
    }

    @Override
    protected String getHandlerId() {
        return HANDLER_ID;
    }

    @Override
    protected LogbookTypeProcess getOperationType() {
        return LogbookTypeProcess.INGEST;
    }

    public static String getId() {
        return HANDLER_ID;
    }
}

