/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.HandlerIO;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class HandlerUtils {
    private HandlerUtils() {
    }

    public static void save(HandlerIO handlerIO, Object object, int rank) throws IOException, ProcessingException {
        String tmpFilePath = handlerIO.getOutput(rank).getPath();
        File firstMapTmpFile = handlerIO.getNewLocalFile(tmpFilePath);
        try {
            JsonHandler.writeAsFile((Object)object, (File)firstMapTmpFile);
        }
        catch (InvalidParseOperationException e) {
            throw new IOException(e);
        }
        handlerIO.addOutputResult(rank, (Object)firstMapTmpFile, true, false);
    }

    public static void save(HandlerIO handlerIO, Object object, String workspacePath) throws IOException, ProcessingException {
        File firstMapTmpFile = handlerIO.getNewLocalFile(workspacePath);
        try {
            JsonHandler.writeAsFile((Object)object, (File)firstMapTmpFile);
        }
        catch (InvalidParseOperationException e) {
            throw new IOException(e);
        }
        handlerIO.transferFileToWorkspace(workspacePath, firstMapTmpFile, true, false);
    }

    public static void saveMap(HandlerIO handlerIO, Map<String, ?> map, int rank, boolean removeTmpFile, boolean asyncIO) throws IOException, ProcessingException {
        String tmpFilePath = handlerIO.getOutput(rank).getPath();
        File firstMapTmpFile = handlerIO.getNewLocalFile(tmpFilePath);
        try {
            JsonHandler.writeAsFile(map, (File)firstMapTmpFile);
        }
        catch (InvalidParseOperationException e) {
            throw new IOException(e);
        }
        handlerIO.addOutputResult(rank, (Object)firstMapTmpFile, removeTmpFile, asyncIO);
    }

    public static void saveSet(HandlerIO handlerIO, Set<?> set, int rank, boolean removeTmpFile, boolean asyncIO) throws IOException, ProcessingException {
        String tmpFilePath = handlerIO.getOutput(rank).getPath();
        File firstMapTmpFile = handlerIO.getNewLocalFile(tmpFilePath);
        try {
            JsonHandler.writeAsFile(set, (File)firstMapTmpFile);
        }
        catch (InvalidParseOperationException e) {
            throw new IOException(e);
        }
        handlerIO.addOutputResult(rank, (Object)firstMapTmpFile, removeTmpFile, asyncIO);
    }
}

