/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import de.odysseus.staxon.json.JsonXMLConfig;
import de.odysseus.staxon.json.JsonXMLConfigBuilder;
import de.odysseus.staxon.json.JsonXMLOutputFactory;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveUnitType;
import fr.gouv.culture.archivesdefrance.seda.v2.BinaryDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectGroupType;
import fr.gouv.culture.archivesdefrance.seda.v2.DataObjectOrArchiveUnitReferenceType;
import fr.gouv.culture.archivesdefrance.seda.v2.PhysicalDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2.RelatedObjectReferenceType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.SedaConstants;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.query.QueryParserHelper;
import fr.gouv.vitam.common.exception.CycleFoundException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.graph.DirectedCycle;
import fr.gouv.vitam.common.graph.DirectedGraph;
import fr.gouv.vitam.common.graph.Graph;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.QueryProjection;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.ContractsDetailsModel;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.administration.IngestContractCheckState;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.PersistentIdentifierPolicyTypeEnum;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.unit.ManagementModel;
import fr.gouv.vitam.common.model.unit.RuleCategoryModel;
import fr.gouv.vitam.common.model.unit.RuleModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import fr.gouv.vitam.common.xml.XmlNamespaceUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleObjectGroupModel;
import fr.gouv.vitam.logbook.common.model.LogbookLifeCycleUnitModel;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCyclesClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ArchiveUnitContainDataObjectException;
import fr.gouv.vitam.processing.common.exception.ExceptionType;
import fr.gouv.vitam.processing.common.exception.MetaDataContainSpecialCharactersException;
import fr.gouv.vitam.processing.common.exception.MissingFieldException;
import fr.gouv.vitam.processing.common.exception.MissingMandatoryVersionException;
import fr.gouv.vitam.processing.common.exception.ProcessingAttachmentRequiredException;
import fr.gouv.vitam.processing.common.exception.ProcessingAttachmentUnauthorizedException;
import fr.gouv.vitam.processing.common.exception.ProcessingDuplicatedVersionException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.exception.ProcessingMalformedDataException;
import fr.gouv.vitam.processing.common.exception.ProcessingManifestReferenceException;
import fr.gouv.vitam.processing.common.exception.ProcessingNotFoundException;
import fr.gouv.vitam.processing.common.exception.ProcessingNotValidLinkingException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectGroupEveryDataObjectVersionException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectGroupLifeCycleException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectGroupLinkingException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectGroupMasterMandatoryException;
import fr.gouv.vitam.processing.common.exception.ProcessingObjectReferenceException;
import fr.gouv.vitam.processing.common.exception.ProcessingTooManyUnitsFoundException;
import fr.gouv.vitam.processing.common.exception.ProcessingUnitLinkingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import fr.gouv.vitam.worker.common.utils.SedaUtilsFactory;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.exception.WorkerspaceQueueException;
import fr.gouv.vitam.worker.core.extractseda.ExtractMetadataListener;
import fr.gouv.vitam.worker.core.extractseda.IngestContext;
import fr.gouv.vitam.worker.core.extractseda.IngestSession;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.HandlerUtils;
import fr.gouv.vitam.worker.core.handler.PersistentIdentifierGenerationService;
import fr.gouv.vitam.worker.core.utils.JsonLineDataBase;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtractSedaActionHandler
extends ActionHandler {
    public static final int OG_ID_TO_UNID_ID_IO_RANK = 4;
    public static final int OG_ID_TO_GUID_IO_MEMORY_RANK = 8;
    public static final String SUBTASK_ERROR_PARSE_ATTACHMENT = "ERROR_PARSE_ATTACHMENT";
    public static final String SUBTASK_EMPTY_KEY_ATTACHMENT = "EMPTY_KEY_ATTACHMENT";
    public static final String SUBTASK_NULL_LINK_PARENT_ID_ATTACHMENT = "NULL_LINK_PARENT_ID_ATTACHMENT";
    public static final String SUBTASK_TOO_MANY_FOUND_ATTACHMENT = "TOO_MANY_FOUND_ATTACHMENT";
    public static final String EXPECTED_MANDATORY_VERSION_1 = "EXPECTED_MANDATORY_VERSION_1";
    public static final String SUBTASK_NOT_FOUND_ATTACHMENT = "NOT_FOUND_ATTACHMENT";
    public static final String SUBTASK_ATTACHMENT_REQUIRED = "ATTACHMENT_REQUIRED";
    public static final String SUBTASK_UNAUTHORIZED_ATTACHMENT = "UNAUTHORIZED_ATTACHMENT";
    public static final String SUBTASK_UNAUTHORIZED_ATTACHMENT_BY_CONTRACT = "UNAUTHORIZED_ATTACHMENT_BY_CONTRACT";
    public static final String SUBTASK_UNAUTHORIZED_ATTACHMENT_BY_BAD_SP = "SUBTASK_UNAUTHORIZED_ATTACHMENT_BY_BAD_SP";
    public static final String SUBTASK_INVALID_GUID_ATTACHMENT = "INVALID_GUID_ATTACHMENT";
    public static final String SUBTASK_MODIFY_PARENT_EXISTING_UNIT_UNAUTHORIZED = "MODIFY_PARENT_EXISTING_UNIT_UNAUTHORIZED";
    public static final String MANAGEMENT_CONTRACT_ID_FIELD = "_managementContractId";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ExtractSedaActionHandler.class);
    private static final TypeReference<List<LogbookEvent>> LIST_TYPE_REFERENCE = new TypeReference<List<LogbookEvent>>(){};
    private static final PerformanceLogger PERFORMANCE_LOGGER = PerformanceLogger.getInstance();
    private static final int GRAPH_WITH_LONGEST_PATH_IO_RANK = 0;
    private static final int DO_ID_TO_OG_ID_IO_RANK = 1;
    private static final int DO_ID_TO_GUID_IO_RANK = 2;
    private static final int OG_ID_TO_GUID_IO_RANK = 3;
    private static final int BDO_ID_TO_VERSION_DO_IO_RANK = 5;
    private static final int UNIT_ID_TO_GUID_IO_RANK = 6;
    private static final int GLOBAL_SEDA_PARAMETERS_FILE_IO_RANK = 7;
    private static final int EXISTING_GOT_RANK = 9;
    private static final int GUID_TO_UNIT_ID_IO_RANK = 10;
    private static final int HANDLER_IO_OUT_PARAMETER_NUMBER = 15;
    private static final int ONTOLOGY_IO_RANK = 11;
    private static final int EXISTING_GOT_TO_NEW_GOT_GUID_FOR_ATTACHMENT_RANK = 12;
    private static final int EXISTING_UNITS_GUID_FOR_ATTACHMENT_RANK = 13;
    private static final int EXISTING_GOTS_GUID_FOR_ATTACHMENT_RANK = 14;
    private static final int UNIT_TYPE_INPUT_RANK = 1;
    private static final int STORAGE_INFO_INPUT_RANK = 2;
    private static final int CONTRACTS_INPUT_RANK = 3;
    private static final String HANDLER_ID = "CHECK_MANIFEST";
    private static final String SUBTASK_LOOP = "CHECK_MANIFEST_LOOP";
    private static final String SUBTASK_MALFORMED = "CHECK_MANIFEST_MALFORMED_DATA";
    private static final String AU_REFRENCES_MULTIPLE_GOT = "ARCHIVEUNIT_REFERENCES_MULTIPLE_OBJECTGROUP";
    private static final String EXISTING_OG_NOT_DECLARED = "EXISTING_OG_NOT_DECLARED";
    private static final String MASTER_MANDATORY_REQUIRED = "MASTER_MANDATORY_REQUIRED";
    private static final String ATTACHMENT_OBJECTGROUP = "ATTACHMENT_OBJECTGROUP";
    private static final String LFC_INITIAL_CREATION_EVENT_TYPE = "LFC_CREATION";
    private static final String LFC_CREATION_SUB_TASK_ID = "LFC_CREATION";
    private static final String ATTACHMENT_IDS = "_up";
    private static final String OBJECT_GROUP_ID = "_og";
    private static final String TRANSFER_AGENCY = "TransferringAgency";
    private static final String ARCHIVAL_AGENCY = "ArchivalAgency";
    private static final int BATCH_SIZE = 50;
    private static final String RULES = "Rules";
    private static final int MAX_ELASTIC_REQUEST_SIZE = 1000;
    private static final String ORIGIN_ANGENCY_NAME = "originatingAgency";
    private static final String ORIGIN_ANGENCY_SUBMISSION = "submissionAgency";
    private static final String ARCHIVAl_AGREEMENT = "ArchivalAgreement";
    private static final String ARCHIVAl_PROFIL = "ArchivalProfile";
    private static final String EV_DETAIL_REQ = "EvDetailReq";
    private static final String JSON_EXTENSION = ".json";
    private static final String DATA_OBJECT_GROUP = "DataObjectGroup";
    private static final String BINARY_DATA_OBJECT = "BinaryDataObject";
    private static final String PHYSICAL_DATA_OBJECT = "PhysicalDataObject";
    private static final String ARCHIVE_UNIT = "ArchiveUnit";
    private static final String BINARY_MASTER = "BinaryMaster";
    private static final String BINARY_MASTER_1 = "BinaryMaster_1";
    private static final String PHYSICAL_MASTER = "PhysicalMaster";
    private static final String DATAOBJECT_PACKAGE = "DataObjectPackage";
    private static final String FILE_INFO = "FileInfo";
    private static final String METADATA = "Metadata";
    private static final String LOGBOOK_LF_BAD_REQUEST_EXCEPTION_MSG = "LogbookClient Unsupported request";
    private static final String LOGBOOK_LF_OBJECT_EXISTS_EXCEPTION_MSG = "LifeCycle Object already exists";
    private static final String LOGBOOK_LF_RESOURCE_NOT_FOUND_EXCEPTION_MSG = "Logbook LifeCycle resource not found";
    private static final String LOGBOOK_SERVER_INTERNAL_EXCEPTION_MSG = "Logbook Server internal error";
    private static final String DATA_OBJECT_VERSION_MUST_BE_UNIQUE = "ERROR: DataObject version must be unique";
    private static final String LEVEL = "level_";
    private static final String GRAPH_CYCLE_MSG = "The Archive Unit graph in the SEDA file has a cycle";
    private static final String CYCLE_FOUND_EXCEPTION = "Seda has an archive unit cycle ";
    private static final String SAVE_ARCHIVE_ID_TO_GUID_IOEXCEPTION_MSG = "Can not save unitToGuidMap to temporary file";
    private static final String CANNOT_READ_SEDA = "Can not read SEDA";
    private static final String MANIFEST_NOT_FOUND = "Manifest.xml Not Found";
    private static final String MISSING_STORAGE_INFO = "Missing one or more storage infos";
    private static final String GLOBAL_MGT_RULE_TAG = "GLOBAL_MGT_RULE";
    private static final List<Class<?>> HANDLER_INPUT_IO_LIST = Arrays.asList(String.class, String.class, File.class, File.class);
    private static final String namespaceURI = "fr:gouv:culture:archivesdefrance:seda:v2";
    private static final boolean asyncIO = true;
    private static JAXBContext jaxbContext;
    private final MetaDataClientFactory metaDataClientFactory;
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final SedaUtilsFactory sedaUtilsFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final PersistentIdentifierGenerationService persistentIdentifierGenerationService;

    public ExtractSedaActionHandler() {
        this(MetaDataClientFactory.getInstance(), AdminManagementClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance());
    }

    @VisibleForTesting
    ExtractSedaActionHandler(MetaDataClientFactory metaDataClientFactory, AdminManagementClientFactory adminManagementClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.sedaUtilsFactory = SedaUtilsFactory.getInstance();
        this.persistentIdentifierGenerationService = PersistentIdentifierGenerationService.getInstance();
    }

    public static String getId() {
        return HANDLER_ID;
    }

    private static ObjectNode buildRightsStatementIdentifier(IngestContext ingestContext) {
        String archivalProfile;
        ObjectNode rightsStatementIdentifier = JsonHandler.createObjectNode();
        IngestContractModel ingestContract = ingestContext.getIngestContract();
        if (ingestContract != null) {
            LOGGER.debug("contract name  is: " + ingestContract.getIdentifier());
            rightsStatementIdentifier.put(ARCHIVAl_AGREEMENT, ingestContract.getIdentifier());
        }
        if ((archivalProfile = ingestContext.getArchivalProfile()) != null) {
            LOGGER.debug("archivalProfile  is: " + archivalProfile);
            rightsStatementIdentifier.put(ARCHIVAl_PROFIL, archivalProfile);
        }
        return rightsStatementIdentifier;
    }

    private static ObjectNode buildAgIdExt(IngestContext ingestContext) {
        String submissionAgencyIdentifier;
        String archivalAgency;
        String transferringAgency;
        ObjectNode agIdExt = JsonHandler.createObjectNode();
        String originatingAgency = ingestContext.getOriginatingAgency();
        if (originatingAgency != null) {
            LOGGER.debug("supplier service is: " + originatingAgency);
            agIdExt.put(ORIGIN_ANGENCY_NAME, originatingAgency);
        }
        if ((transferringAgency = ingestContext.getTransferringAgency()) != null) {
            LOGGER.debug("Find a transfAgency: " + transferringAgency);
            agIdExt.put(TRANSFER_AGENCY, transferringAgency);
        }
        if ((archivalAgency = ingestContext.getArchivalAgency()) != null) {
            LOGGER.debug("Find a archivalAgency: " + archivalAgency);
            agIdExt.put(ARCHIVAL_AGENCY, archivalAgency);
        }
        if ((submissionAgencyIdentifier = ingestContext.getSubmissionAgencyIdentifier()) != null) {
            LOGGER.debug("Find a submissionAgencyIdentifier: " + submissionAgencyIdentifier);
            agIdExt.put(ORIGIN_ANGENCY_SUBMISSION, submissionAgencyIdentifier);
        }
        return agIdExt;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        IngestSession ingestSession = new IngestSession();
        return this.execute(params, handlerIO, ingestSession);
    }

    @VisibleForTesting
    ItemStatus execute(WorkerParameters params, HandlerIO handlerIO, IngestSession ingestSession) {
        this.checkMandatoryParameters(params);
        ItemStatus globalCompositeItemStatus = new ItemStatus(HANDLER_ID);
        try {
            IngestContext ingestContext = this.retrieveIngestContext(params, handlerIO);
            Map filesWithParamsFromWorkspace = handlerIO.getFilesWithParamsFromWorkspace(handlerIO.getContainerName(), "SIP");
            ingestSession.getFileWithParmsFromFolder().putAll(filesWithParamsFromWorkspace);
            handlerIO.enableAsync(true);
            this.checkMandatoryIOParameter(handlerIO);
            SedaUtils sedaUtils = this.sedaUtilsFactory.createSedaUtilsWithSedaIngestParams(handlerIO);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ingestContext.setSedaVersion(sedaUtils.getSedaIngestParams().getVersion());
            JsonLineDataBase unitsDatabase = new JsonLineDataBase(handlerIO, "tmp_units");
            JsonLineDataBase objectsDatabase = new JsonLineDataBase(handlerIO, "tmp_objectGroups");
            ExtractMetadataListener listener = new ExtractMetadataListener(handlerIO, ingestContext, ingestSession, unitsDatabase, objectsDatabase, this.metaDataClientFactory);
            unmarshaller.setListener((Unmarshaller.Listener)listener);
            ObjectNode evDetData = this.extractSEDA(handlerIO, unmarshaller, ingestContext, ingestSession, unitsDatabase, objectsDatabase, globalCompositeItemStatus);
            if (!ingestSession.getExistingUnitGuids().isEmpty()) {
                evDetData.set(ATTACHMENT_IDS, JsonHandler.toJsonNode(ingestSession.getExistingUnitGuids()));
            }
            globalCompositeItemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)evDetData));
            globalCompositeItemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), (Object)JsonHandler.unprettyPrint((Object)evDetData));
            globalCompositeItemStatus.increment(StatusCode.OK);
            handlerIO.enableAsync(false);
            ObjectNode agIdExt = ExtractSedaActionHandler.buildAgIdExt(ingestContext);
            if (!agIdExt.isEmpty()) {
                globalCompositeItemStatus.setMasterData(LogbookMongoDbName.agIdExt.getDbname(), (Object)agIdExt.toString());
                globalCompositeItemStatus.setData(LogbookMongoDbName.agIdExt.getDbname(), (Object)agIdExt.toString());
            }
            this.extractOntology(handlerIO);
            ObjectNode rightsStatementIdentifier = ExtractSedaActionHandler.buildRightsStatementIdentifier(ingestContext);
            if (!rightsStatementIdentifier.isEmpty()) {
                globalCompositeItemStatus.setData(LogbookMongoDbName.rightsStatementIdentifier.getDbname(), (Object)rightsStatementIdentifier.toString());
                globalCompositeItemStatus.setMasterData(LogbookMongoDbName.rightsStatementIdentifier.getDbname(), (Object)rightsStatementIdentifier.toString());
                ObjectNode data = (ObjectNode)JsonHandler.getFromString((String)globalCompositeItemStatus.getEvDetailData());
                data.set(LogbookMongoDbName.rightsStatementIdentifier.getDbname(), (JsonNode)rightsStatementIdentifier);
                globalCompositeItemStatus.setEvDetailData(data.toString());
                globalCompositeItemStatus.setData(LogbookMongoDbName.rightsStatementIdentifier.getDbname(), (Object)rightsStatementIdentifier.toString());
            }
        }
        catch (ProcessingDuplicatedVersionException e) {
            LOGGER.debug("ProcessingException: duplicated version", (Throwable)e);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingNotFoundException e) {
            LOGGER.debug("ProcessingException : " + e.getType() + " not found", (Throwable)e);
            String message = e.getType() == ExceptionType.UNIT ? this.getMessageItemStatusAUNotFound(e.getManifestId(), e.getGuid(), e.isValidGuid()) : this.getMessageItemStatusOGNotFound(e.getManifestId(), e.getGuid(), e.isValidGuid());
            this.updateDetailItemStatus(globalCompositeItemStatus, message, e.getTaskKey());
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingTooManyUnitsFoundException e) {
            LOGGER.debug("ProcessingException : multiple units found", (Throwable)e);
            this.updateDetailItemStatus(globalCompositeItemStatus, this.getMessageItemStatusAUNotFound(e.getUnitId(), e.getUnitGuid(), e.isValidGuid()), SUBTASK_TOO_MANY_FOUND_ATTACHMENT);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (MissingMandatoryVersionException e) {
            LOGGER.debug("ProcessingException :", (Throwable)e);
            this.updateDetailItemStatus(globalCompositeItemStatus, JsonHandler.unprettyPrint((Object)JsonHandler.createObjectNode().put("MsgError", e.getMessage())), EXPECTED_MANDATORY_VERSION_1);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingMalformedDataException e) {
            LOGGER.debug("ProcessingException : Missing or malformed data in the manifest", (Throwable)e);
            ObjectNode error = JsonHandler.createObjectNode();
            error.put("error", e.getMessage());
            this.updateDetailItemStatus(globalCompositeItemStatus, JsonHandler.unprettyPrint((Object)error), SUBTASK_MALFORMED);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingObjectReferenceException e) {
            LOGGER.error("ProcessingObjectReferenceException: archive unit references more than one got");
            ObjectNode error = JsonHandler.createObjectNode();
            error.put("error", e.getMessage());
            this.updateDetailItemStatus(globalCompositeItemStatus, JsonHandler.unprettyPrint((Object)error), AU_REFRENCES_MULTIPLE_GOT);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingManifestReferenceException e) {
            LOGGER.debug("ProcessingException : reference incorrect in Manifest", (Throwable)e);
            this.updateItemStatusForManifestReferenceException(globalCompositeItemStatus, e);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (MissingFieldException e) {
            LOGGER.debug("MissingFieldException", (Throwable)e);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingObjectGroupMasterMandatoryException e) {
            globalCompositeItemStatus.increment(StatusCode.KO);
            this.updateDetailItemStatus(globalCompositeItemStatus, this.getMessageItemStatusGOTMasterMandatory(e.getObjectGroupId()), MASTER_MANDATORY_REQUIRED);
        }
        catch (ProcessingObjectGroupEveryDataObjectVersionException e) {
            globalCompositeItemStatus.increment(StatusCode.KO);
            this.updateDetailItemStatus(globalCompositeItemStatus, this.getMessageItemStatusGOTEveryDataObjectVersion(e.getUnitId(), e.getObjectGroupId()), ATTACHMENT_OBJECTGROUP);
        }
        catch (ArchiveUnitContainDataObjectException e) {
            LOGGER.debug("ProcessingException: archive unit contain an data object declared object group.", (Throwable)e);
            globalCompositeItemStatus.setEvDetailData(e.getEventDetailData());
            this.updateDetailItemStatus(globalCompositeItemStatus, this.getMessageItemStatusAUDeclaringObject(e.getUnitId(), e.getBdoId(), e.getGotId()), EXISTING_OG_NOT_DECLARED);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (MetaDataContainSpecialCharactersException e) {
            LOGGER.debug("ProcessingException: archive unit contains special characters.", (Throwable)e);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingUnitLinkingException e) {
            LOGGER.debug("ProcessingException: Linking FILING_UNIT or HOLDING_UNIT to INGEST Unauthorized", (Throwable)e);
            this.updateDetailItemStatus(globalCompositeItemStatus, this.getMessageItemStatusAULinkingException(e), SUBTASK_UNAUTHORIZED_ATTACHMENT);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingAttachmentUnauthorizedException e) {
            this.updateDetailItemStatus(globalCompositeItemStatus, e.getMessage(), SUBTASK_UNAUTHORIZED_ATTACHMENT_BY_CONTRACT);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingNotValidLinkingException e) {
            this.updateDetailItemStatus(globalCompositeItemStatus, e.getMessage(), SUBTASK_UNAUTHORIZED_ATTACHMENT_BY_BAD_SP);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingAttachmentRequiredException e) {
            this.updateDetailItemStatus(globalCompositeItemStatus, e.getMessage(), SUBTASK_ATTACHMENT_REQUIRED);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingObjectGroupLifeCycleException e) {
            this.updateDetailItemStatus(globalCompositeItemStatus, e.getMessage(), null);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingObjectGroupLinkingException e) {
            this.updateDetailItemStatus(globalCompositeItemStatus, this.getMessageItemStatusGOTLinkingException(e.getUnitId(), e.getObjectGroupId()), SUBTASK_UNAUTHORIZED_ATTACHMENT);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (InvalidParseOperationException | ProcessingException | WorkerspaceQueueException e) {
            LOGGER.debug("ProcessingException ", e);
            globalCompositeItemStatus.increment(StatusCode.FATAL);
        }
        catch (CycleFoundException e) {
            LOGGER.debug("ProcessingException: cycle found", (Throwable)e);
            globalCompositeItemStatus.setEvDetailData(e.getEventDetailData());
            this.updateDetailItemStatus(globalCompositeItemStatus, e.getCycle(), SUBTASK_LOOP);
            globalCompositeItemStatus.increment(StatusCode.KO);
        }
        catch (JAXBException e) {
            LOGGER.error("unable to create ExtractSeda handler, unmarshaller failed", (Throwable)e);
            globalCompositeItemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, globalCompositeItemStatus);
    }

    private IngestContext retrieveIngestContext(WorkerParameters params, HandlerIO handlerIO) throws InvalidParseOperationException {
        ContractsDetailsModel contracts = (ContractsDetailsModel)JsonHandler.getFromFile((File)((File)handlerIO.getInput(3)), ContractsDetailsModel.class);
        IngestContext ingestContext = new IngestContext();
        ingestContext.setWorkflowUnitType(this.getUnitType(handlerIO));
        ingestContext.setTypeProcess(params.getLogbookTypeProcess());
        ingestContext.setOperationId(params.getContainerName());
        ingestContext.setIngestContract(contracts.getIngestContractModel());
        ingestContext.setManagementContractModel(contracts.getManagementContractModel());
        return ingestContext;
    }

    private void updateItemStatusForManifestReferenceException(ItemStatus globalCompositeItemStatus, ProcessingManifestReferenceException e) {
        String message;
        String key = null;
        ObjectNode error = JsonHandler.createObjectNode();
        ObjectNode errorDetail = JsonHandler.createObjectNode();
        if (e.getType() == ExceptionType.UNIT) {
            errorDetail.put("ManifestUnitId", e.getManifestId());
            errorDetail.put("SystemId", e.getUnitGuid());
            errorDetail.put("ParentUnitId", e.getUnitParentId());
            errorDetail.put("Message", e.getMessage());
            error.set(e.getManifestId(), (JsonNode)errorDetail);
            message = JsonHandler.unprettyPrint((Object)error);
            key = SUBTASK_MODIFY_PARENT_EXISTING_UNIT_UNAUTHORIZED;
        } else {
            errorDetail.put("ManifestGotId", e.getManifestId());
            errorDetail.put("Message", e.getMessage());
            error.set(e.getManifestId(), (JsonNode)errorDetail);
            message = JsonHandler.unprettyPrint((Object)error);
        }
        this.updateDetailItemStatus(globalCompositeItemStatus, message, key);
    }

    private UnitType getUnitType(HandlerIO handlerIO) {
        return UnitType.valueOf((String)UnitType.getUnitTypeString((String)((String)handlerIO.getInput(1))));
    }

    private String getMessageItemStatusAUDeclaringObject(String unitId, String bdoId, String gotId) {
        ObjectNode error = JsonHandler.createObjectNode();
        error.put(ARCHIVE_UNIT, unitId);
        error.put("BinaryDataObjectID", bdoId);
        error.put("DataObjectGroupId", gotId);
        return JsonHandler.unprettyPrint((Object)error);
    }

    private String getMessageItemStatusGOTEveryDataObjectVersion(String unitId, String objectGroupId) {
        ObjectNode error = JsonHandler.createObjectNode();
        error.put(ARCHIVE_UNIT, unitId);
        error.put("DataObjectReferenceId", objectGroupId);
        return JsonHandler.unprettyPrint((Object)error);
    }

    private String getMessageItemStatusGOTMasterMandatory(String gotId) {
        ObjectNode error = JsonHandler.createObjectNode();
        error.put("DataObjectGroupId", gotId);
        return JsonHandler.unprettyPrint((Object)error);
    }

    private String getMessageItemStatusAUNotFound(String unitId, String unitGuid, boolean isGuid) {
        if (isGuid) {
            unitGuid = "[MetadataName:" + ParserTokens.PROJECTIONARGS.ID.exactToken() + ", MetadataValue : " + (String)unitGuid + "]";
        }
        ObjectNode error = JsonHandler.createObjectNode();
        ObjectNode errorDetail = JsonHandler.createObjectNode();
        errorDetail.put(ARCHIVE_UNIT, (String)unitGuid);
        error.set(unitId, (JsonNode)errorDetail);
        return JsonHandler.unprettyPrint((Object)error);
    }

    private String getMessageItemStatusGOTLinkingException(String unitGuid, String got) {
        ObjectNode error = JsonHandler.createObjectNode();
        error.put(ARCHIVE_UNIT, unitGuid);
        error.put("DataObjectReferenceId", got);
        return JsonHandler.unprettyPrint((Object)error);
    }

    private String getMessageItemStatusAULinkingException(ProcessingUnitLinkingException e) {
        ObjectNode error = JsonHandler.createObjectNode();
        error.put(ARCHIVE_UNIT, e.getManifestId());
        if (e.getUnitType() != null) {
            error.put("ExistingUnitType", e.getUnitType().name());
        }
        error.put("IngestUnitType", e.getIngestType().name());
        error.put("message", e.getMessage());
        return JsonHandler.unprettyPrint((Object)error);
    }

    private String getMessageItemStatusOGNotFound(String unitId, String objectGroupGuid, boolean isGuid) {
        if (isGuid) {
            objectGroupGuid = "[MetadataName:" + ParserTokens.PROJECTIONARGS.ID.exactToken() + ", MetadataValue : " + (String)objectGroupGuid + "]";
        }
        ObjectNode error = JsonHandler.createObjectNode();
        ObjectNode errorDetail = JsonHandler.createObjectNode();
        errorDetail.put(DATA_OBJECT_GROUP, (String)objectGroupGuid);
        error.set(unitId, (JsonNode)errorDetail);
        return JsonHandler.unprettyPrint((Object)error);
    }

    private ObjectNode extractSEDA(HandlerIO handlerIO, Unmarshaller unmarshaller, IngestContext ingestContext, IngestSession ingestSession, JsonLineDataBase unitsDatabase, JsonLineDataBase objectsDatabase, ItemStatus globalCompositeItemStatus) throws ProcessingException, CycleFoundException {
        ParametersChecker.checkParameter((String)"ContainerId is a mandatory parameter", (Object[])new Object[]{ingestContext});
        ParametersChecker.checkParameter((String)"itemStatus is a mandatory parameter", (Object[])new Object[]{globalCompositeItemStatus});
        XMLEventReader reader = null;
        QName dataObjectGroupName = new QName(namespaceURI, DATA_OBJECT_GROUP);
        QName dataObjectName = new QName(namespaceURI, BINARY_DATA_OBJECT);
        QName physicalDataObjectName = new QName(namespaceURI, PHYSICAL_DATA_OBJECT);
        QName unitName = new QName(namespaceURI, ARCHIVE_UNIT);
        try {
            ObjectNode objectNode;
            block71: {
                InputStream xmlFile = this.getTransformedXmlAsInputStream(handlerIO, ingestContext.getSedaVersion());
                try {
                    boolean attachmentsNotAuthorizedByIngestContract;
                    reader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)xmlFile);
                    JsonXMLConfig config = new JsonXMLConfigBuilder().autoArray(true).autoPrimitive(true).prettyPrint(true).namespaceDeclarations(false).build();
                    File globalSedaParametersFile = handlerIO.getNewLocalFile(handlerIO.getOutput(7).getPath());
                    FileWriter tmpFileWriter = new FileWriter(globalSedaParametersFile);
                    XMLEventFactory eventFactory = XMLEventFactory.newInstance();
                    JsonXMLOutputFactory jsonXMLOutputFactory = new JsonXMLOutputFactory(config);
                    XMLEventWriter writer = jsonXMLOutputFactory.createXMLEventWriter((Writer)tmpFileWriter);
                    writer.setPrefix("", namespaceURI);
                    writer.add(eventFactory.createStartDocument());
                    boolean globalMetadata = true;
                    JsonNode storageInfo = JsonHandler.getFromFile((File)((File)handlerIO.getInput(2)));
                    JsonNode storageUnitInfo = storageInfo.get(VitamConfiguration.getDefaultStrategy());
                    JsonNode storageObjectGroupInfo = storageInfo.get(VitamConfiguration.getDefaultStrategy());
                    JsonNode storageObjectInfo = storageInfo.get(VitamConfiguration.getDefaultStrategy());
                    if (ingestContext.getManagementContractModel() != null && ingestContext.getManagementContractModel().getStorage() != null) {
                        if (StringUtils.isNotBlank((CharSequence)ingestContext.getManagementContractModel().getStorage().getUnitStrategy())) {
                            storageUnitInfo = storageInfo.get(ingestContext.getManagementContractModel().getStorage().getUnitStrategy());
                        }
                        if (StringUtils.isNotBlank((CharSequence)ingestContext.getManagementContractModel().getStorage().getObjectGroupStrategy())) {
                            storageObjectGroupInfo = storageInfo.get(ingestContext.getManagementContractModel().getStorage().getObjectGroupStrategy());
                        }
                        if (StringUtils.isNotBlank((CharSequence)ingestContext.getManagementContractModel().getStorage().getObjectStrategy())) {
                            storageObjectInfo = storageInfo.get(ingestContext.getManagementContractModel().getStorage().getObjectStrategy());
                        }
                    }
                    if (storageUnitInfo == null || storageObjectGroupInfo == null || storageObjectInfo == null) {
                        LOGGER.error(MISSING_STORAGE_INFO);
                        throw new ProcessingException(MISSING_STORAGE_INFO);
                    }
                    ObjectNode evDetData = JsonHandler.createObjectNode();
                    Stopwatch xmlParserStopwatch = Stopwatch.createStarted();
                    while (true) {
                        XMLEvent event;
                        if ((event = reader.peek()).isStartElement() && event.asStartElement().getName().equals(unitName)) {
                            this.extractMetadataUsingMarshellar(reader, unmarshaller, handlerIO, ingestContext, ingestSession, ArchiveUnitType.class);
                            continue;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().equals(dataObjectGroupName)) {
                            this.extractMetadataUsingMarshellar(reader, unmarshaller, handlerIO, ingestContext, ingestSession, DataObjectGroupType.class);
                            continue;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().equals(dataObjectName)) {
                            this.extractMetadataUsingMarshellar(reader, unmarshaller, handlerIO, ingestContext, ingestSession, BinaryDataObjectType.class);
                            continue;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().equals(physicalDataObjectName)) {
                            this.extractMetadataUsingMarshellar(reader, unmarshaller, handlerIO, ingestContext, ingestSession, PhysicalDataObjectType.class);
                            continue;
                        }
                        reader.nextEvent();
                        if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(DATAOBJECT_PACKAGE)) {
                            globalMetadata = true;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(ARCHIVAl_AGREEMENT)) {
                            String ingestContractIdentifier = reader.getElementText();
                            this.updateGlobalSedaFile(writer, eventFactory, ARCHIVAl_AGREEMENT, ingestContractIdentifier);
                            continue;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(ARCHIVAl_PROFIL)) {
                            this.updateGlobalSedaFile(writer, eventFactory, ARCHIVAl_PROFIL, reader.getElementText());
                            continue;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("OriginatingAgencyIdentifier")) {
                            if (!UnitType.HOLDING_UNIT.equals((Object)ingestContext.getWorkflowUnitType())) {
                                String originatingAgency = reader.getElementText();
                                ingestContext.setOriginatingAgency(originatingAgency);
                                ingestSession.getOriginatingAgencies().add(originatingAgency);
                                this.updateGlobalSedaFile(writer, eventFactory, "OriginatingAgencyIdentifier", originatingAgency);
                                for (String currentAgency : ingestSession.getOriginatingAgencies()) {
                                    this.updateGlobalSedaFile(writer, eventFactory, "OriginatingAgencyIdentifiers", currentAgency);
                                }
                            }
                            globalMetadata = false;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("ServiceLevel")) {
                            String serviceLevel = reader.getElementText();
                            this.updateGlobalSedaFile(writer, eventFactory, "ServiceLevel", serviceLevel);
                            globalMetadata = false;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("AcquisitionInformation")) {
                            String acquisitionInformation = reader.getElementText();
                            this.updateGlobalSedaFile(writer, eventFactory, "AcquisitionInformation", acquisitionInformation);
                            globalMetadata = false;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("LegalStatus")) {
                            String legalStatus = reader.getElementText();
                            this.updateGlobalSedaFile(writer, eventFactory, "LegalStatus", legalStatus);
                            globalMetadata = false;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("SubmissionAgencyIdentifier")) {
                            String submissionAgencyIdentifier = reader.getElementText();
                            ingestContext.setSubmissionAgencyIdentifier(submissionAgencyIdentifier);
                            this.updateGlobalSedaFile(writer, eventFactory, "SubmissionAgencyIdentifier", submissionAgencyIdentifier);
                            globalMetadata = false;
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("NeedAuthorization")) {
                            String globalNeedAuthorization = reader.getElementText();
                            ingestContext.setGlobalNeedAuthorization(globalNeedAuthorization);
                            globalMetadata = false;
                        }
                        if (event.isStartElement() && SedaConstants.getSupportedRules().contains(event.asStartElement().getName().getLocalPart())) {
                            StartElement element = event.asStartElement();
                            this.parseMetadataManagementRules(ingestSession, reader, element, event.asStartElement().getName().getLocalPart());
                        }
                        if (globalMetadata && event.getEventType() != 7 && event.getEventType() != 8) {
                            writer.add(event);
                        }
                        if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(DATAOBJECT_PACKAGE)) {
                            globalMetadata = false;
                        }
                        if (event.isEndDocument()) break;
                    }
                    boolean bl = attachmentsNotAuthorizedByIngestContract = ingestContext.getIngestContract() != null && IngestContractCheckState.REQUIRED.equals((Object)ingestContext.getIngestContract().getCheckParentLink()) && ingestSession.getExistingUnitGuids().isEmpty();
                    if (attachmentsNotAuthorizedByIngestContract) {
                        throw new ProcessingAttachmentRequiredException("ingest contract requires at least one existing archive unit to attach, but not found in manifest");
                    }
                    long elapsed = xmlParserStopwatch.elapsed(TimeUnit.MILLISECONDS);
                    PERFORMANCE_LOGGER.log("STP_INGEST_CONTROL_SIP", "CHECK_DATAOBJECTPACKAGE", "extractSeda.xml.parse", elapsed);
                    writer.add(eventFactory.createEndDocument());
                    writer.close();
                    this.saveGuids(handlerIO, ingestSession);
                    try {
                        JsonNode dataObjPack;
                        JsonNode identifier;
                        JsonNode archivalAgencyContent;
                        JsonNode identifier2;
                        JsonNode transfAgency;
                        JsonNode archAgreement;
                        JsonNode date;
                        JsonNode metadataAsJson = JsonHandler.getFromFile((File)globalSedaParametersFile).get("ArchiveTransfer");
                        JsonNode comments = metadataAsJson.get("Comment");
                        if (comments != null && comments.isArray()) {
                            ArrayNode commentsArray = (ArrayNode)comments;
                            for (JsonNode node : commentsArray) {
                                JsonNode oldCommentCurrentLang;
                                Object comment;
                                String lang = null;
                                if (node.isTextual()) {
                                    comment = node.asText();
                                } else {
                                    lang = node.get("@lang").asText();
                                    comment = node.get("$").asText();
                                }
                                JsonNode oldComment = evDetData.get(EV_DETAIL_REQ);
                                String evDetReq = null;
                                if (oldComment != null) {
                                    evDetReq = oldComment.asText();
                                }
                                if ((oldCommentCurrentLang = evDetData.get(EV_DETAIL_REQ + (String)(ParametersChecker.isNotEmpty((String[])new String[]{lang}) ? "_" + lang : ""))) != null) {
                                    comment = oldCommentCurrentLang.asText() + "_" + (String)comment;
                                }
                                if (evDetReq == null || "fr".equalsIgnoreCase(lang)) {
                                    evDetData.put(EV_DETAIL_REQ, (String)comment);
                                }
                                evDetData.put(EV_DETAIL_REQ + (String)(ParametersChecker.isNotEmpty((String[])new String[]{lang}) ? "_" + lang : ""), (String)comment);
                                LOGGER.debug("evDetData after comment: " + evDetData);
                            }
                        } else if (comments != null && comments.isTextual()) {
                            evDetData.put(EV_DETAIL_REQ, comments.asText());
                        }
                        if ((date = metadataAsJson.get("Date")) != null) {
                            LOGGER.debug("Find a date: " + date);
                            evDetData.put("EvDateTimeReq", date.asText().trim());
                        }
                        if ((archAgreement = metadataAsJson.get(ARCHIVAl_AGREEMENT)) != null) {
                            LOGGER.debug("Find an archival agreement: " + archAgreement);
                            evDetData.put(ARCHIVAl_AGREEMENT, archAgreement.asText());
                        }
                        if ((transfAgency = metadataAsJson.get(TRANSFER_AGENCY)) != null && (identifier2 = transfAgency.get("Identifier")) != null) {
                            String transferringAgency = identifier2.asText();
                            ingestContext.setTransferringAgency(transferringAgency);
                        }
                        if ((archivalAgencyContent = metadataAsJson.get(ARCHIVAL_AGENCY)) != null && (identifier = archivalAgencyContent.get("Identifier")) != null) {
                            String archivalAgency = identifier.asText();
                            ingestContext.setArchivalAgency(archivalAgency);
                        }
                        if ((dataObjPack = metadataAsJson.get(DATAOBJECT_PACKAGE)) != null) {
                            JsonNode legalStatus;
                            JsonNode serviceLevel = dataObjPack.get("ServiceLevel");
                            JsonNode archivalProfileElement = dataObjPack.get(ARCHIVAl_PROFIL);
                            if (archivalProfileElement != null) {
                                LOGGER.debug("Find an archival profile: " + archivalProfileElement.asText());
                                evDetData.put(ARCHIVAl_PROFIL, archivalProfileElement.asText());
                                String archivalProfile = archivalProfileElement.asText();
                                ingestContext.setArchivalProfile(archivalProfile);
                            }
                            if (serviceLevel != null) {
                                LOGGER.debug("Find a service Level: " + serviceLevel);
                                evDetData.put("ServiceLevel", serviceLevel.asText());
                            } else {
                                LOGGER.debug("Put a null ServiceLevel (No service Level)");
                                evDetData.set("ServiceLevel", null);
                            }
                            JsonNode acquisitionInformation = dataObjPack.get("AcquisitionInformation");
                            if (acquisitionInformation != null) {
                                LOGGER.debug("Find AcquisitionInformation : " + acquisitionInformation);
                                evDetData.put("AcquisitionInformation", acquisitionInformation.asText());
                            }
                            if ((legalStatus = dataObjPack.get("LegalStatus")) != null) {
                                LOGGER.debug("Find legalStatus : " + legalStatus);
                                evDetData.put("LegalStatus", legalStatus.asText());
                            }
                        } else {
                            LOGGER.debug("Put a null ServiceLevel (No Data Object Package)");
                            evDetData.set("ServiceLevel", null);
                        }
                    }
                    catch (InvalidParseOperationException e) {
                        LOGGER.error("Can't parse globalSedaPareters", (Throwable)e);
                        throw new ProcessingException((Throwable)e);
                    }
                    String evDetDataJson = JsonHandler.unprettyPrint((Object)evDetData);
                    Stopwatch checkCycle = Stopwatch.createStarted();
                    this.checkCycle(handlerIO, ingestContext, ingestSession, evDetDataJson);
                    PERFORMANCE_LOGGER.log("STP_INGEST_CONTROL_SIP", "CHECK_DATAOBJECTPACKAGE", "extractSeda.checkCycle", checkCycle.elapsed(TimeUnit.MILLISECONDS));
                    this.createIngestLevelStackFile(handlerIO, ingestSession, new Graph((JsonNode)ingestSession.getArchiveUnitTree()).getGraphWithLongestPaths(), 0);
                    this.checkArchiveUnitIdReference(ingestSession, evDetDataJson);
                    Stopwatch saveObjectGroupToWorkspaceStopWatch = Stopwatch.createStarted();
                    this.checkMasterIsMandatoryAndCheckCanAddObjectToExistingObjectGroup(ingestSession, ingestContext.getIngestContract());
                    this.saveObjectGroupsToWorkspace(handlerIO, ingestContext, ingestSession, objectsDatabase, storageObjectGroupInfo, storageObjectInfo);
                    PERFORMANCE_LOGGER.log("STP_INGEST_CONTROL_SIP", "CHECK_DATAOBJECTPACKAGE", "extractSeda.saveObjectGroup", saveObjectGroupToWorkspaceStopWatch.elapsed(TimeUnit.MILLISECONDS));
                    Stopwatch saveArchiveUnitStopWatch = Stopwatch.createStarted();
                    this.finalizeAndSaveArchiveUnitToWorkspace(handlerIO, ingestContext, ingestSession, unitsDatabase, storageUnitInfo);
                    PERFORMANCE_LOGGER.log("STP_INGEST_CONTROL_SIP", "CHECK_DATAOBJECTPACKAGE", "extractSeda.saveArchiveUnit", saveArchiveUnitStopWatch.elapsed(TimeUnit.MILLISECONDS));
                    handlerIO.addOutputResult(7, (Object)globalSedaParametersFile, false, true);
                    objectNode = evDetData;
                    if (xmlFile == null) break block71;
                }
                catch (Throwable throwable) {
                    try {
                        if (xmlFile != null) {
                            try {
                                xmlFile.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidParseOperationException | XMLStreamException | TransformerException e) {
                        LOGGER.error(CANNOT_READ_SEDA, e);
                        throw new ProcessingException(e);
                    }
                    catch (LogbookClientBadRequestException e) {
                        LOGGER.error(LOGBOOK_LF_BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
                        throw new ProcessingException((Throwable)e);
                    }
                    catch (LogbookClientNotFoundException e) {
                        LOGGER.error(LOGBOOK_LF_RESOURCE_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
                        throw new ProcessingException((Throwable)e);
                    }
                    catch (LogbookClientAlreadyExistsException e) {
                        LOGGER.error(LOGBOOK_LF_OBJECT_EXISTS_EXCEPTION_MSG, (Throwable)e);
                        throw new ProcessingException((Throwable)e);
                    }
                    catch (LogbookClientServerException e) {
                        LOGGER.error(LOGBOOK_SERVER_INTERNAL_EXCEPTION_MSG, (Throwable)e);
                        throw new ProcessingException((Throwable)e);
                    }
                    catch (CycleFoundException e) {
                        LOGGER.error(CYCLE_FOUND_EXCEPTION, (Throwable)e);
                        throw e;
                    }
                    catch (IOException e) {
                        LOGGER.error(SAVE_ARCHIVE_ID_TO_GUID_IOEXCEPTION_MSG, (Throwable)e);
                        throw new ProcessingException((Throwable)e);
                    }
                    catch (ArchiveUnitContainDataObjectException e) {
                        LOGGER.error("Archive Unit Reference to BDO", (Throwable)e);
                        throw e;
                    }
                    catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
                        LOGGER.error(MANIFEST_NOT_FOUND);
                        throw new ProcessingException(e);
                    }
                }
                xmlFile.close();
            }
            return objectNode;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                }
            }
        }
    }

    private void updateGlobalSedaFile(XMLEventWriter writer, XMLEventFactory eventFactory, String key, String value) throws XMLStreamException {
        writer.add(eventFactory.createStartElement("", namespaceURI, key));
        writer.add(eventFactory.createCharacters(value));
        writer.add(eventFactory.createEndElement("", namespaceURI, key));
    }

    @Nonnull
    private InputStream getTransformedXmlAsInputStream(HandlerIO handlerIO, String inputSedaVersion) throws TransformerException, IOException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        File xmlFile = handlerIO.getFileFromWorkspace("SIP/manifest.xml");
        File cleanManifest = handlerIO.getNewLocalFile("_manifest.xml");
        try (FileInputStream inputStream = new FileInputStream(xmlFile);
             FileOutputStream outputStream = new FileOutputStream(cleanManifest);){
            SupportedSedaVersions sedaVersion = (SupportedSedaVersions)SupportedSedaVersions.getSupportedSedaVersionByVersion((String)inputSedaVersion).orElseThrow();
            XmlNamespaceUtils.transformXMLNamespace((InputStream)inputStream, (OutputStream)outputStream, (String)sedaVersion.getNamespaceURI(), (String)namespaceURI);
        }
        return new FileInputStream(cleanManifest);
    }

    private void handleJaxbUnmarshalRuntimeException(HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, RuntimeException e) throws IOException, ProcessingException, InvalidParseOperationException, LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        if (e.getCause() instanceof ProcessingNotFoundException) {
            ProcessingNotFoundException exception = (ProcessingNotFoundException)e.getCause();
            if (exception.getType() == ExceptionType.UNIT && exception.isValidGuid()) {
                ingestSession.getUnitIdToGuid().put(exception.getManifestId(), exception.getGuid());
                ingestSession.getGuidToUnitId().put(exception.getGuid(), exception.getManifestId());
                this.saveGuids(handlerIO, ingestSession);
                this.createLifeCycleForError(ingestSession.getGuidToLifeCycleParameters(), exception.getTaskKey(), this.getMessageItemStatusAUNotFound(exception.getManifestId(), exception.getGuid(), exception.isValidGuid()), exception.getGuid(), true, false, ingestContext.getOperationId(), ingestContext.getTypeProcess());
                throw exception;
            }
            if (exception.getType() == ExceptionType.GOT) {
                ingestSession.getDataObjectIdToGuid().put(exception.getGuid(), exception.getGuid());
                this.saveGuids(handlerIO, ingestSession);
                this.createLifeCycleForError(ingestSession.getGuidToLifeCycleParameters(), exception.getTaskKey(), this.getMessageItemStatusOGNotFound(exception.getManifestId(), exception.getGuid(), exception.isValidGuid()), exception.getGuid(), false, true, ingestContext.getOperationId(), ingestContext.getTypeProcess());
                throw exception;
            }
        }
        if (e.getCause() instanceof ProcessingException) {
            throw (ProcessingException)e.getCause();
        }
        throw e;
    }

    private void saveGuids(HandlerIO handlerIO, IngestSession ingestSession) throws IOException, ProcessingException {
        HandlerUtils.saveMap(handlerIO, ingestSession.getDataObjectIdToGuid(), 2, true, true);
        handlerIO.addOutputResult(4, ingestSession.getObjectGroupIdToUnitId(), true);
        HandlerUtils.saveMap(handlerIO, ingestSession.getDataObjectIdToDetailDataObject(), 5, true, true);
        HandlerUtils.saveMap(handlerIO, ingestSession.getUnitIdToGuid(), 6, true, true);
        HandlerUtils.saveMap(handlerIO, ingestSession.getGuidToUnitId(), 10, true, true);
        HandlerUtils.saveMap(handlerIO, ingestSession.getExistingGOTGUIDToNewGotGUIDInAttachment(), 12, true, true);
        HandlerUtils.saveSet(handlerIO, ingestSession.getExistingUnitGuids(), 13, true, true);
        HandlerUtils.saveSet(handlerIO, ingestSession.getExistingGOTs().keySet(), 14, true, true);
    }

    private void checkCycle(HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, String evDetData) throws CycleFoundException, LogbookClientNotFoundException, InvalidParseOperationException, LogbookClientBadRequestException, LogbookClientServerException {
        DirectedGraph directedGraph = new DirectedGraph((JsonNode)ingestSession.getArchiveUnitTree());
        DirectedCycle directedCycle = new DirectedCycle(directedGraph);
        if (!directedCycle.isCyclic()) {
            return;
        }
        String cycleMessage = null;
        if (directedCycle.getCycle() != null && !directedCycle.getCycle().isEmpty()) {
            if (directedCycle.getCycle().size() <= 20) {
                ArrayList<String> cycle = new ArrayList<String>();
                for (Integer index : directedCycle.getCycle()) {
                    cycle.add(directedGraph.getId(index));
                }
                cycleMessage = "Cycle : " + Arrays.toString(cycle.toArray());
            }
            String unitGuid = ingestSession.getUnitIdToGuid().get(directedGraph.getId((Integer)directedCycle.getCycle().get(0)));
            LogbookLifeCycleParameters llcp = ingestSession.getGuidToLifeCycleParameters().get(unitGuid);
            llcp.setFinalStatus(SUBTASK_LOOP, null, StatusCode.KO, null, new String[0]);
            ObjectNode llcEvDetData = JsonHandler.createObjectNode();
            llcEvDetData.put("evDetTechData", cycleMessage);
            String wellFormedJson = JsonHandler.writeAsString((Object)llcEvDetData);
            llcp.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            handlerIO.getHelper().updateDelegate(llcp);
            this.bulkLifeCycleUnit(handlerIO, ingestContext.getOperationId(), Lists.newArrayList((Object[])new String[]{unitGuid}));
        }
        throw new CycleFoundException(GRAPH_CYCLE_MSG, cycleMessage, evDetData);
    }

    private void parseMetadataManagementRules(IngestSession ingestSession, XMLEventReader reader, StartElement element, String currentRuleInProcess) throws ProcessingException {
        try {
            XMLEvent event;
            StringWriter stringWriterRule = new StringWriter();
            JsonXMLConfig config = new JsonXMLConfigBuilder().autoArray(true).autoPrimitive(true).prettyPrint(true).namespaceDeclarations(false).build();
            JsonXMLOutputFactory xmlOutputFactory = new JsonXMLOutputFactory(config);
            XMLEventWriter xw = xmlOutputFactory.createXMLEventWriter(stringWriterRule);
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            String currentRuleId = null;
            xw.add(eventFactory.createStartDocument());
            xw.add(eventFactory.createStartElement("", "", GLOBAL_MGT_RULE_TAG));
            xw.add(eventFactory.createStartElement("", "", element.getName().getLocalPart()));
            while (true) {
                if ((event = reader.nextEvent()).isEndElement() && currentRuleInProcess.equalsIgnoreCase(((EndElement)event).getName().getLocalPart())) break;
                if (event.isStartElement() && "Rule".equals(event.asStartElement().getName().getLocalPart())) {
                    if (currentRuleId != null) {
                        xw.add(eventFactory.createEndElement("", "", GLOBAL_MGT_RULE_TAG));
                        xw.add(eventFactory.createEndDocument());
                        ingestSession.getMngtMdRuleIdToRulesXml().put(currentRuleId, stringWriterRule);
                        stringWriterRule.close();
                        stringWriterRule = new StringWriter();
                        xw = xmlOutputFactory.createXMLEventWriter(stringWriterRule);
                        xw.add(eventFactory.createStartDocument());
                        xw.add(eventFactory.createStartElement("", "", GLOBAL_MGT_RULE_TAG));
                        xw.add(eventFactory.createStartElement("", "", element.getName().getLocalPart()));
                    }
                    xw.add(eventFactory.createStartElement("", "", "Rule"));
                    event = (XMLEvent)reader.next();
                    xw.add(event);
                    if (event.isCharacters()) {
                        currentRuleId = event.asCharacters().getData();
                    }
                    if ((event = (XMLEvent)reader.next()).isStartElement()) {
                        xw.add(eventFactory.createStartElement("", "", event.asStartElement().getName().getLocalPart()));
                        continue;
                    }
                    if (event.isCharacters()) {
                        xw.add(event.asCharacters());
                        continue;
                    }
                    if (!event.isEndElement()) continue;
                    xw.add(eventFactory.createEndElement("", "", event.asEndElement().getName().getLocalPart()));
                    continue;
                }
                if (event.isStartElement()) {
                    xw.add(eventFactory.createStartElement("", "", event.asStartElement().getName().getLocalPart()));
                    continue;
                }
                if (event.isCharacters()) {
                    xw.add(event.asCharacters());
                    continue;
                }
                if (!event.isEndElement()) continue;
                xw.add(eventFactory.createEndElement("", "", event.asEndElement().getName().getLocalPart()));
            }
            xw.add(eventFactory.createEndElement("", "", event.asEndElement().getName().getLocalPart()));
            ingestSession.getMngtMdRuleIdToRulesXml().put(Objects.requireNonNullElse(currentRuleId, currentRuleInProcess), stringWriterRule);
            stringWriterRule.close();
            xw.add(eventFactory.createEndDocument());
        }
        catch (IOException | XMLStreamException e) {
            LOGGER.error(CANNOT_READ_SEDA, (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
    }

    private void finalizeAndSaveArchiveUnitToWorkspace(HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, JsonLineDataBase unitsDatabase, JsonNode storageUnitInfo) throws LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException, ProcessingException, InvalidParseOperationException {
        if (ingestSession.getUnitIdToGuid() == null) {
            return;
        }
        ArrayList<String> uuids = new ArrayList<String>();
        for (Map.Entry<String, String> element : ingestSession.getUnitIdToGuid().entrySet()) {
            String unitGuid = element.getValue();
            if (ingestSession.getExistingUnitGuids().contains(unitGuid)) continue;
            String manifestUnitId = element.getKey();
            boolean isRootArchive = true;
            List logbookLifeCycle = null;
            this.createUnitLifeCycle(handlerIO, ingestSession, unitGuid, ingestContext.getOperationId());
            File unitCompleteTmpFile = handlerIO.getNewLocalFile(unitGuid);
            ObjectNode archiveUnit = (ObjectNode)unitsDatabase.read(unitGuid);
            JsonNode logbookLifeCycleAsNode = archiveUnit.get("LogbookLifeCycleExternal");
            if (logbookLifeCycleAsNode != null) {
                logbookLifeCycle = (List)JsonHandler.getFromJsonNode((JsonNode)logbookLifeCycleAsNode, LIST_TYPE_REFERENCE);
            }
            HashSet<String> globalMgtIdExtra = new HashSet<String>();
            this.addStorageInformation(archiveUnit, storageUnitInfo);
            this.addValidComputedInheritedRulesInformation(ingestContext, archiveUnit);
            isRootArchive = this.attachmentByIngestContractAndManageRulesInformation(ingestContext, ingestSession, archiveUnit, manifestUnitId, unitGuid, globalMgtIdExtra);
            this.updateManagementAndAppendGlobalMgtRule(ingestContext, ingestSession, archiveUnit, globalMgtIdExtra, isRootArchive);
            if (ingestSession.getIsThereManifestRelatedReferenceRemained().get(manifestUnitId) != null && ingestSession.getIsThereManifestRelatedReferenceRemained().get(manifestUnitId).booleanValue()) {
                this.postReplaceInternalReferenceForRelatedObjectReference(ingestSession, archiveUnit);
            }
            JsonHandler.writeAsFile((Object)archiveUnit, (File)unitCompleteTmpFile);
            handlerIO.transferFileToWorkspace("Units" + File.separator + unitGuid + JSON_EXTENSION, unitCompleteTmpFile, true, true);
            this.addFinalStatusToUnitLifeCycle(handlerIO, ingestContext, ingestSession, unitGuid, manifestUnitId, isRootArchive);
            if (logbookLifeCycle != null) {
                this.createExternalLifeCycleLogbook(handlerIO, logbookLifeCycle, ingestContext.getOperationId(), unitGuid);
            }
            uuids.add(unitGuid);
            if (uuids.size() != 50) continue;
            this.bulkLifeCycleUnit(handlerIO, ingestContext.getOperationId(), uuids);
            uuids.clear();
        }
        if (!uuids.isEmpty()) {
            this.bulkLifeCycleUnit(handlerIO, ingestContext.getOperationId(), uuids);
            uuids.clear();
        }
    }

    private void createExternalLifeCycleLogbook(HandlerIO handlerIO, List<LogbookEvent> externalModelEvents, String processId, String guid) throws LogbookClientNotFoundException, ProcessingMalformedDataException {
        LogbookLifeCycleParameters parent = this.createExternalParentLogbookLifeCycle(processId, guid);
        handlerIO.getHelper().updateDelegate(parent);
        for (LogbookEvent eventModel : externalModelEvents) {
            LogbookLifeCycleParameters external = this.toLogbookLifeCycleParameters(eventModel, parent.getParameterValue(LogbookParameterName.eventIdentifier), processId, guid);
            handlerIO.getHelper().updateDelegateWithKey(guid, external);
        }
    }

    private LogbookLifeCycleParameters createExternalParentLogbookLifeCycle(String processId, String guid) {
        LogbookLifeCycleParameters parent = new LogbookLifeCycleParameters(LogbookParameterHelper.getDefaultLifeCycleMandatory());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(LogbookParameterName.eventIdentifier.name(), GUIDFactory.newGUID().getId());
        parameters.put(LogbookParameterName.eventType.name(), "LFC.EXTERNAL_LOGBOOK");
        parameters.put(LogbookParameterName.eventDateTime.name(), LocalDateUtil.nowFormatted());
        parameters.put(LogbookParameterName.eventTypeProcess.name(), LogbookTypeProcess.INGEST.name());
        parameters.put(LogbookParameterName.eventIdentifierProcess.name(), processId);
        parameters.put(LogbookParameterName.outcome.name(), StatusCode.OK.name());
        parameters.put(LogbookParameterName.outcomeDetail.name(), "LFC.EXTERNAL_LOGBOOK.OK");
        parameters.put(LogbookParameterName.outcomeDetailMessage.name(), "Succ\u00e8s de la r\u00e9cup\u00e9ration des journaux de cycle de vie de l\u2019archive transf\u00e9r\u00e9e");
        parameters.put(LogbookParameterName.objectIdentifier.name(), guid);
        parent.setMap(parameters);
        return parent;
    }

    private LogbookLifeCycleParameters toLogbookLifeCycleParameters(LogbookEvent eventModel, String parentId, String identifierProcess, String guid) throws ProcessingMalformedDataException {
        LogbookLifeCycleParameters logbookLifeCycleParameters = new LogbookLifeCycleParameters(Collections.singleton(LogbookParameterName.eventDateTime));
        this.checkEveDateTime(eventModel);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(LogbookParameterName.eventIdentifier.name(), eventModel.getEvId());
        parameters.put(LogbookParameterName.parentEventIdentifier.name(), StringUtils.isBlank((CharSequence)eventModel.getEvParentId()) ? parentId : eventModel.getEvParentId());
        parameters.put(LogbookParameterName.eventType.name(), eventModel.getEvType());
        parameters.put(LogbookParameterName.eventDateTime.name(), eventModel.getEvDateTime());
        parameters.put(LogbookParameterName.eventIdentifierProcess.name(), StringUtils.isBlank((CharSequence)eventModel.getEvIdProc()) ? identifierProcess : eventModel.getEvIdProc());
        parameters.put(LogbookParameterName.eventTypeProcess.name(), eventModel.getEvTypeProc());
        parameters.put(LogbookParameterName.outcome.name(), eventModel.getOutcome());
        parameters.put(LogbookParameterName.outcomeDetail.name(), eventModel.getOutDetail());
        parameters.put(LogbookParameterName.outcomeDetailMessage.name(), eventModel.getOutMessg());
        parameters.put(LogbookParameterName.agentIdentifier.name(), eventModel.getAgId());
        parameters.put(LogbookParameterName.objectIdentifier.name(), StringUtils.isBlank((CharSequence)eventModel.getObId()) ? guid : eventModel.getObId());
        logbookLifeCycleParameters.setMap(parameters);
        return logbookLifeCycleParameters;
    }

    private void checkEveDateTime(LogbookEvent eventModel) throws ProcessingMalformedDataException {
        String evDateTime = eventModel.getEvDateTime();
        LocalDateTime now = LocalDateUtil.now();
        LocalDateTime localDateTime = LocalDateUtil.parseMongoFormattedDate((String)Objects.requireNonNull(evDateTime, "EventDateTime cannot be null."));
        if (localDateTime.isAfter(now)) {
            throw new ProcessingMalformedDataException(String.format("EventDateTime in Logbook Event cannot be in the future, here '%s' is after '%s'.", LocalDateUtil.getFormattedDateTimeForMongo((String)evDateTime), LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)now)));
        }
    }

    private void addStorageInformation(ObjectNode archiveUnit, JsonNode storageUnitInfo) {
        ObjectNode archiveUnitNode = (ObjectNode)archiveUnit.get(ARCHIVE_UNIT);
        ObjectNode storage = JsonHandler.createObjectNode();
        storage.put("strategyId", storageUnitInfo.get("strategyId").asText());
        archiveUnitNode.set("_storage", (JsonNode)storage);
    }

    private void addValidComputedInheritedRulesInformation(IngestContext ingestContext, ObjectNode archiveUnit) {
        if (ingestContext.getIngestContract() != null && ingestContext.getIngestContract().isComputeInheritedRulesAtIngest()) {
            ObjectNode archiveUnitNode = (ObjectNode)archiveUnit.get(ARCHIVE_UNIT);
            archiveUnitNode.put("_validComputedInheritedRules", false);
        }
    }

    private void postReplaceInternalReferenceForRelatedObjectReference(IngestSession ingestSession, ObjectNode archiveUnit) throws InvalidParseOperationException {
        ObjectNode archiveUnitNode = (ObjectNode)archiveUnit.get(ARCHIVE_UNIT);
        if (archiveUnitNode.has("RelatedObjectReference") && archiveUnitNode.get("RelatedObjectReference") instanceof ObjectNode) {
            RelatedObjectReferenceType archiveUnitRelatedObjectReference = (RelatedObjectReferenceType)JsonHandler.getFromJsonNode((JsonNode)archiveUnitNode.get("RelatedObjectReference"), RelatedObjectReferenceType.class);
            this.fillArchiveUnitReference(ingestSession, archiveUnitRelatedObjectReference.getIsVersionOf());
            this.fillArchiveUnitReference(ingestSession, archiveUnitRelatedObjectReference.getReplaces());
            this.fillArchiveUnitReference(ingestSession, archiveUnitRelatedObjectReference.getRequires());
            this.fillArchiveUnitReference(ingestSession, archiveUnitRelatedObjectReference.getIsPartOf());
            this.fillArchiveUnitReference(ingestSession, archiveUnitRelatedObjectReference.getReferences());
            ObjectNode archiveUnitRelatedObjectReferenceNode = (ObjectNode)JsonHandler.toJsonNode((Object)archiveUnitRelatedObjectReference);
            archiveUnitNode.set("RelatedObjectReference", (JsonNode)archiveUnitRelatedObjectReferenceNode);
        }
    }

    private void fillArchiveUnitReference(IngestSession ingestSession, List<DataObjectOrArchiveUnitReferenceType> dataObjectOrArchiveUnitReference) {
        for (DataObjectOrArchiveUnitReferenceType relatedObjectReferenceItem : dataObjectOrArchiveUnitReference) {
            String externalReference;
            String repositoryObjectPID;
            String repositoryArchiveUnitPID;
            String archiveUnitRefId = relatedObjectReferenceItem.getArchiveUnitRefId();
            if (archiveUnitRefId != null && ingestSession.getUnitIdToGuid().containsKey(archiveUnitRefId)) {
                relatedObjectReferenceItem.setArchiveUnitRefId(ingestSession.getUnitIdToGuid().get(archiveUnitRefId));
            }
            if ((repositoryArchiveUnitPID = relatedObjectReferenceItem.getRepositoryArchiveUnitPID()) != null && ingestSession.getUnitIdToGuid().containsKey(repositoryArchiveUnitPID)) {
                relatedObjectReferenceItem.setRepositoryArchiveUnitPID(ingestSession.getUnitIdToGuid().get(repositoryArchiveUnitPID));
            }
            if ((repositoryObjectPID = relatedObjectReferenceItem.getRepositoryObjectPID()) != null && ingestSession.getUnitIdToGuid().containsKey(repositoryObjectPID)) {
                relatedObjectReferenceItem.setRepositoryObjectPID(ingestSession.getUnitIdToGuid().get(repositoryObjectPID));
            }
            if ((externalReference = relatedObjectReferenceItem.getExternalReference()) == null) continue;
            relatedObjectReferenceItem.setExternalReference(externalReference);
        }
    }

    private void bulkLifeCycleUnit(HandlerIO handlerIO, String containerId, List<String> uuids) throws LogbookClientBadRequestException, LogbookClientServerException {
        List collect = uuids.stream().filter(value -> handlerIO.getHelper().containsUpdate(value)).map(value -> new LogbookLifeCycleUnitModel(value, (Collection)handlerIO.getHelper().removeUpdateDelegate(value))).collect(Collectors.toList());
        try (LogbookLifeCyclesClient logbookLifeCycleClient = this.logbookLifeCyclesClientFactory.getClient();){
            logbookLifeCycleClient.bulkUnit(containerId, collect);
        }
        catch (LogbookClientAlreadyExistsException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private void bulkLifeCycleObjectGroup(HandlerIO handlerIO, String containerId, List<String> uuids) throws LogbookClientBadRequestException, LogbookClientServerException {
        List collect = uuids.stream().filter(value -> handlerIO.getHelper().containsCreate(value)).map(value -> new LogbookLifeCycleObjectGroupModel(value, (Collection)handlerIO.getHelper().removeCreateDelegate(value))).collect(Collectors.toList());
        try (LogbookLifeCyclesClient logbookLifeCycleClient = this.logbookLifeCyclesClientFactory.getClient();){
            logbookLifeCycleClient.bulkObjectGroup(containerId, collect);
        }
        catch (LogbookClientAlreadyExistsException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private void updateManagementAndAppendGlobalMgtRule(IngestContext ingestContext, IngestSession ingestSession, ObjectNode archiveUnit, Set<String> globalMgtIdExtra, boolean isRootArchive) throws InvalidParseOperationException {
        ObjectNode archiveUnitMgtNode;
        ObjectNode archiveUnitNode = (ObjectNode)archiveUnit.get(ARCHIVE_UNIT);
        ManagementModel archiveUnitManagementModel = archiveUnitNode.has("_mgt") && archiveUnitNode.get("_mgt") instanceof ObjectNode ? (ManagementModel)JsonHandler.getFromJsonNode((JsonNode)archiveUnitNode.get("_mgt"), ManagementModel.class) : new ManagementModel();
        for (String ruleId : globalMgtIdExtra) {
            StringWriter stringWriter = ingestSession.getMngtMdRuleIdToRulesXml().get(ruleId);
            JsonNode stringWriterNode = JsonHandler.getFromString((String)stringWriter.toString());
            JsonNode globalMgtRuleNode = stringWriterNode.get(GLOBAL_MGT_RULE_TAG);
            Iterator ruleTypes = globalMgtRuleNode.fieldNames();
            while (ruleTypes.hasNext()) {
                String ruleType = (String)ruleTypes.next();
                JsonNode globalMgtRuleTypeNode = globalMgtRuleNode.get(ruleType);
                if (globalMgtRuleTypeNode.isArray()) {
                    for (JsonNode globalMgtRuleTypeItemNode : globalMgtRuleTypeNode) {
                        this.mergeRule(globalMgtRuleTypeItemNode, archiveUnitManagementModel, ruleType);
                    }
                    continue;
                }
                this.mergeRule(globalMgtRuleTypeNode, archiveUnitManagementModel, ruleType);
            }
        }
        if (isRootArchive && archiveUnitManagementModel != null && ingestContext.getGlobalNeedAuthorization() != null && archiveUnitManagementModel.isNeedAuthorization() == null) {
            archiveUnitManagementModel.setNeedAuthorization(Boolean.valueOf(ingestContext.getGlobalNeedAuthorization()));
        }
        if ((archiveUnitMgtNode = (ObjectNode)JsonHandler.toJsonNode((Object)archiveUnitManagementModel)) != null) {
            for (RuleType ruleType : RuleType.values()) {
                String name = ruleType.name();
                if (archiveUnitMgtNode.get(name) == null || archiveUnitMgtNode.get(name).get(RULES) == null || archiveUnitMgtNode.get(name).get(RULES).size() != 0) continue;
                ObjectNode ruleNode = (ObjectNode)archiveUnitMgtNode.get(name);
                ruleNode.remove(RULES);
            }
        }
        archiveUnitNode.set("_mgt", (JsonNode)archiveUnitMgtNode);
    }

    private void mergeRule(JsonNode globalMgtRuleNode, ManagementModel archiveUnitManagementModel, String ruleType) throws InvalidParseOperationException {
        JsonNode finalAction;
        RuleCategoryModel ruleCategoryModel = archiveUnitManagementModel.getRuleCategoryModel(ruleType);
        if (ruleCategoryModel == null) {
            ruleCategoryModel = new RuleCategoryModel();
        }
        if (ruleCategoryModel.isPreventInheritance()) {
            return;
        }
        RuleModel ruleModel = (RuleModel)JsonHandler.getFromJsonNode((JsonNode)globalMgtRuleNode, RuleModel.class);
        if (ruleModel.getRule() != null) {
            if (ruleCategoryModel.getInheritance() != null && ruleCategoryModel.getInheritance().getPreventRulesId() != null && ruleCategoryModel.getInheritance().getPreventRulesId().contains(ruleModel.getRule())) {
                return;
            }
            ruleCategoryModel.getRules().add(ruleModel);
        }
        if (globalMgtRuleNode.has("PreventInheritance")) {
            ruleCategoryModel.setPreventInheritance(Boolean.valueOf(globalMgtRuleNode.get("PreventInheritance").asBoolean()));
        }
        if (globalMgtRuleNode.has("RefNonRuleId")) {
            if (globalMgtRuleNode.get("RefNonRuleId").isArray()) {
                for (JsonNode refNonRuleId : globalMgtRuleNode.get("RefNonRuleId")) {
                    ruleCategoryModel.addToPreventRulesId(refNonRuleId.asText());
                }
            } else {
                ruleCategoryModel.addToPreventRulesId(globalMgtRuleNode.get("RefNonRuleId").asText());
            }
        }
        if (globalMgtRuleNode.has("ClassificationLevel")) {
            ruleCategoryModel.setClassificationLevel(globalMgtRuleNode.get("ClassificationLevel").asText());
        }
        if (globalMgtRuleNode.has("ClassificationOwner")) {
            ruleCategoryModel.setClassificationOwner(globalMgtRuleNode.get("ClassificationOwner").asText());
        }
        if (globalMgtRuleNode.has("ClassificationAudience")) {
            ruleCategoryModel.setClassificationAudience(globalMgtRuleNode.get("ClassificationAudience").asText());
        }
        if (globalMgtRuleNode.has("ClassificationReassessingDate")) {
            ruleCategoryModel.setClassificationReassessingDate(globalMgtRuleNode.get("ClassificationReassessingDate").asText());
        }
        if (globalMgtRuleNode.has("NeedReassessingAuthorization")) {
            ruleCategoryModel.setNeedReassessingAuthorization(Boolean.valueOf(globalMgtRuleNode.get("NeedReassessingAuthorization").asBoolean()));
        }
        if ((finalAction = globalMgtRuleNode.get("FinalAction")) != null && ruleCategoryModel.getFinalAction() == null) {
            ruleCategoryModel.setFinalAction(finalAction.asText());
        }
        archiveUnitManagementModel.setRuleCategoryModel(ruleCategoryModel, ruleType);
    }

    private boolean attachmentByIngestContractAndManageRulesInformation(IngestContext ingestContext, IngestSession ingestSession, ObjectNode archiveUnit, String manifestUnitId, String unitGuid, Set<String> globalMgtIdExtra) {
        JsonNode archiveUps;
        ObjectNode workNode = JsonHandler.createObjectNode();
        ArrayNode upNode = JsonHandler.createArrayNode();
        boolean isUnitRoot = true;
        JsonNode archiveNode = ingestSession.getArchiveUnitTree().get(manifestUnitId);
        if (archiveNode != null && null != (archiveUps = archiveNode.get(ATTACHMENT_IDS)) && archiveUps.isArray() && archiveUps.size() > 0) {
            ArrayNode ups = (ArrayNode)archiveUps;
            for (JsonNode parent : ups) {
                upNode.add(ingestSession.getUnitIdToGuid().get(parent.asText()));
                boolean atLeastOneParentDoesNotExists = !ingestSession.getExistingUnitGuids().contains(parent.asText()) && !ingestSession.getExistingUnitGuids().contains(ingestSession.getUnitIdToGuid().get(parent.asText()));
                if (!atLeastOneParentDoesNotExists) continue;
                isUnitRoot = false;
            }
        }
        if (ingestContext.getIngestContract() != null && !Strings.isNullOrEmpty((String)ingestContext.getIngestContract().getLinkParentId()) && isUnitRoot) {
            upNode.add(ingestContext.getIngestContract().getLinkParentId());
        }
        workNode.set(ATTACHMENT_IDS, (JsonNode)upNode);
        ArrayNode rulesNode = JsonHandler.createArrayNode();
        globalMgtIdExtra.addAll(this.getMgtRulesToApplyByUnit(ingestSession, rulesNode, manifestUnitId, isUnitRoot));
        workNode.set("RulesToApply", (JsonNode)rulesNode);
        if (ingestSession.getExistingUnitGuids().contains(unitGuid)) {
            workNode.put("_existing", Boolean.TRUE);
        }
        archiveUnit.set("_work", (JsonNode)workNode);
        return isUnitRoot;
    }

    private void createUnitLifeCycle(HandlerIO handlerIO, IngestSession ingestSession, String unitGuid, String containerId) throws LogbookClientNotFoundException {
        if (ingestSession.getGuidToLifeCycleParameters().get(unitGuid) != null && !ingestSession.getExistingUnitGuids().contains(unitGuid)) {
            LogbookLifeCycleUnitParameters unitLifeCycle = this.createUnitLifeCycle(ingestSession.getGuidToLifeCycleParameters(), unitGuid, containerId, LogbookTypeProcess.INGEST);
            handlerIO.getHelper().updateDelegate((LogbookLifeCycleParameters)unitLifeCycle);
        }
    }

    private void addFinalStatusToUnitLifeCycle(HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, String unitGuid, String unitId, boolean isRootArchive) throws LogbookClientNotFoundException {
        if (ingestSession.getGuidToLifeCycleParameters().get(unitGuid) != null) {
            LogbookLifeCycleParameters llcp = ingestSession.getGuidToLifeCycleParameters().get(unitGuid);
            String eventId = GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).toString();
            LogbookLifeCycleParameters subLlcp = null;
            if (!ingestSession.getExistingUnitGuids().contains(unitGuid)) {
                subLlcp = LogbookLifeCyclesClientHelper.copy((LogbookLifeCycleParameters)llcp);
                subLlcp.putParameterValue(LogbookParameterName.eventIdentifier, GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).toString());
                subLlcp.putParameterValue(LogbookParameterName.parentEventIdentifier, eventId);
                subLlcp.setFinalStatus(HANDLER_ID, "LFC_CREATION", StatusCode.OK, null, new String[0]);
            }
            llcp.putParameterValue(LogbookParameterName.eventIdentifier, eventId);
            llcp.setFinalStatus(HANDLER_ID, null, StatusCode.OK, null, new String[0]);
            Set<String> parentAttachments = this.existAttachmentUnitAsParentOnTree(ingestSession, unitId);
            if (isRootArchive && ingestContext.getIngestContract() != null && ingestContext.getIngestContract().getLinkParentId() != null) {
                parentAttachments.add(ingestContext.getIngestContract().getLinkParentId());
            }
            ObjectNode evDetData = JsonHandler.createObjectNode();
            if (!parentAttachments.isEmpty()) {
                ArrayNode arrayNode = JsonHandler.createArrayNode();
                parentAttachments.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
                evDetData.set(ATTACHMENT_IDS, (JsonNode)arrayNode);
            }
            if (ingestSession.getUnitIdToGroupId().containsKey(unitId) && ingestSession.getExistingGOTs().containsKey(ingestSession.getUnitIdToGroupId().get(unitId))) {
                evDetData.put(OBJECT_GROUP_ID, ingestSession.getUnitIdToGroupId().get(unitId));
            }
            try {
                String wellFormedJson = JsonHandler.writeAsString((Object)evDetData);
                llcp.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error("unable to generate evDetData, incomplete journal generation", (Throwable)e);
            }
            handlerIO.getHelper().updateDelegate(llcp);
            if (!ingestSession.getExistingUnitGuids().contains(unitGuid)) {
                handlerIO.getHelper().updateDelegate(subLlcp);
            }
        }
    }

    private LogbookLifeCycleUnitParameters createUnitLifeCycle(Map<String, LogbookLifeCycleParameters> guidToLifeCycleParameters, String unitGuid, String containerId, LogbookTypeProcess logbookTypeProcess) {
        LogbookLifeCycleUnitParameters logbookLifecycleUnitParameters = (LogbookLifeCycleUnitParameters)this.initLogbookLifeCycleParameters(guidToLifeCycleParameters, unitGuid, true, false);
        logbookLifecycleUnitParameters.setFinalStatus("LFC_CREATION", null, StatusCode.OK, null, new String[0]);
        logbookLifecycleUnitParameters.putParameterValue(LogbookParameterName.eventIdentifierProcess, containerId);
        logbookLifecycleUnitParameters.putParameterValue(LogbookParameterName.eventIdentifier, GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).toString());
        logbookLifecycleUnitParameters.putParameterValue(LogbookParameterName.eventTypeProcess, logbookTypeProcess.name());
        return logbookLifecycleUnitParameters;
    }

    private Set<String> existAttachmentUnitAsParentOnTree(IngestSession ingestSession, String unitId) {
        JsonNode archiveUps;
        JsonNode archiveNode;
        HashSet<String> parents = new HashSet<String>();
        if (ingestSession.getArchiveUnitTree().has(unitId) && (archiveNode = ingestSession.getArchiveUnitTree().get(unitId)).has(ATTACHMENT_IDS) && (archiveUps = archiveNode.get(ATTACHMENT_IDS)).isArray() && archiveUps.size() > 0) {
            ArrayNode archiveUpsArray = (ArrayNode)archiveUps;
            for (JsonNode jsonNode : archiveUpsArray) {
                String archiveUnitId = jsonNode.textValue();
                String guid = ingestSession.getUnitIdToGuid().get(archiveUnitId);
                if (!ingestSession.getExistingUnitGuids().contains(guid)) continue;
                parents.add(guid);
            }
        }
        return parents;
    }

    private Set<String> getMgtRulesToApplyByUnit(IngestSession ingestSession, ArrayNode rulesNode, String manifestUnitId, boolean isRootArchive) {
        String listRulesForCurrentUnit = "";
        if (ingestSession.getUnitIdToSetOfRuleId() != null && ingestSession.getUnitIdToSetOfRuleId().containsKey(manifestUnitId)) {
            listRulesForCurrentUnit = this.getListOfRulesFormater(ingestSession.getUnitIdToSetOfRuleId().get(manifestUnitId));
        }
        String listRulesForAuRoot = "";
        HashSet<String> globalMgtIdExtra = new HashSet<String>();
        if (isRootArchive) {
            if (ingestSession.getMngtMdRuleIdToRulesXml() != null && !ingestSession.getMngtMdRuleIdToRulesXml().isEmpty()) {
                globalMgtIdExtra.addAll(ingestSession.getMngtMdRuleIdToRulesXml().keySet());
            }
            if (!globalMgtIdExtra.isEmpty() && ingestSession.getUnitIdToSetOfRuleId() != null && ingestSession.getUnitIdToSetOfRuleId().get(manifestUnitId) != null && !ingestSession.getUnitIdToSetOfRuleId().get(manifestUnitId).isEmpty()) {
                globalMgtIdExtra.removeAll((Collection)ingestSession.getUnitIdToSetOfRuleId().get(manifestUnitId));
            }
            if (!globalMgtIdExtra.isEmpty()) {
                listRulesForAuRoot = this.getListOfRulesFormater(globalMgtIdExtra);
            }
        }
        StringBuilder rules = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)listRulesForCurrentUnit)) {
            rules.append(listRulesForCurrentUnit);
        }
        if (!Strings.isNullOrEmpty((String)listRulesForAuRoot)) {
            rules.append(listRulesForAuRoot);
        }
        if (ParametersChecker.isNotEmpty((String[])new String[]{rules.toString()})) {
            rulesNode.add(rules.toString());
        }
        return globalMgtIdExtra;
    }

    private String getListOfRulesFormater(Set<String> rulesId) {
        StringBuilder sbRules = new StringBuilder();
        if (rulesId != null) {
            for (String ruleId : rulesId) {
                sbRules.append(ruleId).append(";");
            }
        }
        return sbRules.toString();
    }

    private void checkArchiveUnitIdReference(IngestSession ingestSession, String llcEvDetData) throws ProcessingException {
        if (ingestSession.getUnitIdToGroupId() != null && !ingestSession.getUnitIdToGroupId().isEmpty()) {
            for (Map.Entry<String, String> entry : ingestSession.getUnitIdToGroupId().entrySet()) {
                if (ingestSession.getObjectGroupIdToGuid().get(entry.getValue()) != null) continue;
                String groupId = ingestSession.getDataObjectIdToObjectGroupId().get(entry.getValue());
                if (Strings.isNullOrEmpty((String)groupId)) {
                    throw new ProcessingException("Archive Unit references a BDO Id but is not correct");
                }
                if (groupId.equals(entry.getValue())) continue;
                throw new ArchiveUnitContainDataObjectException("The archive unit " + entry.getKey() + " references one BDO Id " + entry.getValue() + " while this BDO has a GOT id " + groupId, entry.getKey(), entry.getValue(), groupId, llcEvDetData);
            }
        }
    }

    private void createObjectGroupLifeCycle(HandlerIO handlerIO, Map<String, LogbookLifeCycleParameters> guidToLifeCycleParameters, String groupGuid, String containerId, LogbookTypeProcess typeProcess) throws LogbookClientAlreadyExistsException {
        LogbookLifeCycleObjectGroupParameters logbookLifecycleObjectGroupParameters = (LogbookLifeCycleObjectGroupParameters)this.initLogbookLifeCycleParameters(guidToLifeCycleParameters, groupGuid, false, true);
        logbookLifecycleObjectGroupParameters.setFinalStatus("LFC_CREATION", null, StatusCode.OK, null, new String[0]);
        logbookLifecycleObjectGroupParameters.putParameterValue(LogbookParameterName.eventIdentifierProcess, containerId);
        logbookLifecycleObjectGroupParameters.putParameterValue(LogbookParameterName.eventIdentifier, GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).toString());
        logbookLifecycleObjectGroupParameters.putParameterValue(LogbookParameterName.eventTypeProcess, typeProcess.name());
        handlerIO.getHelper().createDelegate((LogbookLifeCycleParameters)logbookLifecycleObjectGroupParameters);
        guidToLifeCycleParameters.put(groupGuid, (LogbookLifeCycleParameters)logbookLifecycleObjectGroupParameters);
    }

    private void createIngestLevelStackFile(HandlerIO handlerIO, IngestSession ingestSession, Map<Integer, Set<String>> levelStackMap, int rank) throws ProcessingException {
        LOGGER.debug("Begin createIngestLevelStackFile/containerId: ", (Object)handlerIO.getContainerName());
        ParametersChecker.checkParameter((String)"levelStackMap is a mandatory parameter", (Object[])new Object[]{levelStackMap});
        ParametersChecker.checkParameter((String)"unitIdToGuid is a mandatory parameter", (Object[])new Object[]{ingestSession.getUnitIdToGuid()});
        try {
            File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(rank).getPath());
            ObjectNode ingestLevelStack = JsonHandler.createObjectNode();
            for (Map.Entry<Integer, Set<String>> entry : levelStackMap.entrySet()) {
                ArrayNode unitList = ingestLevelStack.withArray(LEVEL + entry.getKey());
                Set<String> unitGuidList = entry.getValue();
                HashSet<String> alreadyAdded = new HashSet<String>();
                for (String idXml : unitGuidList) {
                    String unitGuid = ingestSession.getUnitIdToGuid().get(idXml);
                    if (unitGuid == null) {
                        throw new IllegalArgumentException("Unit guid not found in map");
                    }
                    if (ingestSession.getExistingUnitGuids().contains(unitGuid) || alreadyAdded.contains(unitGuid)) continue;
                    alreadyAdded.add(unitGuid);
                    unitList.add(unitGuid);
                }
                ingestLevelStack.set(LEVEL + entry.getKey(), (JsonNode)unitList);
            }
            LOGGER.debug("IngestLevelStack: {}", (Object)ingestLevelStack);
            JsonHandler.writeAsFile((Object)ingestLevelStack, (File)tempFile);
            handlerIO.addOutputResult(rank, (Object)tempFile, true, true);
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(e);
            throw new ProcessingException(e);
        }
        LOGGER.info("End createIngestLevelStackFile/containerId:" + handlerIO.getContainerName());
    }

    private LogbookParameters initLogbookLifeCycleParameters(Map<String, LogbookLifeCycleParameters> guidToLifeCycleParameters, String guid, boolean isArchive, boolean isObjectGroup) {
        LogbookParameters logbookLifeCycleParameters = (LogbookParameters)guidToLifeCycleParameters.get(guid);
        if (logbookLifeCycleParameters == null) {
            logbookLifeCycleParameters = isArchive ? LogbookParameterHelper.newLogbookLifeCycleUnitParameters() : (isObjectGroup ? LogbookParameterHelper.newLogbookLifeCycleObjectGroupParameters() : LogbookParameterHelper.newLogbookOperationParameters());
            logbookLifeCycleParameters.putParameterValue(LogbookParameterName.objectIdentifier, guid);
        }
        return logbookLifeCycleParameters;
    }

    private void checkMasterIsMandatoryAndCheckCanAddObjectToExistingObjectGroup(IngestSession ingestSession, IngestContractModel ingestContract) throws ProcessingException {
        Set<String> updatedObjectGroupIds = this.getUpdatedObjectGroupIds(ingestSession);
        this.checkMasterMandatory(ingestSession, ingestContract, updatedObjectGroupIds);
        this.checkIngestContractForObjectGroupAttachment(ingestSession, ingestContract, ingestSession.getUsageToObjectGroupId(), updatedObjectGroupIds);
    }

    private Set<String> getUpdatedObjectGroupIds(IngestSession ingestSession) {
        Set updatedUnitsId = ingestSession.getUnitIdToGuid().keySet().stream().filter(unitId -> ingestSession.getExistingUnitIdWithExistingObjectGroup().containsKey(ingestSession.getUnitIdToGuid().get(unitId))).collect(Collectors.toSet());
        return ingestSession.getUnitIdToGroupId().entrySet().stream().filter(entry -> updatedUnitsId.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    private void checkMasterMandatory(IngestSession ingestSession, IngestContractModel contract, Set<String> updatedObjectGroupIds) throws ProcessingObjectGroupMasterMandatoryException {
        List objectIdWithoutMaster;
        List objectIdWithoutUpdatedOG;
        if (contract.isMasterMandatory() && !(objectIdWithoutUpdatedOG = (objectIdWithoutMaster = ingestSession.getDataObjectGroupMasterMandatory().entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList())).stream().filter(objectId -> !updatedObjectGroupIds.contains(objectId)).collect(Collectors.toList())).isEmpty()) {
            String objectGroupsId = String.join((CharSequence)" , ", objectIdWithoutMaster);
            throw new ProcessingObjectGroupMasterMandatoryException(String.format("BinaryMaster or PhysicalMaster is not present for objectGroup : %s", objectGroupsId), objectGroupsId);
        }
    }

    private void checkIngestContractForObjectGroupAttachment(IngestSession ingestSession, IngestContractModel contract, Multimap<String, String> usages, Set<String> updatedObjectGroupIds) throws ProcessingObjectGroupEveryDataObjectVersionException {
        if (!ingestSession.getExistingUnitIdWithExistingObjectGroup().isEmpty() && !contract.isEveryDataObjectVersion()) {
            Set usageInObjectVersion;
            Set dataObjectVersion = contract.getDataObjectVersion();
            if (dataObjectVersion != null && !dataObjectVersion.isEmpty() && (usageInObjectVersion = usages.asMap().entrySet().stream().filter(entry -> dataObjectVersion.contains(entry.getKey())).map(entry -> {
                HashSet values = new HashSet((Collection)entry.getValue());
                List updatedObjectGroupGuids = updatedObjectGroupIds.stream().map(e -> ingestSession.getObjectGroupIdToGuid().get(e)).collect(Collectors.toList());
                values.retainAll(updatedObjectGroupGuids);
                return new AbstractMap.SimpleEntry((String)entry.getKey(), values);
            }).filter(entry -> !((Set)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet())).size() == dataObjectVersion.size()) {
                return;
            }
            ArrayList ogId = new ArrayList();
            ingestSession.getExistingUnitIdWithExistingObjectGroup().keySet().forEach(unitGuid -> ingestSession.getUnitIdToGuid().entrySet().stream().filter(entry -> ((String)entry.getValue()).contains((CharSequence)unitGuid)).findFirst().ifPresent(unitmap -> ogId.add(ingestSession.getUnitIdToGroupId().get(unitmap.getKey()))));
            String objectGroupsId = String.join((CharSequence)" , ", ogId);
            String unitsId = String.join((CharSequence)" , ", ingestSession.getExistingUnitIdWithExistingObjectGroup().keySet());
            throw new ProcessingObjectGroupEveryDataObjectVersionException("Ingest Contract don't authorized ObjectGroup attachment", unitsId, objectGroupsId);
        }
    }

    private void saveObjectGroupsToWorkspace(HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, JsonLineDataBase objectsDatabase, JsonNode storageObjectGroupInfo, JsonNode storageObjectInfo) throws ProcessingException {
        boolean existingGot = false;
        HashMap<String, ObjectNode> listObjectToValidate = new HashMap<String, ObjectNode>();
        try {
            HandlerUtils.saveMap(handlerIO, ingestSession.getDataObjectIdToObjectGroupId(), 1, true, true);
            HandlerUtils.saveMap(handlerIO, ingestSession.getObjectGroupIdToGuid(), 3, true, true);
            handlerIO.addOutputResult(8, ingestSession.getObjectGroupIdToGuid(), true);
        }
        catch (IOException e1) {
            LOGGER.error("Can not write to tmp folder ", (Throwable)e1);
            throw new ProcessingException((Throwable)e1);
        }
        try {
            if (handlerIO.removeFolder("ObjectGroup")) {
                LOGGER.warn("Folder has been deleted, it's a replay for this operation : " + ingestContext.getOperationId());
            }
        }
        catch (ContentAddressableStorageException e1) {
            LOGGER.warn("Couldn't delete folder", (Throwable)e1);
        }
        ArrayList<String> uuids = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : ingestSession.getObjectGroupIdToDataObjectId().entrySet()) {
            ObjectNode objectGroup = JsonHandler.createObjectNode();
            ObjectNode fileInfo = JsonHandler.createObjectNode();
            ArrayNode unitParent = JsonHandler.createArrayNode();
            String objectGroupType = "";
            String unitParentGUID = null;
            if (ingestSession.getObjectGroupIdToUnitId() != null && ingestSession.getObjectGroupIdToUnitId().size() != 0 && ingestSession.getObjectGroupIdToUnitId().get(entry.getKey()) != null) {
                for (String unitId : ingestSession.getObjectGroupIdToUnitId().get(entry.getKey())) {
                    if (ingestSession.getUnitIdToGuid().get(unitId) == null) continue;
                    unitParentGUID = ingestSession.getUnitIdToGuid().get(unitId);
                    unitParent.add(unitParentGUID);
                }
            }
            String objectGroupGuid = ingestSession.getObjectGroupIdToGuid().get(entry.getKey());
            if (ingestSession.getExistingUnitIdWithExistingObjectGroup().containsKey(unitParentGUID)) {
                existingGot = true;
                objectGroupGuid = ingestSession.getExistingUnitIdWithExistingObjectGroup().get(unitParentGUID);
                ingestSession.getObjectGroupIdToGuid().put(entry.getKey(), objectGroupGuid);
            }
            File tmpFile = handlerIO.getNewLocalFile(objectGroupGuid + JSON_EXTENSION);
            uuids.add(objectGroupGuid);
            try {
                boolean isCreation;
                List events;
                HashMap<String, List<JsonNode>> categoryMap = new HashMap<String, List<JsonNode>>();
                objectGroup.put("_id", objectGroupGuid);
                objectGroup.put("_tenant", ParameterHelper.getTenantParameter());
                ArrayList<Object> versionList = new ArrayList<Object>();
                for (int index = 0; index < entry.getValue().size(); ++index) {
                    String id = entry.getValue().get(index);
                    JsonNode dataObjectNode = objectsDatabase.read(ingestSession.getDataObjectIdToGuid().get(id));
                    boolean isPhysical = ingestSession.getPhysicalDataObjetsGuids().contains(ingestSession.getDataObjectIdToGuid().get(id));
                    ((ObjectNode)dataObjectNode).put("DataObjectGroupId", objectGroupGuid);
                    String nodeCategory = "";
                    if (dataObjectNode.get("DataObjectVersion") != null) {
                        nodeCategory = dataObjectNode.get("DataObjectVersion").asText();
                    }
                    if (Strings.isNullOrEmpty((String)nodeCategory)) {
                        nodeCategory = isPhysical ? PHYSICAL_MASTER : BINARY_MASTER;
                    }
                    ArrayList<JsonNode> nodeCategoryArray = (ArrayList<JsonNode>)categoryMap.get(nodeCategory);
                    String[] array = nodeCategory.split("_");
                    Object nodeCategoryNumbered = nodeCategory;
                    if (array.length == 1) {
                        nodeCategoryNumbered = nodeCategory + "_1";
                        ((ObjectNode)dataObjectNode).put("DataObjectVersion", (String)nodeCategoryNumbered);
                    }
                    if (versionList.contains(nodeCategoryNumbered)) {
                        LOGGER.error(DATA_OBJECT_VERSION_MUST_BE_UNIQUE);
                        throw new ProcessingDuplicatedVersionException(DATA_OBJECT_VERSION_MUST_BE_UNIQUE);
                    }
                    versionList.add(nodeCategoryNumbered);
                    if (BINARY_MASTER_1.equals(nodeCategoryNumbered)) {
                        fileInfo = (ObjectNode)dataObjectNode.get(FILE_INFO);
                        if (dataObjectNode.get(METADATA) != null && !dataObjectNode.get(METADATA).isNull() && !dataObjectNode.get(METADATA).isEmpty()) {
                            objectGroupType = (String)dataObjectNode.get(METADATA).fieldNames().next();
                        }
                    }
                    if (nodeCategoryArray == null) {
                        nodeCategoryArray = new ArrayList<JsonNode>();
                        nodeCategoryArray.add(dataObjectNode);
                    } else {
                        int dataObjectNodePosition = Integer.parseInt(nodeCategory.split("_")[1]) - 1;
                        nodeCategoryArray.add(dataObjectNodePosition, dataObjectNode);
                    }
                    categoryMap.put((String)nodeCategoryNumbered, nodeCategoryArray);
                }
                File newLocalFile = handlerIO.getNewLocalFile(objectGroupGuid + "_logbook_OG.json");
                if (newLocalFile.exists() && !(events = (List)JsonHandler.getFromFileAsTypeReference((File)newLocalFile, LIST_TYPE_REFERENCE)).isEmpty()) {
                    this.createExternalLifeCycleLogbook(handlerIO, events, ingestContext.getOperationId(), objectGroupGuid);
                }
                objectGroup.put("_profil", objectGroupType);
                objectGroup.set(FILE_INFO, (JsonNode)fileInfo);
                boolean bl = isCreation = !existingGot;
                if (isCreation) {
                    this.checkFirstMasterVersion(DataObjectVersionType.BINARY_MASTER, categoryMap.keySet());
                    this.checkFirstMasterVersion(DataObjectVersionType.PHYSICAL_MASTER, categoryMap.keySet());
                }
                ArrayNode qualifiersNode = this.getObjectGroupQualifiers(ingestSession, categoryMap, ingestContext.getOperationId());
                this.fillManagementContractForObjects(categoryMap, ingestContext.getManagementContractModel());
                this.persistentIdentifierGenerationService.handlePersistentIdentifierForGot(categoryMap, ingestContext.getManagementContractModel(), PersistentIdentifierPolicyTypeEnum.ARK);
                objectGroup.set("_qualifiers", (JsonNode)qualifiersNode);
                ObjectNode workNode = this.getObjectGroupWork(ingestSession, categoryMap, ingestContext.getOperationId(), storageObjectInfo);
                objectGroup.set("_work", (JsonNode)workNode);
                objectGroup.set(ATTACHMENT_IDS, (JsonNode)unitParent);
                objectGroup.put("_nbc", entry.getValue().size());
                objectGroup.putArray("_ops").add(ingestContext.getOperationId());
                objectGroup.put("_opi", ingestContext.getOperationId());
                objectGroup.put("_sp", ingestContext.getOriginatingAgency());
                objectGroup.set("_sps", (JsonNode)JsonHandler.createArrayNode().add(ingestContext.getOriginatingAgency()));
                ObjectNode storageObjectGroup = JsonHandler.createObjectNode();
                storageObjectGroup.put("strategyId", storageObjectGroupInfo.get("strategyId").asText());
                objectGroup.set("_storage", (JsonNode)storageObjectGroup);
                if (existingGot) {
                    String existingOg = ingestSession.getExistingUnitIdWithExistingObjectGroup().get(unitParentGUID);
                    workNode.put("DataObjectGroupExistingReferenceId", existingOg);
                    if (existingOg != null) {
                        listObjectToValidate.put(existingOg, objectGroup);
                    }
                }
                JsonHandler.writeAsFile((Object)objectGroup, (File)tmpFile);
                handlerIO.transferFileToWorkspace("ObjectGroup/" + objectGroupGuid + JSON_EXTENSION, tmpFile, true, true);
                this.createObjectGroupLifeCycle(handlerIO, ingestSession.getGuidToLifeCycleParameters(), objectGroupGuid, ingestContext.getOperationId(), ingestContext.getTypeProcess());
                if (!existingGot) {
                    String eventId = GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).toString();
                    handlerIO.getHelper().updateDelegate((LogbookLifeCycleParameters)((LogbookLifeCycleObjectGroupParameters)ingestSession.getGuidToLifeCycleParameters().get(objectGroupGuid).setFinalStatus(HANDLER_ID, null, StatusCode.OK, null, new String[0]).putParameterValue(LogbookParameterName.eventIdentifier, eventId)));
                    handlerIO.getHelper().updateDelegate((LogbookLifeCycleParameters)((LogbookLifeCycleObjectGroupParameters)ingestSession.getGuidToLifeCycleParameters().get(objectGroupGuid).setFinalStatus(HANDLER_ID, "LFC_CREATION", StatusCode.OK, null, new String[0]).putParameterValue(LogbookParameterName.eventIdentifier, GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).toString()).putParameterValue(LogbookParameterName.parentEventIdentifier, eventId)));
                }
                if (uuids.size() != 50) continue;
                this.bulkLifeCycleObjectGroup(handlerIO, ingestContext.getOperationId(), uuids);
                uuids.clear();
            }
            catch (InvalidParseOperationException e) {
                LOGGER.error("Can not parse ObjectGroup", (Throwable)e);
                throw new ProcessingException((Throwable)e);
            }
            catch (LogbookClientBadRequestException e) {
                LOGGER.error(LOGBOOK_LF_BAD_REQUEST_EXCEPTION_MSG, (Throwable)e);
                throw new ProcessingException((Throwable)e);
            }
            catch (LogbookClientAlreadyExistsException e) {
                LOGGER.error(LOGBOOK_LF_OBJECT_EXISTS_EXCEPTION_MSG, (Throwable)e);
                throw new ProcessingException((Throwable)e);
            }
            catch (LogbookClientServerException e) {
                LOGGER.error(LOGBOOK_SERVER_INTERNAL_EXCEPTION_MSG, (Throwable)e);
                throw new ProcessingException((Throwable)e);
            }
            catch (LogbookClientNotFoundException e) {
                LOGGER.error(LOGBOOK_LF_RESOURCE_NOT_FOUND_EXCEPTION_MSG, (Throwable)e);
                throw new ProcessingException((Throwable)e);
            }
        }
        if (!uuids.isEmpty()) {
            try {
                this.bulkLifeCycleObjectGroup(handlerIO, ingestContext.getOperationId(), uuids);
                uuids.clear();
            }
            catch (LogbookClientBadRequestException | LogbookClientServerException e) {
                throw new VitamRuntimeException(e);
            }
        }
        this.manageExistingObjectGroups(handlerIO, ingestContext, ingestSession, uuids);
        if (!listObjectToValidate.isEmpty()) {
            try {
                this.checkOriginatingAgencyAttachementConformity(ingestContext.getOriginatingAgency(), listObjectToValidate);
            }
            catch (ProcessingStatusException e) {
                throw new ProcessingException((Throwable)e);
            }
        }
    }

    private void fillManagementContractForObjects(Map<String, List<JsonNode>> categoryMap, ManagementContractModel managementContractModel) {
        if (Objects.isNull(managementContractModel)) {
            return;
        }
        if (ActivationStatus.INACTIVE.equals((Object)managementContractModel.getStatus())) {
            return;
        }
        for (Map.Entry<String, List<JsonNode>> entry : categoryMap.entrySet()) {
            for (JsonNode nodeQualifier : entry.getValue()) {
                ObjectNode nodeQualifierOb = (ObjectNode)nodeQualifier;
                nodeQualifierOb.put(MANAGEMENT_CONTRACT_ID_FIELD, managementContractModel.getIdentifier());
            }
        }
    }

    private void checkFirstMasterVersion(DataObjectVersionType qualifier, Set<String> qualifiers) throws MissingMandatoryVersionException {
        boolean hasAtLeastOneQualifier = qualifiers.stream().anyMatch(key -> key.startsWith(qualifier.getName()));
        boolean hasFirstQualifierVersion = qualifiers.contains(qualifier.getName() + "_1");
        if (hasAtLeastOneQualifier && !hasFirstQualifierVersion) {
            throw new MissingMandatoryVersionException("The object group (" + qualifier.getName() + ") requires Mandatory version 1 to be present");
        }
    }

    private void checkOriginatingAgencyAttachementConformity(String originatingAgency, Map<String, ObjectNode> listObjectToValidate) throws ProcessingStatusException, ProcessingNotValidLinkingException {
        Set<String> objectGroupIds = listObjectToValidate.keySet();
        boolean objectGroupsExistedIdsWithSp = this.loadExistingObjectGroups(originatingAgency, objectGroupIds);
        if (!objectGroupsExistedIdsWithSp) {
            throw new ProcessingNotValidLinkingException("Not allowed object attachement of originating agency (" + originatingAgency + ") to other originating agency");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadExistingObjectGroups(String originatingAgency, Set<String> objectGroupIds) throws ProcessingStatusException {
        try (MetaDataClient client = this.metaDataClientFactory.getClient();){
            for (List ids : ListUtils.partition(new ArrayList<String>(objectGroupIds), (int)1000)) {
                SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
                selectMultiQuery.addRoots(ids.toArray(new String[0]));
                selectMultiQuery.addQueries(new Query[]{QueryParserHelper.ne((String)VitamFieldsHelper.originatingAgency(), (String)originatingAgency)});
                ObjectNode objectNode = JsonHandler.createObjectNode();
                objectNode.put(VitamFieldsHelper.originatingAgency(), 1);
                objectNode.put(VitamFieldsHelper.id(), 1);
                JsonNode projection = JsonHandler.createObjectNode().set("$fields", (JsonNode)objectNode);
                selectMultiQuery.setProjection(projection);
                JsonNode jsonNode = client.selectObjectGroups((JsonNode)selectMultiQuery.getFinalSelect());
                RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)jsonNode);
                if (requestResponseOK.getResults().isEmpty()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load object groups", e);
        }
    }

    private void manageExistingObjectGroups(HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, List<String> uuids) throws ProcessingException {
        HashSet<String> toIgnore = new HashSet<String>();
        if (!ingestSession.getExistingGOTs().isEmpty()) {
            try (LogbookLifeCyclesClient logbookLifeCyclesClient = this.logbookLifeCyclesClientFactory.getClient();){
                for (List partition : Lists.partition(new ArrayList<String>(ingestSession.getExistingGOTs().keySet()), (int)VitamConfiguration.getBatchSize())) {
                    Select select = new Select();
                    InQuery evId = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])((String[])partition.toArray(String[]::new)));
                    select.setQuery((Query)evId);
                    select.addUsedProjection(new String[]{VitamFieldsHelper.id(), "obId", "evIdProc"});
                    JsonNode request = logbookLifeCyclesClient.selectObjectGroupLifeCycle((JsonNode)select.getFinalSelect(), LifeCycleStatusCode.LIFE_CYCLE_IN_PROCESS);
                    RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)request);
                    for (JsonNode json : requestResponseOK.getResults()) {
                        if (!json.get("evIdProc").asText().equals(handlerIO.getContainerName())) {
                            throw new ProcessingObjectGroupLifeCycleException(LOGBOOK_LF_OBJECT_EXISTS_EXCEPTION_MSG, json.get("obId").asText());
                        }
                        toIgnore.add(json.get(VitamFieldsHelper.id()).asText());
                    }
                }
            }
            catch (LogbookClientNotFoundException e2) {
                LOGGER.debug("No logbook currently in process");
            }
            catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e3) {
                LOGGER.error(e3.getMessage(), e3);
                throw new ProcessingException(e3);
            }
        }
        Set collect = ingestSession.getExistingGOTs().entrySet().stream().filter(e -> e.getValue() != null).map(Map.Entry::getKey).filter(Predicate.not(toIgnore::contains)).map(e -> e + JSON_EXTENSION).collect(Collectors.toSet());
        File existingGotsFile = handlerIO.getNewLocalFile(handlerIO.getOutput(9).getPath());
        try {
            JsonHandler.writeAsFile(collect, (File)existingGotsFile);
        }
        catch (InvalidParseOperationException e4) {
            throw new ProcessingException((Throwable)e4);
        }
        handlerIO.addOutputResult(9, (Object)existingGotsFile, true, false);
        for (String gotGuid : ingestSession.getExistingGOTs().keySet()) {
            try {
                JsonNode existingGot = ingestSession.getExistingGOTs().get(gotGuid);
                if (existingGot == null) continue;
                uuids.add(gotGuid);
                this.createObjectGroupLifeCycle(handlerIO, ingestSession.getGuidToLifeCycleParameters(), gotGuid, ingestContext.getOperationId(), ingestContext.getTypeProcess());
                if (uuids.size() != 50) continue;
                this.bulkLifeCycleObjectGroup(handlerIO, ingestContext.getOperationId(), uuids);
                uuids.clear();
            }
            catch (LogbookClientBadRequestException e5) {
                LOGGER.error(LOGBOOK_LF_BAD_REQUEST_EXCEPTION_MSG, (Throwable)e5);
                throw new ProcessingException((Throwable)e5);
            }
            catch (LogbookClientServerException e6) {
                LOGGER.error(LOGBOOK_SERVER_INTERNAL_EXCEPTION_MSG, (Throwable)e6);
                throw new ProcessingException((Throwable)e6);
            }
            catch (LogbookClientAlreadyExistsException e7) {
                LOGGER.error(LOGBOOK_LF_OBJECT_EXISTS_EXCEPTION_MSG, (Throwable)e7);
                throw new ProcessingException((Throwable)e7);
            }
        }
        if (!uuids.isEmpty()) {
            try {
                this.bulkLifeCycleObjectGroup(handlerIO, ingestContext.getOperationId(), uuids);
                uuids.clear();
            }
            catch (LogbookClientBadRequestException | LogbookClientServerException e8) {
                throw new VitamRuntimeException(e8);
            }
        }
    }

    private ArrayNode getObjectGroupQualifiers(IngestSession ingestSession, Map<String, List<JsonNode>> categoryMap, String containerId) {
        ArrayNode qualifiersArray = JsonHandler.createArrayNode();
        for (Map.Entry<String, List<JsonNode>> entry : categoryMap.entrySet()) {
            ArrayNode arrayNode;
            String qualifier = entry.getKey().contains("_") ? entry.getKey().split("_")[0] : entry.getKey();
            ObjectNode objectNode = this.findQualifierObjectNode(qualifiersArray, qualifier);
            if (objectNode == null) {
                objectNode = JsonHandler.createObjectNode();
                objectNode.put("qualifier", qualifier);
                objectNode.put("_nbc", 0);
                arrayNode = JsonHandler.createArrayNode();
                objectNode.set("versions", (JsonNode)arrayNode);
                qualifiersArray.add((JsonNode)objectNode);
            }
            arrayNode = (ArrayNode)objectNode.get("versions");
            for (JsonNode node : entry.getValue()) {
                String id = node.findValue("_id").textValue();
                String guid = ingestSession.getDataObjectIdToGuid().get(id);
                this.updateObjectNode(ingestSession, (ObjectNode)node, guid, PHYSICAL_MASTER.equals(qualifier), containerId);
                arrayNode.add(node);
                objectNode.put("_nbc", objectNode.get("_nbc").asInt() + 1);
            }
        }
        for (JsonNode qualifierData : qualifiersArray) {
            ArrayNode versions = (ArrayNode)qualifierData.get("versions");
            List sortedVersions = StreamSupport.stream(versions.spliterator(), false).sorted(Comparator.comparing(this::getVersionNumber)).collect(Collectors.toList());
            versions.removeAll();
            versions.addAll(sortedVersions);
        }
        return qualifiersArray;
    }

    private int getVersionNumber(JsonNode versionNode) {
        String dataObjectVersion = versionNode.get("DataObjectVersion").asText();
        return Integer.parseInt(dataObjectVersion.split("_")[1]);
    }

    private ObjectNode findQualifierObjectNode(ArrayNode qualifiersArray, String qualifier) {
        for (JsonNode node : qualifiersArray) {
            if (!node.has("qualifier") || !node.get("qualifier").textValue().equals(qualifier)) continue;
            return (ObjectNode)node;
        }
        return null;
    }

    private ObjectNode getObjectGroupWork(IngestSession ingestSession, Map<String, List<JsonNode>> categoryMap, String containerId, JsonNode storageObjectInfo) {
        ObjectNode workObject = JsonHandler.createObjectNode();
        ObjectNode qualifierObject = JsonHandler.createObjectNode();
        for (Map.Entry<String, List<JsonNode>> entry : categoryMap.entrySet()) {
            ObjectNode dataObjectNode = JsonHandler.createObjectNode();
            dataObjectNode.put("_nbc", entry.getValue().size());
            ArrayNode arrayNode = JsonHandler.createArrayNode();
            for (JsonNode node : entry.getValue()) {
                ObjectNode objectNode = JsonHandler.createObjectNode();
                String id = node.findValue("_id").textValue();
                boolean phsyical = ingestSession.getPhysicalDataObjetsGuids().contains(id);
                this.updateObjectNode(ingestSession, objectNode, id, phsyical, containerId);
                if (phsyical) {
                    objectNode.set("PhysicalId", node.get("PhysicalId"));
                } else {
                    ObjectNode storageObject = JsonHandler.createObjectNode();
                    storageObject.put("strategyId", storageObjectInfo.get("strategyId").asText());
                    objectNode.set("_storage", (JsonNode)storageObject);
                }
                arrayNode.add((JsonNode)objectNode);
            }
            dataObjectNode.set("versions", (JsonNode)arrayNode);
            qualifierObject.set(entry.getKey(), (JsonNode)dataObjectNode);
        }
        workObject.set("_qualifiers", (JsonNode)qualifierObject);
        return workObject;
    }

    private void updateObjectNode(IngestSession ingestSession, ObjectNode objectNode, String guid, boolean isPhysical, String containerId) {
        objectNode.put("_id", guid);
        objectNode.put("_opi", containerId);
        if (!isPhysical) {
            if (ingestSession.getObjectGuidToDataObject().get(guid).getSize() != null) {
                objectNode.put("Size", ingestSession.getObjectGuidToDataObject().get(guid).getSize());
                ObjectNode diffSizeJson = ingestSession.getObjectGuidToDataObject().get(guid).getDiffSizeJson();
                if (!JsonHandler.isNullOrEmpty((JsonNode)diffSizeJson)) {
                    ObjectNode work = JsonHandler.createObjectNode();
                    work.put("_isSizeIncorrect", ingestSession.getObjectGuidToDataObject().get(guid).getSizeIncorrect());
                    work.set("_diffSizeJson", (JsonNode)diffSizeJson);
                    objectNode.set("_work", (JsonNode)work);
                }
            }
            if (ingestSession.getObjectGuidToDataObject().get(guid).getUri() != null) {
                objectNode.put("Uri", ingestSession.getObjectGuidToDataObject().get(guid).getUri());
            }
            if (ingestSession.getObjectGuidToDataObject().get(guid).getMessageDigest() != null) {
                objectNode.put("MessageDigest", ingestSession.getObjectGuidToDataObject().get(guid).getMessageDigest());
            }
            if (ingestSession.getObjectGuidToDataObject().get(guid).getAlgo() != null) {
                objectNode.put("Algorithm", ingestSession.getObjectGuidToDataObject().get(guid).getAlgo().getName());
            }
        }
    }

    private void createLifeCycleForError(Map<String, LogbookLifeCycleParameters> guidToLifeCycleParameters, String subTask, String message, String guid, boolean isArchive, boolean isObjectGroup, String containerId, LogbookTypeProcess logbookTypeProcess) throws InvalidParseOperationException, LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException {
        LogbookLifeCycleParameters lfcParameters = (LogbookLifeCycleParameters)this.initLogbookLifeCycleParameters(guidToLifeCycleParameters, guid, isArchive, isObjectGroup);
        lfcParameters.setFinalStatus("LFC_CREATION", null, StatusCode.KO, null, new String[0]);
        lfcParameters.putParameterValue(LogbookParameterName.eventIdentifierProcess, containerId);
        lfcParameters.putParameterValue(LogbookParameterName.eventIdentifier, GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()).toString());
        lfcParameters.putParameterValue(LogbookParameterName.eventTypeProcess, logbookTypeProcess.name());
        try (LogbookLifeCyclesClient logbookLifeCycleClient = this.logbookLifeCyclesClientFactory.getClient();){
            GUIDReader.getGUID((String)guid);
            logbookLifeCycleClient.create(lfcParameters);
            guidToLifeCycleParameters.put(guid, lfcParameters);
            lfcParameters.setFinalStatus(HANDLER_ID, subTask, StatusCode.KO, null, new String[0]);
            ObjectNode llcEvDetData = JsonHandler.createObjectNode();
            llcEvDetData.put("evDetTechData", message);
            lfcParameters.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.writeAsString((Object)llcEvDetData));
            logbookLifeCycleClient.update(lfcParameters);
        }
        catch (InvalidGuidOperationException e) {
            LOGGER.error("ID is not a GUID: " + guid, (Throwable)e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
        if (!handler.checkHandlerIO(15, HANDLER_INPUT_IO_LIST)) {
            throw new ProcessingException("Input/Output io parameter is not correct");
        }
    }

    private void extractOntology(HandlerIO handlerIO) throws ProcessingException {
        Select selectOntologies = new Select();
        List ontologyModelList = new ArrayList();
        try (AdminManagementClient adminClient = this.adminManagementClientFactory.getClient();){
            selectOntologies.setQuery((Query)QueryHelper.in((String)"Collections", (String[])new String[]{MetadataType.UNIT.getName()}));
            HashMap<String, Integer> projection = new HashMap<String, Integer>();
            projection.put("Identifier", 1);
            projection.put("Type", 1);
            QueryProjection queryProjection = new QueryProjection();
            queryProjection.setFields(projection);
            selectOntologies.setProjection(JsonHandler.toJsonNode((Object)queryProjection));
            RequestResponse responseOntologies = adminClient.findOntologies((JsonNode)selectOntologies.getFinalSelect());
            if (responseOntologies != null && responseOntologies.isOk() && !((RequestResponseOK)responseOntologies).getResults().isEmpty()) {
                ontologyModelList = ((RequestResponseOK)responseOntologies).getResults();
            }
            File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(11).getPath());
            JsonHandler.writeAsFile(ontologyModelList, (File)tempFile);
            handlerIO.addOutputResult(11, (Object)tempFile, true, false);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error("Could not get ontology", e);
            throw new ProcessingException(e);
        }
    }

    private void extractMetadataUsingMarshellar(XMLEventReader reader, Unmarshaller unmarshaller, HandlerIO handlerIO, IngestContext ingestContext, IngestSession ingestSession, Class<?> clasz) throws InvalidParseOperationException, LogbookClientAlreadyExistsException, LogbookClientNotFoundException, IOException, LogbookClientBadRequestException, LogbookClientServerException, ProcessingException {
        try {
            unmarshaller.unmarshal(reader, clasz);
        }
        catch (RuntimeException e) {
            this.handleJaxbUnmarshalRuntimeException(handlerIO, ingestContext, ingestSession, e);
        }
        catch (JAXBException e) {
            throw new InvalidParseOperationException((Throwable)e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)(ArchiveUnitType.class.getPackage().getName() + ":fr.gouv.vitam.common.model.unit:fr.gouv.vitam.common.model.objectgroup"));
        }
        catch (JAXBException e) {
            LOGGER.error("unable to create jaxb context", (Throwable)e);
        }
    }
}

