/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.LogbookLifecycleWorkerHelper;
import fr.gouv.vitam.worker.core.handler.ActionHandler;

public abstract class CommitLifeCycleActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CommitLifeCycleActionHandler.class);

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = this.getItemStatus();
        String objectID = LogbookLifecycleWorkerHelper.getObjectID((WorkerParameters)params);
        String operationId = params.getContainerName();
        try {
            this.checkMandatoryIOParameter(handlerIO);
            this.commitLifeCycle(handlerIO, objectID, operationId);
            itemStatus.increment(StatusCode.OK);
        }
        catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException | ProcessingException e) {
            LOGGER.error(e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return this.buildFinalItemStatus(itemStatus);
    }

    public abstract ItemStatus getItemStatus();

    public abstract ItemStatus buildFinalItemStatus(ItemStatus var1);

    public abstract void commitLifeCycle(HandlerIO var1, String var2, String var3) throws ProcessingException, LogbookClientBadRequestException, LogbookClientNotFoundException, LogbookClientServerException;

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

