/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import fr.gouv.vitam.worker.common.utils.SedaUtilsException;
import fr.gouv.vitam.worker.common.utils.SedaUtilsFactory;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.Map;

public class CheckVersionActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckVersionActionHandler.class);
    private static final String HANDLER_ID = "CHECK_MANIFEST_DATAOBJECT_VERSION";
    private static final String SUBTASK_PDO_DATAOBJECTIONVERSION_BINARYMASTER = "PDO_DATAOBJECTIONVERSION_BINARYMASTER";
    private static final String SUBTASK_BDO_DATAOBJECTIONVERSION_PHYSICALMASTER = "BDO_DATAOBJECTIONVERSION_PHYSICALMASTER";
    private static final String SUBTASK_INVALID_DATAOBJECTVERSION = "INVALID_DATAOBJECTVERSION";
    private static final String SUBTASK_EMPTY_REQUIRED_FIELD = "EMPTY_REQUIRED_FIELD";
    private static final String SUBTASK_INVALIDE_ALGO = "INVALIDE_ALGO";
    private static final String BDO_CONTAINS_OTHER_TYPE = "BinaryDataObjectContainsOtherType";
    private static final String PDO_CONTAINS_OTHER_TYPE = "PhysicalDataObjectContainsOtherType";
    private static final String INCORRECT_VERSION_FORMAT = "IncorrectVersionFormat";
    private static final String INCORRECT_URI = "IncorrectUri";
    private static final String INCORRECT_PHYSICAL_ID = "IncorrectPhysicalId";
    private final SedaUtilsFactory sedaUtilsFactory;

    public CheckVersionActionHandler() {
        this(SedaUtilsFactory.getInstance());
    }

    @VisibleForTesting
    public CheckVersionActionHandler(SedaUtilsFactory sedaUtilsFactory) {
        this.sedaUtilsFactory = sedaUtilsFactory;
    }

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        SedaUtils sedaUtils = this.sedaUtilsFactory.createSedaUtils(handlerIO);
        try {
            this.checkMandatoryIOParameter(handlerIO);
            Map versionMap = sedaUtils.checkSupportedDataObjectVersion(params);
            Map invalidVersionMap = (Map)versionMap.get("INVALID_DATAOBJECT_VERSION");
            Map validVersionMap = (Map)versionMap.get("VALID_DATAOBJECT_VERSION");
            if (!invalidVersionMap.isEmpty()) {
                itemStatus.increment(StatusCode.KO, invalidVersionMap.size());
                itemStatus.increment(StatusCode.OK, validVersionMap.size());
                invalidVersionMap.forEach((key, value) -> {
                    if (key.endsWith(BDO_CONTAINS_OTHER_TYPE)) {
                        this.updateDetailItemStatus(itemStatus, this.getMessageItemStatusUsageError("BinaryDataObject", (String)key, (String)value), SUBTASK_BDO_DATAOBJECTIONVERSION_PHYSICALMASTER);
                    } else if (key.endsWith(PDO_CONTAINS_OTHER_TYPE)) {
                        this.updateDetailItemStatus(itemStatus, this.getMessageItemStatusUsageError("PhysicalDataObject", (String)key, (String)value), SUBTASK_PDO_DATAOBJECTIONVERSION_BINARYMASTER);
                    } else if (key.endsWith(INCORRECT_VERSION_FORMAT)) {
                        this.updateDetailItemStatus(itemStatus, this.getMessageItemStatusUsageError(key.contains("BinaryDataObject") ? "BinaryDataObject" : "PhysicalDataObject", (String)key, (String)value), SUBTASK_INVALID_DATAOBJECTVERSION);
                    } else if (key.endsWith(INCORRECT_URI)) {
                        this.updateDetailItemStatus(itemStatus, this.getMessageItemStatusUsageError("BinaryDataObject", (String)key, (String)value), SUBTASK_EMPTY_REQUIRED_FIELD);
                    } else if (key.endsWith(INCORRECT_PHYSICAL_ID)) {
                        this.updateDetailItemStatus(itemStatus, this.getMessageItemStatusUsageError("PhysicalDataObject", (String)key, (String)value), SUBTASK_EMPTY_REQUIRED_FIELD);
                    }
                });
                itemStatus.setData("errorNumber", (Object)invalidVersionMap.size());
            } else {
                itemStatus.increment(StatusCode.OK);
            }
        }
        catch (SedaUtilsException e) {
            ObjectNode errorDetail = JsonHandler.createObjectNode();
            errorDetail.put("Error", e.getMessage());
            this.updateDetailItemStatus(itemStatus, JsonHandler.unprettyPrint((Object)errorDetail), SUBTASK_INVALIDE_ALGO);
            itemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private String getMessageItemStatusUsageError(String typeDataObject, String key, String errorVersion) {
        ObjectNode errorDetail = JsonHandler.createObjectNode();
        errorDetail.put(typeDataObject, errorVersion + (String)(key.contains("_") ? " - " + key.split("_")[0] : ""));
        return JsonHandler.unprettyPrint((Object)errorDetail);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

