/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ContractsDetailsModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.model.StorageInformation;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import fr.gouv.vitam.worker.common.utils.SedaUtilsFactory;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class CheckStorageAvailabilityActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckStorageAvailabilityActionHandler.class);
    private static final String HANDLER_ID = "STORAGE_AVAILABILITY_CHECK";
    private static final int REFERENTIAL_INGEST_CONTRACT_IN_RANK = 0;
    private final StorageClientFactory storageClientFactory;
    private final SedaUtilsFactory sedaUtilsFactory;

    public CheckStorageAvailabilityActionHandler() {
        this(StorageClientFactory.getInstance(), SedaUtilsFactory.getInstance());
    }

    @VisibleForTesting
    public CheckStorageAvailabilityActionHandler(StorageClientFactory storageClientFactory, SedaUtilsFactory sedaUtilsFactory) {
        this.storageClientFactory = storageClientFactory;
        this.sedaUtilsFactory = sedaUtilsFactory;
    }

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        ItemStatus itemStatus;
        block15: {
            this.checkMandatoryParameters(params);
            itemStatus = new ItemStatus(HANDLER_ID);
            try {
                JsonNode storageCapacityNode;
                this.checkMandatoryIOParameter(handlerIO);
                ManagementContractModel managementContract = this.loadManagementContractFromWorkspace(handlerIO);
                SedaUtils sedaUtils = this.sedaUtilsFactory.createSedaUtils(handlerIO);
                long objectsSizeInSip = sedaUtils.computeTotalSizeOfObjectsInManifest(params);
                String strategyId = VitamConfiguration.getDefaultStrategy();
                if (managementContract != null && managementContract.getStorage() != null && StringUtils.isNotBlank((CharSequence)managementContract.getStorage().getObjectStrategy())) {
                    strategyId = managementContract.getStorage().getObjectStrategy();
                }
                try (StorageClient storageClient = this.storageClientFactory.getClient();){
                    storageCapacityNode = storageClient.getStorageInformation(strategyId);
                }
                if (storageCapacityNode == null) {
                    LOGGER.warn("storage capacity account information not found for object strategy");
                    itemStatus.increment(StatusCode.OK);
                    return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
                }
                StorageInformation[] informations = (StorageInformation[])JsonHandler.getFromJsonNode((JsonNode)storageCapacityNode.get("capacities"), StorageInformation[].class);
                if (informations.length > 0) {
                    for (StorageInformation information : informations) {
                        ItemStatus is = new ItemStatus(HANDLER_ID);
                        ObjectNode info = JsonHandler.createObjectNode();
                        if (information.getUsableSpace() >= objectsSizeInSip || information.getUsableSpace() == -1L) {
                            info.put(information.getOfferId(), StatusCode.OK.name());
                            is.increment(StatusCode.OK);
                        } else {
                            LOGGER.error("storage capacity invalid on offer {} of object strategy : usableSpace={}, totalSizeToBeStored={}", new Object[]{information.getOfferId(), information.getUsableSpace(), objectsSizeInSip});
                            info.put(information.getOfferId(), StatusCode.KO.name());
                            info.put(information.getOfferId() + "_usableSpace", information.getUsableSpace());
                            info.put(information.getOfferId() + "_totalSizeToBeStored", objectsSizeInSip);
                            is.increment(StatusCode.KO);
                        }
                        is.setEvDetailData(info.toString());
                        itemStatus.setItemsStatus(HANDLER_ID, is);
                    }
                    break block15;
                }
                LOGGER.warn("No information found for offers");
                itemStatus.increment(StatusCode.OK);
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
            catch (InvalidParseOperationException | ProcessingException | StorageNotFoundClientException | StorageServerClientException e) {
                LOGGER.error(e);
                itemStatus.increment(StatusCode.FATAL);
            }
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private ManagementContractModel loadManagementContractFromWorkspace(HandlerIO handlerIO) throws InvalidParseOperationException {
        ContractsDetailsModel contractsDetailsModel = (ContractsDetailsModel)JsonHandler.getFromFile((File)((File)handlerIO.getInput(0)), ContractsDetailsModel.class);
        return contractsDetailsModel.getManagementContractModel();
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

