/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import fr.gouv.vitam.worker.common.utils.SedaUtilsFactory;
import fr.gouv.vitam.worker.core.handler.ActionHandler;

public class CheckSedaActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckSedaActionHandler.class);
    private static final String NOT_XSD_VALID = "NOT_XSD_VALID";
    private static final String NOT_XML_FILE = "NOT_XML_FILE";
    private static final String UNSUPPORTED_SEDA_VERSION = "UNSUPPORTED_SEDA_VERSION";
    private static final String NO_FILE = "NO_FILE";
    private static final String HANDLER_ID = "CHECK_SEDA";
    private static final String CONTAINER_FORMAT = "CONTAINER_FORMAT";
    private static final String FILE = "FILE";
    private static final String DIRECTORY = "DIRECTORY";
    private static final String SUBTASK_CHECK_MULTI_MANIFEST = "CONTAINER_FORMAT.FILE";
    private static final String SUBTASK_CHECK_MULTI_FOLDER_CONTENT_ID = "CONTAINER_FORMAT.DIRECTORY";
    private static final int SEDA_INGEST_PARAMS_RANK_OUTPUT = 0;
    private final SedaUtilsFactory sedaUtilsFactory;

    public CheckSedaActionHandler() {
        this(SedaUtilsFactory.getInstance());
    }

    CheckSedaActionHandler(SedaUtilsFactory sedaUtilsFactory) {
        this.sedaUtilsFactory = sedaUtilsFactory;
    }

    public static String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        SedaUtils sedaUtils = this.sedaUtilsFactory.createSedaUtils(handlerIO);
        try {
            sedaUtils.extractXmlNameSpaceAndSaveSedaParams(handlerIO, 0);
            SedaUtils.CheckSedaValidationStatus status = sedaUtils.checkSedaValidation(itemStatus);
            switch (status) {
                case VALID: {
                    itemStatus.increment(StatusCode.OK);
                    break;
                }
                case NO_FILE: {
                    itemStatus.setGlobalOutcomeDetailSubcode(NO_FILE);
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case NOT_XML_FILE: {
                    itemStatus.setGlobalOutcomeDetailSubcode(NOT_XML_FILE);
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case NOT_XSD_VALID: {
                    itemStatus.setGlobalOutcomeDetailSubcode(NOT_XSD_VALID);
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case MORE_THAN_ONE_MANIFEST: {
                    itemStatus.setGlobalOutcomeDetailSubcode(SUBTASK_CHECK_MULTI_MANIFEST);
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case MORE_THAN_ONE_FOLDER_CONTENT: {
                    itemStatus.setGlobalOutcomeDetailSubcode(SUBTASK_CHECK_MULTI_FOLDER_CONTENT_ID);
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case UNSUPPORTED_SEDA_VERSION: {
                    itemStatus.setGlobalOutcomeDetailSubcode(UNSUPPORTED_SEDA_VERSION);
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                default: {
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
            }
        }
        catch (ProcessingException e) {
            if (e.getMessage() != null) {
                if (e.getMessage().equals(SedaUtils.CheckSedaValidationStatus.NOT_XML_FILE.name())) {
                    itemStatus.setGlobalOutcomeDetailSubcode(NOT_XML_FILE);
                } else if (SedaUtils.CheckSedaValidationStatus.UNSUPPORTED_SEDA_VERSION.name().equals(e.getMessage())) {
                    itemStatus.setGlobalOutcomeDetailSubcode(UNSUPPORTED_SEDA_VERSION);
                }
            } else {
                LOGGER.error((Throwable)e);
            }
            itemStatus.increment(StatusCode.KO);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

