/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckOriginatingAgencyHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckOriginatingAgencyHandler.class);
    private static final int AGENT_RANK = 0;
    private static final String HANDLER_ID = "CHECK_AGENT";
    public static final String EMPTY_REQUIRED_FIELD = "EMPTY_REQUIRED_FIELD";
    private final AdminManagementClientFactory adminManagementClientFactory;

    public CheckOriginatingAgencyHandler() {
        this(AdminManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    public CheckOriginatingAgencyHandler(AdminManagementClientFactory adminManagementClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handlerIO) {
        this.checkMandatoryParameters(param);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            Set<String> missingserviceAgents;
            this.checkMandatoryIOParameter(handlerIO);
            Map mandatoryValueMap = (Map)handlerIO.getInput(0);
            HashSet<String> serviceAgentList = new HashSet<String>();
            if (mandatoryValueMap.get("OriginatingAgencyIdentifier") == null || Strings.isNullOrEmpty((String)((String)mandatoryValueMap.get("OriginatingAgencyIdentifier")))) {
                ObjectNode evDetData = JsonHandler.createObjectNode();
                evDetData.put("evDetTechData", "Error originating agency not found in the manifest");
                itemStatus.setEvDetailData(JsonHandler.writeAsString((Object)evDetData));
                itemStatus.increment(StatusCode.KO);
                itemStatus.setGlobalOutcomeDetailSubcode(EMPTY_REQUIRED_FIELD);
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
            serviceAgentList.add((String)mandatoryValueMap.get("OriginatingAgencyIdentifier"));
            if (mandatoryValueMap.get("SubmissionAgencyIdentifier") != null && !Strings.isNullOrEmpty((String)((String)mandatoryValueMap.get("SubmissionAgencyIdentifier")))) {
                serviceAgentList.add((String)mandatoryValueMap.get("SubmissionAgencyIdentifier"));
            }
            if (!(missingserviceAgents = this.getMissingServiceAgents(serviceAgentList)).isEmpty()) {
                itemStatus.increment(StatusCode.KO, missingserviceAgents.size());
                itemStatus.setGlobalOutcomeDetailSubcode("UNKNOWN");
                ObjectNode evDetData = JsonHandler.createObjectNode();
                ArrayNode serviceAgents = JsonHandler.createArrayNode();
                missingserviceAgents.forEach(agent -> serviceAgents.add(agent));
                evDetData.put("evDetTechData", "error originating agency validation" + JsonHandler.writeAsString(missingserviceAgents));
                itemStatus.setEvDetailData(JsonHandler.writeAsString((Object)evDetData));
            } else {
                itemStatus.increment(StatusCode.OK);
            }
        }
        catch (InvalidParseOperationException | ProcessingException e) {
            LOGGER.error(e);
            itemStatus.increment(StatusCode.KO);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private Set<String> getMissingServiceAgents(Set<String> serviceAgentList) throws ProcessingException {
        HashSet<String> hashSet;
        block9: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                HashSet<String> missingServiceAgent = new HashSet<String>();
                String[] serviceAgentArray = serviceAgentList.toArray(new String[serviceAgentList.size()]);
                Select select = new Select();
                select.setQuery((Query)QueryHelper.in((String)"Identifier", (String[])serviceAgentArray));
                JsonNode results = client.getAgencies((JsonNode)select.getFinalSelect());
                List res = results.findValuesAsText("Identifier");
                for (String serviceAgent : serviceAgentList) {
                    if (res.contains(serviceAgent)) continue;
                    missingServiceAgent.add(serviceAgent);
                }
                hashSet = missingServiceAgent;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | ReferentialException e) {
                    LOGGER.error("Originating agency not found: ", e);
                    throw new ProcessingException("Error while accessing referential AGENCIES");
                }
            }
            client.close();
        }
        return hashSet;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

