/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamKoRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.VitamConstants;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.ExtractUriResponse;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import fr.gouv.vitam.worker.common.utils.SedaUtilsFactory;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class CheckObjectsNumberActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckObjectsNumberActionHandler.class);
    private static final String HANDLER_ID = "CHECK_MANIFEST_OBJECTNUMBER";
    private static final String SUBTASK_INVALID_URI = "INVALID_URI";
    private static final String SUBTASK_MANIFEST_INFERIOR_BDO = "MANIFEST_INFERIOR_BDO";
    private static final String SUBTASK_MANIFEST_SUPERIOR_BDO = "MANIFEST_SUPERIOR_BDO";
    private static final String ERROR_IN_MANIFEST = "manifestError";
    private static final String ERROR_IN_CONTENT = "contentError";
    private final SedaUtilsFactory sedaUtilsFactory;

    public CheckObjectsNumberActionHandler() {
        this(SedaUtilsFactory.getInstance());
    }

    public CheckObjectsNumberActionHandler(SedaUtilsFactory sedaUtilsFactory) {
        this.sedaUtilsFactory = sedaUtilsFactory;
    }

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            this.checkMandatoryIOParameter(handlerIO);
            ExtractUriResponse extractUriResponse = this.getUriListFromManifest(handlerIO);
            if (extractUriResponse != null && !extractUriResponse.isErrorDuplicateUri()) {
                Set uriSetFromManifest = extractUriResponse.getUriSetManifest();
                List<URI> uriListFromWorkspace = this.getUriListFromWorkspace(handlerIO, params);
                this.checkCountDigitalObjectConformity(uriSetFromManifest, uriListFromWorkspace, itemStatus);
            } else if (extractUriResponse != null) {
                itemStatus.increment(StatusCode.KO, extractUriResponse.getErrorNumber());
            }
        }
        catch (VitamKoRuntimeException e) {
            ObjectNode evdev = JsonHandler.createObjectNode();
            evdev.put("evDetTechData", e.getMessage());
            itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)evdev));
            itemStatus.increment(StatusCode.KO);
        }
        catch (ProcessingException | ContentAddressableStorageServerException e) {
            LOGGER.error(e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private ExtractUriResponse getUriListFromManifest(HandlerIO handlerIO) throws ProcessingException {
        SedaUtils sedaUtils = this.sedaUtilsFactory.createSedaUtilsWithSedaIngestParams(handlerIO);
        return sedaUtils.getAllDigitalObjectUriFromManifest();
    }

    private List<URI> getUriListFromWorkspace(HandlerIO handlerIO, WorkerParameters params) throws ProcessingException, ContentAddressableStorageServerException {
        return this.getDigitalObjectUriListFromWorkspace(handlerIO, params);
    }

    private void checkCountDigitalObjectConformity(Set<URI> uriManifestSet, List<URI> uriListWorkspace, ItemStatus itemStatus) throws ProcessingException {
        ParametersChecker.checkParameter((String)"Manifest uri set is a mandatory parameter", (Object[])new Object[]{uriManifestSet});
        ParametersChecker.checkParameter((String)"Workspace uri list is a mandatory parameter", (Object[])new Object[]{uriListWorkspace});
        ParametersChecker.checkParameter((String)"ItemStatus is a mandatory parameter", (Object[])new Object[]{itemStatus});
        HashSet<URI> uriWorkspaceSet = new HashSet<URI>(uriListWorkspace);
        Set notInWorkspace = SetUtils.difference(uriManifestSet, uriWorkspaceSet).toSet();
        Set notInManifest = SetUtils.difference(uriWorkspaceSet, uriManifestSet).toSet();
        int errorCount = notInWorkspace.size() + notInManifest.size();
        int okCount = uriWorkspaceSet.size() - notInManifest.size();
        if (errorCount == 0) {
            itemStatus.increment(StatusCode.OK, okCount);
        } else {
            itemStatus.increment(StatusCode.OK, okCount);
            itemStatus.increment(StatusCode.KO, errorCount);
            String status = uriManifestSet.size() > uriListWorkspace.size() ? SUBTASK_MANIFEST_SUPERIOR_BDO : (uriManifestSet.size() < uriListWorkspace.size() ? SUBTASK_MANIFEST_INFERIOR_BDO : SUBTASK_INVALID_URI);
            this.updateDetailItemStatus(itemStatus, this.getMessageItemStatusInvalidURIandIncorrectTotals(notInWorkspace, notInManifest), status);
        }
        itemStatus.setData("errorNumber", (Object)errorCount);
    }

    private String getMessageItemStatusInvalidURIandIncorrectTotals(Set<URI> notInWorkspace, Set<URI> notInManifest) {
        ObjectNode error = JsonHandler.createObjectNode();
        if (!notInWorkspace.isEmpty()) {
            ArrayNode errorDetailsManifest = JsonHandler.createArrayNode();
            notInWorkspace.forEach(uri -> errorDetailsManifest.add(uri.getPath()));
            error.set(ERROR_IN_MANIFEST, (JsonNode)errorDetailsManifest);
        }
        if (!notInManifest.isEmpty()) {
            ArrayNode errorDetailsContent = JsonHandler.createArrayNode();
            notInManifest.forEach(uri -> errorDetailsContent.add(uri.getPath()));
            error.set(ERROR_IN_CONTENT, (JsonNode)errorDetailsContent);
        }
        return JsonHandler.unprettyPrint((Object)error);
    }

    private List<URI> getDigitalObjectUriListFromWorkspace(HandlerIO handlerIO, WorkerParameters workParams) throws ProcessingException, ContentAddressableStorageServerException {
        List<URI> list;
        block8: {
            WorkspaceClient workspaceClient = handlerIO.getWorkspaceClientFactory().getClient();
            try {
                List uriListWorkspace = (List)JsonHandler.getFromStringAsTypeReference((String)workspaceClient.getListUriDigitalObjectFromFolder(workParams.getContainerName(), "SIP").toJsonNode().get("$results").get(0).toString(), (TypeReference)new TypeReference<List<URI>>(){});
                list = uriListWorkspace.stream().filter(uri -> uri.toString().contains(VitamConstants.URL_ENCODED_SEPARATOR)).collect(Collectors.toList());
                if (workspaceClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (workspaceClient != null) {
                        try {
                            workspaceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException e) {
                    throw new ProcessingException(e);
                }
            }
            workspaceClient.close();
        }
        return list;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

