/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleObjectGroupParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCyclesClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.LogbookLifecycleWorkerHelper;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CheckObjectUnitConsistencyActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckObjectUnitConsistencyActionHandler.class);
    private static final int OBJECTGROUP_TO_GUID_MAP_RANK = 1;
    private static final int OBJECTGROUP_TO_UNIT_MAP_RANK = 0;
    private static final String HANDLER_ID = "CHECK_CONSISTENCY";
    private static final String SUBTASK_ORPHAN = "CHECK_CONSISTENCY_ORPHAN_OBJECT";
    private final List<Class<?>> handlerInitialIOList = new ArrayList();

    public CheckObjectUnitConsistencyActionHandler() {
        this.handlerInitialIOList.add(Map.class);
        this.handlerInitialIOList.add(Map.class);
    }

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) throws ProcessingException {
        this.checkMandatoryParameters(params);
        this.checkMandatoryIOParameter(handler);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            List<String> notConformOGs = this.findObjectGroupsNonReferencedByArchiveUnit(handler, params, itemStatus);
            if (!notConformOGs.isEmpty()) {
                itemStatus.setData("errorNumber", (Object)notConformOGs.size());
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.KO);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private List<String> findObjectGroupsNonReferencedByArchiveUnit(HandlerIO handlerIO, WorkerParameters params, ItemStatus itemStatus) {
        ArrayList<String> ogList = new ArrayList<String>();
        Map objectGroupToUnitStoredMap = (Map)handlerIO.getInput(0);
        Map objectGroupToGuidStoredMap = (Map)handlerIO.getInput(1);
        if (objectGroupToGuidStoredMap.size() == 0) {
            itemStatus.increment(StatusCode.OK);
        } else {
            for (Map.Entry objectGroup : objectGroupToGuidStoredMap.entrySet()) {
                String objectID;
                LogbookLifeCycleObjectGroupParameters logbookLifecycleObjectGroupParameters;
                if (!objectGroupToUnitStoredMap.containsKey(objectGroup.getKey())) {
                    itemStatus.increment(StatusCode.KO);
                    itemStatus.setGlobalOutcomeDetailSubcode(SUBTASK_ORPHAN);
                    try {
                        logbookLifecycleObjectGroupParameters = LogbookParameterHelper.newLogbookLifeCycleObjectGroupParameters();
                        logbookLifecycleObjectGroupParameters.setFinalStatus(SUBTASK_ORPHAN, null, StatusCode.KO, null, new String[0]);
                        LogbookLifecycleWorkerHelper.updateLifeCycleStep((LogbookLifeCyclesClientHelper)handlerIO.getHelper(), (LogbookLifeCycleParameters)logbookLifecycleObjectGroupParameters, (WorkerParameters)params, (String)HANDLER_ID, (LogbookTypeProcess)params.getLogbookTypeProcess(), (StatusCode)StatusCode.KO, (String[])new String[]{objectGroupToGuidStoredMap.get(objectGroup.getKey()).toString()});
                        objectID = logbookLifecycleObjectGroupParameters.getParameterValue(LogbookParameterName.objectIdentifier);
                        handlerIO.getLifecyclesClient().bulkUpdateObjectGroup(params.getContainerName(), (Iterable)handlerIO.getHelper().removeUpdateDelegate(objectID));
                    }
                    catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException | ProcessingException e) {
                        LOGGER.error("Can not update logbook lifcycle", e);
                    }
                    ogList.add((String)objectGroup.getKey());
                    continue;
                }
                itemStatus.increment(StatusCode.OK);
                try {
                    logbookLifecycleObjectGroupParameters = LogbookParameterHelper.newLogbookLifeCycleObjectGroupParameters();
                    logbookLifecycleObjectGroupParameters.setFinalStatus(HANDLER_ID, null, StatusCode.OK, null, new String[0]);
                    LogbookLifecycleWorkerHelper.updateLifeCycleStep((LogbookLifeCyclesClientHelper)handlerIO.getHelper(), (LogbookLifeCycleParameters)logbookLifecycleObjectGroupParameters, (WorkerParameters)params, (String)HANDLER_ID, (LogbookTypeProcess)params.getLogbookTypeProcess(), (StatusCode)StatusCode.OK, (String[])new String[]{objectGroupToGuidStoredMap.get(objectGroup.getKey()).toString()});
                    objectID = logbookLifecycleObjectGroupParameters.getParameterValue(LogbookParameterName.objectIdentifier);
                    handlerIO.getLifecyclesClient().bulkUpdateObjectGroup(params.getContainerName(), (Iterable)handlerIO.getHelper().removeUpdateDelegate(objectID));
                }
                catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException | ProcessingException e) {
                    LOGGER.error("Can not update logbook lifcycle", e);
                }
            }
        }
        return ogList;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
        if (!handler.checkHandlerIO(0, this.handlerInitialIOList)) {
            throw new ProcessingException("Input/Output io parameter is not correct");
        }
    }
}

