/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.xml.SecureXMLFactoryUtils;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import fr.gouv.vitam.worker.common.utils.SedaUtilsFactory;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CheckNoObjectsActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckNoObjectsActionHandler.class);
    private static final String HANDLER_ID = "CHECK_NO_OBJECT";
    private final SedaUtilsFactory sedaUtilsFactory = SedaUtilsFactory.getInstance();

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            this.checkMandatoryIOParameter(handlerIO);
            if (!this.checkNoObjectInManifest(handlerIO)) {
                itemStatus.increment(StatusCode.KO);
            } else {
                itemStatus.increment(StatusCode.OK);
            }
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private boolean checkNoObjectInManifest(HandlerIO handlerIO) throws ProcessingException {
        SedaUtils sedaUtils = this.sedaUtilsFactory.createSedaUtilsWithSedaIngestParams(handlerIO);
        InputStream xmlFile = null;
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        QName binaryDataObject = new QName(sedaUtils.getSedaIngestParams().getNamespaceURI(), "BinaryDataObject");
        QName physicalDataObject = new QName(sedaUtils.getSedaIngestParams().getNamespaceURI(), "PhysicalDataObject");
        XMLEventReader eventReader = null;
        try {
            XMLEvent event;
            try {
                xmlFile = handlerIO.getInputStreamFromWorkspace("SIP/manifest.xml");
            }
            catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e1) {
                LOGGER.error("Workspace error: Can not get file", e1);
                throw new ProcessingException(e1);
            }
            eventReader = SecureXMLFactoryUtils.createSecureXMLEventReader((InputStream)xmlFile);
            do {
                StartElement element;
                if (!(event = eventReader.nextEvent()).isStartElement() || !(element = event.asStartElement()).getName().equals(binaryDataObject) && !element.getName().equals(physicalDataObject)) continue;
                boolean bl = false;
                return bl;
            } while (!event.isEndDocument());
            LOGGER.debug("data : " + event);
            LOGGER.debug("End of extracting  Uri from manifest");
        }
        catch (XMLStreamException e) {
            LOGGER.error((Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        finally {
            try {
                if (eventReader != null) {
                    eventReader.close();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.warn((Throwable)e);
            }
            StreamUtils.closeSilently((InputStream)xmlFile);
        }
        return true;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

