/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.ContextStatus;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.ManagmentContractChecker;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CheckIngestContractActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckIngestContractActionHandler.class);
    private static final int SEDA_PARAMETERS_RANK = 0;
    private static final String HANDLER_ID = "CHECK_CONTRACT_INGEST";
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final StorageClientFactory storageClientFactory;

    public CheckIngestContractActionHandler() {
        this(AdminManagementClientFactory.getInstance(), StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public CheckIngestContractActionHandler(AdminManagementClientFactory adminManagementClientFactory, StorageClientFactory storageClientFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public static String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO ioParam) {
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            ObjectNode infoNode = JsonHandler.createObjectNode();
            this.checkMandatoryIOParameter(ioParam);
            Map mandatoryValueMap = (Map)ioParam.getInput(0);
            String contractIdentifier = null;
            if (null != mandatoryValueMap.get("ArchivalAgreement") && !((String)mandatoryValueMap.get("ArchivalAgreement")).isEmpty()) {
                contractIdentifier = (String)mandatoryValueMap.get("ArchivalAgreement");
                infoNode.put("ArchivalAgreement", contractIdentifier);
            }
            CheckIngestContractStatus status = this.checkIngestContract(contractIdentifier);
            switch (status) {
                case CONTRACT_INACTIVE: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.CONTRACT_INACTIVE.toString());
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case CONTRACT_UNKNOWN: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.CONTRACT_UNKNOWN.toString());
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case CONTRACT_NOT_IN_MANIFEST: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.CONTRACT_NOT_IN_MANIFEST.toString());
                    infoNode.put("evDetTechData", "Error ingest contract not found in the Manifest");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case CONTEXT_INACTIVE: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.CONTEXT_INACTIVE.toString());
                    infoNode.put("evDetTechData", "Context inactive");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case CONTEXT_UNKNOWN: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.CONTEXT_UNKNOWN.toString());
                    infoNode.put("evDetTechData", "Context not found");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case CONTEXT_CHECK_ERROR: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.CONTEXT_CHECK_ERROR.toString());
                    infoNode.put("evDetTechData", "Loading context error");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case CONTRACT_NOT_IN_CONTEXT: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.CONTRACT_NOT_IN_CONTEXT.toString());
                    infoNode.put("evDetTechData", "Error ingest contract not found in the Context");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case MANAGEMENT_CONTRACT_UNKNOWN: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.MANAGEMENT_CONTRACT_UNKNOWN.toString());
                    infoNode.put("evDetTechData", "Management Contract not found");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case MANAGEMENT_CONTRACT_INACTIVE: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.MANAGEMENT_CONTRACT_INACTIVE.toString());
                    infoNode.put("evDetTechData", "Management Contract inactive");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case MANAGEMENT_CONTRACT_INVALID: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.MANAGEMENT_CONTRACT_INVALID.toString());
                    infoNode.put("evDetTechData", "Management Contract invalid");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case FATAL: {
                    itemStatus.setGlobalOutcomeDetailSubcode(CheckIngestContractStatus.FATAL.toString());
                    infoNode.put("evDetTechData", "Unexpected technical error");
                    itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
                    itemStatus.increment(StatusCode.FATAL);
                    break;
                }
                case KO: {
                    itemStatus.increment(StatusCode.KO);
                    break;
                }
                case OK: {
                    itemStatus.increment(StatusCode.OK);
                }
            }
        }
        catch (ProcessingException e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.KO);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CheckIngestContractStatus checkIngestContract(String contractIdentifier) {
        if (!ParametersChecker.isNotEmpty((String[])new String[]{contractIdentifier})) {
            return CheckIngestContractStatus.CONTRACT_NOT_IN_MANIFEST;
        }
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            RequestResponse referenceContracts = adminManagementClient.findIngestContractsByID(contractIdentifier);
            if (!referenceContracts.isOk()) return CheckIngestContractStatus.KO;
            List results = ((RequestResponseOK)referenceContracts).getResults();
            if (results.isEmpty()) return CheckIngestContractStatus.KO;
            Iterator iterator = results.iterator();
            if (!iterator.hasNext()) return CheckIngestContractStatus.KO;
            IngestContractModel result = (IngestContractModel)iterator.next();
            ActivationStatus status = result.getStatus();
            if (ActivationStatus.ACTIVE.equals((Object)status) && result.getIdentifier().equals(contractIdentifier)) {
                CheckIngestContractStatus tempStatus = this.checkIngestContractInTheContext(contractIdentifier);
                if (CheckIngestContractStatus.OK.equals((Object)tempStatus) && StringUtils.isNotBlank((CharSequence)result.getManagementContractId())) {
                    ManagmentContractChecker managementContractChecker = new ManagmentContractChecker(result.getManagementContractId(), this.adminManagementClientFactory, this.storageClientFactory);
                    CheckIngestContractStatus checkIngestContractStatus = managementContractChecker.check();
                    return checkIngestContractStatus;
                }
                CheckIngestContractStatus checkIngestContractStatus = tempStatus;
                return checkIngestContractStatus;
            }
            CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractStatus.CONTRACT_INACTIVE;
            return checkIngestContractStatus;
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException e) {
            LOGGER.error(e);
            return CheckIngestContractStatus.FATAL;
        }
        catch (ReferentialNotFoundException e) {
            LOGGER.error("Contract not found :", (Throwable)e);
            return CheckIngestContractStatus.CONTRACT_UNKNOWN;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CheckIngestContractStatus checkIngestContractInTheContext(String ingestContract) {
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            String contextId = VitamThreadUtils.getVitamSession().getContextId();
            if (null == contextId || contextId.isEmpty()) {
                CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractStatus.CONTEXT_UNKNOWN;
                return checkIngestContractStatus;
            }
            RequestResponse contextResponse = adminManagementClient.findContextById(contextId);
            if (contextResponse.isOk()) {
                List results = ((RequestResponseOK)contextResponse).getResults();
                if (results.isEmpty()) {
                    LOGGER.error("CheckContract : The context " + contextId + "  not found in database");
                    CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractStatus.CONTEXT_UNKNOWN;
                    return checkIngestContractStatus;
                }
                ContextModel context = (ContextModel)results.get(0);
                if (Boolean.FALSE.equals(context.isEnablecontrol())) {
                    CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractStatus.OK;
                    return checkIngestContractStatus;
                }
                if (!ContextStatus.ACTIVE.equals((Object)context.getStatus())) {
                    LOGGER.error("CheckContract : The context " + contextId + "  is not activated");
                    CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractStatus.CONTEXT_INACTIVE;
                    return checkIngestContractStatus;
                }
                Integer tenant = ParameterHelper.getTenantParameter();
                long count = context.getPermissions().stream().filter(p -> Objects.equals(p.getTenant(), tenant)).filter(p -> p.getIngestContract() != null).filter(p -> p.getIngestContract().contains(ingestContract)).count();
                if (count > 0L) {
                    CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractStatus.OK;
                    return checkIngestContractStatus;
                }
                CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractStatus.CONTRACT_NOT_IN_CONTEXT;
                return checkIngestContractStatus;
            }
            LOGGER.error("Context check error : " + contextResponse.toString());
            CheckIngestContractStatus checkIngestContractStatus = CheckIngestContractStatus.CONTEXT_CHECK_ERROR;
            return checkIngestContractStatus;
        }
        catch (ReferentialNotFoundException e) {
            LOGGER.error("Context not found :", (Throwable)e);
            return CheckIngestContractStatus.CONTEXT_UNKNOWN;
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException e) {
            LOGGER.error("Context check error :", e);
            return CheckIngestContractStatus.FATAL;
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static enum CheckIngestContractStatus {
        CONTRACT_NOT_IN_MANIFEST,
        CONTRACT_NOT_IN_CONTEXT,
        CONTEXT_UNKNOWN,
        CONTEXT_INACTIVE,
        CONTEXT_CHECK_ERROR,
        CONTRACT_UNKNOWN,
        CONTRACT_INACTIVE,
        MANAGEMENT_CONTRACT_UNKNOWN,
        MANAGEMENT_CONTRACT_INACTIVE,
        MANAGEMENT_CONTRACT_INVALID,
        OK,
        KO,
        FATAL;

    }
}

