/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.handler;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.ContractsDetailsModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.common.utils.SedaUtils;
import fr.gouv.vitam.worker.common.utils.SedaUtilsFactory;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckArchiveProfileActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckArchiveProfileRelationActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckIngestContractActionHandler;
import fr.gouv.vitam.worker.core.handler.CheckOriginatingAgencyHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CheckHeaderActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckHeaderActionHandler.class);
    private static final String HANDLER_ID = "CHECK_HEADER";
    private static final String EV_DETAIL_REQ = "EvDetailReq";
    public static final String INGEST_CONTRACT = "ingestContract";
    public static final String MANAGEMENT_CONTRACT = "managementContract";
    private static final int CHECK_ORIGINATING_AGENCY_RANK_INPUT = 0;
    private static final int CHECK_PROFILE_RANK_INPUT = 1;
    private static final int REFERENTIAL_CONTRACTS_RANK_OUTPUT = 0;
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final SedaUtilsFactory sedaUtilsFactory;

    public CheckHeaderActionHandler() {
        this(AdminManagementClientFactory.getInstance(), StorageClientFactory.getInstance(), SedaUtilsFactory.getInstance());
    }

    @VisibleForTesting
    public CheckHeaderActionHandler(AdminManagementClientFactory adminManagementClientFactory, StorageClientFactory storageClientFactory, SedaUtilsFactory sedaUtilsFactory) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.sedaUtilsFactory = sedaUtilsFactory;
    }

    public static String getId() {
        return HANDLER_ID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters params, HandlerIO handlerIO) {
        List results;
        AdminManagementClient adminClient;
        Map mandatoryValueMap;
        this.checkMandatoryParameters(params);
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        ObjectNode infoNode = JsonHandler.createObjectNode();
        boolean shouldCheckOriginatingAgency = Boolean.parseBoolean((String)handlerIO.getInput(0, String.class));
        boolean shouldCheckProfile = Boolean.parseBoolean((String)handlerIO.getInput(1, String.class));
        try {
            SedaUtils sedaUtils = this.sedaUtilsFactory.createSedaUtilsWithSedaIngestParams(handlerIO);
            mandatoryValueMap = sedaUtils.getMandatoryValues(params);
        }
        catch (ProcessingException e) {
            LOGGER.error("Getting Mandatory Values throws ProcessingException", (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        }
        if (mandatoryValueMap.get("MessageIdentifier") != null) {
            itemStatus.setData("MessageIdentifier", mandatoryValueMap.get("MessageIdentifier"));
            itemStatus.setMasterData(LogbookParameterName.objectIdentifierIncome.name(), mandatoryValueMap.get("MessageIdentifier"));
        }
        this.updateSedaInfo(mandatoryValueMap, infoNode);
        String evDevDetailData = JsonHandler.unprettyPrint((Object)infoNode);
        itemStatus.setEvDetailData(evDevDetailData);
        itemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), (Object)evDevDetailData);
        if (shouldCheckOriginatingAgency) {
            handlerIO.getInput().clear();
            handlerIO.getInput().add(mandatoryValueMap);
            CheckOriginatingAgencyHandler checkOriginatingAgencyHandler = new CheckOriginatingAgencyHandler(this.adminManagementClientFactory);
            ItemStatus checkOriginatingAgencyStatus = checkOriginatingAgencyHandler.execute(params, handlerIO);
            itemStatus.setItemsStatus(CheckOriginatingAgencyHandler.getId(), checkOriginatingAgencyStatus);
            checkOriginatingAgencyHandler.close();
            if (checkOriginatingAgencyStatus.shallStop(true)) {
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
        }
        if (mandatoryValueMap.get("MessageIdentifier") != null) {
            itemStatus.setMasterData(LogbookParameterName.objectIdentifierIncome.name(), mandatoryValueMap.get("MessageIdentifier"));
        }
        handlerIO.getInput().clear();
        handlerIO.getInput().add(mandatoryValueMap);
        CheckIngestContractActionHandler checkIngestContractActionHandler = new CheckIngestContractActionHandler(this.adminManagementClientFactory, this.storageClientFactory);
        ItemStatus checkContratItemStatus = checkIngestContractActionHandler.execute(params, handlerIO);
        itemStatus.setItemsStatus(CheckIngestContractActionHandler.getId(), checkContratItemStatus);
        checkIngestContractActionHandler.close();
        if (checkContratItemStatus.shallStop(true)) {
            return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        }
        String contractIdentifier = (String)mandatoryValueMap.get("ArchivalAgreement");
        String profileIdentifier = (String)mandatoryValueMap.get("ArchivalProfile");
        ContractsDetailsModel contractsDetailsModel = new ContractsDetailsModel();
        try {
            adminClient = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse referenceContracts = adminClient.findIngestContractsByID(contractIdentifier);
                if (!referenceContracts.isOk()) {
                    ObjectNode evDetailData2 = JsonHandler.createObjectNode();
                    evDetailData2.put(INGEST_CONTRACT, contractIdentifier);
                    itemStatus.setEvDetailData(evDetailData2.toString());
                    itemStatus.increment(StatusCode.KO);
                    ItemStatus itemStatus2 = new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
                    return itemStatus2;
                }
                results = ((RequestResponseOK)referenceContracts).getResults();
                if (null != results && results.size() > 0) {
                    contractsDetailsModel.setIngestContractModel((IngestContractModel)results.iterator().next());
                }
            }
            finally {
                if (adminClient != null) {
                    adminClient.close();
                }
            }
        }
        catch (ReferentialNotFoundException e) {
            LOGGER.error((Throwable)e);
            ObjectNode evDetailData = JsonHandler.createObjectNode();
            evDetailData.put(INGEST_CONTRACT, contractIdentifier);
            itemStatus.setEvDetailData(evDetailData.toString());
            itemStatus.increment(StatusCode.KO);
            return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        }
        catch (InvalidParseOperationException | AdminManagementClientServerException e) {
            LOGGER.error(e);
            ObjectNode evDetailData = JsonHandler.createObjectNode();
            evDetailData.put(INGEST_CONTRACT, contractIdentifier);
            itemStatus.setEvDetailData(evDetailData.toString());
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)contractsDetailsModel.getIngestContractModel().getManagementContractId())) {
            ObjectNode evDetailData;
            try {
                adminClient = this.adminManagementClientFactory.getClient();
                try {
                    RequestResponse managementReferenceContract = adminClient.findManagementContractsByID(contractsDetailsModel.getIngestContractModel().getManagementContractId());
                    if (!managementReferenceContract.isOk()) {
                        ObjectNode evDetailData3 = JsonHandler.createObjectNode();
                        evDetailData3.put(INGEST_CONTRACT, contractIdentifier);
                        evDetailData3.put(MANAGEMENT_CONTRACT, contractsDetailsModel.getIngestContractModel().getManagementContractId());
                        itemStatus.setEvDetailData(evDetailData3.toString());
                        itemStatus.increment(StatusCode.KO);
                        ItemStatus itemStatus3 = new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
                        return itemStatus3;
                    }
                    results = ((RequestResponseOK)managementReferenceContract).getResults();
                    if (null != results && results.size() > 0) {
                        contractsDetailsModel.setManagementContractModel((ManagementContractModel)results.iterator().next());
                    }
                }
                finally {
                    if (adminClient != null) {
                        adminClient.close();
                    }
                }
            }
            catch (ReferentialNotFoundException e) {
                LOGGER.error((Throwable)e);
                evDetailData = JsonHandler.createObjectNode();
                evDetailData.put(INGEST_CONTRACT, contractIdentifier);
                evDetailData.put(MANAGEMENT_CONTRACT, contractsDetailsModel.getIngestContractModel().getManagementContractId());
                itemStatus.setEvDetailData(evDetailData.toString());
                itemStatus.increment(StatusCode.KO);
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
            catch (InvalidParseOperationException | AdminManagementClientServerException e) {
                LOGGER.error(e);
                evDetailData = JsonHandler.createObjectNode();
                evDetailData.put(INGEST_CONTRACT, contractIdentifier);
                evDetailData.put(MANAGEMENT_CONTRACT, contractsDetailsModel.getIngestContractModel().getManagementContractId());
                itemStatus.setEvDetailData(evDetailData.toString());
                itemStatus.increment(StatusCode.FATAL);
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
        }
        try {
            this.writeIngestContractToWorkspace(handlerIO, contractsDetailsModel);
        }
        catch (InvalidParseOperationException | ProcessingException e) {
            LOGGER.error("Error when saving mandatory Seda parameter to Workspace ", e);
            itemStatus.increment(StatusCode.FATAL);
            return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        }
        if (!shouldCheckProfile) {
            itemStatus.increment(StatusCode.OK);
            return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        }
        if (!contractsDetailsModel.getIngestContractModel().getArchiveProfiles().isEmpty()) {
            handlerIO.getInput().clear();
            handlerIO.getInput().add(profileIdentifier);
            handlerIO.getInput().add(contractIdentifier);
            CheckArchiveProfileRelationActionHandler checkProfileRelation = new CheckArchiveProfileRelationActionHandler(this.adminManagementClientFactory);
            ItemStatus checkProfilRelationItemStatus = checkProfileRelation.execute(params, handlerIO);
            itemStatus.setItemsStatus(CheckArchiveProfileRelationActionHandler.getId(), checkProfilRelationItemStatus);
            checkProfileRelation.close();
            if (checkProfilRelationItemStatus.shallStop(true)) {
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
        }
        handlerIO.getInput().clear();
        if (!ParametersChecker.isNotEmpty((String[])new String[]{profileIdentifier})) return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        handlerIO.getInput().add(mandatoryValueMap.get("ArchivalProfile"));
        CheckArchiveProfileActionHandler checkArchiveProfile = new CheckArchiveProfileActionHandler();
        ItemStatus checkProfilItemStatus = checkArchiveProfile.execute(params, handlerIO);
        itemStatus.setItemsStatus(CheckArchiveProfileActionHandler.getId(), checkProfilItemStatus);
        checkArchiveProfile.close();
        if (!checkProfilItemStatus.shallStop(true)) return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private void writeIngestContractToWorkspace(HandlerIO handlerIO, ContractsDetailsModel ingestContractWithDetailsModel) throws InvalidParseOperationException, ProcessingException {
        File tempFile = handlerIO.getNewLocalFile(handlerIO.getOutput(0).getPath());
        JsonHandler.writeAsFile((Object)ingestContractWithDetailsModel, (File)tempFile);
        handlerIO.addOutputResult(0, (Object)tempFile, true, false);
    }

    private void updateSedaInfo(Map<String, String> madatoryValueMap, ObjectNode infoNode) {
        if (madatoryValueMap.get("Comment") != null) {
            infoNode.put(EV_DETAIL_REQ, madatoryValueMap.get("Comment"));
        }
        if (madatoryValueMap.get("ArchivalAgreement") != null) {
            String contractName = madatoryValueMap.get("ArchivalAgreement");
            infoNode.put("ArchivalAgreement", contractName);
        }
        if (madatoryValueMap.get("ArchivalProfile") != null) {
            String profileName = madatoryValueMap.get("ArchivalProfile");
            infoNode.put("ArchivalProfile", profileName);
        }
        if (madatoryValueMap.get("AcquisitionInformation") != null) {
            String acquisitionInformation = madatoryValueMap.get("AcquisitionInformation");
            infoNode.put("AcquisitionInformation", acquisitionInformation);
        }
        if (madatoryValueMap.get("LegalStatus") != null) {
            String legalStatus = madatoryValueMap.get("LegalStatus");
            infoNode.put("LegalStatus", legalStatus);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

